require '_h2ph_pre.ph';

unless(defined(&_SYS_FLOCK_IMPL_H)) {
    eval 'sub _SYS_FLOCK_IMPL_H () {1;}' unless defined(&_SYS_FLOCK_IMPL_H);
    require 'sys/types.ph';
    require 'sys/fcntl.ph';
    require 'sys/file.ph';
    require 'sys/flock.ph';
    require 'sys/kmem.ph';
    require 'sys/user.ph';
    require 'sys/thread.ph';
    require 'sys/proc.ph';
    require 'sys/cred.ph';
    require 'sys/debug.ph';
    require 'sys/cmn_err.ph';
    require 'sys/errno.ph';
    require 'sys/vnode.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub DEBUG_RECLOCK () {1;}' unless defined(&DEBUG_RECLOCK);
    eval 'sub GET_FIRST_ACTIVE_LOCK {
        local($vp) = @_;
	    eval q((($vp)-> &v_filocks));
    }' unless defined(&GET_FIRST_ACTIVE_LOCK);
    eval 'sub SET_FIRST_ACTIVE_LOCK {
        local($vp, $lock) = @_;
	    eval q(-> &v_filocks = ($lock));
    }' unless defined(&SET_FIRST_ACTIVE_LOCK);
    eval 'sub ASSERT_WARNING {
        local($condition) = @_;
	    eval q({  &if (!($condition))  &cmn_err( &CE_WARN, \\"File %s, line=%d: assertion failed: %s\\\\n\\",  &__FILE__,  &__LINE__, $condition); });
    }' unless defined(&ASSERT_WARNING);
    eval 'sub ASSERT_PANIC {
        local($condition) = @_;
	    eval q({  &if (!($condition))  &cmn_err( &CE_PANIC, \\"File %s, line=%d: assertion failed: %s\\\\n\\",  &__FILE__,  &__LINE__, $condition); });
    }' unless defined(&ASSERT_PANIC);
    eval 'sub STACK_DECLARE {
        local($name, $type) = @_;
	    eval q($type *$name);
    }' unless defined(&STACK_DECLARE);
    eval 'sub STACK_INIT {
        local($stack) = @_;
	    eval q(($stack) =  &NULL);
    }' unless defined(&STACK_INIT);
    eval 'sub STACK_PUSH {
        local($stack, $ptr) = @_;
	    eval q(($ptr)-> &stack_link = ($stack), ($stack) = ($ptr));
    }' unless defined(&STACK_PUSH);
    eval 'sub STACK_POP {
        local($stack) = @_;
	    eval q(($stack) = ($stack)-> &stack_link);
    }' unless defined(&STACK_POP);
    eval 'sub STACK_TOP {
        local($stack) = @_;
	    eval q(($stack));
    }' unless defined(&STACK_TOP);
    eval 'sub STACK_EMPTY {
        local($stack) = @_;
	    eval q((($stack) ==  &NULL));
    }' unless defined(&STACK_EMPTY);
    eval 'sub S_BEFORE () {0x001;}' unless defined(&S_BEFORE);
    eval 'sub S_START () {0x002;}' unless defined(&S_START);
    eval 'sub S_MIDDLE () {0x004;}' unless defined(&S_MIDDLE);
    eval 'sub S_END () {0x008;}' unless defined(&S_END);
    eval 'sub S_AFTER () {0x010;}' unless defined(&S_AFTER);
    eval 'sub E_BEFORE () {0x020;}' unless defined(&E_BEFORE);
    eval 'sub E_START () {0x040;}' unless defined(&E_START);
    eval 'sub E_MIDDLE () {0x080;}' unless defined(&E_MIDDLE);
    eval 'sub E_END () {0x100;}' unless defined(&E_END);
    eval 'sub E_AFTER () {0x200;}' unless defined(&E_AFTER);
    unless(defined(&MAXEND)) {
	eval 'sub MAXEND () {(~(1<< ( &NBBY*$sizeof{ &off_t}-1)));}' unless defined(&MAXEND);
    }
    eval("sub DONT_FREE_LOCK () { 0; }") unless defined(&DONT_FREE_LOCK);
    eval("sub FREE_LOCK () { 1; }") unless defined(&FREE_LOCK);
    eval("sub DONT_UPDATE_FIRST_LOCK () { 0; }") unless defined(&DONT_UPDATE_FIRST_LOCK);
    eval("sub UPDATE_FIRST_LOCK () { 1; }") unless defined(&UPDATE_FIRST_LOCK);
    eval 'sub SAME_OWNER {
        local($ap, $bp) = @_;
	    eval q((($ap)-> &pid == ($bp)-> &pid  && ($ap)-> &sysid == ($bp)-> &sysid));
    }' unless defined(&SAME_OWNER);
    eval 'sub OWNER {
        local($lock) = @_;
	    eval q((($lock)-> &owner));
    }' unless defined(&OWNER);
    eval 'sub FLOCK {
        local($lock) = @_;
	    eval q((($lock)-> ($info->{li_sleep}->{sli_flock})));
    }' unless defined(&FLOCK);
    eval 'sub CONDVAR {
        local($lock) = @_;
	    eval q((($lock)-> ($info->{li_sleep}->{sli_cv})));
    }' unless defined(&CONDVAR);
    eval 'sub BLOCKERS {
        local($lock) = @_;
	    eval q((($lock)-> ($info->{li_sleep}->{sli_blockers})));
    }' unless defined(&BLOCKERS);
    eval 'sub LOCK_COUNT {
        local($head) = @_;
	    eval q((($head)-> ($info->{li_head}->{lhi_nlocks})));
    }' unless defined(&LOCK_COUNT);
    eval 'sub IS_LOCAL_LOCK {
        local($lock) = @_;
	    eval q(( &OWNER($lock)-> &sysid == 0));
    }' unless defined(&IS_LOCAL_LOCK);
    eval 'sub IS_REMOTE_LOCK {
        local($lock) = @_;
	    eval q((!  &IS_LOCAL_LOCK($lock)));
    }' unless defined(&IS_REMOTE_LOCK);
    eval 'sub IO_LOCK () {0x001;}' unless defined(&IO_LOCK);
    eval 'sub WILLING_TO_SLEEP_LOCK () {0x002;}' unless defined(&WILLING_TO_SLEEP_LOCK);
    eval 'sub QUERY_LOCK () {0x004;}' unless defined(&QUERY_LOCK);
    eval 'sub ACTIVE_LOCK () {0x008;}' unless defined(&ACTIVE_LOCK);
    eval 'sub CLONE_LOCK () {0x010;}' unless defined(&CLONE_LOCK);
    eval 'sub DELETED_LOCK () {0x020;}' unless defined(&DELETED_LOCK);
    eval 'sub REFERENCED_LOCK () {0x040;}' unless defined(&REFERENCED_LOCK);
    eval 'sub LOCK_DENIED () {0x080;}' unless defined(&LOCK_DENIED);
    eval 'sub LOCK_GRANTED () {0x100;}' unless defined(&LOCK_GRANTED);
    eval 'sub IS_IO_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &IO_LOCK));
    }' unless defined(&IS_IO_LOCK);
    eval 'sub IS_WILLING_TO_SLEEP_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &WILLING_TO_SLEEP_LOCK));
    }' unless defined(&IS_WILLING_TO_SLEEP_LOCK);
    eval 'sub IS_QUERY_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &QUERY_LOCK));
    }' unless defined(&IS_QUERY_LOCK);
    eval 'sub IS_ACTIVE_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &ACTIVE_LOCK));
    }' unless defined(&IS_ACTIVE_LOCK);
    eval 'sub IS_CLONE_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &CLONE_LOCK));
    }' unless defined(&IS_CLONE_LOCK);
    eval 'sub IS_REFERENCED_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &REFERENCED_LOCK));
    }' unless defined(&IS_REFERENCED_LOCK);
    eval 'sub IS_DELETED_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &DELETED_LOCK));
    }' unless defined(&IS_DELETED_LOCK);
    eval 'sub IS_LOCK_DENIED {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &LOCK_DENIED));
    }' unless defined(&IS_LOCK_DENIED);
    eval 'sub IS_LOCK_GRANTED {
        local($lock) = @_;
	    eval q((($lock)-> &flags &  &LOCK_GRANTED));
    }' unless defined(&IS_LOCK_GRANTED);
    eval 'sub LOCKS_OVERLAP {
        local($lock1, $lock2) = @_;
	    eval q((($lock2)-> &start <= ($lock1)-> &start  && ($lock1)-> &start <= ($lock2)-> &end || ($lock1)-> &start <= ($lock2)-> &start  && ($lock2)-> &start <= ($lock1)-> &end));
    }' unless defined(&LOCKS_OVERLAP);
    eval 'sub BLOCKS {
        local($lock, $request) = @_;
	    eval q((!  &SAME_OWNER( &OWNER($lock),  &OWNER($request))  &&  &LOCKS_OVERLAP($lock, $request)  && (($lock)-> &type ==  &F_WRLCK || ($request)-> &type ==  &F_WRLCK)));
    }' unless defined(&BLOCKS);
    eval 'sub LOCK_EFFECT {
        local($request, $lock) = @_;
	    eval q(((($request)-> &type == ($lock)-> &type) ?  &STAY_SAME : (($request)-> &type ==  &F_WRLCK) ?  &UPGRADE :  &DOWNGRADE));
    }' unless defined(&LOCK_EFFECT);
    eval("sub UPGRADE () { 0; }") unless defined(&UPGRADE);
    eval("sub DOWNGRADE () { 1; }") unless defined(&DOWNGRADE);
    eval("sub STAY_SAME () { 2; }") unless defined(&STAY_SAME);
    eval 'sub HEAD {
        local($lock_list) = @_;
	    eval q((($lock_list)));
    }' unless defined(&HEAD);
    eval 'sub LIST_IS_EMPTY {
        local($list) = @_;
	    eval q(( &HEAD($list)-> &next ==  &HEAD($list)));
    }' unless defined(&LIST_IS_EMPTY);
    eval 'sub REMOTE_GRANTED_PENDING () {
        eval q((! &LIST_IS_EMPTY( &lockd_granted_locks)));
    }' unless defined(&REMOTE_GRANTED_PENDING);
    eval 'sub GET_FIRST_SLEEPING_LOCK {
        local($vp) = @_;
	    eval q( &flk_get_first_sleeping_lock_on_vnode($vp));
    }' unless defined(&GET_FIRST_SLEEPING_LOCK);
    eval 'sub LIST_INSERT_BEFORE {
        local($element, $new_element) = @_;
	    eval q({ ($new_element)-> &next = ($element); ($new_element)-> &prev = ($element)-> &prev; ($element)-> &prev = ($new_element); ($new_element)-> ($prev->{next})	= ($new_element); });
    }' unless defined(&LIST_INSERT_BEFORE);
    eval 'sub LIST_INSERT_AFTER {
        local($element, $new_element) = @_;
	    eval q({ ($new_element)-> &prev = ($element); ($new_element)-> &next = ($element)-> &next; ($element)-> &next = ($new_element); ($new_element)-> ($next->{prev})	= ($new_element); });
    }' unless defined(&LIST_INSERT_AFTER);
    eval 'sub LIST_REMOVE {
        local($element) = @_;
	    eval q({  &if ( ==  &HEAD || ==  &HEAD || ==  &HEAD)  &panic(\\"Attempt to LIST_REMOVE head of list\\\\n\\"); -> ($next->{prev})	 = -> &prev; -> ($prev->{next})	 = -> &next; -> &next = 0; -> &prev = 0; });
    }' unless defined(&LIST_REMOVE);
    eval 'sub REMOVE_LOCK {
        local($list, $element) = @_;
	    eval q({  &LIST_REMOVE($element);  &LOCK_COUNT( &HEAD($list))--; });
    }' unless defined(&REMOVE_LOCK);
    eval 'sub CLEAR {
        local($v) = @_;
	    eval q(  &bzero(($v), $sizeof{$v}));
    }' unless defined(&CLEAR);
    eval 'sub NEW {
        local($type) = @_;
	    eval q(  &kmem_alloc($sizeof{$type},  &KM_SLEEP));
    }' unless defined(&NEW);
    eval 'sub FREE_PTR {
        local($p) = @_;
	    eval q( &kmem_free(($p), $sizeof{$p}));
    }' unless defined(&FREE_PTR);
    eval 'sub ALLOCATE_LOCK () {
        eval q( &flk_allocate_lock(1));
    }' unless defined(&ALLOCATE_LOCK);
    eval 'sub ALLOCATE_LOCK_NOWAIT () {
        eval q( &flk_allocate_lock(0));
    }' unless defined(&ALLOCATE_LOCK_NOWAIT);
    eval 'sub FREE_LOCK {
        local($p) = @_;
	    eval q( &flk_free_lock($p));
    }' unless defined(&FREE_LOCK);
    if(defined(&DEBUG_RECLOCK)) {
	eval 'sub RECLOCK_DEBUG_UNLKSYS () {0x1;}' unless defined(&RECLOCK_DEBUG_UNLKSYS);
	eval 'sub RECLOCK_DEBUG_VERIFY () {0x2;}' unless defined(&RECLOCK_DEBUG_VERIFY);
	eval 'sub RECLOCK_DEBUG_CMD () {0x4;}' unless defined(&RECLOCK_DEBUG_CMD);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
