require '_h2ph_pre.ph';

unless(defined(&_SYS_CPUVAR_H)) {
    eval 'sub _SYS_CPUVAR_H () {1;}' unless defined(&_SYS_CPUVAR_H);
    require 'sys/thread.ph';
    require 'sys/sysinfo.ph';
    require 'sys/gprof.ph';
    require 'sys/disp.ph';
    require 'sys/processor.ph';
    if((defined( &_KERNEL) || defined( &_KMEMUSER))  && defined( &_MACHDEP)) {
	require 'sys/machcpuvar.ph';
    }
    if(defined(&__cplusplus)) {
    }
    require 'sys/types.ph';
    require 'sys/file.ph';
    if((defined( &_KERNEL) || defined( &_KMEMUSER))  && defined( &_MACHDEP)) {
    }
    eval 'sub CPU_RUNNING () {0x01;}' unless defined(&CPU_RUNNING);
    eval 'sub CPU_READY () {0x02;}' unless defined(&CPU_READY);
    eval 'sub CPU_QUIESCED () {0x04;}' unless defined(&CPU_QUIESCED);
    eval 'sub CPU_EXISTS () {0x08;}' unless defined(&CPU_EXISTS);
    eval 'sub CPU_ENABLE () {0x10;}' unless defined(&CPU_ENABLE);
    eval 'sub CPU_OFFLINE () {0x20;}' unless defined(&CPU_OFFLINE);
    eval 'sub CPU_ACTIVE {
        local($cpu) = @_;
	    eval q(((($cpu)-> &cpu_flags &  &CPU_OFFLINE) == 0));
    }' unless defined(&CPU_ACTIVE);
    eval 'sub CPUSET {
        local($cpu) = @_;
	    eval q((1<< ($cpu)));
    }' unless defined(&CPUSET);
    eval 'sub CPUSET_ALL () {(~0);}' unless defined(&CPUSET_ALL);
    eval 'sub CPUSET_ALL_BUT {
        local($cpu) = @_;
	    eval q((~ &CPUSET($cpu)));
    }' unless defined(&CPUSET_ALL_BUT);
    eval 'sub CPU_IN_SET {
        local($set, $cpu) = @_;
	    eval q((($set) &  &CPUSET($cpu)));
    }' unless defined(&CPU_IN_SET);
    eval 'sub CPUSET_ADD {
        local($set, $cpu) = @_;
	    eval q((($set) |=  &CPUSET($cpu)));
    }' unless defined(&CPUSET_ADD);
    eval 'sub CPUSET_DEL {
        local($set, $cpu) = @_;
	    eval q((($set) &= ~ &CPUSET($cpu)));
    }' unless defined(&CPUSET_DEL);
    if(defined( &i386)) {
	eval 'sub CPU () {( &curcpup());}' unless defined(&CPU);
    } else {
	eval 'sub CPU () {( ($curthread->{t_cpu}));}' unless defined(&CPU);
    }
    eval 'sub CPU_STAT_ENTER_K () {
        eval q( &kpreempt_disable());
    }' unless defined(&CPU_STAT_ENTER_K);
    eval 'sub CPU_STAT_EXIT_K () {
        eval q( &kpreempt_enable());
    }' unless defined(&CPU_STAT_EXIT_K);
    eval 'sub CPU_STAT_ADD_K {
        local($thing, $amount) = @_;
	    eval q({  &kpreempt_disable();  &CPU_STAT_ADDQ( &CPU, $thing, $amount);  &kpreempt_enable(); });
    }' unless defined(&CPU_STAT_ADD_K);
    eval 'sub CPU_STAT_ENTER {
        local($cpuptr) = @_;
	    eval q( &mutex_enter(( ($cpuptr->{cpu_stat}->{cpu_stat_lock}))));
    }' unless defined(&CPU_STAT_ENTER);
    eval 'sub CPU_STAT_EXIT {
        local($cpuptr) = @_;
	    eval q( &mutex_exit(( ($cpuptr->{cpu_stat}->{cpu_stat_lock}))));
    }' unless defined(&CPU_STAT_EXIT);
    eval 'sub CPU_STAT_ADDQ {
        local($cpuptr, $thing, $amount) = @_;
	    eval q( ($cpuptr->{cpu_stat}->{thing}) += $amount);
    }' unless defined(&CPU_STAT_ADDQ);
    eval 'sub CPU_STAT_ADD {
        local($cpuptr, $thing, $amount) = @_;
	    eval q({ \'struct cpu\' * &xx___cpup;  &xx___cpup = $cpuptr;  &CPU_STAT_ENTER( &xx___cpup);  &CPU_STAT_ADDQ( &xx___cpup, $thing, $amount);  &CPU_STAT_EXIT( &xx___cpup); });
    }' unless defined(&CPU_STAT_ADD);
    if(defined( &_KERNEL)  && defined( &__STDC__) ) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
