require '_h2ph_pre.ph';

unless(defined(&_SYS_VFS_H)) {
    eval 'sub _SYS_VFS_H () {1;}' unless defined(&_SYS_VFS_H);
    require 'sys/types.ph';
    require 'sys/t_lock.ph';
    require 'sys/cred.ph';
    require 'sys/vnode.ph';
    require 'sys/statvfs.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub MAXFIDSZ () {36;}' unless defined(&MAXFIDSZ);
    eval 'sub OLD_MAXFIDSZ () {16;}' unless defined(&OLD_MAXFIDSZ);
    eval 'sub freefid {
        local($fidp) = @_;
	    eval q( &kmem_free(($fidp), $sizeof{\'struct fid\'} -  &MAXFIDSZ + ($fidp)-> &fid_len));
    }' unless defined(&freefid);
    eval 'sub VFS_RDONLY () {0x01;}' unless defined(&VFS_RDONLY);
    eval 'sub VFS_REF () {0x02;}' unless defined(&VFS_REF);
    eval 'sub VFS_NOSUID () {0x08;}' unless defined(&VFS_NOSUID);
    eval 'sub VFS_REMOUNT () {0x10;}' unless defined(&VFS_REMOUNT);
    eval 'sub VFS_NOTRUNC () {0x20;}' unless defined(&VFS_NOTRUNC);
    eval 'sub VFS_UNLINKABLE () {0x40;}' unless defined(&VFS_UNLINKABLE);
    eval("sub ROOT_INIT () { 0; }") unless defined(&ROOT_INIT);
    eval("sub ROOT_REMOUNT () { 1; }") unless defined(&ROOT_REMOUNT);
    eval("sub ROOT_UNMOUNT () { 2; }") unless defined(&ROOT_UNMOUNT);
    eval 'sub VFS_MOUNT {
        local($vfsp, $mvp, $uap, $cr) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_mount}))($vfsp, $mvp, $uap, $cr));
    }' unless defined(&VFS_MOUNT);
    eval 'sub VFS_UNMOUNT {
        local($vfsp, $cr) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_unmount}))($vfsp, $cr));
    }' unless defined(&VFS_UNMOUNT);
    eval 'sub VFS_ROOT {
        local($vfsp, $vpp) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_root}))($vfsp, $vpp));
    }' unless defined(&VFS_ROOT);
    eval 'sub VFS_STATVFS {
        local($vfsp, $sp) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_statvfs}))($vfsp, $sp));
    }' unless defined(&VFS_STATVFS);
    eval 'sub VFS_SYNC {
        local($vfsp, $flag, $cr) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_sync}))($vfsp, $flag, $cr));
    }' unless defined(&VFS_SYNC);
    eval 'sub VFS_VGET {
        local($vfsp, $vpp, $fidp) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_vget}))($vfsp, $vpp, $fidp));
    }' unless defined(&VFS_VGET);
    eval 'sub VFS_MOUNTROOT {
        local($vfsp, $init) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_mountroot}))($vfsp, $init));
    }' unless defined(&VFS_MOUNTROOT);
    eval 'sub VFS_SWAPVP {
        local($vfsp, $vpp, $nm) = @_;
	    eval q((*($vfsp)-> ($vfs_op->{vfs_swapvp}))($vfsp, $vpp, $nm));
    }' unless defined(&VFS_SWAPVP);
    if(defined( &_KERNEL)) {
    }
    eval 'sub VFS_INIT {
        local($vfsp, $op, $data) = @_;
	    eval q({ -> &vfs_next = 0; ($vfsp)-> &vfs_op = ($op); ($vfsp)-> &vfs_flag = 0; ($vfsp)-> &vfs_data = ($data); ($vfsp)-> &vfs_nsubmounts = 0; });
    }' unless defined(&VFS_INIT);
    eval 'sub VFS_INSTALLED {
        local($vfsswp) = @_;
	    eval q((($vfsswp)-> &vsw_vfsops));
    }' unless defined(&VFS_INSTALLED);
    eval 'sub ALLOCATED_VFSSW {
        local($vswp) = @_;
	    eval q((($vswp)-> $vsw_name[0] != ord(\'\\\\0\')));
    }' unless defined(&ALLOCATED_VFSSW);
    eval 'sub RLOCK_VFSSW () {
        eval q(( &rw_enter( &vfssw_lock,  &RW_READER)));
    }' unless defined(&RLOCK_VFSSW);
    eval 'sub RUNLOCK_VFSSW () {
        eval q(( &rw_exit( &vfssw_lock)));
    }' unless defined(&RUNLOCK_VFSSW);
    eval 'sub WLOCK_VFSSW () {
        eval q(( &rw_enter( &vfssw_lock,  &RW_WRITER)));
    }' unless defined(&WLOCK_VFSSW);
    eval 'sub WUNLOCK_VFSSW () {
        eval q(( &rw_exit( &vfssw_lock)));
    }' unless defined(&WUNLOCK_VFSSW);
    eval 'sub VFSSW_LOCKED () {
        eval q(( &RW_LOCK_HELD( &vfssw_lock)));
    }' unless defined(&VFSSW_LOCKED);
    eval 'sub SYNC_ATTR () {0x01;}' unless defined(&SYNC_ATTR);
    eval 'sub SYNC_CLOSE () {0x02;}' unless defined(&SYNC_CLOSE);
    if(defined(&__cplusplus)) {
    }
}
1;
