require '_h2ph_pre.ph';

unless(defined(&_SYS_KSTAT_H)) {
    eval 'sub _SYS_KSTAT_H () {1;}' unless defined(&_SYS_KSTAT_H);
    require 'sys/types.ph';
    require 'sys/time.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub KSTAT_IOC_BASE () {(ord(\'K\') << 8);}' unless defined(&KSTAT_IOC_BASE);
    eval 'sub KSTAT_IOC_CHAIN_ID () { &KSTAT_IOC_BASE | 0x01;}' unless defined(&KSTAT_IOC_CHAIN_ID);
    eval 'sub KSTAT_IOC_READ () { &KSTAT_IOC_BASE | 0x02;}' unless defined(&KSTAT_IOC_READ);
    eval 'sub KSTAT_IOC_WRITE () { &KSTAT_IOC_BASE | 0x03;}' unless defined(&KSTAT_IOC_WRITE);
    eval 'sub KSTAT_STRLEN () {31;}' unless defined(&KSTAT_STRLEN);
    if(defined( &_KERNEL)) {
	eval 'sub KSTAT_ENTER {
	    local($k) = @_;
    	    eval q({  &kmutex_t * &lp = -> &ks_lock;  &if  &mutex_enter( &lp); });
	}' unless defined(&KSTAT_ENTER);
	eval 'sub KSTAT_EXIT {
	    local($k) = @_;
    	    eval q({  &kmutex_t * &lp = -> &ks_lock;  &if  &mutex_exit( &lp); });
	}' unless defined(&KSTAT_EXIT);
	eval 'sub KSTAT_UPDATE {
	    local($k, $rw) = @_;
    	    eval q((*($k)-> &ks_update)(($k), ($rw)));
	}' unless defined(&KSTAT_UPDATE);
	eval 'sub KSTAT_SNAPSHOT {
	    local($k, $buf, $rw) = @_;
    	    eval q((*($k)-> &ks_snapshot)(($k), ($buf), ($rw)));
	}' unless defined(&KSTAT_SNAPSHOT);
    }
    eval 'sub KSTAT_TYPE_RAW () {0;}' unless defined(&KSTAT_TYPE_RAW);
    eval 'sub KSTAT_TYPE_NAMED () {1;}' unless defined(&KSTAT_TYPE_NAMED);
    eval 'sub KSTAT_TYPE_INTR () {2;}' unless defined(&KSTAT_TYPE_INTR);
    eval 'sub KSTAT_TYPE_IO () {3;}' unless defined(&KSTAT_TYPE_IO);
    eval 'sub KSTAT_TYPE_TIMER () {4;}' unless defined(&KSTAT_TYPE_TIMER);
    eval 'sub KSTAT_NUM_TYPES () {5;}' unless defined(&KSTAT_NUM_TYPES);
    eval 'sub KSTAT_FLAG_VIRTUAL () {0x01;}' unless defined(&KSTAT_FLAG_VIRTUAL);
    eval 'sub KSTAT_FLAG_VAR_SIZE () {0x02;}' unless defined(&KSTAT_FLAG_VAR_SIZE);
    eval 'sub KSTAT_FLAG_WRITABLE () {0x04;}' unless defined(&KSTAT_FLAG_WRITABLE);
    eval 'sub KSTAT_FLAG_PERSISTENT () {0x08;}' unless defined(&KSTAT_FLAG_PERSISTENT);
    eval 'sub KSTAT_FLAG_DORMANT () {0x10;}' unless defined(&KSTAT_FLAG_DORMANT);
    eval 'sub KSTAT_FLAG_INVALID () {0x20;}' unless defined(&KSTAT_FLAG_INVALID);
    eval 'sub KSTAT_READ () {0;}' unless defined(&KSTAT_READ);
    eval 'sub KSTAT_WRITE () {1;}' unless defined(&KSTAT_WRITE);
    eval 'sub KSTAT_DATA_CHAR () {0;}' unless defined(&KSTAT_DATA_CHAR);
    eval 'sub KSTAT_DATA_LONG () {1;}' unless defined(&KSTAT_DATA_LONG);
    eval 'sub KSTAT_DATA_ULONG () {2;}' unless defined(&KSTAT_DATA_ULONG);
    eval 'sub KSTAT_DATA_LONGLONG () {3;}' unless defined(&KSTAT_DATA_LONGLONG);
    eval 'sub KSTAT_DATA_ULONGLONG () {4;}' unless defined(&KSTAT_DATA_ULONGLONG);
    eval 'sub KSTAT_DATA_FLOAT () {5;}' unless defined(&KSTAT_DATA_FLOAT);
    eval 'sub KSTAT_DATA_DOUBLE () {6;}' unless defined(&KSTAT_DATA_DOUBLE);
    eval 'sub KSTAT_NAMED_PTR {
        local($kptr) = @_;
	    eval q(( ($kptr)-> &ks_data));
    }' unless defined(&KSTAT_NAMED_PTR);
    eval 'sub KSTAT_INTR_HARD () {0;}' unless defined(&KSTAT_INTR_HARD);
    eval 'sub KSTAT_INTR_SOFT () {1;}' unless defined(&KSTAT_INTR_SOFT);
    eval 'sub KSTAT_INTR_WATCHDOG () {2;}' unless defined(&KSTAT_INTR_WATCHDOG);
    eval 'sub KSTAT_INTR_SPURIOUS () {3;}' unless defined(&KSTAT_INTR_SPURIOUS);
    eval 'sub KSTAT_INTR_MULTSVC () {4;}' unless defined(&KSTAT_INTR_MULTSVC);
    eval 'sub KSTAT_NUM_INTRS () {5;}' unless defined(&KSTAT_NUM_INTRS);
    eval 'sub KSTAT_INTR_PTR {
        local($kptr) = @_;
	    eval q(( ($kptr)-> &ks_data));
    }' unless defined(&KSTAT_INTR_PTR);
    eval 'sub KSTAT_IO_PTR {
        local($kptr) = @_;
	    eval q(( ($kptr)-> &ks_data));
    }' unless defined(&KSTAT_IO_PTR);
    eval 'sub KSTAT_TIMER_PTR {
        local($kptr) = @_;
	    eval q(( ($kptr)-> &ks_data));
    }' unless defined(&KSTAT_TIMER_PTR);
    if(defined( &_KERNEL)) {
	require 'sys/t_lock.ph';
    }
    if(defined(&__cplusplus)) {
    }
}
1;
