require '_h2ph_pre.ph';

unless(defined(&_SYS_FS_CACHEFS_FS_H)) {
    eval 'sub _SYS_FS_CACHEFS_FS_H () {1;}' unless defined(&_SYS_FS_CACHEFS_FS_H);
    require 'sys/vnode.ph';
    require 'sys/vfs.ph';
    require 'sys/types.ph';
    require 'sys/t_lock.ph';
    require 'sys/fs/cachefs_filegrp.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub DEF_FILEGRP_SIZE () {256;}' unless defined(&DEF_FILEGRP_SIZE);
    eval 'sub DEF_POP_SIZE () {0x10000;}' unless defined(&DEF_POP_SIZE);
    eval 'sub CNODE_BUCKET_SIZE () {64;}' unless defined(&CNODE_BUCKET_SIZE);
    eval 'sub CFSVERSION () {1;}' unless defined(&CFSVERSION);
    eval 'sub CACHELABEL_NAME () {".cfs_label";}' unless defined(&CACHELABEL_NAME);
    eval 'sub RESOURCE_NAME () {".cfs_resource";}' unless defined(&RESOURCE_NAME);
    eval 'sub OPTION_NAME () {".cfs_option";}' unless defined(&OPTION_NAME);
    eval 'sub ATTRCACHE_NAME () {".cfs_attrcache";}' unless defined(&ATTRCACHE_NAME);
    eval 'sub BACKMNT_NAME () {".cfs_mnt_points";}' unless defined(&BACKMNT_NAME);
    eval 'sub CACHEFS_LOCK_FILE () {".cfs_lock";}' unless defined(&CACHEFS_LOCK_FILE);
    eval 'sub ROOTLINK_NAME () {"root";}' unless defined(&ROOTLINK_NAME);
    eval 'sub CFS_FRONTFILE_NAME_SIZE () {9;}' unless defined(&CFS_FRONTFILE_NAME_SIZE);
    eval 'sub CUSAGE_ACTIVE () {1;}' unless defined(&CUSAGE_ACTIVE);
    eval 'sub CUSAGE_NEED_ADJUST () {2;}' unless defined(&CUSAGE_NEED_ADJUST);
    eval 'sub CACHE_NOCACHE () {0x1;}' unless defined(&CACHE_NOCACHE);
    eval 'sub CACHE_UPDATED () {0x2;}' unless defined(&CACHE_UPDATED);
    eval 'sub CACHE_ALLOC_PENDING () {0x4;}' unless defined(&CACHE_ALLOC_PENDING);
    eval 'sub CACHE_NOFILL () {0x8;}' unless defined(&CACHE_NOFILL);
    eval 'sub CACHE_GARBAGE_COLLECT () {0x10;}' unless defined(&CACHE_GARBAGE_COLLECT);
    eval 'sub CACHE_GARBAGE_THREADRUN () {0x20;}' unless defined(&CACHE_GARBAGE_THREADRUN);
    eval 'sub CACHE_GARBAGE_THREADEXIT () {0x40;}' unless defined(&CACHE_GARBAGE_THREADEXIT);
    eval 'sub CACHE_DIRTY () {0x80;}' unless defined(&CACHE_DIRTY);
    eval 'sub CFS_WRITE_AROUND () {0x01;}' unless defined(&CFS_WRITE_AROUND);
    eval 'sub CFS_DUAL_WRITE () {0x02;}' unless defined(&CFS_DUAL_WRITE);
    eval 'sub CFS_BLOTOUT () {0x04;}' unless defined(&CFS_BLOTOUT);
    eval 'sub CFS_NOCONST_MODE () {0x08;}' unless defined(&CFS_NOCONST_MODE);
    eval 'sub CFS_ACCESS_BACKFS () {0x10;}' unless defined(&CFS_ACCESS_BACKFS);
    eval 'sub CFS_PURGE () {0x20;}' unless defined(&CFS_PURGE);
    eval 'sub CFS_AUTOPURGE () {0x40;}' unless defined(&CFS_AUTOPURGE);
    eval 'sub C_ISFS_BLOTOUT {
        local($FSCP) = @_;
	    eval q((($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_BLOTOUT));
    }' unless defined(&C_ISFS_BLOTOUT);
    eval 'sub C_ISFS_WRITE_AROUND {
        local($FSCP) = @_;
	    eval q((($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_WRITE_AROUND));
    }' unless defined(&C_ISFS_WRITE_AROUND);
    eval 'sub C_ISFS_STRICT {
        local($FSCP) = @_;
	    eval q(((($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_WRITE_AROUND)  && (($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_NOCONST_MODE) == 0));
    }' unless defined(&C_ISFS_STRICT);
    eval 'sub C_ISFS_SINGLE {
        local($FSCP) = @_;
	    eval q((($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_DUAL_WRITE));
    }' unless defined(&C_ISFS_SINGLE);
    eval 'sub C_ISFS_NOCONST {
        local($FSCP) = @_;
	    eval q((($FSCP)-> ($fs_options->{opt_flags}) &  &CFS_NOCONST_MODE));
    }' unless defined(&C_ISFS_NOCONST);
    eval 'sub CFS_FS_MOUNTED () {1;}' unless defined(&CFS_FS_MOUNTED);
    eval 'sub CFS_FS_SYNC_PENDING () {2;}' unless defined(&CFS_FS_SYNC_PENDING);
    eval 'sub CFSOP_INIT_COBJECT {
        local($FSCP, $CP, $CR) = @_;
	    eval q((*($FSCP)-> ($fs_cfsops->{co_init_cobject}))($FSCP, $CP, $CR));
    }' unless defined(&CFSOP_INIT_COBJECT);
    eval 'sub CFSOP_CHECK_COBJECT {
        local($FSCP, $CP, $WHAT, $TYPE, $CR) = @_;
	    eval q((*($FSCP)-> ($fs_cfsops->{co_check_cobject}))($FSCP, $CP, $WHAT, $TYPE, $CR));
    }' unless defined(&CFSOP_CHECK_COBJECT);
    eval 'sub CFSOP_MODIFY_COBJECT {
        local($FSCP, $CP, $CR) = @_;
	    eval q((*($FSCP)-> ($fs_cfsops->{co_modify_cobject}))($FSCP, $CP, $CR));
    }' unless defined(&CFSOP_MODIFY_COBJECT);
    eval 'sub CFSOP_INVALIDATE_COBJECT {
        local($FSCP, $CP, $CR) = @_;
	    eval q((*($FSCP)-> ($fs_cfsops->{co_invalidate_cobject}))($FSCP, $CP, $CR));
    }' unless defined(&CFSOP_INVALIDATE_COBJECT);
    eval 'sub MAXTOKEN_SIZE () {32;}' unless defined(&MAXTOKEN_SIZE);
    eval 'sub MAXCOOKIE_SIZE () {36;}' unless defined(&MAXCOOKIE_SIZE);
    eval 'sub C_VERIFY_ATTRS () {0x1;}' unless defined(&C_VERIFY_ATTRS);
    eval 'sub C_BACK_CHECK () {0x2;}' unless defined(&C_BACK_CHECK);
    eval 'sub C_MAX_ALLOCINFO_SLOTS () {32;}' unless defined(&C_MAX_ALLOCINFO_SLOTS);
    eval 'sub C_FSL_SIZE () {($sizeof{\'struct cachefs_allocmap\'} *  &C_MAX_ALLOCINFO_SLOTS);}' unless defined(&C_FSL_SIZE);
    eval 'sub MD_BLOTOUT () {0x1;}' unless defined(&MD_BLOTOUT);
    eval 'sub MD_POPULATED () {0x2;}' unless defined(&MD_POPULATED);
    eval 'sub MD_FILE () {0x4;}' unless defined(&MD_FILE);
    eval 'sub MD_FASTSYMLNK () {0x8;}' unless defined(&MD_FASTSYMLNK);
    eval 'sub MD_PINNED () {0x10;}' unless defined(&MD_PINNED);
    eval 'sub MD_LOCAL () {0x20;}' unless defined(&MD_LOCAL);
    eval 'sub MD_INVALREADDIR () {0x40;}' unless defined(&MD_INVALREADDIR);
    eval 'sub C_MAX_MOUNT_FSCDIRNAME () {128;}' unless defined(&C_MAX_MOUNT_FSCDIRNAME);
    eval 'sub MAXCNODES () {100;}' unless defined(&MAXCNODES);
    eval 'sub C_FRONT () {0x1;}' unless defined(&C_FRONT);
    eval 'sub C_BACK () {0x2;}' unless defined(&C_BACK);
    eval 'sub c_attr () { ($c_metadata->{md_vattr});}' unless defined(&c_attr);
    eval 'sub c_token () { ($c_metadata->{md_token});}' unless defined(&c_token);
    eval 'sub c_cookie () { ($c_metadata->{md_cookie});}' unless defined(&c_cookie);
    eval 'sub CFS_DIRCACHE_COST () {3;}' unless defined(&CFS_DIRCACHE_COST);
    eval 'sub CFS_DIRCACHE_INVAL () {3;}' unless defined(&CFS_DIRCACHE_INVAL);
    eval 'sub CFS_DIRCACHE_ENABLE () {( &CFS_DIRCACHE_INVAL *  &CFS_DIRCACHE_COST);}' unless defined(&CFS_DIRCACHE_ENABLE);
    eval 'sub VTOC {
        local($VP) = @_;
	    eval q(((($VP)-> &v_data)));
    }' unless defined(&VTOC);
    eval 'sub CTOV {
        local($CP) = @_;
	    eval q((( &vnode_t *)(($CP)-> &c_vnode)));
    }' unless defined(&CTOV);
    eval 'sub VFS_TO_FSCACHE {
        local($VFSP) = @_;
	    eval q(((($VFSP)-> &vfs_data)));
    }' unless defined(&VFS_TO_FSCACHE);
    eval 'sub C_TO_FSCACHE {
        local($CP) = @_;
	    eval q(( &VFS_TO_FSCACHE( &CTOV($CP)-> &v_vfsp)));
    }' unless defined(&C_TO_FSCACHE);
    eval 'sub CN_NOCACHE () {0x1;}' unless defined(&CN_NOCACHE);
    eval 'sub CN_DESTROY () {0x2;}' unless defined(&CN_DESTROY);
    eval 'sub CN_ROOT () {0x4;}' unless defined(&CN_ROOT);
    eval 'sub CN_INACTIVE () {0x8;}' unless defined(&CN_INACTIVE);
    eval 'sub CN_BLOTOUT () {0x10;}' unless defined(&CN_BLOTOUT);
    eval 'sub CN_LOCAL () {0x20;}' unless defined(&CN_LOCAL);
    eval 'sub CN_UPDATED () {0x40;}' unless defined(&CN_UPDATED);
    eval 'sub CDIRTY () {0x80;}' unless defined(&CDIRTY);
    eval 'sub CN_NEED_FRONT_SYNC () {0x100;}' unless defined(&CN_NEED_FRONT_SYNC);
    eval 'sub CN_ALLOC_PENDING () {0x200;}' unless defined(&CN_ALLOC_PENDING);
    eval 'sub CN_STALE () {0x400;}' unless defined(&CN_STALE);
    eval 'sub CFASTSYMLNK () {0x800;}' unless defined(&CFASTSYMLNK);
    eval 'sub CN_MODIFIED () {0x1000;}' unless defined(&CN_MODIFIED);
    eval 'sub CN_NEED_INVAL () {0x2000;}' unless defined(&CN_NEED_INVAL);
    eval 'sub CN_HASHSKIP () {0x4000;}' unless defined(&CN_HASHSKIP);
    eval 'sub CN_POPULATION_PENDING () {0x8000;}' unless defined(&CN_POPULATION_PENDING);
    eval 'sub CN_LRU () {0x10000;}' unless defined(&CN_LRU);
    eval 'sub CIO_PUTPAGES () {0x1;}' unless defined(&CIO_PUTPAGES);
    eval 'sub CHASH {
        local($FILENO) = @_;
	    eval q((($FILENO & ( &CNODE_BUCKET_SIZE - 1))));
    }' unless defined(&CHASH);
    eval 'sub CFS_MAX_THREADS () {5;}' unless defined(&CFS_MAX_THREADS);
    eval 'sub CFS_ASYNC_TIMEOUT () {(60*  &HZ);}' unless defined(&CFS_ASYNC_TIMEOUT);
    eval("sub CFS_CACHE_SYNC () { 0; }") unless defined(&CFS_CACHE_SYNC);
    eval("sub CFS_PUTPAGE () { 1; }") unless defined(&CFS_PUTPAGE);
    eval("sub CFS_INACTIVE () { 2; }") unless defined(&CFS_INACTIVE);
    eval("sub CFS_NOOP () { 3; }") unless defined(&CFS_NOOP);
    eval 'sub CFS_MAX_EXPORT_SIZE () {10;}' unless defined(&CFS_MAX_EXPORT_SIZE);
    eval 'sub CFS_FID_LOCAL () {1;}' unless defined(&CFS_FID_LOCAL);
    eval 'sub CFS_FID_BACK () {2;}' unless defined(&CFS_FID_BACK);
    eval 'sub CFS_FID_SIZE () {($sizeof{\'struct cachefs_fid\'} - $sizeof{\'u_short\'});}' unless defined(&CFS_FID_SIZE);
    if(defined(&ZIP)) {
	eval 'sub CFS_CM_FRONT () {1;}' unless defined(&CFS_CM_FRONT);
	eval 'sub CFS_CM_BACK () {2;}' unless defined(&CFS_CM_BACK);
    }
    if(defined( &_KERNEL)  && defined( &__STDC__)) {
    }
    eval 'sub C_LRU_MAXENTS () {0x4000;}' unless defined(&C_LRU_MAXENTS);
    if(defined(&DEBUG)) {
	eval 'sub CFSDEBUG_ALL () {0xffffffff;}' unless defined(&CFSDEBUG_ALL);
	eval 'sub CFSDEBUG_NONE () {0x0;}' unless defined(&CFSDEBUG_NONE);
	eval 'sub CFSDEBUG_SUBR () {0x1;}' unless defined(&CFSDEBUG_SUBR);
	eval 'sub CFSDEBUG_CNODE () {0x2;}' unless defined(&CFSDEBUG_CNODE);
	eval 'sub CFSDEBUG_DIR () {0x4;}' unless defined(&CFSDEBUG_DIR);
	eval 'sub CFSDEBUG_STRICT () {0x8;}' unless defined(&CFSDEBUG_STRICT);
	eval 'sub CFSDEBUG_VOPS () {0x10;}' unless defined(&CFSDEBUG_VOPS);
	eval 'sub CFSDEBUG_VFSOP () {0x20;}' unless defined(&CFSDEBUG_VFSOP);
	eval 'sub CFSDEBUG_RESOURCE () {0x40;}' unless defined(&CFSDEBUG_RESOURCE);
	eval 'sub CFSDEBUG_CHEAT () {0x80;}' unless defined(&CFSDEBUG_CHEAT);
	eval 'sub CFS_DEBUG {
	    local($N) = @_;
    	    eval q( &if ( &cachefsdebug & ($N)));
	}' unless defined(&CFS_DEBUG);
	eval 'sub CFSDEBUG () {1;}' unless defined(&CFSDEBUG);
    }
    eval 'sub C_ISVDEV {
        local($t) = @_;
	    eval q((($t ==  &VBLK) || ($t ==  &VCHR) || ($t ==  &VFIFO) || ($t ==  &VXNAM)));
    }' unless defined(&C_ISVDEV);
    require 'sys/ioccom.ph';
    eval 'sub _FIOPIN () { &_IO(ord(\'f\'), 72);}' unless defined(&_FIOPIN);
    eval 'sub _FIOUNPIN () { &_IO(ord(\'f\'), 73);}' unless defined(&_FIOUNPIN);
    eval 'sub _FIOCACHESYNC () { &_IO(ord(\'f\'), 74);}' unless defined(&_FIOCACHESYNC);
    eval 'sub _FIOCNVTMNT () { &_IO(ord(\'f\'), 80);}' unless defined(&_FIOCNVTMNT);
    if(defined(&__cplusplus)) {
    }
}
1;
