.if n \{\
.	ds ct "
.\}
.if t \{\
.	ds ct \\(co
.\}
.TH READMSG 1L "Elm Version 2.5" "USENET Community Trust"
.SH NAME
readmsg - extract messages from a mail folder
.SH SYNOPSIS
.B readmsg
[\fB\-anhp\fR]
[\fB\-f\fR folder]
[\fB\-w\fR weedlist]
[selection ...]
.SH DESCRIPTION
.I Readmsg
extracts selected mail messages from a mail folder.  One helpful use of
the program is when you are composing a response to a mail message in an
external editor.  In this case, you can run
.I readmsg
to pull a copy of the original message into the editing buffer.
.P
When you run
.I readmsg
from within
.I elm
(e.g. from a subshell escape or in an external editor while composing
a mail reply) it behaves a bit differently from when you run it directly
(e.g. from a shell command line).  We will first describe its normal
behavior, and then describe how it is different when you run it under
.IR elm .
.P
You tell
.I readmsg
which messages to extract with the
.I selection
argument.  There are a couple of possible different ways to specify
the
.IR selection .
.IP "1."
A lone ``*'' means select all messages in the mailbox.
.IP "2."
A list of message numbers may be specified.  Values of ``0'' and
``$'' in the list both mean the last message in the mailbox.  For
example:
.ft CW
.sp
	readmsg 1 3 0
.sp
.ft P
extracts three messages from the folder:  the first, the third, and
the last.
.IP "3."
Finally, the
.I selection
may be some text to match.  This will select a mail message which
.I exactly
matches the specified text.  For example,
.ft CW
.sp
	readmsg staff meeting
.sp
.ft P
extracts the message which contains the words ``staff meeting.''  Note
that it will
.I not
match a message containing ``Staff Meeting'' \(en the matching is case
sensitive.  Normally only the first message which matches the pattern
will be printed.  The
.B \-a
option discussed in a moment changes this.
.P
The
.B \-f
flag indicates that you'd rather use the folder specified
rather than the default incoming mailbox.  The specified
.I folder
can be a filename or a specification such as ``=sentmail''.
.P
The
.B \-w
flag tailors the list of mail headers that are weeded and displayed.
Header weeding is discussed below.
.P
The
.B \-h
flag instructs the program to ignore the header weeding list, and
include the entire header of the matched message or messages when
displaying their text.
.P
The
.B \-n
flag instructs the program to ignore the header weeding list, and
exclude \fIall\fR headers.  This is used mostly for extracting files
mailed and such.
.P
The
.B \-p
flag indicates that the program should
put form-feeds (control-L) between message headers.
.P
The
.B \-a
flag indicates that all messages which match the pattern
specified on the command line should be printed, not just the first.
If a pattern was not specified on the command line then this flag has
no effect.
.P
When you run
.I readmsg
under
.I elm
(say in the context of an external editor) the behavior
will be different from that described above as follows.
.IP "1."
The default mail folder will be the folder you are currently
examining in
.I elm
and not necessarily your incoming mail folder.
.IP "2."
You do not need to specify a
.I selection
on the command line.  If you omit the
.I selection
then
.I readmsg
will extract the message(s) you have selected in Elm.  If you have
tagged any messages then this would be all of the tagged messages,
otherwise it would be the message you are currently examining.
.IP "3."
Normally the message numbers
.I readmsg
uses are in mailbox order.  When you call
.I readmsg
under
.I elm
and do not override the folder selection with the
.B \-f
option, then message numbers will be sorted as they are displayed on
the
.I elm
message index screen.
.P
Normally,
.I readmsg
selects and displays certain headers from the message.  By default,
the list of selected headers includes:
.P
.RS
.nf
\(bu The ``Subject:'' header.
\(bu The ``From:'' header.
\(bu The ``To:'' header.
\(bu The ``Cc:'' header.
\(bu The ``Date:'' header.
\(bu Any header starting with ``Apparently-''.
.fi
.RE
.P
The header weeding may be changed with the
.B \-w
option.  The argument to this option is a list of header names,
separated by whitespace or commas.
.I readmsg
compares each header to the ones in this list, and if a match is found
the header is displayed.  The list entries can contain partial header
names.  For instance, an entry of ``From'' would match both the
``From\s-1<SPACE>\s0'' line at the top of the message, as well as any
``From:'' header.  Matching is case insensitive.  An underscore (``_'')
may be used to represent a space, so specifying ``From_'' will select
the ``From\s-1<SPACE>\s0'' line but not the ``From:'' header.  A list
entry may be preceded by an exclamation point to suppress the header.
Thus, a specification of ``!From_\0From'' means about the same thing
as ``From:''.  When no header weeding options are specified, the
default action corresponds to:
.P
.ft CW
	readmsg -w "Subject: From: To: Cc: Apparently- Date:"
.ft 1
.SH "EXAMPLES"
First off, to use this from within \fBvi\fR to include the text of the 
current message, you could use the command:
.nf

	:r !readmsg

.fi
(as you hit the ':' the editor will put you at the bottom of the screen
with the ':' prompt).  The space following ':r' is required.
.sp 2
Let's look at something more interesting, however;
.sp
Suppose you have the mail file;
.nf

   From joe Jun 3 1986 4:45:30 MST
   Subject: hello
   
   Hey Guy!  Wanta go out and have a milk this evening?
   
   Joe
   
   From john Jun 3 1986 4:48:20 MST
   Subject: Dinner at Eight
   From: John Dinley <xyz!john>

   Remember you should show up about eight, okay?

		   - John D -

   From xxzyz!cron Jun 3 1986 5:02:43 MST

   Cannot connect to server: blob
   Job 43243 deleted from queue.
   
.fi
The following commands will result in;
.nf

  $ readmsg 2		
  [ display the second message, from John ]

  $ readmsg 		
  [ an error, unless we're calling from \fIelm\fR ]

  $ readmsg BLOB	
  [ no match - case sensitive! ]

  $ readmsg -h connect to server 
  [ displays third message, including headers ]

.fi
.SH FILES
/usr/mail/<username>   		The incoming mail
.br
$ELMSTATE			Status information from \fIelm\fR
.SH AUTHOR
Elm Development Group
.SH SEE ALSO
newmail(1L), elm(1L)
.SH BUGS
The '*' metacharacter doesn't always work as expected!
.br
Perhaps the pattern matching should be case insensitive?
.br
It might be confusing that messages are sorted when running under
.I elm
with the current folder, and in mailbox order for all other cases.
When
.I readmsg
is run standalone, messages may be truncated at lines beginning with
"From".  This is not a problem when
.I readmsg
is spawned under
.IR elm
because the status information file created by
.I elm
says exactly how long each message is.
.SH BUG REPORTS TO
Bill Pemberton  flash@virginia.edu
.SH COPYRIGHTS
\fB\*(ct\fRCopyright 1988-1995 by The USENET Community Trust
.br
Derived from Elm 2.0, \fB\*(ct\fR Copyright 1986, 1987 by Dave Taylor
