;;; se-mode.el --- minor mode for editing SE Toolkit interpreter files in Emacs

;;; Author: Rajesh Godbole <argv@Sun.COM>
;;; version: 1.01 Wed Oct 15 16:36:12 PDT 1997

;;; Borrowed from cc-mode of [x]emacs

;;; A major mode for editing SE Toolkit interpreter files.  When you have
;;; entered SE mode, you may get more info by pressing C-h m.  You may
;;; also get online help describing various functions by: C-h f
;;; <Name of function you want described

;;; To set up automatic se mode, put this file in your load path,
;;; byte-compile it and include stuff like this in your .emacs:

; (autoload 'se-mode "se-mode" "SE mode" t )
; (setq auto-mode-alist (cons  '("\\.se\\'" . se-mode) auto-mode-alist))


(eval-when-compile
  (require 'cc-mode))

(defun se-mode ()
  "Major mode for editing Sun Microsystems' SE Toolkit code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
se-mode buffer.  This automatically sets up a mail buffer with version
information already added.  You just need to add a description of the
problem, including a reproducible test case and send the message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook variable `se-mode-hook' is run with no args, if that value is
bound and has a non-nil value.  Also the hook `se-mode-common-hook' is
run first.

Key bindings:
\\{se-mode-map}"
  (interactive)
  (c-initialize-cc-mode)
  (kill-all-local-variables)
  (set-syntax-table c-mode-syntax-table)
  (setq major-mode 'c-mode
	mode-name "SE"
	local-abbrev-table c-mode-abbrev-table)
  (use-local-map c-mode-map)
  (c-common-init)
  (setq comment-start "/* "
	comment-end   " */"
	c-conditional-key c-C-conditional-key
	c-class-key c-C-class-key
	c-baseclass-key nil
	c-comment-start-regexp c-C++-comment-start-regexp
	imenu-generic-expression cc-imenu-c-generic-expression)
  (run-hooks 'c-mode-common-hook)
  (run-hooks 'c-mode-hook)
  (c-update-modeline))
