if (!defined &_SYS_CPUVAR_H) {
    eval 'sub _SYS_CPUVAR_H () {1;}' unless defined(&_SYS_CPUVAR_H);
    require 'sys/thread.ph';
    require 'sys/sysinfo.ph';
    require 'sys/gprof.ph';
    require 'sys/disp.ph';
    require 'sys/processor.ph';
    if ((defined( &_KERNEL) || defined( &_KMEMUSER)) & defined( &_MACHDEP)) {
	require 'sys/machcpuvar.ph';
    }
    require 'sys/types.ph';
    require 'sys/file.ph';
    if (defined &__cplusplus) {
    }
    if ((defined( &_KERNEL) || defined( &_KMEMUSER)) & defined( &_MACHDEP)) {
    }
    eval 'sub CPU_RUNNING () {0x01;}' unless defined(&CPU_RUNNING);
    eval 'sub CPU_READY () {0x02;}' unless defined(&CPU_READY);
    eval 'sub CPU_QUIESCED () {0x04;}' unless defined(&CPU_QUIESCED);
    eval 'sub CPU_EXISTS () {0x08;}' unless defined(&CPU_EXISTS);
    eval 'sub CPU_ENABLE () {0x10;}' unless defined(&CPU_ENABLE);
    eval 'sub CPU_OFFLINE () {0x20;}' unless defined(&CPU_OFFLINE);
    eval 'sub CPU_POWEROFF () {0x40;}' unless defined(&CPU_POWEROFF);
    eval 'sub CPU_ACTIVE {
        local($cpu) = @_;
        eval "((($cpu)-> &cpu_flags   &CPU_OFFLINE) == 0)";
    }' unless defined(&CPU_ACTIVE);
    if ((defined(&NCPU) ? &NCPU : 0) > 32) {
	if (!defined &NBBY) {
	    eval 'sub NBBY () {8;}' unless defined(&NBBY);
	}
	eval 'sub CPUSHIFT () {5;}' unless defined(&CPUSHIFT);
	eval 'sub CPUBPM () {($sizeof{ &uint32_t} *  &NBBY);}' unless defined(&CPUBPM);
	eval 'sub CPUMASKS {
	    local($x, $y) = @_;
	    eval "((($x)+(($y)-1))/($y))";
	}' unless defined(&CPUMASKS);
	eval 'sub CPUSET_SIZE () { &CPUMASKS( &NCPU,  &CPUBPM);}' unless defined(&CPUSET_SIZE);
	eval 'sub CPUSET {
	    local($cpu) = @_;
	    eval "(( &uint32_t)1<< (($cpu)  0x1f))";
	}' unless defined(&CPUSET);
	eval 'sub CPUSET_ALL () {{~0, ~0, ~0, ~0};}' unless defined(&CPUSET_ALL);
	eval 'sub CPUSET_ALL_BUT {
	    local($cpu) = @_;
	    eval "";
	}' unless defined(&CPUSET_ALL_BUT);
	eval 'sub CPU_IN_SET {
	    local($set, $cpu) = @_;
	    eval "((($set). $cpub[($cpu)>> &CPUSHIFT])   &CPUSET($cpu))";
	}' unless defined(&CPU_IN_SET);
	eval 'sub CPUSET_ADD {
	    local($set, $cpu) = @_;
	    eval "((($set). $cpub[($cpu)>> &CPUSHIFT]) |=  &CPUSET($cpu))";
	}' unless defined(&CPUSET_ADD);
	eval 'sub CPUSET_DEL {
	    local($set, $cpu) = @_;
	    eval "((($set). $cpub[($cpu)>> &CPUSHIFT]) = ~ &CPUSET($cpu))";
	}' unless defined(&CPUSET_DEL);
	eval 'sub CPUSET_ZERO {
	    local($set) = @_;
	    eval "( &bzero(($set), $sizeof{($set)}))";
	}' unless defined(&CPUSET_ZERO);
	eval 'sub CPUSET_ISEQUAL {
	    local($set1, $set2) = @_;
	    eval "( &cpuset_cmp(($set1), ($set2)))";
	}' unless defined(&CPUSET_ISEQUAL);
	eval 'sub CPUSET_ISNULL {
	    local($set) = @_;
	    eval "( &cpuset_isnull($set))";
	}' unless defined(&CPUSET_ISNULL);
	eval 'sub CPUSET_OR {
	    local($set1, $set2) = @_;
	    eval "{ \'int\'  &_i;  &uint32_t * &_s1 = ( &uint32_t *)($set1);  &uint32_t * &_s2 = ( &uint32_t *)($set2);  &for ( &_i = 0;  &_i <  &CPUSET_SIZE;  &_i++) * &_s1++ |= * &_s2++; }";
	}' unless defined(&CPUSET_OR);
	eval 'sub CPUSET_AND {
	    local($set1, $set2) = @_;
	    eval "{ \'int\'  &_i;  &uint32_t * &_s1 = ( &uint32_t *)($set1);  &uint32_t * &_s2 = ( &uint32_t *)($set2);  &for ( &_i = 0;  &_i <  &CPUSET_SIZE;  &_i++) * &_s1++ = * &_s2++; }";
	}' unless defined(&CPUSET_AND);
	eval 'sub CPUSET_CAS {
	    local($setp, $cpu) = @_;
	    eval "{  &uint32_t  &_wix,  &_cwrd,  &_nwrd;  &extern  &uint32_t  &cas32( &uint32_t *,  &uint32_t,  &uint32_t);  &_wix = ($cpu) >>  &CPUSHIFT;  &do {  &_cwrd = ($setp). $cpub[ &_wix];  &_nwrd =  &_cwrd;  &_nwrd |=  &CPUSET(($cpu));  &_nwrd =  &cas32(($setp). $cpub[ &_wix],  &_cwrd,  &_nwrd); }  &while ( &_nwrd !=  &_cwrd); }";
	}' unless defined(&CPUSET_CAS);
    }
    else {
	eval 'sub CPUSET {
	    local($cpu) = @_;
	    eval "(1<< ($cpu))";
	}' unless defined(&CPUSET);
	eval 'sub CPUSET_ALL () {(~0);}' unless defined(&CPUSET_ALL);
	eval 'sub CPUSET_ALL_BUT {
	    local($cpu) = @_;
	    eval "(~ &CPUSET($cpu))";
	}' unless defined(&CPUSET_ALL_BUT);
	eval 'sub CPU_IN_SET {
	    local($set, $cpu) = @_;
	    eval "(($set)   &CPUSET($cpu))";
	}' unless defined(&CPU_IN_SET);
	eval 'sub CPUSET_ADD {
	    local($set, $cpu) = @_;
	    eval "(($set) |=  &CPUSET($cpu))";
	}' unless defined(&CPUSET_ADD);
	eval 'sub CPUSET_DEL {
	    local($set, $cpu) = @_;
	    eval "(($set) = ~ &CPUSET($cpu))";
	}' unless defined(&CPUSET_DEL);
	eval 'sub CPUSET_OR {
	    local($set1, $set2) = @_;
	    eval "{ (($set1) |= ($set2)); }";
	}' unless defined(&CPUSET_OR);
	eval 'sub CPUSET_AND {
	    local($set1, $set2) = @_;
	    eval "{ (($set1) = ($set2)); }";
	}' unless defined(&CPUSET_AND);
	eval 'sub CPUSET_ZERO {
	    local($set) = @_;
	    eval "(($set) = 0)";
	}' unless defined(&CPUSET_ZERO);
	eval 'sub CPUSET_ISNULL {
	    local($set) = @_;
	    eval "(($set) == 0)";
	}' unless defined(&CPUSET_ISNULL);
	eval 'sub CPUSET_ISEQUAL {
	    local($set1, $set2) = @_;
	    eval "(($set1) == ($set2))";
	}' unless defined(&CPUSET_ISEQUAL);
	eval 'sub CPUSET_CAS {
	    local($set, $cpu) = @_;
	    eval "{  &uint32_t  &_cs,  &_ns;  &extern  &uint32_t  &cas32( &uint32_t *,  &uint32_t,  &uint32_t);  &do {  &_cs = ($set);  &_ns =  &_cs;  &CPUSET_ADD( &_ns, ($cpu));  &_ns =  &cas32(($set),  &_cs,  &_ns); }  &while ( &_ns !=  &_cs); }";
	}' unless defined(&CPUSET_CAS);
    }
    eval 'sub CPU_CPR_ONLINE () {0x1;}' unless defined(&CPU_CPR_ONLINE);
    eval 'sub CPU_CPR_IS_OFFLINE {
        local($cpu) = @_;
        eval "((($cpu)-> &cpu_cpr_flags   &CPU_CPR_ONLINE) == 0)";
    }' unless defined(&CPU_CPR_IS_OFFLINE);
    eval 'sub CPU_SET_CPR_FLAGS {
        local($cpu, $flag) = @_;
        eval "(($cpu)-> &cpu_cpr_flags |= $flag)";
    }' unless defined(&CPU_SET_CPR_FLAGS);
    if (defined( &i386) || defined( &__i386)) {
	eval 'sub CPU () {( &curcpup());}' unless defined(&CPU);
    }
    else {
	eval 'sub CPU () {( &curthread-> &t_cpu);}' unless defined(&CPU);
    }
    eval 'sub CPU_STAT_ENTER_K () {
        eval " &kpreempt_disable()";
    }' unless defined(&CPU_STAT_ENTER_K);
    eval 'sub CPU_STAT_EXIT_K () {
        eval " &kpreempt_enable()";
    }' unless defined(&CPU_STAT_EXIT_K);
    eval 'sub CPU_STAT_ADD_K {
        local($thing, $amount) = @_;
        eval "{  &kpreempt_disable();  &CPU_STAT_ADDQ( &CPU, $thing, $amount);  &kpreempt_enable(); }";
    }' unless defined(&CPU_STAT_ADD_K);
    eval 'sub CPU_STAT_ADDQ {
        local($cpuptr, $thing, $amount) = @_;
        eval "$cpuptr-> &cpu_stat.$thing += $amount";
    }' unless defined(&CPU_STAT_ADDQ);
    if (defined( &_KERNEL) & defined( &__STDC__) ) {
    }
    if (defined &__cplusplus) {
    }
}
1;
