'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) scrolledtext.n 1.21 94/12/17 16:04:44
'/" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS messagebox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
messagebox \- Create and manipulate a messagebox text widget
.SH SYNOPSIS
\fBmessagebox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Labeledwidget <- Scrolledwidget <- Messagebox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBactiveForeground\fR	\fBbackground\fR	\fBborderWidth\fR
\fBcursor\fR	\fBexportSelection\fR	\fBfont\fR	\fBforeground\fR
\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBpadX\fR	\fBpadY\fR
\fBrelief\fR	\fBsetGrid\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBactiveRelief\fR	\fBelementBorderWidth\fR	\fBjump\fR	\fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBhscrollMode\fR	\fBsbWidth\fR	\fBscrollMargin\fR
\fBtextBackground\fR	\fBvisibleItems\fR	\fBvscrollMode\fR	\fBwidth\fR
.fi
.LP
See the "scrolledtext" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBspacing1\fR	\fBspacing2\fR	\fBspacing3\fR
.fi
.LP
See the "text" widget manual entry for details on the above
associated options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBfileName\fR
Class:	\fBFileName\fR
Command-Line Switch:	\fB-filename\fR
.fi
.IP
Specifies the filename to be displayed in the file selection dialog when 
it pops up during a save of the messagebox contents operation.
.LP
.nf
Name:	\fBmaxLines\fR
Class:	\fBMaxLines\fR
Command-Line Switch:	\fB-maxlines\fR
.fi
.IP
Specifies the maximum number of lines allowed in the text area of the 
messagebox. When this limit is reached, the oldest line will be deleted 
such that the total number of lines remains \fImaxlines\fR.
.LP
.nf
Name:	\fBsaveDir\fR
Class:	\fBSaveDir\fR
Command-Line Switch:	\fB-savedir\fR
.fi
.IP
Specifies the default directory to display when the file selection dialog 
pops up during a save of the messagebox contents operation. If this 
parameter is not specified, then the files in the current working directory 
are displayed.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBmessagebox\fR command creates 
a scrolled information messages area widget.
Message types can be user defined and configured.  Their options
include foreground, background, font, bell, and their display
mode of on or off.  This allows message types to defined as needed,
removed when no longer so, and modified when necessary.  An export
method is provided for file I/O.

.PP
The number of lines displayed may be limited with
the default being 1000. When this limit is reached, the oldest line 
is removed.  A popup menu which appears when the right mouse button
has been pressed in the message area has been predefined.  The contents
of the popup menu by default support clearing the area and saving its
contents to a file.  Additional operations may be defined or existing
operations removed by using the component command to access the 
popup menu.

.SH "MESSAGE TYPES"
.PP
The display characteristics of messages issued to the messagebox vary
with the message type.  Types are defined by the user and they may
be added, removed, and configured.  The options of the message type
control the display include the following:
.TP
\fB\-background \fIcolor\fR
\fIColor\fR specifies the background color to use for characters
associated with the message type.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-bell \fIboolean\fR
Specifies whether or not to ring the bell whenenver a message of this
type is issued.  \fIBoolean\fR may have any of the forms accepted by 
\fBTk_GetBoolean\fR.  The default is 0.
.TP
\fB-font\ \fIfontName\fR
\fIFontName\fR is the name of a font to use for drawing
characters.  It may have any of the forms accepted
by Tk_GetFontStruct.
.TP
\fB\-foreground \fIcolor\fR
\fIColor\fR specifies the foreground color to use for characters
associated with the message type.
It may have any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-show \fIboolean\fR
Specifies whether of not to display this message type when issued.
\fIBoolean\fR may have any of the forms accepted by 
\fBTk_GetBoolean\fR.  The default is 1.

.SH "METHODS"
.PP
The \fBmessagebox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for messagebox widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBmessagebox\fR
command.
.TP
\fIpathName \fBclear\fR
Clear the messagebox of all messages.
.TP
\fIpathName \fBexport\fR \fIfilename\fR
Write text to a file.  If \fIfilename\fR exists then
contents are replaced with text widget contents.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBmessagebox\fR
command.
.TP
\fIpathName \fBtype\fR \fIoption\fR \fImsgtype\fR ?\fIarg arg ...\fR?
This  command  is  used to manipulate message types.  The behavior of 
the command depends on the option argument that follows the type keyword. 
The following forms of the command are supported:
.RS
.TP
.TP
\fIpathName \fBtype add\fR \fImsgtype\fR ?\fIoption value ...\fR?
Adds a new message type given by \fImsgtype\fR with the display
properties defined by the option value pairs.  
See MESSAGE TYPES for information on the options that
are supported.
.TP
\fIpathName \fBtype cget\fR \fImsgtype option\fR
Returns the value of a configuration option for a message type.
\fIMsgtype\fR identifies the message type, and \fIoption\fR
specifies a particular configuration option, which must be one of
the ones listed in the section MESSAGE TYPES.
.TP
\fIpathName \fBtype configure \fImsgtype\fR ?\fIoption value ...\fR?
Query or modify the configuration options for a message type.
If no \fIoption\fR is specified, returns a list describing all of
the available options for the message type \fImsgtype\fR.
If \fIoption\fR is specified with no \fIvalue\fR, then the command
returns a list describing the one named option.
If one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
See MESSAGE TYPES for information on the options that
are supported.
\fIpathName \fBtype remove\fR \fImsgtype\fR 
Removes an existing message type given by \fImsgtype\fR.
.RE
.TP
\fIpathName \fBissue\fR \fIstring\fR \fI?level?\fR \fI?tags?\fR
Print a \fIstring\fR to the text area at the given level and with
any additional tags specified.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBitemMenu\fR
Class:	\fBMenu\fR
.fi
.IP
This is the popup menu that gets displayed when you right-click in the 
text area of the messagebox.  Its contents may be modified via the component
command.
.LP
.nf
Name:	\fBtext\fR
Class:	\fBScrolledtext\fR
.fi
.IP
The text component is the scrolledtext widget.  See the "scrolledtext" widget 
manual entry for details on the text component item.
.fi

.SH EXAMPLE
.DS
 messagebox .mb -hscrollmode dynamic -labeltext "Messages" -labelpos n \\
	-height 120 -width 550 -savedir "/tmp" -textbackground #d9d9d9

 pack .mb -padx 5 -pady 5 -fill both -expand yes

 .mb type add ERROR -background red -foreground white -bell 1
 .mb type add WARNING -background yellow -foreground black
 .mb type add INFO -background white -foreground black

 .mb issue "This is an error message in red with a beep" ERROR
 .mb issue "This warning message in yellow" WARNING
 .mb issue "This is an informational message" INFO
.DE
.SH AUTHOR
Alfredo Jahn V
.DE
Mark L. Ulferts
.LP
.SH KEYWORDS
messagebox, scrolledtext, text, widget

