
// Abstract class for all app windows
class Window
{
protected:
    HWND hWndFrame;
    HWND hWndClient;

public:
    // Provide (read) access to the windows Client or Frame
    // handles in case they're needed.
    HWND GetFrameHandle(void) { return hWndFrame; }
    HWND GetClient(void) { return hWndClient; }

    BOOL ShowWindow(int nCmdShow) { return WinShowWindow(hWndFrame,nCmdShow); }
    BOOL Update(void) { return WinUpdateWindow(hWndFrame); }

    // Pure virtual function makes "Window" an abstract class
    virtual MRESULT WndProc(HWND hWnd, ULONG iMessage, MPARAM mParam1, MPARAM mParam2 ) = 0;
};

class SleepWindow : public Window
{
private:
    char szClassName[14];

    // pen variables - for drawing the circle
    POINTL penpos, oldpos;
    RECTL windowrect;
    RECTL invalidrect;
    LONG radius;
    LONG direction;

public:
    SleepWindow(HAB);   // constructor
    ~SleepWindow();     // destructor

    BOOL Register(HAB); // register the window class

    void StartSleep();  // start sleeping (ie: wake up the screen saver module)
    void StopSleep();   // stop sleeping (ie: hide the screen saver module)

    MRESULT WndProc(HWND ,ULONG, MPARAM,MPARAM);
};




