#define INCL_PM 
#define INCL_DOS

#include <os2.h>                    
#include <string.h>
#include "sample.h"        // resource file symbolics
#include "saverdef.h"      // message and timer ids

MRESULT EXPENTRY _export ExpWndProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2);

MRESULT EXPENTRY AboutBoxDlgProc(HWND hwnd, ULONG msg,
             MPARAM mp1, MPARAM mp2);

#include "sample.hpp"   // C++ headers for these classes

#undef NULL
#define NULL 0L

static HMODULE dllmod;  // resources used by this screen saver module

static SleepWindow * sleepwin = NULL;
static BOOL initialized = FALSE;


SleepWindow :: SleepWindow(HAB hab) : Window()
{
        ULONG flCreate = FCF_SIZEBORDER | FCF_ICON | FCF_SHELLPOSITION | FCF_TASKLIST;

        hWndFrame = NULL;
        hWndClient = NULL;
        sleepwin = this;

        strcpy(szClassName,"SampleSS");

        if (!Register(hab))
        {
                WinMessageBox(HWND_DESKTOP, NULL,"SleepWindow","Register failed",0,MB_OK);
                // should really abort out here
        }

        hWndFrame = WinCreateStdWindow(
               HWND_DESKTOP,            // Desktop window is parent
               0,
               &flCreate, 
               szClassName, 
               "",
               0, 
               dllmod,           
               ID_WINDOW,               // Frame window identifier 
               &hWndClient 
               );

         windowrect.xLeft = 20;
         windowrect.yBottom = 100;
         windowrect.xRight = 600;
         windowrect.yTop = 300;

         if (!WinSetWindowPos( hWndFrame,
                       HWND_TOP,
                       windowrect.xLeft, windowrect.yBottom,
                       windowrect.xRight, windowrect.yTop,
                       SWP_ACTIVATE | SWP_SIZE | SWP_MOVE
                     ))
                WinMessageBox(HWND_DESKTOP, NULL,"SleepWindow","WinSetWindowPos failed",0,MB_OK);
}  // end of constructor


SleepWindow :: ~SleepWindow()
{
        // free any dynamically allocated memory

        // destroy the window
        WinDestroyWindow(hWndFrame);

}  // end of destructor


BOOL SleepWindow :: Register(HAB hab)
{
        return WinRegisterClass(
            hab,
            szClassName,
            ExpWndProc,
            CS_SIZEREDRAW,
            0
            );
} 

/*************************************************************************
*
*       StartSleep
*
*       Perform any initialization needed for the *CURRENT* activation
*       of the screen saver module.
*
**************************************************************************/
void SleepWindow :: StartSleep()
{
        
         // maximize, activate, and show the window
         WinSetWindowPos( hWndFrame,
                       HWND_TOP,          
                       0, 0, 0, 0, 
                       // Flags set to show and activate frame window
                       SWP_MAXIMIZE | SWP_SHOW | SWP_ACTIVATE
                     );        

        WinSetFocus(HWND_DESKTOP,hWndFrame);

        // get the boundry of the maximized window
        WinQueryWindowRect(hWndFrame,&windowrect);
        
        // initialize variables for the moving circle
        direction = 1; // left;
        radius = 8;
        penpos.x = windowrect.xLeft - radius;
        penpos.y = windowrect.yBottom + ((windowrect.yTop - windowrect.yBottom) / 2);
        oldpos.x = penpos.x;
        oldpos.y = penpos.y;
      
} // end of StartSleep

/***************************************************************************
*
*  StopSleep
*
*  The screen saver is about to wake up - hide its window.  This is also a
*  good time to free any significant memory that the module may be hogging.
*
****************************************************************************/
void SleepWindow :: StopSleep()
{
         // hide the window
         WinSetWindowPos( hWndFrame,
                       HWND_BOTTOM,
                       0, 0, 0, 0,
                       SWP_HIDE 
                     );        
} // end of StopSleep



/***************************************************************************
*
*    WndProc
*
*   Window procedure for SleepWindow.  Parses messages received from
*   presentation manager.
*
****************************************************************************/
MRESULT SleepWindow::WndProc(HWND hWnd,ULONG iMessage,MPARAM mParam1,
                             MPARAM mParam2 )
{
    switch( iMessage )
    {
      case SS_START: // the screen saver module is about to be invoked
        {
                StartSleep();
                
                // return the desired clock period for this screen saver
                // module.  The calling program uses this same clock for 
                // checking for user input (to wakeup), so do not use a
                // clock period longer than 1000 milliseconds.
                return (MRESULT)100;  // 100 milliseconds
        }
        break;
      case SS_STOP:  // the screen saver module is being instructed to wakeup
        {
                StopSleep();
        }
        break;

      case SS_TICK:  // clock tick - do something interesting
        {
                // only do something if the window is showing!
                if (WinIsWindowShowing(hWndFrame) != FALSE)
                {
                        oldpos.x = penpos.x;
                        oldpos.y = penpos.y;

                        // move the circle to a new location
                        if (direction == 1) // left
                        {
                                penpos.x += 8;
                                if ((penpos.x + radius) >= windowrect.xRight)
                                {
                                        penpos.x = windowrect.xRight - radius;
                                        direction = 0; // right
                                }
                        }
                        else // right
                        {
                                penpos.x -= 8;
                                if ((penpos.x - radius) <= windowrect.xLeft)
                                {
                                        penpos.x = windowrect.xLeft + radius;
                                        direction = 1; // right
                                }
                        }

                        // set the invalid area of the window to be a rectangle
                        // surrounding the old and new circle positions
                        if (penpos.x < oldpos.x)
                        {
                                invalidrect.xLeft = penpos.x - radius;
                                invalidrect.xRight = oldpos.x + radius + 1;
                                invalidrect.yTop = penpos.y + radius + 1;
                                invalidrect.yBottom = penpos.y - radius;
                        }
                        else
                        {
                                invalidrect.xLeft = oldpos.x - radius;
                                invalidrect.xRight = penpos.x + radius + 1;
                                invalidrect.yTop = penpos.y + radius + 1;
                                invalidrect.yBottom = penpos.y - radius;
                        }
        
                        // cause the window to repaint 
                        WinInvalidateRect(hWndClient,&invalidrect,FALSE);
                }
        }
        break;

      case SS_CREDITS:  // This is where you tell the world who created this
                        // screen saver module.  You could even use this
                        // space to ask for a few bucks.
            WinDlgBox(HWND_DESKTOP,
                      hWndFrame,
                      (PFNWP)AboutBoxDlgProc,
                      (HMODULE)dllmod,
                      IDD_ABOUT,
                      (PVOID)NULL);

        break;

      case WM_CREATE:
        // Do any required window initialization stuff here
        break;

      case WM_ERASEBACKGROUND:
        // Return TRUE to cause PM to paint the window background
        // in SYSCLR_WINDOW.
        return (MRESULT)( TRUE );

      case WM_PAINT:
        // Window draw stuff here - do the window background in black and
        // the circle in red
        {
          HPS    hps;
          RECTL  rc;
          POINTL pt;
   	  static ARCPARAMS arcp = {1, 1, 0, 0};

          hps = WinBeginPaint( hWnd, (HPS)NULL, &rc );
          WinFillRect( hps, &rc, CLR_BLACK );// Fill invalid rectangle

          GpiMove(hps, &penpos);
          GpiSetColor(hps,CLR_RED);
	  GpiSetArcParams(hps, &arcp);
	  GpiFullArc(hps, DRO_OUTLINEFILL, MAKEFIXED(radius, 0)); 

          WinEndPaint( hps );  
          break;
        }

      default:
          return WinDefWindowProc( hWnd, iMessage , mParam1, mParam2 );
      }
      return FALSE;
}


/**************************************************************************
*
*  ExpWndProc
*
*  Exported Window Procedure - parses messages from Presentation Manager,
*  sends them on to the SleepWindow once its been initialized.
*
***************************************************************************/
MRESULT EXPENTRY _export ExpWndProc(HWND hWnd,ULONG iMessage,
    MPARAM mParam1, MPARAM mParam2)
{
   if (initialized == FALSE)
   {
        if (iMessage == WM_CREATE)
        {
                initialized = TRUE;
                if (sleepwin == NULL)
                {
                        WinMessageBox(HWND_DESKTOP, NULL,"ExpWndProc","Got WM_CREATE but sleepwin is NULL",0,MB_OK);
                        return (MPARAM)0L;
                }
                else
                        return sleepwin->WndProc(hWnd,iMessage,mParam1,mParam2);
        }
        else
        {
                return WinDefWindowProc(hWnd,iMessage,mParam1,mParam2);
        }
   }
   else
   {
        if (sleepwin)
        {
                return sleepwin->WndProc(hWnd,iMessage,mParam1,mParam2);
        }
        else
        {
                return WinDefWindowProc(hWnd,iMessage,mParam1,mParam2);
        }
   }
}  // end ExpWndProc


/**************************************************************************
*
*  AboutBoxDlgProc
*
*  Window procedure for the About Box.
*
***************************************************************************/
MRESULT EXPENTRY AboutBoxDlgProc(HWND hwnd, ULONG msg,MPARAM mp1,MPARAM mp2)
{
        switch(msg)  
        {
        case WM_COMMAND:
                /* no matter what the command, close the dialog */
                WinDismissDlg(hwnd, TRUE);
        break;

        default:
                return(WinDefDlgProc(hwnd, msg, mp1, mp2));

        }

        return 0L;

} // end AboutBoxDlgProc() 


/***************************************************************************
*
*  LoadDLL
*
*  You MUST provide this procedure, even if your module does not require a
*  resource DLL (in that case, just return NULL).
*
*  IMPORTANT - if coding in 'C' rather than 'C++', you must name this
*  procedure @LoadDLL$qv   - this is what the Borland C++ compiler 'name
*  mangles' it to.  The calling program uses that exact name to get the
*  address of this function via DosQueryProcAddr.
*
***************************************************************************/

HMODULE _export LoadDLL()
{
        initialized = FALSE;
	char LoadError[100];
        long dosrtn;

        // give a relative path to the resource DLL file.
        // Note that this screen saver module is to be installed in a 
        // self-named subdirectory of the directory that holds the 
        // screen saver program itself.
	dosrtn = DosLoadModule(LoadError,sizeof(LoadError),".\\sample\\resource.dll",&dllmod);

        return dllmod;  // return the handle of the resource module 
}


/***************************************************************************
*
*  InitSaver
*
*  You MUST provide this procedure.  This is where you should create (but
*  not show) your screen saver module window.
*
*  IMPORTANT - if coding in 'C' rather than 'C++', you must name this
*  procedure @InitSaver$qul   - this is what the Borland C++ compiler 'name
*  mangles' it to.  The calling program uses that exact name to get the
*  address of this function via DosQueryProcAddr.
*
***************************************************************************/

HWND _export InitSaver(HAB hab)  // given anchor block handle of calling program
{
        initialized = FALSE;
        new SleepWindow(hab);
        return sleepwin->GetFrameHandle();  // return the handle to your
                                            // screen saver module's window                                                                                                                                                    
}


/***************************************************************************
*
*  ReleaseSaver
*
*  You MUST provide this procedure.  This is where you should destroy your
*  screen saver module's window and free any remaining resources - this 
*  screen saver module is about to be replaced with a different one.
*
*  IMPORTANT - if coding in 'C' rather than 'C++', you must name this
*  procedure @ReleaseSaver$qv   - this is what the Borland C++ compiler 'name
*  mangles' it to.  The calling program uses that exact name to get the
*  address of this function via DosQueryProcAddr.
*
***************************************************************************/

void _export ReleaseSaver()
{
        delete sleepwin;
}

