#
# Makefile for TREESIZE.EXE.
#
# For use with IBM NMAKE, which is part of IBM C-Set/2 and VisualAge C++.
# This file will probably not work with other MAKE utilities, such as
# GNU make or DMAKE.
#
#       Copyright (C) 1997-98 Ulrich Mller.
#       This file is part of the XFolder source package.
#       XFolder is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published
#       by the Free Software Foundation, in version 2 as it comes in the
#       "COPYING" file of the XFolder main distribution.
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#

# HELPERS must be the path to the XFolder /helpers directory.
# WarpIn does not require XFolder to run, but needs a bit of
# source code from XFolder so that I don't have to rewrite
# everything. The .OBJ files from these sources are created
# in our own directory, because we are using different compiler
# options than XFolder does.
HELPERS = G:\develop\C\XFolder\source\helpers

INCLUDE = $(INCLUDE);$(HELPERS)

CC      = icc /c /Ge /Gd- /Se /Re /ss /Gm+ /O- /Oi- /q+ /w2
HEADERS = treesize.h ..\helpers\eas.h ..\helpers\eas.h ..\helpers\dosh.h

ALL_OBJ1 = treesize.obj eas.obj dosh.obj stringh.obj

all: treesize.exe

treesize.res: treesize.rc treesize.h treesize.dlg treesize.ico

treesize.obj: treesize.c $(HEADERS)
          $(CC) treesize.c

eas.obj: ..\helpers\$*.c $(HEADERS)
          $(CC) ..\helpers\$*.c

dosh.obj: ..\helpers\$*.c $(HEADERS)
          $(CC) ..\helpers\$*.c

stringh.obj: ..\helpers\$*.c $(HEADERS)
          $(CC) ..\helpers\$*.c

treesize.exe: $(ALL_OBJ1) treesize.def treesize.res
          ilink /exepack:2 $(ALL_OBJ1) ..\helpers\pmprintf.lib treesize.def
          rc -p -x2 treesize.res treesize.exe




