
/*
 * notebook.h:
 *      header file for notebook.c. See notes there. New with V0.82.
 +
 *      All the functions in this file have the ntb* prefix.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef NOTEBOOK_HEADER_INCLUDED
    #define NOTEBOOK_HEADER_INCLUDED

    /********************************************************************
     *                                                                  *
     *   Declarations                                                   *
     *                                                                  *
     ********************************************************************/

    // some callback function prototypes
    typedef VOID (FNCBACTION)(PVOID, ULONG);
    typedef FNCBACTION *PFNCBACTION;

    typedef MRESULT (FNCBITEMCHANGED)(PVOID, USHORT, USHORT, ULONG);
    typedef FNCBITEMCHANGED *PFNCBITEMCHANGED;

    typedef MRESULT (FNCBMESSAGE)(PVOID, ULONG, MPARAM, MPARAM);
    typedef FNCBMESSAGE *PFNCBMESSAGE;

    /*
     *  here come the ORed flags which are passed to
     *  the INIT callback
     */

    #define CBI_INIT        0x01        // only set on first call (WM_INITDLG)
    #define CBI_SET         0x02        // controls should be set
    #define CBI_ENABLE      0x04        // controls should be en/disabled
    #define CBI_DESTROY     0x08        // notebook page is destroyed
    #define CBI_SHOW        0x10        // notebook page is turned to
    #define CBI_HIDE        0x20        // notebook page is turned away from

    /*
     * CREATENOTEBOOKPAGE:
     *      this structure must be passed to ntbInsertPage.
     */

    typedef struct _CREATENOTEBOOKPAGE
    {
        HWND        hwndNotebook;   // hwnd of Notebook control; this is the
                                    // (misnamed) hwndDlg parameter in the
                                    // _wpAddSettingsPages method
        WPObject    *somSelf;       // object whose Settings notebook is opened
        HMODULE     hmod;           // module of dlg resource
        ULONG       ulDlgID;        // ID of dlg resource
        BOOL        fMajorTab,      // TRUE: give the page a major tab
                    fEnumerate;     // TRUE: add "page 1 of 3" thingies
        PSZ         pszName;        // title of page
        ULONG       ulDefaultHelpPanel; // default help panel ID in XFolder help file;
                                    // if (fSubHelp == FALSE), this will always be
                                    // displayed, otherwise only no matching help
                                    // panel is found
        ULONG       ulPageID;       // an additional page identifier, in case you
                                    // use the same callbacks for different pages
        ULONG       ulTimer;        // if !=0, a timer will be started and pfncbTimer
                                    // will be called with this frequency (in ms)
        PVOID       pBackup,
                    pBackup2;       // user data; since you can access this structure
                // from the NOTEBOOKINFO structure which is always passed to the
                // callbacks, you can use this for backing up data for the "Undo" button
                // in the INIT callback. Simply allocate memory and store it here.
                // When the notebook page is destroyed, both pointers are checked and
                // will automatically be free()'d if != NULL.

        // Here follow the callback functions. If any of these is NULL,
        // it will not be called. As a result, you may selectively install
        // callbacks, depending on how much functionality you need.
        PFNCBACTION pfncbInitPage;
                // callback function for initializing the page. Parameters:
                //     PNOTEBOOKINFO pnbi       notebook info struct
                //     ULONG ulExtra            CBI_* flags.
                // -- When the page is initialized (WM_INITDLG), ulExtra is
                //    CBI_INIT | CBI_SET | CBI_ENABLE.
                // -- When the page is later turned away from, ulExtra is
                //    CBI_HIDE.
                // -- When the page is later turned to, ulExtra is
                //    CBI_SHOW | CBI_ENABLE.
                // -- When the page is destroyed (when the notebook is closed),
                //    ulExtra is CBI_DESTROY.
                // As a result, you can evaluate the ulExtra flags and
                // initilialize internal data, set the controls' data,
                // and enable/disable items accordingly.

        PFNCBITEMCHANGED pfncbItemChanged;
                // callback function if an item on the page has changed; you
                // should update your data in memory then. Parameters:
                //     PNOTEBOOKINFO pnbi       notebook info struct
                //     USHORT usItemId          ID of the changing item
                //     USHORT usNotifyCode      as in WM_CONTROL; NULL for WM_COMMAND
                //     ULONG  ulExtra           contains additional information
                //                              depending on the type of control.
                //            -- For checkboxes and radiobuttons, this is the new
                //               selection state of the control (0 or 1, or, for
                //               tri-state checkboxes, possibly 2).
                //            -- For pushbuttons (WM_COMMAND message), this contains
                //               the mp2 of WM_COMMAND.
                //            -- For spinbuttons, this contains the new LONG value.
                //            -- For all other controls, this is always -1.
                //     Return value (MRESULT):
                //          should always be -1.

        PFNCBACTION pfncbTimer;
                // callback function if ulTimer != 0; you need not worry about starting
                // and stopping the timer, just set this function. Parameters:
                //     PNOTEBOOKINFO pnbi       notebook info struct
                //     ULONG ulTimer            timer id (always 1)

        PFNCBMESSAGE pfncbMessage;
                // callback function thru which all dialog messages are going.
                // You can use this if you need additional handling which the above
                // callbacks do not provide for. This callback gets called _after_
                // the other message processing (including the callbacks). Parameters:
                //     PNOTEBOOKINFO pnbi       notebook info struct
                //     msg, mp1, mp2            as usual

        // the following fields will be set later for the callbacks,
        // these are not for input to ntbInsertPage
        BOOL        fPageVisible;           // TRUE if the page is currently visible
        HWND        hwndPage;               // hwnd of dlg page in notebook

        // internal use only, do not mess with these
        PVOID   pnbli;

    } CREATENOTEBOOKPAGE, *PCREATENOTEBOOKPAGE;

    /********************************************************************
     *                                                                  *
     *   Prototypes                                                     *
     *                                                                  *
     ********************************************************************/

    /*
     * ntbInsertPage:
     *      this function inserts the specified notebook page
     *      using the _wpInsertSettingsPage function. However,
     *      this always uses fnwpNotebookCommon for the notebook's
     *      window procedure, which then calls the callbacks which
     *      you may specify in the CREATENOTEBOOKPAGE structure.
     *      See "notebook.h" for a detailed description.
     *      This function returns the return code of
     *      _wpInsertSettingsPages.
     */

    ULONG ntbInsertPage(PCREATENOTEBOOKPAGE pcnbp);

    typedef struct _NOTEBOOKLISTITEM
    {
        struct _NOTEBOOKLISTITEM *pNext, *pPrevious;
        ULONG                   ulSize;
        PCREATENOTEBOOKPAGE     pcnbp;
    } NOTEBOOKLISTITEM, *PNOTEBOOKLISTITEM;

    /*
     * ntbQueryOpenPages:
     *      this function returns the CREATENOTEBOOKPAGE
     *      structures for currently open notebook pages, which
     *      are maintained by ntbInsertPage and fnwpNotebookCommon.
     *      This way you can iterate over all open pages and call
     *      the callbacks of certain pages to have pages updated,
     *      if necessary.
     *      In order to identify pages properly, you should always
     *      set unique ulPageID identifiers when inserting notebook
     *      pages and evaluate somSelf, if these are instance pages.
     *      If pcnpb == NULL, the first open page is returned;
     *      otherwise, the page which follows after pcnbp in
     *      our internal list.
     */

    PCREATENOTEBOOKPAGE ntbQueryOpenPages(PCREATENOTEBOOKPAGE pcnbp);

    /*
     * ntbUpdateVisiblePage:
     *      this will go thru all currently open notebook
     *      pages and update a page (by calling the INIT
     *      callback with CBI_SET | CBI_ENABLE) if it
     *      matches the specified criteria, which are:
     *          somSelf         must match somSelf for notebook
     *          ulPageID        must match ulPageID for notebook
     *      If any of these criteria is NULL, it's considered
     *      a "don't care", i.e. it is not checked for.
     *      A page is only updated if it's currently visible,
     *      i.e. turned to in an open settings notebook.
     *      Returns the number of pages that were updated.
     */

    ULONG ntbUpdateVisiblePage(WPObject *somSelf, ULONG ulPageID);

    /*
     * ntbDisplayFocusHelp:
     *      this is used from all kinds of settings dlg
     *      procs to display a help panel according to
     *      the dlg item which currently has the focus;
     *      if no matching help panel is found,
     *      ulPanelIfNotFound is displayed instead.
     *      Here we query the dlg ID of the item which
     *      currently has the focus, subtract ID_XSDI_FIRST
     *      (see dlgids.h) and add the ID of the first help
     *      panel for these help pages.
     *      This only works for XFolder dialogs where the dlg
     *      items have ascending IDs with correlated help panels.
     */

    BOOL ntbDisplayFocusHelp(WPObject *somSelf, ULONG ulPanelIfNotFound);

#endif
