
/*
 * menus.h:
 *      header file for menus.c.
 *
 *      This file is new with V0.81. The function prototypes in
 *      this file used to be in common.h and have now been exported
 *      to make their context more lucid.
 *
 *      Some declarations for menus.c are still in common.h however.
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef MENUS_HEADER_INCLUDED
    #define MENUS_HEADER_INCLUDED

    BOOL mnuAppendMi2List(WPObject *pObject, USHORT usObjType);

    VOID mnuAppendFldr2ContentList(WPFolder *pFolder, SHORT sMenuId);

    ULONG mnuInsertOneObjectMenuItem(HWND       hAddToMenu,
                        USHORT     iPosition,
                        PSZ        pszNewItemString,
                        USHORT     afStyle,
                        WPObject   *pObject,
                        ULONG      usObjType);

    #ifdef SOM_XFolder_h
        SHORT mnuPrepareContentSubmenu(XFolder *somSelf, HWND hwndMenu, PSZ pszTitle,
                        USHORT iPosition, BOOL fOwnerDraw);

        SHORT EXPENTRY fncbSortContentMenuItems(PVOID pItem1, PVOID pItem2, PVOID hab);

        VOID mnuFillContentSubmenu(SHORT sMenuId,
                                    HWND hwndMenu,
                                    PFNWP *ppfnwpFolderContentOriginal);

        LONG mnuFillMenuWithObjects(WPObject      *somSelf,
                                WPFolder   *pFolder,
                                HWND       hAddToMenu,
                                HWND       hwndCnr);

        VOID mnuCheckDefaultSortItem(PGLOBALSETTINGS pGlobalSettings,
                                    HWND hwndSortMenu,
                                    ULONG ulDefaultSort);
    #endif

    #ifdef SOM_XFolder_ih

        VOID mnuModifySortMenu(HWND hwndMenu,               // parent of "Sort" menu
                        XFolderData *somThis,               // XFolderGetData
                        PGLOBALSETTINGS pGlobalSettings,    // cmnQueryGlobalSettings
                        PNLSSTRINGS pNLSStrings);           // cmnQueryNLSStrings
    #endif

    #ifdef SOM_XFolder_h

        BOOL mnuInsertFldrViewItems(XFolder *somSelf,       // in: folder w/ context menu
                                    HWND hwndViewSubmenu,   // in: submenu to add items to
                                    BOOL fInsertNewMenu,    // in: insert "View" into hwndViewSubmenu
                                    HWND hwndCnr,           // in: cnr hwnd passed to
                                                            //     mnuModifyPopupMenu
                                    PCNRINFO pCnrInfo);     // in: shortcut to CNRINFO struct

        BOOL mnuModifyPopupMenu(XFolder *somSelf, HWND hwndMenu, HWND hwndCnr, ULONG iPosition);
    #endif

    WPObject* mnuQuerySelectedObject(WPFolder *somSelf,
                                     HWND hwndCnr,
                                     PULONG pulSelection);

    WPObject* mnuQueryNextSelectedObject(HWND hwndCnr, WPObject *pObject);

    #ifdef SOM_WPProgram_h
        BOOL mnuProgramObjectSelected(WPObject *somSelf, WPProgram *pProgram);
    #endif

    #ifdef SOM_XFolder_h
        BOOL mnuIsSortMenuItemSelected(XFolder* somSelf,
                            HWND hwndFrame,
                            HWND hwndMenu,
                            ULONG ulMenuId,
                            PGLOBALSETTINGS pGlobalSettings,
                            PBOOL pbDismiss);

        BOOL mnuMenuItemSelected(XFolder *somSelf, HWND hwndFrame, ULONG ulMenuId);
    #endif

    BOOL mnuMenuItemHelpSelected(WPObject *somSelf, ULONG MenuId);

    #ifdef SOM_XFolder_h

        BOOL mnuFileSystemSelectingMenuItem(WPObject *somSelf,
                                         USHORT usItem,
                                         BOOL fPostCommand,
                                         HWND hwndMenu,
                                         HWND hwndCnr,
                                         ULONG ulSelection,
                                         BOOL *pfDismiss);

        BOOL mnuFolderSelectingMenuItem(WPFolder *somSelf,
                                         USHORT usItem,
                                         BOOL fPostCommand,
                                         HWND hwndMenu,
                                         HWND hwndCnr,
                                         ULONG ulSelection,
                                         BOOL *pfDismiss);
    #endif

    VOID mnuPrepareOwnerDraw(MPARAM mp1, MPARAM mp2);

    MRESULT mnuMeasureItem(POWNERITEM poi,
                            PGLOBALSETTINGS pGlobalSettings);

    BOOL mnuDrawItem(PGLOBALSETTINGS pGlobalSettings,
                        MPARAM mp1, MPARAM mp2);

#endif
