/* Wiresave Install Utility */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs

cls

ver = SysOS2Ver()

if ( ver < 2.3 ) then
do
   say "This program will not run on OS/2 versions previous to"
   say "Warp 3.0.  Why aren't you Warped?"
   exit 1
end

say "Please enter the fully qualified directory to store the program"
say "files.  Default is C:\UTILS\WIRESAVE."
say "ex: C:\UTILS\WIRESAVE"
say ""

parse pull inDir

if ( length( inDir ) = 0 ) then
   inDir = "C:\UTILS\WIRESAVE"

if ( right( inDir, 1 ) = "\" ) then
   inDir = LEFT( inDir, length( inDir ) - 1 )

fileRC = sysfiletree( inDir, retStem, 'D' )

if ( rc > 0 ) then
do
   say "Error calling sysfiletree(), rc =" fileRC
   exit 1
end

if ( retStem.0 < 1 ) then
do
   say "Directory" inDir "not found. Create it (Y/n)?"
   pull answer

   if ( pos( "N", answer ) > 0 ) then
   do
      say "Installation aborted."
      exit 1
   end
   else
   do
      if ( pos( "\", inDir, 3 ) = 0 ) then
      do
         say "Invalid directory entered. Installation aborted."
         exit 1
      end

      if ( pos( "\\", inDir ) > 0 ) then
      do
         say "Invalid directory entered. Installation aborted."
         exit 1
      end

      endPos = 4

      do until endPos = 0
         endPos = pos( "\", inDir, endPos + 1 )
         if endPos = 0 then
            dirPath = inDir
         else
            dirPath = left( inDir, endPos - 1 )

         makeRC = sysMkDir( dirPath )
      end

   end
end

copyDir = '"' || inDir || '"'

copy "*.*" copyDir

if ( rc > 0 ) then
do
   say "Error copying files to directory" inDir
   exit 1
end


if syscreateobject( "WPFolder", "Wiresave", "<WP_DESKTOP>",,
                    "OBJECTID=<MYFOLDER>", "R" ) then
do
   if syscreateobject( "WPProgram", "Wiresave", "<MYFOLDER>",,
                       "OBJECTID=<MYSAVER>;EXENAME=" || inDir || "\SAVER.EXE;STARTUPDIR=" || inDir,,
                       "R" )  then
   do
      keyline = "EXENAME=" || inDir || "\SAVEEDIT.EXE;STARTUPDIR=" || inDir
      say keyline
      if syscreateobject( "WPProgram", "Wiresave Editor", "<MYFOLDER>",,
                          keyline, "R" )  = 0 then
      do
         say "Error creating object for SAVER.EXE"
         exit 1
      end
   end
   else
   do
      say "Error creating object for SAVEEDIT.EXE"
      exit 1
   end
end
else
do
   say "Error creating desktop folder!"
   exit 1
end

cls

say "If you want to use Wiresave daily, it is best to have a shadow of Wiresave"
say "placed in your Startup."
say "Do you wish to have Wiresave placed in your Startup folder (y/N)?"

pull answer

if ( pos( "Y", answer ) > 0 ) then
do
   say "Creating Shadow"
   if syscreateshadow( "<MYSAVER>", "<WP_START>" ) = 0 then
   do
      say "Error creating shadow of SAVER.EXE in Startup folder"
      exit 1
   end
end

say
say
say "Wiresave installed successfully. Look for the Wiresave folder on"
say "your desktop."
say
say "Please read the file: readme.txt for tips on making Wiresave work"
say "best on your computer."

exit 0
