#define INCL_WIN
#define INCL_DOSPROCESS
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <stdlib.h>
#include <string.h>

#ifdef __EMX__
#define INLINE inline
#else
#define INLINE
#endif

HWND hwndWarpCenter=0;
SWP  swpWCWindow;

char WarpCenterTitle[]="WarpCenter";

ULONG GetWarpCenterInfo() 
    {
    SWBLOCK *pSwBlock;
    ULONG SwBlSize;
    ULONG SwBlLen;
    HWND hwnd;
    static HSWITCH hswitchPrev=0;
    int i;

    if(hwndWarpCenter && hswitchPrev==WinQuerySwitchHandle(hwndWarpCenter, 0))
	{
	WinQueryWindowPos(hwndWarpCenter, &swpWCWindow);
	return 0;
	}
/* hwndWarpCenter is not changed since previous call */

    SwBlLen=WinQuerySwitchList(0L, NULL, 0);
/* Get the number of entries in switch list */

    SwBlSize=sizeof(ULONG)+sizeof(SWENTRY)*SwBlLen;
    if(DosAllocMem((PPVOID)&pSwBlock, SwBlSize, PAG_WRITE|PAG_COMMIT))
	return 1;
    WinQuerySwitchList(0L, pSwBlock, SwBlSize);
/* Get the switch list */

    hwndWarpCenter=0;
    for(i = SwBlLen-1; i>0; i--) 
	if(strcmp(pSwBlock->aswentry[i].swctl.szSwtitle, WarpCenterTitle)==0)  
	    {
	    hwnd=pSwBlock->aswentry[i].swctl.hwnd;
	    WinQueryWindowPos(hwnd, &swpWCWindow);
	    if(swpWCWindow.x!=0) continue;
/* Warp Center - Properties has the same title in list*/
	    hwndWarpCenter=hwnd;
	    hswitchPrev=pSwBlock->aswentry[i].hswitch;
	    break;
	    }
/* First started processes are last in switch list */

    DosFreeMem(pSwBlock);
    return (hwndWarpCenter==0);
    }

INLINE
ULONG ShowWarpCenter() 
    {
    if(GetWarpCenterInfo()) return 1;
/* WarpCenter is not found */

    WinSetWindowPos(hwndWarpCenter, HWND_TOP, 0,0,0,0, SWP_ZORDER);

    return 0;
    }

INLINE
void HideWarpCenter() 
    {
    if(hwndWarpCenter)
	WinSetWindowPos(hwndWarpCenter, HWND_BOTTOM, 0,0,0,0, SWP_ZORDER);
    }

ULONG IsWarpCenterProperties(HWND hwnd)
    {
    HSWITCH hswitch;
    SWCNTRL SwitchData;
    static HWND hwndPrev=0;

    if(hwnd==hwndPrev) return 1;
    hwndPrev=0; 
    if(!(hswitch=WinQuerySwitchHandle(hwnd, 0))) return 0;

    WinQuerySwitchEntry(hswitch, &SwitchData);

    if(strcmp(SwitchData.szSwtitle, WarpCenterTitle)==0)
	{ hwndPrev=hwnd; return 1; }

    return 0;
    }

#define DELAY_SHORT 200
#define DELAY_LONG  3000

int main(int argc)
    {
    ULONG y;
    BOOL WasShown=FALSE;
    BOOL MouseOnWC=FALSE;
    BOOL CheckWarpCenterPos=(argc!=1);
    SWP  swpDesktop;
    POINTL MousePos;
    HWND hwndActive;

    int CheckingCoord, HideTop, HideBottom, WCTop, WCBottom, WCHeight;

    WinQueryWindowPos(HWND_DESKTOP, &swpDesktop); 

    for(;;)
	{
	while(GetWarpCenterInfo())
	    DosSleep(DELAY_LONG);
/* Wait for starting of Warp Center */

	WCHeight=swpWCWindow.cy;
	if(swpWCWindow.y!=0)		/* Top position */
	    {
	    CheckingCoord=swpDesktop.cy-1;
	    WCBottom=swpWCWindow.y;
	    HideBottom=swpDesktop.cy-(swpWCWindow.cy<<1);
	    WCTop=HideTop=swpDesktop.cy;
	    }
	else				/* Bottom position */
	    {
	    CheckingCoord=0;
	    WCBottom=HideBottom=0;
	    WCTop=swpWCWindow.cy;
	    HideTop=(swpWCWindow.cy<<1);
	    }

	for(;;)
	    {
	    if(!WinQueryPointerPos(HWND_DESKTOP, &MousePos)) return 1;
/* Mouse isn't work properly */

	    y=MousePos.y;
	    if(y==CheckingCoord && !MouseOnWC && WinQueryActiveWindow(HWND_DESKTOP))
		{  
		if(ShowWarpCenter()) break;
/* Warp Center was closed */

		WasShown=MouseOnWC=TRUE;

		if(swpWCWindow.cy!=WCHeight) break;
/* Icons size was changed */
		if((swpWCWindow.y!=0)^(CheckingCoord!=0)) break;
/* Position was changed */
		}

	    if(MouseOnWC && (y<WCBottom||y>=WCTop)) 
		MouseOnWC=FALSE;

	    if(WasShown && (y<HideBottom||y>=HideTop))
		{ 
		hwndActive=WinQueryActiveWindow(HWND_DESKTOP);
		if(hwndActive && !IsWarpCenterProperties(hwndActive))
		    { HideWarpCenter(); WasShown=FALSE; }
		}
/* Hide if WarpCenter is not active */

	    if(CheckWarpCenterPos)	/* Cheking Warp Center position each time */
		{
		if(GetWarpCenterInfo()) break;
		if((swpWCWindow.y!=0)^(CheckingCoord==0)) break;
		}

	    DosSleep(DELAY_SHORT);
	    }
	}
    }
