/* BACKDROP.CMD - A character-based program to read the BACKDROP.INI file
   created by the GUI BACKSET.EXE program.  This program should be added
   to the STARTUP.CMD file with the command:

   [path]BACKDROP

   If I get energetic then I will add code to create a program object for
   this file and add the object to the STARTUP folder.  */

/* First make sure the INI file has been created -- in the directory in which this
   program exists -- not necessarily the current directory when it was called */

parse source environment executive command
/* E.g., command now might = c:\utils\backdrop\backdrop.cmd */
IniFile = FILESPEC('D', command) || FILESPEC('P', command) || 'BACKDROP.INI'

if STREAM(IniFile, 'C', 'QUERY EXISTS') = '' then do
  say 'You must run the BACKSET program to setup the bitmaps to'
  say 'display before the randomizer can work.'
  say
  say 'Press ENTER to exit the randomizer'
  call BEEP 350, 100
  pull dummy
  end
 else do
  /* Load RexxUtil functions */
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

  /* Find out how often the bitmap should be changed, and when
     it changed last */
  Frequency = SysIni(IniFile, 'BackDrop', 'Frequency')
  LastChanged = SysIni(IniFile, 'BackDrop', 'LastChanged')
  parse var LastChanged LastMonth '/' LastDay '/' LastYear
  Today = DATE(U)
  parse var Today NowMonth '/' NowDay '/' NowYear
  SELECT
    when Frequency = 'Boot' then signal Randomize

    when Frequency = 'Daily' then
      if LastChanged \= Today then signal Randomize

    when Frequency = 'Weekly' then do
    /* This is the trickiest of the bunch, requiring conversion to Julian
       dates for best processing. */
      call JulianDates
      if NowJulian - 7 >= LastJulian then signal Randomize
      end /* when Weekly */

    when Frequency = 'Monthly' then do
      /* Note that I don't bother counting the number of days per month
         and all that rot.  The first of the month is the day to change */
      if NowYear \= LastYear then signal Randomize
      if NowMonth \= LastMonth then signal Randomize
      end  /* when Monthly */

    end  /* select */

  end  /* else (STREAM...) */
exit  /* end program */

JulianDates:
  /* This procedure simplifies date arithmetic by converting the values to
     Julian (yyddd).  It would have been nice to use the Julian date
     functions in Personal REXX, but I couldn't afford to buy runtime
     licenses for all of CompuServe. I'm also not going to bother with the
     odd number of days per month, assuming they are all 30. */

  If NowYear > LastYear then do
    NowYear = NowYear - 1
    NowMonth = NowMonth + 12
    end
  NowJulian = NowYear * 1000
  LastJulian = LastYear * 1000
  NowJulian = NowJulian + ((NowMonth - 1) * 30)
  LastJulian = LastJulian + ((LastMonth - 1) * 30)
  NowJulian = NowJulian + NowDay
  LastJulian = LastJulian + LastDay

  exit /* JulianDates */

Randomize:
  /* This procedure changes the current desktop bitmap to a different
     one from those selected in the BACKSET program */

  /* First change the date last changed to today */
  call SysIni IniFile, 'BackDrop', 'LastChanged', Today

  /* Now find out how many bitmaps there are to choose from, and
     which one is being displayed currently */
  NumberAvailable = SysIni(IniFile, 'BackDrop', 'Count')

  /* Find out which bitmap is being shown now */
  CurrentBitmap = SysIni(IniFile, 'BackDrop', 'CurrentBitmap')
  NextBitmap = CurrentBitmap

  /* Select a random bitmap from those available, making sure it
     isn't the one already being displayed */
  do until CurrentBitmap \= NextBitmap
    NextBitmap = 'File' || RANDOM(1, NumberAvailable)  /* Build INI key */
    NextBitmap = SysIni(IniFile, 'BackDrop', NextBitmap)
    end

  /* Make this the current bitmap */
  call SysSetObjectData '<WP_DESKTOP>', 'BACKGROUND =' NextBitmap

  /* And store the new bitmap in the INI file */
  call SysIni IniFile, 'BackDrop', 'CurrentBitmap', NextBitmap

  exit
