
/*
 *
 *
 *   Module Name: PILEOF
 *
 *   OS/2 Work Place Shell Sample Program
 *
 *
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_pileof_Source
#define SOM_Module_pileof_Source
#endif
#define PileOf_Class_Source
#define M_PileOf_Class_Source

#include "pileof.ih"


/*
 *
 * METHOD: ValidateDragAndDrop                            (X) PRIVATE
 *                                                        ( ) PUBLIC
 * DESCRIPTION:
 * This method determines if an object can be dragged/dropped on the
 * PileOf. It is invoked by the wpDrag and wpDragOver methods.
 *
 *
 *
 * RETURN:
 *
 *   TRUE  - the object is a text file.
 *   FALSE - the object is not a text file.
 *
 * HOW TO OVERRIDE:
 *
 *   n/a
 *
 */

SOM_Scope BOOL  SOMLINK PileOfwps_ValidateDragAndDrop(PileOf *somSelf,
                                                      PDRAGINFO pdrgInfo)
{
    ULONG   j;
    CHAR    pszBuffer[ 255];     // Buffer for file system object name
    ULONG   ulNumberOfObjects;   // Number of object draged over object
    ULONG   ulCurrentObject;     // Used to increment list of objects
    SOMAny  *Object = NULL;
    SOMAny  *somClassObj = NULL;
    PSZ        pszClass;
    PDRAGITEM pDragItem;
    PDATAPILEOF pDtPileOf;       // Point to PileOf data structure
    PCLSINSERT1  pclsi, pClassIns;


    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_ValidateDragAndDrop");

    // Set pointer to PileOf data
    pDtPileOf = (PDATAPILEOF)_QueryPileOfInstData( somSelf );

    // Poinst to class list structure
    pClassIns  = pDtPileOf->pClsInsert;

    /* Get the number of objects being dragged */
    ulNumberOfObjects = DrgQueryDragitemCount( pdrgInfo);

    /* Test each object */
    for( ulCurrentObject = 0; ulCurrentObject<ulNumberOfObjects;
                                                            ulCurrentObject++)
    {
        pDragItem = DrgQueryDragitemPtr( pdrgInfo, ulCurrentObject);

        DrgQueryStrName( pDragItem->hstrRMF, sizeof( pszBuffer),
                                                            pszBuffer);
        somPrintf( "The rendering mechanism is: '%s'\n", pszBuffer);


        /* Make sure that the rendering mechanism is DRM_OBJECT */
        if(DrgVerifyRMF( pDragItem, "DRM_OBJECT", NULL))
        {
           // Get type of object
           Object = OBJECT_FROM_DRAGITEM(pDragItem);

           // Get class form object
           somClassObj = _somGetClass ( Object );

           // Get class title for this class
           pszClass = _wpclsQueryTitle(somClassObj);

          // see if this class title is in the list of classes in the
          // instance data of the object
          for (j = 0; j < pDtPileOf->cClassIns; j++)
          {
            pclsi = pClassIns + j;

            if (pclsi->flClassSelected)

              // See if class was selected for PileOf object
              if (!strcmp(pclsi->pszClass, pszClass))
                 break;

            // At least one of the objects being dragged is not in
            // the list of allowed objects. DROP should fail !
            // DESIGN: if one object in the DRAGINFO structure can
            //         not be dropped in this PileOf object can we somehow
            //         drop the rest?. For now the DROP will fail for all.
            if ((j+1) == pDtPileOf->cClassIns)
              return (FALSE);

          }

        }
        else
         return ( FALSE );
    }

    return( TRUE);
}

/*
 *
 * METHOD: AddPileOfPage                                  (X) PRIVATE
 *                                                        ( ) PUBLIC
 * DESCRIPTION:
 *
 *  Add page for PileOf class
 *
 *
 * RETURN:
 *
 *   ulPageId - ID of inserted page
 *
 * HOW TO OVERRIDE:
 *
 *   n/a
 *
 */

SOM_Scope ULONG  SOMLINK PileOfwps_AddPileOfPage(PileOf *somSelf,
                                                 HWND hwndNbk)
{
    PAGEINFO  pi;
    ULONG     ulPageID;
    HMODULE   hmod;
    APIRET    rc;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_AddPileOfPage");

    rc = DosQueryModuleHandle( "PILEOF.DLL", &hmod );

    if ( rc )
       somPrintf( "Unable to load module\n");

    memset ( (PCH) &pi, 0, sizeof ( PAGEINFO ) );

    pi.cb                 = sizeof(PAGEINFO);
    pi.hwndPage           = NULLHANDLE;
    pi.usPageStyleFlags   = BKA_MAJOR;
    pi.usPageInsertFlags  = BKA_FIRST;
    pi.pfnwp              = MyDialogProc;
    pi.resid              = hmod;
    pi.dlgid              = DLG_TITLE;
    pi.pszName            = "PileOf";         // PileOf tab text
    pi.pCreateParams      = somSelf;          // dialog create parms
    pi.idDefaultHelpPanel = 0;
    pi.pszHelpLibraryName = NULL;

    ulPageID = _wpInsertSettingsPage ( somSelf, hwndNbk, &pi );

    return ( ulPageID );
}

/*
 *
 * METHOD: QueryPileOfInstData                            (X) PRIVATE
 *                                                        ( ) PUBLIC
 * DESCRIPTION:
 *
 *  Query Selected classes for this PileOf object
 *
 *
 * RETURN:
 *
 *   pClsInsert- Pointer to a structure containing info on selected classes
 *
 * HOW TO OVERRIDE:
 *
 *   n/a
 *
 */

/*
 *
 * METHOD: QueryPileOfInstData                            (X) PRIVATE
 *                                                        ( ) PUBLIC
 * DESCRIPTION:
 *
 *  Query Selected classes for this pile object
 *
 *
 * RETURN:
 *
 *   pClsInsert- Pointer to a structure containing info on selected classes
 *
 * HOW TO OVERRIDE:
 *
 *   n/a
 *
 */

SOM_Scope ULONG  SOMLINK PileOfwps_QueryPileOfInstData(PileOf *somSelf)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_QueryPileOfInstData");

    return (ULONG)_pDataPileOf;
}

/*
 *
 * METHOD: SetPileOfInstData                              (X) PRIVATE
 *                                                        ( ) PUBLIC
 * DESCRIPTION:
 *
 *   Set selected clases for this PileOf object
 *
 *
 * RETURN:
 *
 *   void - nothing
 *
 * HOW TO OVERRIDE:
 *
 *   n/a
 *
 */

SOM_Scope void  SOMLINK PileOfwps_SetPileOfInstData(PileOf *somSelf,
                                                    ULONG pDtPileOf)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_SetPileOfInstData");

    // Set instance data
    _pDataPileOf = (PDATAPILEOF)pDtPileOf;

}



SOM_Scope ULONG  SOMLINK PileOfwps_wpAddFolderView2Page(PileOf *somSelf,
                                                        HWND hwndNotebook)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpAddFolderView2Page");

    return( SETTINGS_PAGE_REMOVED);
}

SOM_Scope ULONG  SOMLINK PileOfwps_wpAddFolderIncludePage(PileOf *somSelf,
                                                          HWND hwndNotebook)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpAddFolderIncludePage");

    return ( SETTINGS_PAGE_REMOVED);
}

SOM_Scope ULONG  SOMLINK PileOfwps_wpFilterPopupMenu(PileOf *somSelf,
                                                     ULONG ulFlags,
                                                     HWND hwndCnr,
                                                     BOOL fMultiSelect)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpFilterPopupMenu");

    ulFlags = PileOf_parent_WPFolder_wpFilterPopupMenu(somSelf,
                                                     ulFlags,
                                                     hwndCnr,
                                                     fMultiSelect);

    /* Remove the tree/icon view menu options and make sure delete  */
    /* is available                                                 */
    return ( ( ulFlags | CTXT_DELETE ) & ~CTXT_TREE & ~CTXT_ICON);
}

SOM_Scope BOOL  SOMLINK PileOfwps_wpModifyPopupMenu(PileOf *somSelf,
                                                    HWND hwndMenu,
                                                    HWND hwndCnr,
                                                    ULONG iPosition)
{
    HMODULE   hmod;
    BOOL      fFlagsOut;
    BOOL      fSuccess;
    APIRET    rc;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpModifyPopupMenu");

    // get module handle for PileOf DLL
    rc = DosQueryModuleHandle( "PILEOF.DLL", &hmod );

    if ( rc )
       somPrintf( "Unable to load module\n");

    // Call Parent first to ge default menu entries
    fFlagsOut =  parent_wpModifyPopupMenu(somSelf,hwndMenu,hwndCnr,iPosition);

    // Add our PileOf menu entries
    fSuccess = _wpInsertPopupMenuItems( somSelf
                                       ,hwndMenu
                                       ,iPosition
                                       ,hmod
                                       ,IDM_PRIMARYMENU
                                       ,WPMENUID_PRIMARY);

    if ( !fSuccess)
      somPrintf( " Error in wpInsertPopupMenuItems ");


    return (fFlagsOut);
}

SOM_Scope BOOL  SOMLINK PileOfwps_wpMenuItemSelected(PileOf *somSelf,
                                                     HWND hwndFrame,
                                                     ULONG ulMenuId)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpMenuItemSelected");


    // Handle PileOf menu entries
    switch (ulMenuId)
    {
       case IDM_NEWTITLE:
            return (TRUE);

       case IDM_SPREAD:
            return (TRUE);

       case IDM_TURNOVER:
            return (TRUE);
    }

    return (PileOf_parent_WPFolder_wpMenuItemSelected(somSelf,
                                                      hwndFrame,
                                                      ulMenuId));
}


SOM_Scope BOOL  SOMLINK PileOfwps_wpAddSettingsPages(PileOf *somSelf,
                                                     HWND hwndNotebook)
{
    ULONG ulPageId;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpAddSettingsPages");

    PileOf_parent_WPFolder_wpAddSettingsPages(somSelf,
                                                      hwndNotebook);

    // Add PileOf settings page
    ulPageId = _AddPileOfPage(somSelf,hwndNotebook);

    return (TRUE);
}

SOM_Scope MRESULT  SOMLINK PileOfwps_wpDragOver(PileOf *somSelf,
                                                HWND hwndCnr,
                                                PDRAGINFO pdrgInfo)
{
    MRESULT mResult;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpDragOver");

    mResult = PileOf_parent_WPFolder_wpDragOver(somSelf, hwndCnr,
                                              pdrgInfo);

    /* If the parent said it is okay to drop then we will check it also. */
    if( DOR_NEVERDROP != SHORT1FROMMR( mResult)){

        /* If the object is acceptable, return the mResult from the parent */
        if( FALSE == _ValidateDragAndDrop( somSelf, pdrgInfo))
            mResult = MRFROM2SHORT( DOR_NEVERDROP, DO_UNKNOWN);
    }

    return ( mResult);
}

SOM_Scope MRESULT  SOMLINK PileOfwps_wpDrop(PileOf *somSelf,
                                            HWND hwndCnr, PDRAGINFO pdrgInfo,
                                            PDRAGITEM pdrgItem)
{
    MRESULT mResult;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpDrop");

    mResult = PileOf_parent_WPFolder_wpDrop(somSelf, hwndCnr, pdrgInfo,
                                          pdrgItem);

    /* If the parent said it is okay to drop then we will check it also */
    if( DOR_NEVERDROP != SHORT1FROMMR( mResult)){


        /* Validate the objects */
        if( FALSE == _ValidateDragAndDrop( somSelf, pdrgInfo))
            mResult = MRFROM2SHORT( DOR_NEVERDROP, DO_UNKNOWN);
    }

    return ( mResult);
}

SOM_Scope BOOL  SOMLINK PileOfwps_wpSaveState(PileOf *somSelf)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpSaveState");

    return (PileOf_parent_WPFolder_wpSaveState(somSelf));
}

SOM_Scope BOOL  SOMLINK PileOfwps_wpRestoreState(PileOf *somSelf,
                                                 ULONG ulReserved)
{
    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_wpRestoreState");

    return (PileOf_parent_WPFolder_wpRestoreState(somSelf, ulReserved));
}

SOM_Scope void  SOMLINK PileOfwps_somInit(PileOf *somSelf)
{
   POBJCLASS  pObjClass,poc;
   PCLSINSERT1 pClassIns,pclsi;
   ULONG      cClassIns = 0;
   PDATAPILEOF pDtPileOf;
   SOMID      ClassId;
   SOMClass   *Class;
   PSZ        pszClass;
   ULONG      ulSize;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_somInit");

    PileOf_parent_WPFolder_somInit(somSelf);


   /* Enumerate the object classes registered with workplace
    */
   WinEnumObjectClasses(NULL,&ulSize);
   if (  ( pDtPileOf = (PDATAPILEOF)_wpAllocMem(somSelf, sizeof(DATAPILEOF),NULL) ) &&
         ( pObjClass = (POBJCLASS)_wpAllocMem(somSelf, ulSize,NULL) ) &&
         ( pClassIns = (PCLSINSERT1)_wpAllocMem(somSelf, ulSize,NULL) )
      )
   {
      memset((PBYTE)pClassIns,0,(USHORT)ulSize);
      pclsi = pClassIns;
      if ( WinEnumObjectClasses(pObjClass,&ulSize) )
      {
         poc = pObjClass;
         while (poc)
         {
            /* Find the NLS name for this class
             */
            ClassId   = SOM_IdFromString(poc->pszClassName);
            somPrintf( "The class name is: '%s'\n", poc->pszClassName);
            if ((Class = _somClassFromId(SOMClassMgrObject,ClassId)) &&
                !(_wpclsQueryStyle(Class) & CLSSTYLE_PRIVATE))
            {
                pszClass = _wpclsQueryTitle(Class);
                if (!pszClass)
                   pszClass = poc->pszClassName;
                somPrintf( "The private class name is: '%s'\n", pszClass);

                /* Save the class in an entry in the CLSINSERT1 table that
                 * we construct, along with its parent class
                 */
                pclsi->pszClass    = pszClass;
                pclsi->Class       = Class;
                pclsi->ClassParent = _somGetParent(Class);
                pclsi->flClassSelected = FALSE;
                pclsi     += 1;
                cClassIns += 1;
            }
            SOMFree(ClassId);
            poc = poc->pNext;
         }
      }
   }

   // Set using instance data
     if (pDtPileOf)
     {
       pDtPileOf->pClsInsert =  pClassIns;
       pDtPileOf->cClassIns =  cClassIns;
     }

   _SetPileOfInstData( somSelf, (ULONG) pDtPileOf );

   // NOTICE: I am not freeing pclsi. To be freed when obj is destroyed
     if (pObjClass)
        _wpFreeMem(somSelf, (PBYTE)pObjClass);

}

SOM_Scope void  SOMLINK PileOfwps_somUninit(PileOf *somSelf)
{
    PDATAPILEOF pDtPileOf;

    PileOfData *somThis = PileOfGetData(somSelf);
    PileOfMethodDebug("PileOf","PileOfwps_somUninit");

    pDtPileOf = (PDATAPILEOF)_QueryPileOfInstData( somSelf );

   // Free PileOf instance data (if still allocated)
   if (pDtPileOf)
   {
      _wpFreeMem(somSelf, (PBYTE)(pDtPileOf->pClsInsert));
      _wpFreeMem(somSelf, (PBYTE)(pDtPileOf));
   }

    PileOf_parent_WPFolder_somUninit(somSelf);
}

// *********************************************************************
//
//        DIALOG  WINDOW  PROCEDURE for the NOTEBOOK  PAGE
//
// *********************************************************************

MRESULT EXPENTRY MyDialogProc   ( HWND hwndDlg, ULONG msg
                                , MPARAM mp1,   MPARAM mp2 )
{

    SOMAny  *somSelf;   // temporary ptr to object instance
    PWINDATA pwin;
    PSZ      psz;
    CHAR     szClass[PILEOF_MAXSTRING];
    HWND     hwndListBox;
    HWND     hwndBtnOneOf;
    HWND     hwndBtnSpread;
    HWND     hwndBtnDelEmpty;
    HWND     hwndBtnTopToBottom;
    USHORT   usButtonId;
    ULONG    Index = 0;
    ULONG    num_selected;
    ULONG    ulBtnStyle;
    ULONG    ulLbStyle;
    BOOL     fOneObj_Chkd;
    CHAR     buf[30];

    switch( msg )
    {

        case WM_INITDLG:

            somSelf = (SOMAny *) mp2;   // obtain creation parms

            pwin = (PWINDATA) _wpAllocMem ( somSelf, sizeof (WINDATA), NULL );

            WinSetWindowPtr (hwndDlg, QWL_USER, pwin );

            // initialize windata structure
            pwin->somSelf     = somSelf;
            pwin->somClassObj = _somGetClass ( pwin->somSelf );

            // query PileOf Object(s)

//          psz = _UserGetPileOfData( pwin->somSelf );

            hwndListBox = WinWindowFromID ( hwndDlg, LBOX_CLASSES );

            /* Add all the currently loaded classes to the
             * 'PileOf...Objects' listbox
             */
            AddTypesToListbox( pwin->somSelf,
                                  WinWindowFromID(hwndDlg,(USHORT)LBOX_CLASSES) );

            WinSetFocus      ( HWND_DESKTOP, hwndListBox );

            hwndBtnOneOf = WinWindowFromID ( hwndDlg, CHKB_ONEOBJ );
            WinSendMsg( hwndBtnOneOf, BM_SETCHECK, MPFROMSHORT(1), NULL );

            hwndBtnSpread = WinWindowFromID ( hwndDlg, CHKB_SPREAD );
            WinSendMsg( hwndBtnSpread, BM_SETCHECK, MPFROMSHORT(1), NULL );

            hwndBtnDelEmpty = WinWindowFromID ( hwndDlg, CHKB_DELEMPTY );
            WinSendMsg( hwndBtnDelEmpty, BM_SETCHECK, MPFROMSHORT(1), NULL );

            hwndBtnTopToBottom = WinWindowFromID ( hwndDlg, RADIOB_TOPTOBOTTOM );
            WinSendMsg( hwndBtnTopToBottom, BM_SETCHECK, MPFROMSHORT(1), NULL );

            // return TRUE to tell PM that we changed focus
            return (MRESULT) TRUE ;

        case WM_CONTROL:

            if ( SHORT2FROMMP( mp1 ) == BN_CLICKED)
            {
               usButtonId = SHORT1FROMMP( mp1 );

               switch (usButtonId)
               {
                  case CHKB_ONEOBJ:


                     hwndBtnOneOf = WinWindowFromID ( hwndDlg, CHKB_ONEOBJ );
                     fOneObj_Chkd = SHORT1FROMMR( WinSendMsg( hwndBtnOneOf
                                                             ,BM_QUERYCHECK
                                                             ,NULL, NULL ));

                     hwndListBox = WinWindowFromID ( hwndDlg, LBOX_CLASSES );
                     ulLbStyle = WinQueryWindowULong ( hwndListBox, QWL_STYLE );
                     if (fOneObj_Chkd)
                     {
                       ulLbStyle &= ~LS_MULTIPLESEL;

                       Index =
                            SHORT1FROMMR( WinSendMsg(
                                              hwndListBox,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT(LIT_FIRST),
                                              NULL) );

                       if ( Index != LIT_NONE)
                           WinSendMsg( hwndListBox, LM_SELECTITEM,
                                  MPFROMSHORT( Index ), MPFROMSHORT( FALSE ));

                       WinSetWindowULong( hwndListBox, QWL_STYLE, ulLbStyle );

                       if ( Index != LIT_NONE)
                           WinSendMsg( hwndListBox, LM_SELECTITEM,
                                  MPFROMSHORT( Index ), MPFROMSHORT( TRUE ));
                     }
                     else
                     {
                       ulLbStyle |= LS_MULTIPLESEL;

                       WinSetWindowULong( hwndListBox, QWL_STYLE, ulLbStyle );
                     }

                      return (0);
               }
            }

            if ( SHORT2FROMMP( mp1 ) == LN_SELECT)
            {
               pwin = (PWINDATA) WinQueryWindowPtr( hwndDlg, QWL_USER);

               hwndListBox = WinWindowFromID ( hwndDlg, LBOX_CLASSES );

               ulLbStyle = WinQueryWindowULong ( hwndListBox, QWL_STYLE );
               num_selected =0;

               // Unmark all entries in classes structure
               UnMark_PileOf_DataItems (pwin->somSelf);

               if (  ulLbStyle & LS_MULTIPLESEL)
               {
                  Index  = SHORT1FROMMR( WinSendMsg(hwndListBox
                                                    ,LM_QUERYITEMCOUNT
                                                    ,NULL,NULL) );
                  Index += 1;
                  while ( Index-- )
                  {
                     if ( (ULONG)Index ==
                                SHORT1FROMMR( WinSendMsg(
                                                  hwndListBox,
                                                  LM_QUERYSELECTION,
                                                  MPFROMSHORT( (Index > 0) ? Index-1 : LIT_FIRST),
                                                  NULL) )
                        )
                     {
                        WinSendMsg( hwndListBox, LM_QUERYITEMTEXT,
                                    MPFROM2SHORT(Index, sizeof(szClass)),
                                    MPFROMP(szClass));

                        Mark_PileOf_DataItem( pwin->somSelf, (PSZ)&szClass );

                        num_selected +=1;
                     }
                  }
               }
               else
               {
                  Index =
                      SHORT1FROMMR( WinSendMsg(
                                              hwndListBox,
                                              LM_QUERYSELECTION,
                                              MPFROMSHORT(LIT_FIRST),
                                              NULL) );

                  if ( Index != LIT_NONE)
                  {
                     WinSendMsg( hwndListBox, LM_QUERYITEMTEXT,
                                 MPFROM2SHORT(Index, sizeof(szClass)),
                                 MPFROMP(szClass));

                     Mark_PileOf_DataItem( pwin->somSelf, (PSZ)&szClass );

                     num_selected = 1;
                  }
               }

               hwndBtnOneOf = WinWindowFromID ( hwndDlg, CHKB_ONEOBJ );
               ulBtnStyle = WinQueryWindowULong ( hwndBtnOneOf, QWL_STYLE );
               if (num_selected > 1)
                 ulBtnStyle |= WS_DISABLED;
               else
                 ulBtnStyle &= ~WS_DISABLED;
               WinSetWindowULong( hwndBtnOneOf, QWL_STYLE, ulBtnStyle );

               return (0);
            }

            return ( WinDefDlgProc( hwndDlg, msg, mp1, mp2 ) );

        case WM_DESTROY:

            pwin = (PWINDATA) WinQueryWindowPtr ( hwndDlg, QWL_USER );

            // save  data to instance fields.

            hwndListBox = WinWindowFromID ( hwndDlg, LBOX_CLASSES );
//          .
//          .
//          .

            // save  data to instance data
//          _UserSetPileOfData ( pwin->somSelf, (PSZ) &buf );

            // save instance data to OS2.INI file
//          _wpSaveImmediate ( pwin -> somSelf );


            _wpFreeMem( pwin->somSelf,(PBYTE) pwin );
            return ( WinDefDlgProc( hwndDlg, msg, mp1, mp2 ) );

    }
    return ( WinDefDlgProc( hwndDlg, msg, mp1, mp2 ) );
}


//*************************************************************************
// AddTypesToListbox
//
// Display the listbox control containing a sorted array of OS/2 supported
// object classes and showing the object class hierachy.
//
//*************************************************************************
BOOL AddTypesToListbox(
    SOMAny *somSelf,
   HWND      hwndLB )
{
   PCLSINSERT1 pClassIns;
   ULONG      cClassIns;
   CHAR       szIndent[CCHMAXPATH*2];
   ULONG      cbIndent;
   PDATAPILEOF pDtPileOf;


    // Set pointer to PileOf data
    pDtPileOf = (PDATAPILEOF)_QueryPileOfInstData( somSelf );

   // Set using instance data
   pClassIns = pDtPileOf->pClsInsert;
   cClassIns  = pDtPileOf->cClassIns;

   /* Insert the listbox items into the hierachy
    */
   szIndent[0] = '\0';
   cbIndent    = 0;
   InsertClassItem(hwndLB,
                   _somGetParent(_WPObject),
                   pClassIns,   /* pointer to CLSINSERT array */
                   cClassIns,   /* count of CLSINSERT array */
                   szIndent,    /* temporary storage */
                   cbIndent );  /* indent counter */

   return TRUE;
}

//***********************************************************************
//
// This is a highly recursive sub-function to insert object types
//
//***********************************************************************
VOID InsertClassItem(
   HWND       hwndLB,
   SOMClass   *Class,
   PCLSINSERT1 pClassIns,
   ULONG      cClassIns,
   PSZ        pszIndent,
   ULONG      cbIndent )
{
   PCLSINSERT1    pclsi;
   USHORT        i,j;
   SHORT         index;
   static CHAR   szFixedClassName[PILEOF_MAXSTRING];

   /* For all classes that we have active at the moment:
    */
   for (j = 0; j < (USHORT)cClassIns; j++)
   {
      pclsi = pClassIns + j;
      if (Class == pclsi->ClassParent)
      {
         /* Add the entry to the listbox, indenting the class name to give a
          * hierachical look to this list...
          */
         for (i = 0; i < (USHORT)cbIndent; i++)
             *(pszIndent + i) = ' ';
         *(pszIndent + i)     = '\0';
         ManipulateNewLines(szFixedClassName,pclsi->pszClass,PILEOF_MAXSTRING);
         strcat(pszIndent,szFixedClassName);
         index = SHORT1FROMMR( WinSendMsg(hwndLB,
                                          LM_INSERTITEM,
                                          MPFROMSHORT(LIT_END),
                                          MPFROMP(pszIndent) ) );

         // Mark selected items as selected
         if (pclsi->flClassSelected)
            WinSendMsg(hwndLB,
                       LM_SELECTITEM,
                       MPFROMLONG(index),
                       MPFROMLONG(TRUE) );


         if (index != LIT_ERROR)
         {
            WinSendMsg(hwndLB,
                       LM_SETITEMHANDLE,
                       MPFROMSHORT(index),
                       MPFROMP(pclsi->Class) );

            /* Now, let's recursively insert all our child classes
             */
            cbIndent += 2;         /* Indent children */
            InsertClassItem(hwndLB,
                            pclsi->Class,
                            pClassIns,
                            cClassIns,
                            pszIndent,
                            cbIndent );
            cbIndent -= 2;        /* Unindent children */
         }
      }
   }
}

//**********************************************************************
// FUNCTION: ManipulateNewLines
//
//   Replace newline and carriage return characters with blanks (otherwise
//   do nothing.
//
//**********************************************************************
CHAR *ManipulateNewLines(
   PSZ   pszTarget,
   PSZ   pszOriginal,
   ULONG cbTarget )
{
   BOOL fSpaceCopied = FALSE;
   ULONG ulIndex = 0;

   if( pszOriginal )
   {
      while( *pszOriginal && ulIndex < cbTarget - 1 )
      {
         if( *pszOriginal == '\n' || *pszOriginal == '\r' )
         {
            if( !fSpaceCopied
                && *( pszOriginal + 1 ) != ' '
                && *( pszOriginal + 1 ) != '\n'
                && *( pszOriginal + 1 ) != '\r' )
            {
               pszTarget[ ulIndex++ ] = ' ';
               fSpaceCopied = TRUE;
            }
         }
         else
         {
            pszTarget[ ulIndex++ ] = *pszOriginal;
            if( *pszOriginal == ' ' )
            {
               fSpaceCopied = TRUE;
            }
            else
            {
               fSpaceCopied = FALSE;
            }
         }
         pszOriginal++;
      }
   }
   pszTarget[ ulIndex ] = '\0';

   return pszTarget;
}

//*********************************************************************
// Mark_PileOf_DataItem
//
// on each item to the class it represents.
//
// History:
//*********************************************************************
BOOL Mark_PileOf_DataItem( SOMAny *somSelf, PSZ pszClass )
{
  PDATAPILEOF pDtPileOf;
  PCLSINSERT1  pClassIns;
  ULONG        index;
  USHORT       i;


   i = 0;

   while ( i < (USHORT)PILEOF_MAXSTRING )
   {
     pszClass += 1;

     if (*(pszClass) != ' ')
        break;
     i++;
   }

   // Set pointer to PileOf data
   pDtPileOf = (PDATAPILEOF)_QueryPileOfInstData( somSelf );

   // Set pointer for class info struct
   pClassIns = pDtPileOf->pClsInsert;

   index = 0;
   // Set a given class as selected
   while( index < pDtPileOf->cClassIns)
   {

     if (strcmp(pszClass, pClassIns->pszClass) == 0)
     {
       pClassIns->flClassSelected = TRUE;
       break;
     }

     pClassIns += 1;
     index++;
   }

   return TRUE;
}

//*********************************************************************
// UnMark_PileOf_DataItems
//
// DESIGN: A lot of room for performance improvements here !!!
//         We should not have to do this every time an item (or more)
//         is selected/removed
//
// History:
//*********************************************************************
void UnMark_PileOf_DataItems( SOMAny *somSelf )
{
  PDATAPILEOF pDtPileOf;
  PCLSINSERT1  pClassIns, pclsi;
  ULONG j;

   // Set pointer to PileOf data
   pDtPileOf = (PDATAPILEOF)_QueryPileOfInstData( somSelf );

   // Set pointer for class info struct
   pClassIns = pDtPileOf->pClsInsert;

   for (j = 0; j < pDtPileOf->cClassIns; j++)
   {
     pclsi = pClassIns + j;

     // Set a given class as NOT selected
     pclsi->flClassSelected = FALSE;
   }

}



SOM_Scope PSZ  SOMLINK PileOfwps_wpclsQueryTitle(M_PileOf *somSelf)
{
    /* M_PileOfData *somThis = M_PileOfGetData(somSelf); */
    M_PileOfMethodDebug("M_PileOf","PileOfwps_wpclsQueryTitle");

    return ( "Pile Of...");
}

SOM_Scope void  SOMLINK PileOfwps_wpclsInitData(M_PileOf *somSelf)
{
    /* M_PileOfData *somThis = M_PileOfGetData(somSelf); */
    M_PileOfMethodDebug("M_PileOf","PileOfwps_wpclsInitData");

    initdebug( __FILE__);

    M_PileOf_parent_M_WPFolder_wpclsInitData(somSelf);
}

SOM_Scope ULONG  SOMLINK PileOfwps_wpclsQueryIconData(M_PileOf *somSelf,
                                                      PICONINFO pIconInfo)
{
    static HMODULE hModule = NULLHANDLE;
    PSZ            pszLibraryName;

    /* M_PileOfData *somThis = M_PileOfGetData(somSelf); */
    M_PileOfMethodDebug("M_PileOf","PileOfwps_wpclsQueryIconData");

    /* Only get the handle once */
    if( (hModule == NULLHANDLE) && pIconInfo){

       /* Get the name of the library so we can get it's handle. */
       if( NULL != ( pszLibraryName = _somLocateClassFile( SOMClassMgrObject,
                      SOM_IdFromString( "PileOf"), PileOf_MajorVersion,
                                                     PileOf_MinorVersion)))

           /* Get the handle for the library. */
           DosQueryModuleHandle( pszLibraryName, &hModule);
    }

    if( pIconInfo){

       pIconInfo->fFormat = ICON_RESOURCE;
       pIconInfo->resid   = ID_ICON;
       pIconInfo->hmod    = hModule;
    }

    return ( sizeof( ICONINFO));
}

SOM_Scope ULONG  SOMLINK PileOfwps_wpclsQueryDefaultView(M_PileOf *somSelf)
{
    /* M_PileOfData *somThis = M_PileOfGetData(somSelf); */
    M_PileOfMethodDebug("M_PileOf","PileOfwps_wpclsQueryDefaultView");

    return (OPEN_DETAILS);
}

