/***********************************************************************\
 *                                 PC2.c                               *
 *               Copyright (C) by Stangl Roman, 1993, 1999             *
 *                                                                     *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed.                                                            *
 *                                                                     *
 * Install.cmd  Installation batch file.                               *
 *                                                                     *
\***********************************************************************/

/* static char     _VERSION_[]="Install.cmd - PC/2 V2.20"; */

                                        /* Register REXX APIs */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

                                        /* CTRL+BREAK signal handler that just ignores any
                                           CTRL+BREAK signal */
/* Call On Halt Name SignalHandler */

                                        /* Get the OS/2 Version we are running at */
OS2Version=SysOS2Ver()
Parse Value OS2Version With OS2MajorVersion '.' OS2MinorVersion
                                        /* Get optional commandline parameters (which would
                                           allow a remote installation (CID),  though it is unsupported
                                           I'm confident it will work):
                                           Arg1 ... InstallationOption (I, U, D, P)
                                           Arg2 ... DestinationDirectory (<any path>)
                                           Arg3 ... SubPackagesSelected (P, W, B)
                                           Arg4 ... FilesSelected (A, R, O)
                                           Arg5 ... SingleClickFlag (Y, N)
                                           Arg6 ... ButtonFlag (1, 3)
                                           Arg7 ... SkipQuestionsFlag (Y, N)
                                           Arg8 ... IconRecreateFlag (Y, N) 
                                           E.g. you would specify something like: 
                                                INSTALL i c:\pc2 p r y 1 n y 
                                           which will install PC/2 (but not WPS 2 PC/2) into c:\pc2
                                           with the minimum required files, using the -SingleClick
                                           flag and button 1 activation, (re)creates and icon on the
                                           Desktop and does not bother the user with questions or
                                           information */
Parse Upper Arg Arg1 Arg2 Arg3 Arg4 Arg5 Arg6 Arg7 Arg8 .
                                        /* Get the full qualified path of our installation
                                           we are running now */
Parse Upper Source . . InstallationFileName
                                        /* Now extract drive and path info terminated
                                           by a backslash */
SourceDirectory=FileSpec('Drive', InstallationFileName)||FileSpec('Path', InstallationFileName)
                                        /* Get \OS2\ directory of boot drive */
OS2Directory=FileSpec('Drive',Value('SYSTEM_INI', , 'OS2ENVIRONMENT'))||'\OS2\'

Call AnsiSetup                          /* Setup ANSI colors */
Say LWhi||BBlu                          /* Set highlighted white on blue */
'@Cls'                                  /* Clear screen to set new color */


                                        /* Ask user what he wants to do, or take
                                           the first commandline arguement when
                                           possible */
InstallationOption=Arg1
If InstallationOption\="I" & InstallationOption\="U" & InstallationOption\="D" & InstallationOption\="P"
    Then Do
    InstallationOption=InstallationMainPanel()
    End
Select
                                        /* If the user wants to quit exit */
    When InstallationOption="Q" Then
        Do
        End
                                        /* If the user wants to install/update PC/2
                                           then get the destination directory, prompt
                                           the user for PC/2, WPS 2 PC/2 or both, update
                                           the files and inform the user */
    When InstallationOption="I" Then
        Do
                                        /* Get the destination directory */
        DestinationDirectory=Arg2
        DestinationDirectory=GetDestinationDirectory(DestinationDirectory)
                                        /* If the user entered QUIT as the destination
                                           directory, because he has to deinstall a
                                           running version of PC/2 first exit */
        If DestinationDirectory="QUIT" Then
            Exit

                                            /* Add terminating backslash */
        DestinationDirectory=DestinationDirectory||"\"
                                        /* Now get the package of PC/2 to install,
                                           either PC/2 (P), WPS 2 PC/2 (W) or both (B) */
        SubPackageSelected=Arg3
        SubPackageSelected=GetSubPackage2Install(SubPackageSelected)
                                        /* Now copy files from current directory to
                                           destination directory */
        FilesSelected=Arg4
        CopySuccess=InstallFiles(FilesSelected, SubPackageSelected, SourceDirectory, DestinationDirectory, OS2Directory)
                                        /* Ask user for -SingleClickFlag */
        SingleClickFlag=Arg5
        SingleClickFlag=QueryClickFlag(SingleClickFlag)
                                        /* Ask user for -ButtonFlag */
        ButtonFlag=Arg6
        ButtonFlag=QueryButtonFlag(ButtonFlag)
                                        /* Now recreate WPS Objects */
        SkipQuestionsFlag=Arg7
        IconRecreateFlag=Arg8
        Ignore=CreateWPSObjects(InstallationOption, SubPackageSelected, DestinationDirectory, OS2Directory, SingleClickFlag, ButtonFlag, SkipQuestionsFlag, IconRecreateFlag)
                                        /* Inform user about some usefull things */
        If SkipQuestionsFlag\="Y" Then
            Ignore=DisplayHint(SkipQuestionsFlag)
        End
                                        /* If the user wants to recreate the WPS
                                           Objects of the PC/2 package prompt user
                                           for PC/2, WPS 2 PC/2 or both */
    When InstallationOption="U" Then
        Do
                                        /* Now get the package of PC/2 to install,
                                           either PC/2 (P), WPS 2 PC/2 (W) or both (B) */
        SubPackageSelected=Arg3
        SubPackageSelected=GetSubPackage2Install(SubPackageSelected)
                                        /* Ask user for -SingleClickFlag */
        If (SubPackageSelected="P" | SubPackageSelected="B") Then
            Do
            SingleClickFlag=Arg5
            SingleClickFlag=QueryClickFlag(SingleClickFlag)
                                        /* Ask user for -ButtonFlag */
            ButtonFlag=Arg6
            ButtonFlag=QueryButtonFlag(ButtonFlag)
            End
        Else
            SingleClickFlag=""
                                        /* Now recreate WPS Objects */
        SkipQuestionsFlag=Arg7
        IconRecreateFlag=Arg8
        Ignore=CreateWPSObjects(InstallationOption, SubPackageSelected, SourceDirectory, OS2Directory, SingleClickFlag, ButtonFlag, SkipQuestionsFlag, IconRecreateFlag)
        End
                                        /* If the user wants to delete the WPS program Objects
                                           for PC/2 and WPS 2 PC/2 destroy them */
    When InstallationOption="D" Then
        Do
        Ignore=DeleteWPSObjects("B")
        End
                                        /* If the user wants to delete all files, delete them */
    When InstallationOption="P" Then
        Do
                                        /* Purge all PC/2 files in the current directory and all
                                           WPS 2 PC/2 files in the \OS2\ subdirectory */
        Ignore=PurgeFiles(SourceDirectory, OS2Directory)
        End
End
                                        /* Change to the drive where we installed from */
Command="@"Filespec("Drive", SourceDirectory)" >NUL"
Command
                                        /* Change in the directory (no trailing \ except for
                                           root directory) */
Command="@CD "Strip(Filespec("Path", SourceDirectory), T, "\")
If Command="@CD " Then
    Command=Command||"\"
Command=Command||" >NUL"
Command
Say LWhi
Say "   And now - enjoy! - And now - enjoy! - And now - enjoy! - And now - enjoy!"
Say Non||Whi||BBla
Exit

/*--------------------------------------------------------------------------------------*\
 * Setup ANSI colors                                                                    *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
AnsiSetup:
                                        /* ANSI control */
Esc=d2c(27)d2c(91)
                                        /* Attributes */
Bli=Esc'5m'
Und=Esc'4m'
Hig=Esc'1m'
Non=Esc'0m'
                                        /* Foreground colors */
Bla=Esc'30m'
Red=Esc'31m'
Gre=Esc'32m'
Bro=Esc'33m'
Blu=Esc'34m'
Cya=Esc'35m'
Tur=Esc'36m'
Whi=Esc'37m'
LBla=Hig||Esc'30m'
LRed=Hig||Esc'31m'
LGre=Hig||Esc'32m'
LBro=Hig||Esc'33m'
LBlu=Hig||Esc'34m'
LCya=Hig||Esc'35m'
LTur=Hig||Esc'36m'
LWhi=Hig||Esc'37m'
                                        /* Background colors */
BBla=Esc'40m'
BRed=Esc'41m'
BGre=Esc'42m'
BBro=Esc'43m'
BBlu=Esc'44m'
BCya=Esc'45m'
BTur=Esc'46m'
BWhi=Esc'47m'
Return

/*--------------------------------------------------------------------------------------*\
 * Copy files from current directory to destination directory                           *
 * Req:                                                                                 *
 *      FileName ...... File to copy                                                    *
 *      CopyDirectory . Directory to copy to                                            *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
FileCopy: Arg FileName, CopyDirectory1, CopyDirectory2
Success="TRUE"
Parse Value SysCurPos() with Row Col
If CopyDirectory2="" Then
    Do
    Say " Copying "FileName" to "CopyDirectory1
    Command='@Copy 'FileName' 'CopyDirectory1' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Else
    Do
    Say " Copying "FileName" to "CopyDirectory1" , "CopyDirectory2
    Command='@Copy 'FileName' 'CopyDirectory1' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    Command='@Copy 'FileName' 'CopyDirectory2' /v >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Col=Col+60
Call SysCurPos Row, Col
If Success="TRUE" Then
    Say "Copied"
Else
    Say LBro"Failed"LWhi
Return Success

/*--------------------------------------------------------------------------------------*\
 * Delete files at the source directory.                                                *
 * Req:                                                                                 *
 *      FileName ...... File to delete                                                  *
 *      DeleteDirectory Directory to delete from                                        *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
FileDelete: Arg FileName, DeleteDirectory1, DeleteDirectory2
Success="TRUE"
Parse Value SysCurPos() with Row Col
If DeleteDirectory2="" Then
    Do
    Say " Deleting "FileName" from "DeleteDirectory1
    Command='@Del 'DeleteDirectory1||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Else
    Do
    Say " Deleting "FileName" from "DeleteDirectory1" , "DeleteDirectory2
    Command='@Del 'DeleteDirectory1||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    Command='@Del 'DeleteDirectory2||FileName' >NUL 2>NUL'
    Command
    If rc\=0 Then
        Success="FALSE"
    End
Col=Col+60
Call SysCurPos Row, Col
If Success="TRUE" Then
    Say "Deleted"
Else
    Say LBro"Failed"LWhi
Return Success

/*--------------------------------------------------------------------------------------*\
 * Display the logo lines                                                               *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
DisplayLogo:
Say LWhi||BBlu
'@Cls'
Say
Say "                 "LRed"PC/2 - Program Commander/2  Version 2.20 for"LWhi
Say "      "LRed"IBM OS/2 2.x, OS/2 WARP, WARP Srv. SMP, Aurora Presentation Manager"LWhi
Say "                "LRed"Copyright (C) by Roman Stangl November, 1999"LWhi
Return

/*--------------------------------------------------------------------------------------*\
 * Display the the main panel of PC/2's installation.                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      I/D/P/Q                                                                         *
\*--------------------------------------------------------------------------------------*/
InstallationMainPanel:
Do Until (InstallationOption="I" | InstallationOption="U" | InstallationOption="D" | InstallationOption="P" | InstallationOption="Q")
    Call DisplayLogo
    Say
    Say " "LGre"I"LWhi" ... Select this choice to install a new version, or to update an existing"
    Say "       version of the "LRed"PC/2"LWhi" package (containing the subpackages "LRed"PC/2"LWhi" and "
    Say "       "LRed"WPS 2 PC/2"LWhi") on your system."
    Say
    Say " "LGre"U"LWhi" ... Select this option to recreate accidentially deleted WPS program"
    Say "       Objects for "LRed"PC/2"LWhi" and/or "LRed"WPS 2 PC/2"LWhi" programs on your Desktop."
    Say
    Say " "LGre"D"LWhi" ... Select this choice to delete the WPS Objects created by the "LRed"PC/2"LWhi
    Say "       Installation program. After deleting these Objects some files are locked"
    Say "       until the next reboot. Therefore after the next reboot you may want to"
    Say "       continue with the "LGre"P"LWhi"urge option, to completely remove the files from"
    Say "       your disk."
    Say
    Say " "LGre"P"LWhi" ... Select this choice to delete all files of the "LRed"PC/2"LWhi" package from your"
    Say "       disk."
    Say
    Say " "LGre"Q"LWhi" ... Quit Installation without any changes."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter your selection and press the Enter key:"LGre
                                            /* Prompt the user for a selection and
                                               return it */
    Col=Col+54
    Call SysCurPos Row, Col
    Pull InstallationOption
End
Return InstallationOption

/*--------------------------------------------------------------------------------------*\
 * Request the directory to install PC/2 into and create it.                            *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Directory to copy PC/2's files into                                             *
\*--------------------------------------------------------------------------------------*/
GetDestinationDirectory: Arg DestinationDirectory
If DestinationDirectory\="" Then
    Do
                                            /* Test for installation directory */
    Call SysFileTree DestinationDirectory, FileDirectory, 'D'
    If FileDirectory.0='0' Then
        Do
                                            /* Make the installation directory */
        Rc=SysMkDir(DestinationDirectory)
        If Rc\=0 Then
            DestinationDirectory=""
        End
    End
Do While DestinationDirectory=""
    Call DisplayLogo
    Say
    Say " You selected to install a new version, or update an existing version of "LRed"PC/2"LWhi":"
    Say
    Say " *) If a version of "LRed"PC/2"LWhi" is currently running, then please close it now!"
    Say
    Say " *) If you have already installed "LRed"WPS 2 PC/2"LWhi" please run the deinstallation"
    Say "    process of that version. These steps are required, because otherwise"
    Say "    files that are going to be updated are locked and installation will abort."
    Say
    Say " *) If you are ready to continue installation, please enter the destination "
    Say "    directory to install "LRed"PC/2"LWhi" into, or enter "LGre"Quit"LWhi" to abort installation."
    Say
    Say " Please specify the directory you want to install "LRed"PC/2"lWhi" into. As "LRed"PC/2"LWhi" does not"
    Say " require any changes in CONFIG.SYS, a unique directory name is suggested."
    Say " Example for an installation directory: "LGre"C:\PMAPPS\PC2"LWhi
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter installation directory: "LGre
    Col=Col+38
    Call SysCurPos Row, Col
    Pull DestinationDirectory
                                            /* Test for installation directory */
    Call SysFileTree DestinationDirectory, FileDirectory, 'D'
    If (FileDirectory.0='0' & Right(DestinationDirectory, 1)\=":") Then
        Do
                                            /* Make the installation directory */
        Rc=SysMkDir(DestinationDirectory)
        If Rc\=0 Then
            Do
            Say LBro
            Say " "LBro"Sorry, the desired directory couldn't be created, please correct your"
            Parse Value SysCurPos() with Row Col
            Say " input! Press the Enter key to retry..."
            Col=Col+40
            Call SysCurPos Row, Col
            Pull Ignore
            DestinationDirectory=""
            End
    End
End
Return DestinationDirectory

/*--------------------------------------------------------------------------------------*\
 * Prompt the user for the PC/2 subpackage to install/recreate. This may be PC/2,       *
 * WPS 2 PC/2 or both.                                                                  *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      P/W/B                                                                           *
\*--------------------------------------------------------------------------------------*/
GetSubPackage2Install: Arg SubPackageSelected
Call DisplayLogo
Do While (SubPackageSelected\="P" & SubPackageSelected\="W" & SubPackageSelected\="B")
    Call DisplayLogo
    Say
    Say " "LGre"P"LWhi" ... Install or update "LRed"PC/2"LWhi
    Say
    Say "       Select this choice to install/recreate the "LRed"PC/2"LWhi" WPS program object of"
    Say "       the "LRed"PC/2"LWhi" package."
    Say
    Say " "LGre"W"LWhi" ... Install or update "LRed"WPS 2 PC/2"LWhi
    Say
    Say "       Select this choice to install/recreate the "LRed"WPS 2 PC2"LWhi" WPS program object"
    Say "       of the WPS of the "LRed"PC/2"LWhi" package. "LRed"WPS 2 PC2"LWhi" allows to to extract WPS"
    Say "       programs, folders and objects into "LRed"PC/2"LWhi"'s Popup Menu easily by using"
    Say "       Drag & Drop."
    Say
    Say " "LGre"B"LWhi" ... Install or update both programs"
    Say
    Say "       Select this choice to install/recreate both program objects onto the"
    Say "       WPS."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter your selection and press the Enter key:"LGre
                                            /* Prompt the user for a selection and
                                               return it */
    Col=Col+54
    Call SysCurPos Row, Col
    Pull SubPackageSelected
End
Return SubPackageSelected

/*--------------------------------------------------------------------------------------*\
 * Copy all required files to the installation destination directory, Take care not to  *
 * overwrite a PC2.cfg configuration file.                                              *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
InstallFiles: Arg FilesSelected, SubPackageSelected, SourceDirectory, DestinationDirectory, OS2Directory
                                        /* Ask user if he only wants to leave out the optionl
                                           files */
If (FilesSelected\="A" & FilesSelected\="R" & FilesSelected\="O") Then Do
    Call DisplayLogo
    Say
    Say " The "LRed"PC/2"LWhi" package contains files, that are not required to run it, but give"
    Say " you some ideas how to configure and use "LRed"PC/2"LWhi". The following files are only"
    Say " optional, and can be skipped to save disk space:"
    Say 
    Say " PC2.doc, History.doc .... Current and previous release feature description"
    Say " TrapInfo.doc ............ Skeleton to report bugs (part of online help too)"
    Say " PC2-*.faq ............... Frequently asked questions (part of online help too)"
    Say " Tutorial.zip ............ A introductional Tutorial for novice users"
    Say " Source.zie, Protect.exe . Source code of "LRed"PC/2"LWhi" and source decryption"
    Say
    Say " "LGre"A"LWhi" ... Install all files (recommended and default option)"
    Say
    Say " "LGre"R"LWhi" ... Install only required files"
    Say
    Say " "LGre"O"LWhi" ... Install only optional files"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Please enter your selection and press the Enter key:"LGre
                                        /* Prompt the user for a selection and
                                           return it */
    Col=Col+54
    Call SysCurPos Row, Col
    Pull FilesSelected
    If (FilesSelected\="A" & FilesSelected\="R" & FilesSelected\="O") Then
        FilesSelected="A"
End
CopySuccess="TRUE"
CopyAbort="FALSE"
                                        /* Now copy files (12 files per page) */
Call DisplayLogo
Say
Say " Now copying files (part 1 of 3)..."
Say
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('PC2.EXE', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('PC2HOOK.DLL', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('PC2SPOOL.DLL', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('PC2NET.DLL', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
                                        /* The resource DLLs are OS/2 version dependent */
    If (OS2MajorVersion>2) | ((OS2MajorVersion=2) & (OS2MinorVersion>=40)) Then Do 
        If (FilesSelected="A" | FilesSelected="R") Then
            If FileCopy('PC2BRES.DL4', DestinationDirectory||'PC2BRes.dll')="FALSE" Then
                CopyAbort="TRUE"
        If (FilesSelected="A" | FilesSelected="R") Then
            If FileCopy('PC2VRES.DL4', DestinationDirectory||'PC2VRes.dll')="FALSE" Then
                CopyAbort="TRUE"
        End
    Else Do
        If (FilesSelected="A" | FilesSelected="R") Then
            If FileCopy('PC2BRES.DL3', DestinationDirectory||'PC2BRes.dll')="FALSE" Then
                CopyAbort="TRUE"
        If (FilesSelected="A" | FilesSelected="R") Then
            If FileCopy('PC2VRES.DL3', DestinationDirectory||'PC2VRes.dll')="FALSE" Then
                CopyAbort="TRUE"
        End
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('PC2.HLP', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
    If (FilesSelected="A" | FilesSelected="R") Then
        If FileCopy('INSTALL.CMD', DestinationDirectory)="FALSE" Then
            CopyAbort="TRUE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PC2.DOC', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('HISTORY.DOC', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('TRAPINFO.DOC', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
/*
 *    If (FilesSelected="A" | FilesSelected="O") Then
 *        If FileCopy('SURVEY.DOC', DestinationDirectory)="FALSE" Then
 *            CopySuccess="FALSE"
 */
    If FileCopy('SYSLEVEL.PC2', DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
                                        /* May exit here */
    CopySuccess=TestCopySuccess(CopySuccess, CopyAbort)
    Call DisplayLogo
    Say
    Say " Now copying files (part 2 of 3)..."
    Say
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PC2-1.FAQ', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PC2-2.FAQ', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PC2-3.FAQ', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('SMALLFNT.CMD', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PMCOLOR.CMD', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('TUTORIAL.ZIP', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('SOURCE.ZIE', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
    If (FilesSelected="A" | FilesSelected="O") Then
        If FileCopy('PROTECT.EXE', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
                                        /* Test for existing PC2.cfg */
    Call SysFileTree DestinationDirectory||"PC2.cfg", File, 'F'
    If File.0='0' Then
        Do
        If FileCopy('PC2.cfg', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
        End
    Else
        Do
        Parse Value SysCurPos() with Row Col
        Say " Found existing PC2.CFG at "DestinationDirectory
        Col=Col+60
        Call SysCurPos Row, Col
        Say LBro"Skipped"LWhi
        End
                                        /* Test for existing PC2.ini */
    Call SysFileTree DestinationDirectory||"PC2.ini", File, 'F'
    If File.0='0' Then
        Do
        If FileCopy('PC2.ini', DestinationDirectory)="FALSE" Then
            CopySuccess="FALSE"
        End
    Else
        Do
        Parse Value SysCurPos() with Row Col
        Say " Found existing PC2.INI at "DestinationDirectory
        Col=Col+60
        Call SysCurPos Row, Col
        Say LBro"Skipped"LWhi
        End
    End
                                        /* Test for existing PC2.env */
Call SysFileTree DestinationDirectory||"PC2.env", File, 'F'
If File.0='0' Then
    Do
    If FileCopy('PC2.env', DestinationDirectory)="FALSE" Then
        CopySuccess="FALSE"
    End
Else
    Do
    Parse Value SysCurPos() with Row Col
    Say " Found existing PC2.ENV at "DestinationDirectory
    Col=Col+60
    Call SysCurPos Row, Col
    Say LBro"Skipped"LWhi
    End
                                        /* May exit here */
CopySuccess=TestCopySuccess(CopySuccess, CopyAbort)
Call DisplayLogo
Say
Say " Now copying files (part 3 of 3)..."
Say
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    If FileCopy('WPS2PC2.DLL', DestinationDirectory, OS2Directory||"DLL\")="FALSE" Then
        CopyAbort="TRUE"
    If FileCopy('WPS2PC2.HLP', DestinationDirectory, OS2Directory||"HELP\")="FALSE" Then
        CopyAbort="TRUE"
    End
                                        /* May exit here */
CopySuccess=TestCopySuccess(CopySuccess, CopyAbort)
Return CopySuccess

/*--------------------------------------------------------------------------------------*\
 * According to the parameters passed, inform user about the success of the file copy   *
 * operations during installation.                                                      *
 * Req:                                                                                 *
 *      CopySuccess, CopyAbort                                                          *
 * Returns:                                                                             *
 *      Success ....... TRUE                                                            *
\*--------------------------------------------------------------------------------------*/
TestCopySuccess: Arg CopySuccess, CopyAbort
If (CopySuccess="FALSE" | CopyAbort="TRUE") Then
    Do
    Say
    If CopyAbort="TRUE" Then Do
                                        /* Fatal error, abort installation */           
        Say " Fatal error(s) detected - Be sure that you are not running another copy of"
        Say " "LRed"PC/2"LWhi". Files may also be locked by other applications (e.g. IBM Communication"
        Say " Manager/2), you may stop some applications or reboot. Press the Enter key to"
        Say " abort the installation... "
        Parse Value SysCurPos() with Row Col
        Row=Row-1
        Col=Col+27
        Call SysCurPos Row, Col
        Pull Ignore
        Say Non||Whi||BBla
        Exit
        End
    Else Do
                                        /* Minor error, inform user */      
        Parse Value SysCurPos() with Row Col
        Say " Minor error(s) detected - press the Enter key to continue..."
        Col=Col+62
        Call SysCurPos Row, Col
        Pull Ignore
    End
    CopySuccess='TRUE'
    End
Else
    Call SysSleep 1
Return "TRUE"

/*--------------------------------------------------------------------------------------*\
 * Ask the user for the -SingleClick flag instead of the default -DoubleClick.          *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      SingleClickFlag Y/N                                                             *
\*--------------------------------------------------------------------------------------*/
                                        /* Now ask the user for -SingleClick flag */
QueryClickFlag: Arg SingleClickFlag
Do While (SingleClickFlag\="Y" & SingleClickFlag\="N")
    Call DisplayLogo
                                        /* Ask the user if he wants to display the Popup-
                                           Menu after a single-click instead of a double-
                                           click with mouse button 1 */
    Say
    Say LWhi" Please note that non-default parameters will be added to "LRed"PC/2"LWhi"'s WPS"
    Say " Object and will take precedence over the options saved with the setup "
    Say " dialogs. You may have to change the commandline parameters at the WPS "
    Say " Object to remove that overrides."
    Say
    Say " Do you want the "LRed"PC/2"LWhi"'s Popup-Menu displayed after a single-click with mouse"
    Say " button 1 instead of the default double click, this will also overwrite any"
    Say " changes you make within PC/2 at the next restart (please refer to the online"
    Say " documentation about this and the other optional commandline parameters of"
    Say " "LRed"PC/2"LWhi")? [N/n"Non||Whi||BBlu"/Y/y"LWhi"]: "LGre
    Parse Value SysCurPos() with Row Col
    Row=Row-1
    Col=Col+19
    Call SysCurPos Row, Col
    Pull SingleClickFlag
    If SingleClickFlag="" Then
        SingleClickFlag="N"
End
Say LWhi
Return SingleClickFlag

/*--------------------------------------------------------------------------------------*\
 * Ask the user for the -Button3 flag instead of the default -Button1.                  *
 * Req:                                                                                 *
 *      QueryClickFlag                                                                  *
 * Returns:                                                                             *
 *      ButtonFlag 1/3                                                                  *
\*--------------------------------------------------------------------------------------*/
                                        /* Now ask the user for -Button3 flag */
QueryButtonFlag: Arg ButtonFlag
Parse Value SysCurPos() with SaveRow SaveCol
Do While (ButtonFlag\="1" & ButtonFlag\="3" & ButtonFlag\="@")
    Call SysCurPos SaveRow, SaveCol
                                        /* Ask the user if he wants to display the Popup-
                                           Menu with button 3 instread of 1 */
    Say LWhi" Do you want to use button 3 to launch the Popup-Menu and for Advanced"
    Say " Marking instead of the default button 1, this will also overwrite any"
    Say " changes you make within PC/2 at the next restart (please refer to the online"
    Say " documentation about this and the other optional commandline parameters of"
    Say " "LRed"PC/2"LWhi")? [1"Non||Whi||BBlu"/3"LWhi"]: "LGre
    Parse Value SysCurPos() with Row Col
    Row=Row-1
    Col=Col+15
    Call SysCurPos Row, Col
    Pull ButtonFlag
    If ButtonFlag="" Then
        ButtonFlag="1"
End
Say LWhi
Return ButtonFlag

/*--------------------------------------------------------------------------------------*\
 * Create the WPS Objects of PC/2 and/or WPS 2 PC/2.                                    *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
CreateWPSObjects: Arg InstallationOption, SubPackageSelected, RunDirectory, OS2Directory, SingleClickFlag, ButtonFlag, SkipQuestionsFlag
                                        /* Form PC/2 setup string */
Parameters=""
If SingleClickFlag='Y' | SingleClickFlag='y' Then
    Do
                                        /* Add -SingleClick to the parameters field, -DoubleClick
                                           is the default */
    Parameters="-SingleClick "
    End
If ButtonFlag='3' Then
    Do
                                        /* Add -Button3 to the parameters field, -Button1
                                           is the default */
    Parameters=Parameters||"-Button3 "
    End
PC2SetupString="EXENAME="RunDirectory"\PC2.EXE;STARTUPDIR="RunDirectory";PARAMETERS="Parameters";OBJECTID=<WP_PC2>"
                                        /* Now create/recreate WPS Objects */
Call DisplayLogo
Say
                                        /* Ask the user if he wants to create icons, which means that
                                           the existing ones may be deleted (e.g. from the Startup
                                           folder) and replaced by ones on the Desktop */
If SkipQuestionsFlag\="Y" Then 
    Do
    Parse Value SysCurPos() with SaveRow SaveCol
    Do While (IconRecreateFlag\="Y" & IconRecreateFlag\="N")
        Call SysCurPos SaveRow, SaveCol
        Say LWhi" Do you want to the installation create "LRed"PC/2"LWhi" icons on the Desktop, replacing"
        Say " icons you may already have configured (e.g. in the Startup folder) from a"
        Say " previous installation? [Y/y"Non||Whi||BBlu"/N/n"LWhi"]: "LGre
        Parse Value SysCurPos() with Row Col
        Row=Row-1
        Col=Col+35
        Call SysCurPos Row, Col
        Pull IconRecreateFlag
        If IconRecreateFlag="" Then
            IconRecreateFlag="Y"
    End
    Say LWhi
    End
If InstallationOption\="U" Then
    Do
    If SkipQuestionsFlag\="Y" Then 
        Do
        Say " Now starting "LRed"PC/2"LWhi" from "RunDirectory"..."
        Say
                                        /* Change to the drive where we installed from */
        Command="@"Filespec("Drive", RunDirectory)" >NUL"
        Command
                                        /* Change in the installation directory */
        Command="@CD "||Strip(Filespec("Path", RunDirectory), T, "\")||" >NUL"
        Command
                                        /* Now we start PC/2 with help, but check for
                                           the clicking method */
        Command="@Start PC2.exe "Parameters" -INSTALL"
        Command
        If rc\=0 Then
            Do
            Say " Sorry, I couldn't start "LRed"PC/2"LWhi" for you..."
            End
        Else
            Do
            Say " After you have finished reading all help panels exit "LRed"PC/2"LWhi" and restart it by"
            Say " clicking on the Desktop with mouse button 1. You will notice that the back-"
            Say " ground behind the icon changed its color and shape if "LRed"PC/2"LWhi" is started."
            End
        Say
        Parse Value SysCurPos() with Row Col
        Say " Press the Enter key to continue..."
        Col=Col+36
        Call SysCurPos Row, Col
        Pull Ignore
        Say
                                        /* Change to the drive where we installed from */
        Command="@"Filespec("Drive", SourceDirectory)" >NUL"
        Command
                                        /* Change in the directory */
        Command="@CD "Strip(Filespec("Path", SourceDirectory), T, "\")" >NUL"
        Command
        End
    End
Say " Now creating WPS Objects for "LRed"PC/2"LWhi" and/or "LRed"WPS 2 PC/2"LWhi"..."
Say
Success="TRUE"
                                        /* Create PC/2 Object */
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    If IconRecreateFlag='Y' | IconRecreateFlag='y' Then
        Do
        Parse Value SysCurPos() with Row Col
        Call SysCurPos Row, Col
        Say " Installing WPS Object of "LRed"PC/2"LWhi
        Col=Col+40
        Call SysCurPos Row, Col
                                        /* Now create the PC/2 object on the Desktop */
        Rc=SysCreateObject('WPProgram', 'PC/2', '<WP_DESKTOP>', PC2SetupString, 'ReplaceIfExists')
        If Rc<>1 Then
            Do
            Say "SysCreateObject failed"
            Row=Row+1
            Success="FALSE"
            End
        Else
            Do
            Say "SysCreateObject ok"
            Row=Row+1
            End
        Say
        End
    End
                                        /* Create/recreate WPS 2 PC/2 Object */
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    If FileCopy(WPS2PC2.DLL, OS2Directory||"DLL\")="FALSE" Then
        CopySuccess="FALSE"
    If FileCopy(WPS2PC2.HLP, OS2Directory||"HELP\")="FALSE" Then
        CopySuccess="FALSE"
                                        /* We have to rename WPS 2 PC/2's DLL otherwise
                                           it will be locked (by WPS or WPS2PC2.dll itself ?),
                                           possibly when having .; in the LIBPATH */
    Command="@Ren WPS2PC2.dll WPS2PC2.dl_"
    Command
    Command="@Ren WPS2PC2.hlp WPS2PC2.hl_"
    Command
    Say
    Parse Value SysCurPos() with Row Col
    Say " Installing WPS Object of "LRed"WPS 2 PC/2"LWhi
    Call SysCurPos Row, Col
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysRegisterObjectClass('Wps2Pc2', OS2Directory||'\DLL\WPS2PC2.DLL');
    If Rc<>1 Then
        Do
        Say "SysRegisterObjectClass failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysRegisterObjectClass ok"
        Row=Row+1
        End
    Call SysCurPos Row, Col
    If IconRecreateFlag='Y' | IconRecreateFlag='y' Then
        Do
        SetupString='OBJECTID=<WP_WPS2PC2>;'
        Rc=SysCreateObject('Wps2Pc2', 'WPS 2 PC/2', '<WP_DESKTOP>', SetupString, 'ReplaceIfExists')
        If Rc<>1 Then
            Do
            Say "SysCreateObject failed"
            Row=Row+1
            Success="FALSE"
            End
        Else
            Do
            Say "SysCreateObject ok"
            Row=Row+1
            End
        End
                                        /* Rename WPS 2 PC/2's DLL to original name */
    Command="@Ren WPS2PC2.dl_ WPS2PC2.dll"
    Command
    Command="@Ren WPS2PC2.hl_ WPS2PC2.hlp"
    Command
    End
                                        /* On error wait for user acknowledgement */
If Success="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press the Enter key to continue..."
    Col=Col+36
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return Success

/*--------------------------------------------------------------------------------------*\
 * Deletes the WPS Objects of PC/2 and/or WPS 2 PC/2.                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
DeleteWPSObjects: Arg SubPackageSelected
                                        /* Now delete WPS Objects */
Call DisplayLogo
Say
Say " Now deregistering WPS Objects..."
Say
Success="TRUE"
                                        /* Delete PC/2 Object */
If (SubPackageSelected="P" | SubPackageSelected="B") Then
    Do
    Parse Value SysCurPos() with Row Col
    Call SysCurPos Row, Col
    Say " Deinstalling WPS Object of "LRed"PC/2"LWhi
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysDestroyObject('<WP_PC2>');
    if Rc<>1 Then
        Do
        Say "SysDestroyObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDestroyObject ok"
        Row=Row+1
        End
    Say
    End
                                        /* Delete WPS 2 PC/2 Object */
If (SubPackageSelected="W" | SubPackageSelected="B") Then
    Do
    Parse Value SysCurPos() with Row Col
    Call SysCurPos Row, Col
    Say " Deinstalling WPS Object of "LRed"WPS 2 PC/2"LWhi
    Col=Col+40
    Call SysCurPos Row, Col
    Rc=SysDestroyObject('<WP_WPS2PC2>');
    if Rc<>1 Then
        Do
        Say "SysDestroyObject failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDestroyObject ok"
        Row=Row+1
        End
    Call SysCurPos Row, Col
    Rc=SysDeregisterObjectClass('Wps2Pc2');
    If Rc<>1 Then
        Do
        Say "SysDeregisterObjectClass failed"
        Row=Row+1
        Success="FALSE"
        End
    Else
        Do
        Say "SysDeregisterObjectClass ok"
        Row=Row+1
        End
    End
                                        /* On error wait for user acknowledgement */
If Success="FALSE" Then
    Do
    Say
    Say " Because automatic deletion faild, please try to delete the WPS Objects for"
    Say " "LRed"PC/2"LWhi" and "LRed"WPS 2 PC/2"LWhi" manually, by either selecting the Delete option from the"
    Say " WPS Object's context menu, or by dragging them into the Shredder."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press the Enter key to continue..."
    Col=Col+36
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return Success

/*--------------------------------------------------------------------------------------*\
 * Deletes all files of PC/2 in the current directory and all WPS 2 PC/2 files in the   *
 * \OS2\ directory on the boot drive.                                                   *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
PurgeFiles: Arg SourceDirectory, OS2Directory
                                        /* Now purge files */
Call DisplayLogo
Say
Say " Now deleting files (part 1 of 3)..."
Say
DeleteSuccess="TRUE"
If FileDelete('PC2.EXE', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2HOOK.DLL', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2BRES.DLL', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2VRES.DLL', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2SPOOL.DLL', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2NET.DLL', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2.HLP', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2.DOC', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('HISTORY.DOC', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('TRAPINFO.DOC', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
/*
 * If FileDelete('SURVEY.DOC', SourceDirectory)="FALSE" Then
 *     DeleteSuccess="FALSE"
 */
If FileDelete('INSTALL.CMD', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If DeleteSuccess="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Deletion failed - press the Enter key to continue..."
    Col=Col+53
    Call SysCurPos Row, Col
    Pull Ignore
    DeleteSuccess='TRUE'
    End
Else
    Call SysSleep 1
Call DisplayLogo
Say
Say " Now deleting files (part 2 of 3)..."
Say
If FileDelete('PC2-1.FAQ', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2-2.FAQ', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2-3.FAQ', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('SMALLFNT.CMD', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('SYSLEVEL.PC2', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('TUTORIAL.ZIP', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('SOURCE.ZIE', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PROTECT.EXE', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2.CFG', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2.INI', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('PC2.ENV', SourceDirectory)="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('WPS2PC2.DLL', SourceDirectory, OS2Directory||"DLL\")="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('WPS2PC2.HLP', SourceDirectory, OS2Directory||"HELP\")="FALSE" Then
    DeleteSuccess="FALSE"
If DeleteSuccess="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Deletion failed - press the Enter key to continue..."
    Col=Col+53
    Call SysCurPos Row, Col
    Pull Ignore
    End
Else
    Call SysSleep 1
Call DisplayLogo
Say
Say " Now deleting files (part 3 of 3)..."
Say
If FileDelete('WPS2PC2.DLL', SourceDirectory, OS2Directory||"DLL\")="FALSE" Then
    DeleteSuccess="FALSE"
If FileDelete('WPS2PC2.HLP', SourceDirectory, OS2Directory||"HELP\")="FALSE" Then
    DeleteSuccess="FALSE"
If DeleteSuccess="FALSE" Then
    Do
    Say
    Parse Value SysCurPos() with Row Col
    Say " Deletion failed - press the Enter key to continue..."
    Col=Col+53
    Call SysCurPos Row, Col
    Pull Ignore
    End
Return DeleteSuccess

/*--------------------------------------------------------------------------------------*\
 * Display hints for user of PC/2 (about SmallFnt.cmd, STARTUPFOLDERSONLY and           *
 * RUNWORKPLACE statements, and the FAQ file).                                          *
 * Req:                                                                                 *
 *      DisplayLogo                                                                     *
 * Returns:                                                                             *
 *      Success ....... TRUE/FALSE                                                      *
\*--------------------------------------------------------------------------------------*/
DisplayHint: Arg SkipQuestionsFlag
                                        /* Now inform user about SMALLFNT.CMD */
If (SkipQuestionsFlag='N' | SkipQuestionsFlag="") Then 
    Do
    Call DisplayLogo
    Say
    Say " "LRed"PC/2"LWhi" also ships a small batch file called "LBro"SmallFnt.cmd"LWhi" which you may use to "
    Say " replace the default Proportional System font with a smaller 8 pts. Helv font. "
    Say " This batch files modifies your "LBro"OS2.INI"Lwhi" file so that after the next reboot "
    Say " most dialogs will be much smaller and more information fits on your screen. "
    Say " You may also use the Font Palette to drop the 8 pts. Helv font over the "
    Say " titlebar and menu of any application while you hold the ALT-key to make this "
    Say " font the default on titlebars and menus."
    Say
    Say " Also included is "LBro"PMColor.cmd"LWhi" which you can use to the the background"
    Say " color of PM. This batchfile is a sample to change settings in OS2*.INI when "
    Say " running PC/2 as the WPS replacement."
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press the Enter key to continue..."
    Col=Col+36
    Call SysCurPos Row, Col
    Pull Ignore
                                        /* Now inform user about STARTUPFOLDERSONLY */
    Call DisplayLogo
    Say
                                        /* Search for CONFIG.SYS and the statement
                                           SET RESTARTOBJECTS=STARTUPFOLDERSONLY. Thanks
                                           to Stefan Hora for giving me a drive independent
                                           way to get data from actual CONFIG.SYS */
    FoundConfig=FALSE
    WorkPlace=strip(Value("RESTARTOBJECTS", , "OS2ENVIRONMENT"))
    if POS('STARTUPFOLDERSONLY', WorkPlace)\=0 Then Do
        FoundConfig=TRUE
    End
                                        /* Inform the user about CONFIG.SYS */
    If FoundConfig=TRUE Then Do
        Say " You have the statement "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in your"
        Say " "LBro"CONFIG.SYS"LWhi". To enable OS/2 to start "LRed"PC/2"LWhi" during boot, you have to create"
        Say " a shadow of "LRed"PC/2"LWhi" and move it into your startup folder or add it to"
        Say " "LBro"STARTUP.CMD"LWhi"."
    End
    Else Do
        Say " You don't have the statement "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in ypur"
        Say " "LBro"CONFIG.SYS"LWhi". OS/2 will start automatically "LRed"PC/2"LWhi" during next boot, if "LRed"PC/2"LWhi" is"
        Say " active before you Shutdown your System."
    End
    Say
                                        /* Now search for CONFIG.SYS and the statement
                                           SET RUNWORKPLACE=C:\OS2\PMSHELL.EXE. Again thanks
                                           to Stefan Hora for his drive independent approach */
    FoundConfig=FALSE
    WorkPlace=strip(Value("RUNWORKPLACE", , "OS2ENVIRONMENT"))
    if POS('PMSHELL.EXE', WorkPlace)\=0 Then Do
        FoundConfig=TRUE
    End
                                        /* Inform the user about CONFIG.SYS */
    If FoundConfig=TRUE Then Do
        Say " You have the statement "LBro"SET RUNWORKPLACE=d:\OS2\PMSHELL.EXE"LWhi" in your"
        Say " "LBro"CONFIG.SYS"LWhi". You may replace the "LBro"WPS"LWhi" by "LRed"PC/2"LWhi", please look into the online"
        Say " help panels of "LRed"PC/2"LWhi" for further information."
    End
    Else Do
        Say " It seems that you don't run the "LBro"WPS"LWhi" ("LBro"WorkPlace Shell"LWhi"). You may use "LRed"PC/2"LWhi" as"
        Say " a replacement for the WPS by adding to or modifying your "LBro"CONFIG.SYS"LWhi":"
        Say " "LGre"SET RUNWORKPLACE="DestinationDirectory"\PC2.EXE"LWhi
        Say " But be sure that "LRed"PC2HOOK.DLL"LWhi", "LRed"PC2SPOOL.DLL"LWhi", "LRed"PC2NET.DLL"LWhi" and "LRed"PC2.HLP"LWhi" are in"
        Say " the directory you started "LRed"PC/2"LWhi" from."
        Say " Please look into the online help panels of "LRed"PC/2"LWhi" for further information."
    End
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press the Enter key to continue..."
    Col=Col+36
    Call SysCurPos Row, Col
    Pull Ignore


                                        /* Now inform user about PROTSHELL */
    Call DisplayLogo
    Say
                                        /* Now search for CONFIG.SYS and the statement
                                           PROTSHELL=C:\OS2\PMSHELL.EXE (we have to find
                                           the boot drive, which we will derive from the
                                           SYSTEM_INI environment setting, which of course
                                           could be changed to a different drive by the user
                                           too, but that's very unlikely and I don't know
                                           a better way) */
    FoundConfig=FALSE
    WorkPlace=strip(Value("SYSTEM_INI", , "OS2ENVIRONMENT"))
    ConfigSysFile=FileSpec("Drive", WorkPlace)||'\CONFIG.SYS'
    Call SysFileSearch 'PROTSHELL', ConfigSysFile, ConfigSysLines
    Do Line=1 to ConfigSysLines.0
        If (POS('PMSHELL.EXE', ConfigSysLines.Line)\=0 & POS('REM', ConfigSysLines.Line)=0) Then Do
            FoundConfig=TRUE
            Leave
        End
    End
                                        /* Inform the user about CONFIG.SYS */
    If FoundConfig=TRUE Then Do
        Say " You have the statement "LBro"PROTSHELL=d:\OS2\PMSHELL.EXE"LWhi" in your"
        Say " "LBro"CONFIG.SYS"LWhi". You may replace the "LBro"PROTSHELL"LWhi" by "LRed"PC/2"LWhi", please look into the"
        Say " online help panels of "LRed"PC/2"LWhi" for further information. This will work, though"
        Say " I don't recommend doing that."
    End
    Else Do
        Say " It seems that you don't run the "LBro"PMSHELL"LWhi" as the protected mode shell"
        Say " ("LBro"PROTSHELL"LWhi"). You may use "LRed"PC/2"LWhi" as the protected mode shell instead, by"
        Say " modifying in your "LBro"CONFIG.SYS"LWhi" (though I don't recommend that) to:"
        Say " "LGre"PROTSHELL="DestinationDirectory"\PC2.EXE"LWhi
        Say " But be sure that "LRed"PC2HOOK.DLL"LWhi", "LRed"PC2SPOOL.DLL"LWhi" and "LRed"PC2.HLP"LWhi" are in the directory"
        Say " you started "LRed"PC/2"LWhi" from."
        Say " Please look into the online help panels of "LRed"PC/2"LWhi" for further information."
    End
    Say
    Parse Value SysCurPos() with Row Col
    Say " Press the Enter key to continue..."
    Col=Col+36
    Call SysCurPos Row, Col
    Pull Ignore

                                        /* Now inform user about FAQ */
    Call DisplayLogo
    Say
                                        /* Inform the user about safety */
    Say " Don't forget to backup your configuration file regularily to avoid possible"
    Say " damages or data corruption."
    Say " If you drag a shadow of "LRed"PC/2"LWhi" into the startup folder and have not set"
    Say " "LBro"SET RESTARTOBJECTS=STARTUPFOLDERSONLY"LWhi" in your "LBro"CONFIG.SYS"LWhi" ensure that during"
    Say " loading of the "LBro"WPS"LWhi" "LRed"PC/2"LWhi" is only started by the startup folder to avoid an"
    Say " informational message."
    Say
    Say " If you find this utility useful and want to honor many months of work, you are"
    Say " welcome to send me a small donation. Please read the online documentation for"
    Say " further information! And, you're welcome to visit my homepage too!"
    Say
    Say " Please unzip and study the tutorial in TUTORIAL.ZIP, it's worth the effort and" 
    Say " can save you hours (even if you are already an experienced PC/2 user)!"
    Say
    Say "   Thank you!"
    Say
    Parse Value SysCurPos() with Row Col
    Say " Do you want to read the FAQ (Frequently Asked Questions) list? [Y/y"Non||Whi||BBlu"/N/n"LWhi"]: "LGre
                                        /* Ask the user if he wants to read the FAQ */
    Col=Col+75
    Call SysCurPos Row, Col
    Pull FAQFlag
    If FAQFlag="" Then
        FAQFlag="Y"
End
If FAQFlag='Y' Then Do
    Call DisplayLogo
    Command="@Type PC2-1.faq |more"
    Command
    Command="@Type PC2-2.faq |more"
    Command
    Command="@Type PC2-3.faq |more"
    Command
    End
Return "TRUE"

/*--------------------------------------------------------------------------------------*\
 * The CTRL+Break signal handler just ignores CTRL+BREAK.                               *
 * Req:                                                                                 *
 *      none                                                                            *
 * Returns:                                                                             *
 *      none                                                                            *
\*--------------------------------------------------------------------------------------*/
SignalHandler:
Return "TRUE"

