/* PASSWORD.CMD - Initialise/check/change WorkArea password */

ARG cmd_file, action
CALL INITIALISE
SELECT 
  WHEN action = 'CHK' THEN CALL CHECK_PASSWORD
  WHEN action = 'CHG' THEN CALL CHANGE_PASSWORD
  OTHERWISE CALL ERROR_DISPLAY 'I M P R O P E R   A C C E S S  !'
END
RETURN tries

CHECK_PASSWORD:
IF (SysGetEA(cmd_file,'password',saved_pw)) = 0
  THEN
    DO
      tries = 0
      IF LENGTH(saved_pw) = 0
        THEN
          DO
            create = true
            msg = 'Create password ?  (Y or N):'
            CALL ENTRY_REQUEST 
            DO UNTIL char = 'Y' | char = 'N'
              char = TRANSLATE(SysGetKey('NOECHO'))
              IF char <> 'Y' & char <> 'N'
                THEN CALL BEEP 800,125
            END
            IF char = 'Y'
              THEN CALL CHANGE_PASSWORD
          END
        ELSE
          DO
            DO UNTIL input_pw = saved_pw | tries = 3 | input_pw = ''
              msg = 'Enter password (null to quit):'
              CALL GET_INPUT_PASSWORD
              IF input_pw <> saved_pw & tries <> -1
                THEN
                  DO
                    tries = tries + 1
                    CALL ERROR_DISPLAY 'P A S S W O R D   E R R O R  !'
                  END
            END
          END
    END
  ELSE
    CALL ERROR_DISPLAY 'C M D   F I L E / P A T H   E R R O R  !'
RETURN

CHANGE_PASSWORD:
create = true
tries = 0
DO UNTIL first_pw = input_pw
  msg = 'Enter new password (1-8 characters, A-Z, 0-9):'
  CALL GET_INPUT_PASSWORD
  first_pw = input_pw
  ctr = ctr + 1
  msg = 'Enter the new password again for verification:'
  CALL GET_INPUT_PASSWORD
  ctr = ctr - 1
  IF input_pw <> first_pw
    THEN CALL ERROR_DISPLAY 'U N M A T C H E D   E N T R I E S  !'
END
CALL SysPutEA cmd_file,'password',input_pw
RETURN

GET_INPUT_PASSWORD:
valid = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890'
input_pw = ''
maxlength = 8
enterkey = d2c(13)
bskey = d2c(8)
CALL ENTRY_REQUEST
DO FOREVER
  char = TRANSLATE(SysGetKey('NOECHO'))
  SELECT
    WHEN char = enterkey
      THEN IF input_pw <> '' 
        THEN 
          DO 
            SAY '' 
            LEAVE 
          END 
        ELSE IF create
          THEN CALL BEEP 800,125
          ELSE
            DO
              tries = -1
              LEAVE  
            END
    WHEN char = bskey
      THEN IF input_pw = ''
        THEN CALL BEEP 800,125
          ELSE 
            DO 
              CALL CHAROUT ,bskey bskey
              input_pw = LEFT(input_pw, LENGTH(input_pw)-1)
            END
    WHEN POS(char, valid) > 0
      THEN
        IF LENGTH(input_pw) = maxlength
          THEN CALL BEEP 800,125
          ELSE
            DO
              CALL CHAROUT ,'*'
              input_pw = input_pw||char
            END
    OTHERWISE CALL BEEP 800,125
    END
  END
RETURN       

INITIALISE:
'ANSI ON'
SAY "1B"x||"[30;46m"
'CLS'
PARSE VALUE SysTextScreenSize() WITH rows cols
ctr = rows % 2
true = 1
false = 0
create = false
tries = -1
RETURN

ENTRY_REQUEST:
cur = SysCurPos(ctr,(cols - LENGTH(msg)) % 2)
SAY msg
cur = SysCurPos(ctr,((cols - LENGTH(msg)) % 2) + LENGTH(msg) + 1)
RETURN

ERROR_DISPLAY:
ARG msg 
SAY "1B"x||"[37;41m"
'CLS'
cur = SysCurPos(ctr,(cols - LENGTH(msg)) % 2)
SAY msg
CALL BEEP 800,250
CALL BEEP 500,250
CALL SysSleep(1)
SAY "1B"x||"[30;46m"
'CLS'
RETURN

/* End of Script */
