:userdoc.
:docprof toc=123456.
:title.MultiDesk 0.2.0 user's manual
:h1 id=1 clear.Overview

.br
This is a quick introduction, that should reply to the questions&colon.
:ul .
:li.what is :hp2.MultiDesk:ehp2.?
:li.what does it do?
:li.why would you want to use it?
:li.which are the main features?
:eul.
:p.
:hp2.MultiDesk:ehp2. was born out of my need to have separate desktops for me and my wife.
My wife is not very computer-literate, and she knows nothing about OS/2, but she
has the need to use computers for her work. I wanted to let her use OS/2,
without the fear of her breaking my desktop or deleting valuable items.
:p.
So here is what :hp2.MultiDesk:ehp2. is and what does it do&colon. it will let you create
desktops for as many users as you want. :hp2.MultiDesk:ehp2. keeps desktops :hp2.completely:ehp2.
separate&colon. one destroyed desktop does not corrupt other desktops. You can simply
delete it and re-create it from scratch or from a backup.
:p.
You may want to use it for your wife and/or your children, like me.
:p.
It is also a good tool for experimenting with WPS hacking, without the fear of
breaking your beloved ultra-customized desktop.
:p.
You may have corrupt INIs, but don't want to rebuild the desktop from scratch&colon.
simply :link reftype=hd viewport dependent refid=18.build:elink. another desktop, then you can :link reftype=hd viewport dependent refid=USAGE_TIPS.transfer:elink.
the good pieces from the old desktop to the new one. When you're done you delete
the old one and use your newly created one.
:p.
Actually, :hp2.MultiDesk:ehp2. does something more to your system&colon. it introduces the concept
of :hp1.multiple users:ehp1. to OS/2. Once MultiDesk is installed you will need to :hp1.login:ehp1.
when you boot OS/2, and if you aren't the :hp2.:ehp2.:hp3.administrator:ehp3.:hp2.:ehp2. (:hp2.:ehp2.:hp3.root:ehp3.:hp2.:ehp2. for those
with a unix background) you won't have access to certain items.
:p.
You may ask why I wrote it from scratch rather than using one of the many other
software products that have similar functions. You'll find your reply :link reftype=hd viewport dependent refid=TECH.here:elink..
:p.
You have to understand though that :hp2.MultiDesk:ehp2. is a work in progress. It isn't
complete by any means, and you will probably find bugs and unimplemented
features. They will be implemented as time goes by, provided I have enough free
time. Before you ask&colon. I'm considering an open-source release, but don't hold your
breath.
:p.
:p.
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=2.Prerequisites:elink.
:li.:link reftype=hd viewport dependent refid=3.Copyright &amp. Co.:elink.
:li.:link reftype=hd viewport dependent refid=7.Installation:elink.
:li.:link reftype=hd viewport dependent refid=8.Usage:elink.
:li.:link reftype=hd viewport dependent refid=19.MultiDesk escape characters:elink.
:li.:link reftype=hd viewport dependent refid=26.MultiDesk commands:elink.
:li.:link reftype=hd viewport dependent refid=56.Limitations:elink.
:li.:link reftype=hd viewport dependent refid=57.Revision history:elink.
:li.:link reftype=hd viewport dependent refid=62.Trademarks:elink.
:li.:link reftype=hd viewport dependent refid=63.MultiDesk configuration samples:elink.
:li.:link reftype=hd viewport dependent refid=67..SUBLINK samples:elink.
:eul.
:p.
:h1 id=2 clear.Prerequisites

.br
You should be able to use :hp2.MultiDesk:ehp2. under OS/2 release 4 (Warp) and up.
I've been using it on OS/2 Warp 4 (with all recent fixpacks and kernels),
and on WSeB up to fixpack 2 (with various kernels).
:p.
:hp2.MultiDesk:ehp2. requires the following&colon.
:ul .
:li.:hp2.REXX:ehp2. installed
:li.a boot partition which supports long file names (HPFS, JFS, etc).
:eul.
:p.
:h1 id=3 x=0% y=0% width=30% height=100% clear.Copyright &amp. Co.
:link reftype=hd auto viewport dependent refid=4.

.br
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=4.Copyright:elink.
:li.:link reftype=hd viewport dependent refid=5.freeware license:elink.
:li.:link reftype=hd viewport dependent refid=6.Disclaimer:elink.
:eul.
:p.
:h2 id=4 x=30% y=0% width=70% height=100%.Copyright
:i1.Copyright

.br
:hp2.MultiDesk:ehp2.
.br
Copyright (C) 2000-2002 Cristiano Guadagnino.
.br
All rights reserved.
:p.
You are welcome to join the MultiDesk group on Yahoo groups.
:p.
To subscribe, send a message to
:sl compact.
:li.:link reftype=launch object='nEtScApE.eXe' data='mailto:multidesk-subscribe@yahoogroups.com'.multidesk-subscribe@yahoogroups.com:elink.
:esl.
:p.
:h2 id=5 x=30% y=0% width=70% height=100%.freeware license
:i1.freeware license

.br
This software package is freeware.
:p.
You are allowed to freely use and distribute the program as long as
:ul compact.
:li.the program or its components are not sold as a part of another program package;
:li.no fee is charged for the program other than for cost of media;
:li.the complete package is distributed unmodified;
:eul.
:p.
:h2 id=6 x=30% y=0% width=70% height=100%.Disclaimer
:i1.Disclaimer

.br
:hp8.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
:p.
In particular, I disclaim all warranties for any damages, including, but
not limited to, incidental or consequential damage caused directly or
indirectly by this software.
:p.
All software is supplied AS IS. You may use the program package only at
your own risk.
:p.
This program must not be used in states that do not allow the above limitation
of liability.
:ehp8.:font.:color fc=default bc=default.
:p.
:h1 id=7 clear.Installation

:p.
:hp2.MultiDesk:ehp2. comes as a self-installing :hp2.WarpIN:ehp2. package, hence you need to
have :hp2.WarpIN:ehp2. installed.
:p.
To download the latest release of WarpIN, go to&colon.
:sl compact.
:li.:link reftype=launch object='nEtScApE.eXe' data='http://www.xworkplace.org'.http&colon.//www.xworkplace.org:elink.
:esl.
:p.
Once :hp2.WarpIN:ehp2. is installed, it will take care of all the installation steps, and
will let you uninstall MultiDesk should you wish to.
:p.
:hp2.WarpIN:ehp2. holds a complete list of all installed packages on your system. To learn
more about :hp2.WarpIN:ehp2. go to
:sl compact.
:li.:link reftype=launch object='nEtScApE.eXe' data='http://warpin.netlabs.org'.http&colon.//warpin.netlabs.org:elink.
:esl.
:p.
:h1 id=8 x=0% y=0% width=30% height=100% clear.Usage
:link reftype=hd auto viewport dependent refid=9.

.br
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=9.The MultiDesk configuration file:elink.
:li.:link reftype=hd viewport dependent refid=18.The MuAdmin administration program:elink.
:eul.
:p.
:h2 id=9 x=30% y=0% width=70% height=100%.The MultiDesk configuration file
:i1.The MultiDesk configuration file

.br
:hp2.MultiDesk:ehp2. must be initially set up with a small text configuration file,
named multidesk.cfg. It contains a few options that you may want to customize
for your system. If not customized, :hp2.MultiDesk:ehp2. uses sensible defaults.
:p.
The configuration file is well documented with internal comments, however here
is a quick reference to the supported keys&colon.
:ul .
:li.:link reftype=fn refid=10.default_user:elink.
:li.:link reftype=fn refid=11.default_user_timeout:elink.
:li.:link reftype=fn refid=12.root_user:elink.
:li.:link reftype=fn refid=13.relaxed_security:elink.
:li.:link reftype=fn refid=14.ssaver_timeout:elink.
:li.:link reftype=fn refid=15.log_users:elink.
:li.:link reftype=fn refid=16.log_users_file:elink.
:li.:link reftype=fn refid=17.users_tree:elink.
:eul.
:p.
Here is a sample configuration :link reftype=hd viewport dependent refid=64.file:elink..
:p.
:fn id=10.

.br
The system will automatically login this
user after default_user_timeout seconds,
if this variable is set. You can comment
it out, or leave it blank to disable
automatic login.
:p.
:efn.
:fn id=11.

.br
The system will automatically login
:hp1.default_user:ehp1. after this number of seconds,
if this variable is set. You can set this
variable to 0 to disable automatic login.
:p.
:efn.
:fn id=12.

.br
The root user (administrator) is the user
that has access to all the log files, the
config files, etc. Here you tell how this
user is named. Default is 'root'.
:p.
:hp2.Note that it is not possible to set default_user = root_user:ehp2.
:p.
:efn.
:fn id=13.

.br
If this is set to YES, then :hp2.MultiDesk:ehp2. will
:hp2.not:ehp2. ask to enter a password. Also, this
enables starting the :hp1.default_user:ehp1. by simply
pressing :hp2.ENTER:ehp2. when the login prompt
shows. Default is :hp2.NO:ehp2..
:p.
Note however that log files, config files,
etc. are still locked to everyone but the
:hp1.root_user:ehp1. (:hp5.which will always require a
password:ehp5.).
:p.
:efn.
:fn id=14.

.br
After this number of seconds without user
interaction, the screen will be blanked.
Screen blanking is never disabled. If you
do not specify it, it will be set to the
default of 120 seconds.
:p.
:efn.
:fn id=15.

.br
If this is set to :hp2.YES:ehp2., all logins will
be logged to the :hp1.log_users_file:ehp1. file.
:p.
Note that this file will be readable only
by the :hp1.root_user:ehp1..
:p.
:efn.
:fn id=16.

.br
All logins will be logged to this file,
but only if :hp1.log_users:ehp1. is set to :hp2.YES:ehp2..
:p.
Note that this file will be readable only
by the :hp1.root_user:ehp1..
:p.
:efn.
:fn id=17.

.br
This is where the :link reftype=hd viewport dependent refid=18.users tree:elink. is created
by default. This is only used by the
administration program.
You can override this setting on a
one-by-one basis, by using the
administration program.
:p.
:p.
:efn.
:h2 id=18 x=30% y=0% width=70% height=100%.The MuAdmin administration program
:i1.The MuAdmin administration program

.br
:hp2.MuAdmin:ehp2. is the administration program, used by the administrator
to manage the users that can log into the system.
:p.
With :hp2.MuAdmin:ehp2. you can&colon.
:ul .
:li.Create new users
:ul .
:li.with a default user tree
:li.with a custom user tree
:eul.
:li.Create new desktops
:li.Change a user's parameters (password, INI files, etc.)
:li.Delete users
:li.Migrate INI settings among desktops
:eul.
:p.
:h1 id=19 x=0% y=0% width=30% height=100% clear res=6001.MultiDesk escape characters
:link reftype=hd auto viewport dependent refid=20.

.br
Please select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=20.attribute escape characters:elink.
:li.:link reftype=hd viewport dependent refid=21.hyperlink and replacement escape characters:elink.
:eul.
:p.
:h2 id=20 x=30% y=0% width=70% height=100%.attribute escape characters
:i1.attribute escape characters

.br
Example&colon.
:xmp.
 .. this is a text with attribute escape chars
 .
 *This text is bold*,
 .
 #this text is italic#,
 .
 _this text is underlinded_,
 .
 _*This text is bold and underlined*_,
 .
 .. there is no escape character for the
 .. hilite attribute, so we use the .ATTRIBUTE command
 .at hilite
 this text is hilighted using the .ATTRIBUTE command
 .at
:exmp.
:p.
The following escape characters can be used to
toggle text attributes&colon.
:parml  compact break=none tsize=4.
:pt.*
:pd.toggle bold attibute
:pt.#
:pd.toggle italic attribute
:pt._
:pd.toggle underline attribute
:eparml.
:p.
The following rules apply to attribute escape characters&colon.
:ul compact.
:li.the escape character toggles the attribute on or off
corresponding to the current status
:li.if you want to use the escape character itself within the text,
you have to specify it twice
:li.one or more attribute can be active at a time with the following exceptions&colon.
:ul compact.
:li.hilighted ignores all other attibutes if set
:li.italic and underlined attribute being active let ignore the bold attribute
:eul.
:eul.
:p.
The resulting text from the example above looks like this&colon.
.br
:hp2.This text is bold:ehp2.,
.br
:hp1.this text is italic:ehp1.,
.br
:hp5.this text is underlinded:ehp5.,
.br
:hp5.:ehp5.:hp7.this text is bold and underlined:ehp7.:hp5.:ehp5.
.br
:hp8.
this text is hilighted using the .ATTRIBUTE command
:ehp8.:font.:color fc=default bc=default.
:p.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.you can also use the :link reftype=hd viewport dependent refid=32..ATTRIBUTE:elink. command to toggle
text attributes
:li.there is no escape character to toggle the hilite attribite
(set to red color). You must use the :link reftype=hd viewport dependent refid=32..ATTRIBUTE:elink. command
to toggle the hilite attribute
:eul.
:p.
:h2 id=21 x=30% y=40% width=70% height=60%.hyperlink and replacement escape characters
:i1.hyperlink and replacement escape characters
:link reftype=hd auto viewport dependent refid=22.

.br
See the following source examples&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=22.Examples for internal links:elink.
:li.:link reftype=hd viewport dependent refid=23.Examples for external links to INF files:elink.
:li.:link reftype=hd viewport dependent refid=24.Examples for external links to internet resources:elink.
:li.:link reftype=hd viewport dependent refid=25.Examples for text replacements:elink.
:eul.
:p.
The following rules apply to creating links and text replacement&colon.
:ul compact.
:li.you have to embed the link information in brackets, this
contains either
:ul compact.
:li.an anchor name  or
:li.a link text  or
:li.both
:eul.
:li.if you want to use the escape characters itself within the text,
you have to specify them twice
:li.when using anchor names within the link information
:ul compact.
:li.the anchor name must start with a period right after the bracket
:li.set the anchor with the :link reftype=hd viewport dependent refid=31..ANCHOR:elink. command
:eul.
:li.if an anchor cannot be resolved, it is assumed that a section exists
with the anchor name as an IPF :hp2.refid:ehp2.. This allows to refer to sections
outside of the IPF source being generated by :hp2.MultiDesk:ehp2., wehn it is
embedded in other IPF sources.
:eul.
:p.
The following types of links can be created&colon.
:parml  tsize=4.
:pt.:hp5.title text link:ehp5.
:pd.the link information is the exact title text of a section (case-insensitive)
:pt.:hp5.anchor link with no text:ehp5.
:pd.the title of the linked page is used as link text
:pt.:hp5.anchor link with no text:ehp5.
:pd.the text specified in the link information is used
:pt.:hp5.external link:ehp5.
:pd.the link information is
:ul compact.
:li.an URL with :hp2.http&colon.//:ehp2. or :hp2.ftp&colon.//:ehp2.
:li.an email address starting with :hp2.mailto&colon.:ehp2.
:li.an inf filename starting with :hp2.inf&colon.:ehp2.
:eul.
.br
.br
and optional with an alternate text to be used
as link text instead of the URL or filename.
:eparml.
:p.
The following types of text replacements can be created&colon.
:parml  tsize=4.
:pt.:hp5.title of linked page:ehp5.
:pd.the link information is the anchor name preceeded with an equal sign and dot like&colon. [=.ANCHORNAME]
:pt.:hp5.value of environment variable:ehp5.
:pd.the link information is the name of the environment variable preceeded with
an equal sign&colon. [=ENVVARNAME]
:eparml.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.You can set environment variables with the :link reftype=hd viewport dependent refid=51..SET:elink. command.
:eul.
:p.
:h3 id=22 x=30% y=0% width=70% height=40%.Examples for internal links
:i1.Examples for internal links

.br
:hp5.:ehp5.:hp7.Examples for internal links:ehp7.:hp5.:ehp5.
:xmp.
 .. link this section with the exact title text&colon.
 title text link&colon. [hyperlink and replacement escape characters]
:exmp.
.br
title text link&colon. :link reftype=hd viewport dependent refid=21.hyperlink and replacement escape characters:elink.
:xmp.
 .. link this section with an anchor name
 .. using the title text
 anchor link&colon. [.ESC_LINKS]
:exmp.
.br
anchor link&colon. :link reftype=hd viewport dependent refid=21.hyperlink and replacement escape characters:elink.
:xmp.
 .. link this section with an anchor name
 .. using alternate text
 anchor link with alternate text&colon. [.ESC_LINKS my link]
:exmp.
.br
anchor link with alternate text&colon. :link reftype=hd viewport dependent refid=21.my link:elink.
:p.
:h3 id=23 x=30% y=0% width=70% height=40%.Examples for external links to INF files
:i1.Examples for external links to INF files

.br
:hp5.:ehp5.:hp7.Examples for external links to INF files:ehp7.:hp5.:ehp5.
:xmp.
 .. link to INF file
 INF file&colon. [inf&colon.cmdref]
:exmp.
.br
INF file&colon. :link reftype=launch object='view.exe' data='cmdref'.cmdref:elink.
:xmp.
 .
 .. link to XCOPY section of command reference
 INF file&colon. [inf&colon.cmdref XCOPY]
:exmp.
.br
INF file&colon. :link reftype=launch object='view.exe' data='cmdref "XCOPY"'.XCOPY:elink.
:p.
:h3 id=24 x=30% y=0% width=70% height=40%.Examples for external links to internet resources
:i1.Examples for external links to internet resources

.br
:hp5.:ehp5.:hp7.Examples for external links to internet resources:ehp7.:hp5.:ehp5.
:xmp.
 .. link to internet resources
 web link&colon. [http&colon.//hobbes.nmsu.edu]
:exmp.
.br
web link&colon. :link reftype=launch object='nEtScApE.eXe' data='http://hobbes.nmsu.edu'.http&colon.//hobbes.nmsu.edu:elink.
:xmp.
 .. same web link with alternate text&colon.
 [http&colon.//hobbes.nmsu.edu The Hobbes File Archive]
:exmp.
.br
:link reftype=launch object='nEtScApE.eXe' data='http://hobbes.nmsu.edu'.The Hobbes File Archive:elink.
:xmp.
 .. ftp link
 ftp link&colon. [ftp&colon.//ftp.netlabs.org/pub]
:exmp.
.br
ftp link&colon. :link reftype=launch object='nEtScApE.eXe' data='ftp://ftp.netlabs.org/pub'.ftp&colon.//ftp.netlabs.org/pub:elink.
:xmp.
 .. email link
 email link&colon. [mailto&colon.C.Langanke@Teamos2.de]
:exmp.
.br
email link&colon. :link reftype=launch object='nEtScApE.eXe' data='mailto:C.Langanke@Teamos2.de'.C.Langanke@Teamos2.de:elink.
:xmp.
 .. email link with alternate text
 email link&colon. [mailto&colon.C.Langanke@Teamos2.de Christian Langanke]
:exmp.
.br
email link&colon. :link reftype=launch object='nEtScApE.eXe' data='mailto:C.Langanke@Teamos2.de'.Christian Langanke:elink.
:p.
:h3 id=25 x=30% y=0% width=70% height=40%.Examples for text replacements
:i1.Examples for text replacements

.br
:hp5.:ehp5.:hp7.Examples for text replacements:ehp7.:hp5.:ehp5.
:xmp.
 .. insert the title of the referred page
 title of the page is&colon. [=.ESC_LINKS]
:exmp.
.br
title of the page is&colon. hyperlink and replacement escape characters
:xmp.
 .. insert the content of environment variable
 IPFC directory on my harddisk is&colon. [=IPFC]
:exmp.
.br
IPFC directory on my harddisk is&colon. F&colon.\os2tk45\ipfc;
:p.
:p.
:h1 id=26 x=0% y=0% width=30% height=100% clear.MultiDesk commands
:link reftype=hd auto viewport dependent refid=27.

.br
Please select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=27.MultiDesk commands in general:elink.
:li.:link reftype=hd viewport dependent refid=28..:elink.
:li.:link reftype=hd viewport dependent refid=29...:elink.
:li.:link reftype=hd viewport dependent refid=30..1 to .6:elink.
:li.:link reftype=hd viewport dependent refid=31..ANCHOR:elink.
:li.:link reftype=hd viewport dependent refid=32..ATTRIBUTE:elink.
:li.:link reftype=hd viewport dependent refid=33..BITMAP:elink.
:li.:link reftype=hd viewport dependent refid=34..ELIST:elink.
:li.:link reftype=hd viewport dependent refid=35..ELSE:elink.
:li.:link reftype=hd viewport dependent refid=36..ENDIF:elink.
:li.:link reftype=hd viewport dependent refid=37..FORMAT:elink.
:li.:link reftype=hd viewport dependent refid=38..FN:elink.
:li.:link reftype=hd viewport dependent refid=40..HCLEAR:elink.
:li.:link reftype=hd viewport dependent refid=41..HINDEX:elink.
:li.:link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink.
:li.:link reftype=hd viewport dependent refid=43..INCLUDE:elink.
:li.:link reftype=hd viewport dependent refid=44..INDEX:elink.
:li.:link reftype=hd viewport dependent refid=45..LMARGIN:elink.
:li.:link reftype=hd viewport dependent refid=46..MIRROR:elink.
:li.:link reftype=hd viewport dependent refid=47..OLIST:elink.
:li.:link reftype=hd viewport dependent refid=48..PLIST:elink.
:li.:link reftype=hd viewport dependent refid=49..RESID:elink.
:li.:link reftype=hd viewport dependent refid=50..RMARGIN:elink.
:li.:link reftype=hd viewport dependent refid=51..SET:elink.
:li.:link reftype=hd viewport dependent refid=52..SLIST:elink.
:li.:link reftype=hd viewport dependent refid=53..SUBLINKS:elink.
:li.:link reftype=hd viewport dependent refid=54..TITLE:elink.
:li.:link reftype=hd viewport dependent refid=55..ULIST:elink.
:eul.
:p.
:h2 id=27 x=30% y=0% width=70% height=100%.MultiDesk commands in general
:i1.MultiDesk commands in general

.br
All :hp2.MultiDesk:ehp2. commands
:ul .
:li.start with a period
:li.must start in the first column of the source file.
.br
As all commands start with a period, a period is not allowed
in the first column unless it is the first character of a :hp2.MultiDesk:ehp2.
command. Place all other text contaning a period that way, that
the period is not the first character of a line.
:li.with the exception of some few commands, command names can be abbreviated, that is
typing only the period plus at least two more characters of the
command name is sufficient.
:eul.
:p.
The following commands may not be abbreviated&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=43..INCLUDE:elink.
:li.:link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink.
:li.:link reftype=hd viewport dependent refid=35..ELSE:elink.
:li.:link reftype=hd viewport dependent refid=36..ENDIF:elink.
:eul.
:p.
:h2 id=28 x=30% y=0% width=70% height=100%..
:i1..

.br
:hp2..:ehp2. -  Line break
:p.
Example&colon.
:xmp.
 This line and
 .
 this line will be split by a line break.
:p.
:exmp.
:p.
A period in the first column forces a line break.
:p.
:h2 id=29 x=30% y=0% width=70% height=100%...
:i1...

.br
:hp2...:ehp2. - comment line
:p.
Example&colon.
:xmp.
 .. This is a comment line
:exmp.
:p.
Two periods at column one and two start a comment line.
:p.
:h2 id=30 x=30% y=0% width=70% height=100%..1 to .6
:i1..1 to .6

.br
:hp2..1:ehp2. to :hp2..6:ehp2. - page header
:p.
Example&colon.
:xmp.
 .1 This is the page title
:exmp.
:p.
These commands open up a new IPF page.
:p.
The following rules apply&colon.
:ul compact.
:li.the number is specifying the level, where the top level is one, the
lowest possible level is 6
:li.the text following the page header command is taken for title of the page
and must be specified
:li.a document always must start with level 1
:li.you may not skip a level when increasing the level number, but you
may of course skip a level when decreasing the level number.
:eul.
:p.
The following would be a valid level sequence&colon.
:ul compact.
:li..1 This is level one
:ul compact.
:li.2. This is level two
:ul compact.
:li.3. This is level three
:eul.
:eul.
:li..1 this is another level one page
:ul compact.
:li.2. This is level two again
:li.2. This is another level two page
:eul.
:eul.
:p.
The following would be an invalid level sequence&colon.
:ul compact.
:li..1 This is level one
:ul compact.
:li.3. This is level three
:hp8.
(Level 2 is missing !!!)
:ehp8.:font.:color fc=default bc=default.
:eul.
:li..1 this is another level one page
:ul compact.
:li.2. This is level two again
:li.2. This is another level two page
:eul.
:eul.
:p.
:h2 id=31 x=30% y=0% width=70% height=100%..ANCHOR
:i1..ANCHOR

.br
:hp2..ANCHOR:ehp2. - set a link or footnote anchor
:p.
Example&colon.
:xmp.
 .an MY_ANCHOR
:exmp.
:p.
This command sets a link anchor. It can be used
:ul .
:li.with the :link reftype=hd viewport dependent refid=21.hyperlink and replacement escape characters:elink. command in order to refer to the page
or footnote, where the anchor has been set.
:li.together with the :link reftype=hd viewport dependent refid=49..RESID:elink. command to allow external
linkage
:eul.
:p.
The above anchor would for an interlan link be referred to with
the following line&colon.
:xmp.
  This is the [.MY_ANCHOR section
  for further explanation].
:exmp.
.br
and the resulting text would look like this&colon.
:p.
This is the :link reftype=hd viewport dependent refid=31.section for further explanation:elink..
:p.
:h2 id=32 x=30% y=0% width=70% height=100%..ATTRIBUTE
:i1..ATTRIBUTE

.br
:hp2..ATTRIBUTE:ehp2. - set a text attribute or reset to default
:p.
Example&colon.
:xmp.
 .at hilite
 This text will appear in red !
 .at
:exmp.
:p.
This command toggles the following text attributes&colon.
:ul compact.
:li.bold
:li.italic
:li.underlined
:li.hilite (turns on red)
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.you can toggle the bold, italic and underlined attribute also with :link reftype=hd viewport dependent refid=20.attribute escape characters:elink.
:li.you can specify more than one attribute at a time
:li.one or more attribute can be active at a time with the following exceptions&colon.
:ul compact.
:li.hilighted ignores all other attibutes if set
:li.italic and underlined attribute being active let ignore the bold attribute
:eul.
:li.you can abbreviate the attribute names to a single character
:li.always remember that you toggle attributes on or off corresponding
to the current status
:li.specify no attribute to reset to default !
:eul.
:p.
:h2 id=33 x=30% y=0% width=70% height=100%..BITMAP
:i1..BITMAP

.br
:hp2..BITMAP:ehp2. - include a bitmap
:p.
Example&colon.
:xmp.
 This bitmap
 .bi ns.bmp
 is for URL links.
:exmp.
:p.
This command includes a bitmap into the IPF text. A given bitmap is searched
at the following places&colon.
:ul compact.
:li.within the specified directory (current directory if none specified)
:li.within the directory, from where :hp2.htext.cmd:ehp2. is called from
:li.within the subdirectory :hp2.htext:ehp2. from the directory, from where :hp2.htext.cmd:ehp2. is called from
:li.within all directories of the :hp2.INCLUDE:ehp2. environment variable, if present
:li.within all directories of the :hp2.HTINCLUDE:ehp2. environment variable, if present
:eul.
:p.
The resulting text from the example above looks like this&colon.
.br
This bitmap

is for URL links.
:p.
:h2 id=34 x=30% y=0% width=70% height=100%..ELIST
:i1..ELIST

.br
:hp2..ELIST:ehp2. - end list level
:p.
Example&colon.
:xmp.
 .. end a list level
 .ul compact
 - first item of the main list
 - second item of the main list
   - first list item in the second level
     - first item in the third level
     - second item in the third level
 .el
 .at hi
     and this text belongs to the item in the
     second level again because we ended the
     third level !!!
 .at
   - last item in the second level
 - last item in the first level
:exmp.
:p.
This command will end a level of a list created with the
:link reftype=hd viewport dependent refid=52..SLIST:elink., :link reftype=hd viewport dependent refid=47..OLIST:elink. and :link reftype=hd viewport dependent refid=55..ULIST:elink. commands. You normally will
require this command only if you use either nested lists or multiple list
levels, and cannot use an empty line within a list to end a level,
because an empty line will end up all open lists.
:p.
The resulting list from the example above looks like this&colon.
:ul compact.
:li.first item of the main list
:li.second item of the main list
:ul compact.
:li.first list item in the second level
:ul compact.
:li.first item in the third level
:li.second item in the third level
:eul.
.br
:hp8.
and this text belongs to the item in the
second level again because we ended the
third level !!!
:ehp8.:font.:color fc=default bc=default.
:li.last item in the second level
:eul.
:li.last item in the first level
:eul.
:p.
:h2 id=35 x=30% y=0% width=70% height=100%..ELSE
:i1..ELSE

.br
:hp2..ELSE:ehp2. - switch conditional compile
:p.
Example&colon.
:xmp.
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 the condition is true
 .else
 the condition is false
 .endif
:exmp.
:p.
This command will switch the condition for conditional compilation,
that can be started with the :link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.the :hp2..ELSE:ehp2. command may not abbreviated !!!
:eul.
:p.
:h2 id=36 x=30% y=0% width=70% height=100%..ENDIF
:i1..ENDIF

.br
:hp2..ENDIF:ehp2. - stop conditional compile
:p.
Example&colon.
:xmp.
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 this is some text
 .endif
:exmp.
:p.
This command will stop conditional compilation,
that can be started with the :link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.the :hp2..ENDIF:ehp2. command may not abbreviated !!!
:eul.
:p.
:h2 id=37 x=30% y=0% width=70% height=100%..FORMAT
:i1..FORMAT

.br
:hp2..FORMAT:ehp2. - toggle IPF formatting on/off
:p.
Example&colon.
:xmp.
 .fo off
 This text will appear in monospaced font
 (just like the sample here).
 .fo on
 The text here will be layouted by IPF again.
:exmp.
:p.
This command toggles IPF layout off and on. Toggle IPF layout off for example if&colon.
:ul compact.
:li.if you want to create tables
:li.if you want to make clear that some text is somewhat special (just like the example above)
:li.if you quote contents from a text window of a special file
:eul.
:p.
:h2 id=38 x=30% y=0% width=70% height=100%..FN
:i1..FN

.br
:hp2..FN:ehp2. - footnode header
:p.
Example&colon.
:xmp.
 .. here is the normal IPF text again linking to
 .. the footnote below.
 Here is the [MYFOOTNOTE footnote].
 .fn
 .
 .an MYFOOTNOTE
 This is a footnote and can be linked to with the
 anchor .MYFOOTNOTE.
:exmp.
:p.
This command creates an IPF footnote.
:p.
The following rules apply to footnotes&colon.
:ul compact.
:li.they are linked to exactly like one would link to normal pages
:li.you must use the :link reftype=hd viewport dependent refid=31..ANCHOR:elink. command to set an anchor for the
footnote, so that you can link to the footnote with it.
:eul.
:p.
The resulting footnote list from the example above looks like this&colon.
.br
Here is the :link reftype=fn refid=39.footnote:elink..
:fn id=39.

.br
This is a footnote and can be linked to with the
anchor :hp2..MYFOOTNOTE:ehp2..
:p.
:efn.
:h2 id=40 x=30% y=0% width=70% height=100%..HCLEAR
:i1..HCLEAR

.br
:hp2..HCLEAR:ehp2. - set header clear attribute
:p.
Example&colon.
:xmp.
 .. this will automatically add the clear attribute
 .. to allheaders of level 2, 3 and 4
 .hi 234
 .
 .. this will stopp setting the clear attribute to
 .. any of the upcoming headers
 .hi
:exmp.
:p.
This command will automatically add the clear attribute to all headers, that
apply to the specified levels. The clear attribute lets IPF close all open windows
when a window with this attribute is opened.
:p.
This is very useful when using the .SUBLINK commands to split windows, which
otherwise would leave a lot of windows open when jumping between windows.
Usually you will likely determine one level in your header hirarchy, that will
split windows first, it is recommended to specify exactly this level with the
with every :link reftype=hd viewport dependent refid=53..SUBLINKS:elink. command.
:p.
Specifying no headers will clear the list of levels to get the clear attribute set.
:p.
:h2 id=41 x=30% y=0% width=70% height=100%..HINDEX
:i1..HINDEX

.br
:hp2..HINDEX:ehp2. - auto add page headers to index
:p.
Example&colon.
:xmp.
 .. this will automatically add all upcoming
 .. headers of level 2, 3 and 4 to the index
 .hi 234
 .
 .. this will stopp adding any of the upcoming
 .. headers to the index
 .hi
:exmp.
:p.
This command will automatically add all pages to the index, that apply to the
specified levels. This saves you from having to place an :link reftype=hd viewport dependent refid=44..INDEX:elink. command
manually to all desired pages. Specifying no headers will clear the list
of levels to be added to the index.
:p.
:h2 id=42 x=30% y=0% width=70% height=100%..IF / .IFDEF / .IFNDEF
:i1..IF / .IFDEF / .IFNDEF

.br
:hp2..IF:ehp2. - start conditional compile
:p.
Examples&colon.
:xmp.
 .. compile the following if environment
 .. environment variable MYVAR is defined
 .ifdef MYVAR
 .endif
 .
 .. compile the following if
 .. environment variable MYVAR is not defined
 .ifndef MYVAR
 .endif
 .
 .. compile the following if
 .. environment variable MYVAR is equal to '1'
 .. and MYVAR2 is equal to '2'
 .if MYVAR=1 &amp. MYVAR2=2
 .endif
:exmp.
:p.
This command will conditionally compile source until the
next .ELSE or .ENDIF.
:p.
The following rules apply to conditional compilation&colon.
:ul compact.
:li.only environment variables can be examined with the .IF* commands
:li.the .IF* commands may not be nested
:li.the .IF command supports
:ul compact.
:li.for comparison only the equal operator
:li.for evaluation of boolean expressions the operators
:ul compact.
:li.&amp. for logical :hp2.and:ehp2.
:li.| for logical :hp2.or:ehp2.
:eul.
:li.you :hp2.cannot:ehp2. use round brackets to group boolean expressions!
:eul.
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.the :hp2..IFDEF:ehp2. and :hp2..IFNDEF:ehp2. commands may not abbreviated !!!
:li.see also the commands :link reftype=hd viewport dependent refid=35..ELSE:elink. and :link reftype=hd viewport dependent refid=36..ENDIF:elink.
:eul.
:p.
:h2 id=43 x=30% y=0% width=70% height=100%..INCLUDE
:i1..INCLUDE

.br
:hp2..INCLUDE:ehp2. - include a hypertext file
:p.
Example&colon.
:xmp.
 .include subchapter.txt
:exmp.
:p.
This command will include another :hp2.MultiDesk:ehp2. source compatible
textfile. The file is being searchd at the following places&colon.
:ul compact.
:li.within the current or specified directory
:li.within all directories of the :hp2.INCLUDE:ehp2. environment variable, if present
:li.within all directories of the :hp2.HTINCLUDE:ehp2. environment variable, if present
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.the :hp2..INCLUDE:ehp2. command may not abbreviated !!!
:eul.
:p.
:h2 id=44 x=30% y=0% width=70% height=100%..INDEX
:i1..INDEX

.br
:hp2..INDEX:ehp2. - add a page to the index with an alternative text
:p.
Example&colon.
:xmp.
 .. add the page to the index with the title text
 .in
 .. add the page to the index with an alternate text
 .in This is a special page !
:exmp.
:p.
This command adds the current page to the index, using either&colon.
:ul compact.
:li.the page title, if no alternate text is specified
:li.the text specified
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.you can add the same page with different text as many times as you want
:eul.
:p.
:h2 id=45 x=30% y=0% width=70% height=100%..LMARGIN
:i1..LMARGIN

.br
:hp2..LMARGIN:ehp2. - set left margin
:p.
Example&colon.
:xmp.
 .. set left margin to 10
 .lm 10
 .. reset left margin to default (that is 1)
 .lm
:exmp.
:p.
This command sets the left margin.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.due to a limitation of the IPF compiler you cannot set the left margin to zero
:eul.
:p.
:h2 id=46 x=30% y=0% width=70% height=100%..MIRROR
:i1..MIRROR

.br
:hp2..MIRROR:ehp2. - mirror a page
:p.
Example&colon.
:xmp.
 .. mirror the contents of another page
 .mi MIRRORED-PAGE
:p.
 This text is completely ignored, because only
 the contents of the mirrored page will be displayed in
 this page.
:exmp.
:p.
This command mirrors the contents of another page, that
you define with its anchorname.
:p.
The following rules apply to mirroring pages&colon.
:ul compact.
:li.all other content of the page is ignored, only the content
of the mirrored page is inserted
:li.you can mirror only one page. If you specify the :hp2..MIRROR:ehp2.
command more than once within a page, only the last specified
page is mirrored
:li.all attributes of the mirrored page, which have been set by a
:link reftype=hd viewport dependent refid=53..SUBLINKS:elink., are copied to the mirroring page
:eul.
:p.
:h2 id=47 x=30% y=0% width=70% height=100%..OLIST
:i1..OLIST

.br
:hp2..OLIST:ehp2. - create ordered list
:p.
Example&colon.
:xmp.
 .ol compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
:exmp.
:p.
This command creates an ordered list.
The following rules apply to ordered lists&colon.
:ul compact.
:li.the following parms can be specified
:parml  compact tsize=2.
:pt.:hp1.compact:ehp1.
:pd.do not place empty lines between items
:pt.:hp1.bold  italic  underlined  hilite:ehp1.
:pd.one or more :link reftype=hd viewport dependent refid=32.text attributes:elink. to be used for the parameter term
:eparml.
:li.a list must be terminated by an empty line
:li.a list level can explicitely be ended with the :link reftype=hd viewport dependent refid=34..ELIST:elink. command
:li.an item starts with a minus sign as the item marker
being the first non-space character on the line
:li.the identation of the items are determined by
the position of the item markers
:eul.
:p.
The resulting list from the example above looks like this&colon.
:ol compact.
:li.this is item 1
:li.this is item 2
:ol compact.
:li.this is item 2.1
:ol compact.
:li.this is item 2.1.1
:eol.
:eol.
:li.this is item 3
:eol.
:p.
:h2 id=48 x=30% y=0% width=70% height=100%..PLIST
:i1..PLIST

.br
:hp2..PLIST:ehp2. - create parameter list
:p.
Example&colon.
:xmp.
 .pl compact bold
 - term 1
 = definition 1
 - term 2
 = definition 2
 - term 3
 = definition 3
 .
 spanning two lines
:exmp.
:p.
This command creates a parameter list. An entry
of a parameter list always consist of two elements&colon.
the parameter term and the parameter definition explaining
the term.
:p.
The following rules apply to parameter lists&colon.
:ul compact.
:li.the following parms can be specified
:parml  compact tsize=2.
:pt.:hp1.compact:ehp1.
:pd.do not place empty lines between items
:pt.:hp1.break=fit:ehp1. or :hp1.break=none:ehp1.
:pd.controls break between parameter term and definition
:pt.:hp1.tsize=n:ehp1.
:pd.specifies the size for the parameter term. Default is 10 character units.
:pt.:hp1.bold  italic  underlined  hilite:ehp1.
:pd.one or more :link reftype=hd viewport dependent refid=CMD#ATTRIBUTE.text attributes:elink. to be used for the parameter term
:eparml.
:li.a list must be terminated by an empty line
:li.a list level, and with a parameter list, that is the paremetr list itself,
can explicitely be ended with the :link reftype=hd viewport dependent refid=34..ELIST:elink. command
:li.the first part of a parameter, the so-called parameter term
starts with a minus sign being the first non-space character on the line
:li.the second part of a parameter, the so-called parameter definition
starts with am equal sign being the first non-space character on the line
:li.both term and definition can span over several lines
:eul.
:p.
The resulting list from the example above looks like this&colon.
:parml  compact.
:pt.:hp2.term 1:ehp2.
:pd.definition 1
:pt.:hp2.term 2:ehp2.
:pd.definition 2
:pt.:hp2.term 3:ehp2.
:pd.definition 3
.br
spanning two lines
:eparml.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.when nesting the .PLIST command with other list commands
:link reftype=hd viewport dependent refid=52..SLIST:elink., :link reftype=hd viewport dependent refid=47..OLIST:elink. and :link reftype=hd viewport dependent refid=55..ULIST:elink., the tsize attribute does
not properly work for values below 5.
:eul.
:p.
:p.
:h2 id=49 x=30% y=0% width=70% height=100%..RESID
:i1..RESID

.br
:hp2..RESID:ehp2. - set a numeric resource id for a panel
:p.
Example&colon.
:xmp.
 .. set numericv resource id for external linkage
 .re 6001
 .. don't forget to set an anchor, otherwise the
 .. resid is quite useless
 .an EXTERNAL_PANEL
:exmp.
:p.
This sets a resource id for external linkage for INF and HLP files.
You need external linkage when
:ul .
:li.when several INF files are viewed together concatenated like
:xmp.
start view file1.inf+file2.inf+file3.inf
:exmp.
.br
and you want to link between the files
:li.an application wants to display context sensitive help panels
from within an application
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:li.specify the :link reftype=hd viewport dependent refid=USAGE_DIRECTLY.parameter /RCH:elink. for :hp2.MultiDesk:ehp2. to
additionally generate a resource header file with all external
resource ids
:eul.
:p.
:h2 id=50 x=30% y=0% width=70% height=100%..RMARGIN
:i1..RMARGIN

.br
:hp2..RMARGIN:ehp2. - set right margin
:p.
Example&colon.
:xmp.
 .. set right margin to 10
 .rm 10
 .. reset right margin to default (that is 0)
 .rm
:exmp.
:p.
This command sets the right margin.
:p.
:h2 id=51 x=30% y=0% width=70% height=100%..SET
:i1..SET

.br
:hp2..SET:ehp2. - sets a variable vor conditional compile
:p.
Example&colon.
:xmp.
 .. set the environment variable MYVAR to 1
 .set MYVAR=1
:exmp.
:p.
This command will set a variable, that can be used
:ul compact.
:li.to control conditional compilation with the :link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands
:li.for text replacement
:eul.
:p.
:hp2.Note&colon.:ehp2.
:ul compact.
:hp8.
:li.Specifying the same variable more than once will make
:hp2.MultiDesk:ehp2. use the :ehp8.:hp8.last:ehp8.:hp8. value for :ehp8.:hp8.all:ehp8.:hp8. text replacements of
this variable, because text replacements are evaluated after
executing all .SET commands!
:ehp8.:font.:color fc=default bc=default.
.br
In opposite to that, text replacements are evaluated
immediately when used within parameters to commands
like for the :link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands
:li.environment variable being set with the :hp2..SET:ehp2. command
will not remain after program termination
:eul.
:p.
:h2 id=52 x=30% y=0% width=70% height=100%..SLIST
:i1..SLIST

.br
:hp2..SLIST:ehp2. - create simple list
:p.
Example&colon.
:xmp.
 .sl compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
:exmp.
:p.
This command creates a simple list (without bullets or characters).
The following rules apply to simple lists&colon.
:ul compact.
:li.the following parms can be specified
:parml  compact tsize=2.
:pt.:hp1.compact:ehp1.
:pd.do not place empty lines between items
:pt.:hp1.bold  italic  underlined  hilite:ehp1.
:pd.one or more :link reftype=hd viewport dependent refid=32.text attributes:elink. to be used for the parameter term
:eparml.
:li.a list must be terminated by an empty line
:li.a list level can explicitely be ended with the :link reftype=hd viewport dependent refid=34..ELIST:elink. command
:li.an item starts with a minus sign as the item marker
being the first non-space character on the line
:li.the identation of the items are determined by
the position of the item markers
:eul.
:p.
The resulting list from the example above looks like this&colon.
:sl compact.
:li.this is item 1
:li.this is item 2
:sl compact.
:li.this is item 2.1
:sl compact.
:li.this is item 2.1.1
:esl.
:esl.
:li.this is item 3
:esl.
:p.
:p.
:h2 id=53 x=30% y=0% width=70% height=100%..SUBLINKS
:i1..SUBLINKS

.br
:hp2..SUBLINKS:ehp2. - creates a sublink list and/or splits windows
:p.
Example&colon.
:xmp.
  .. this sample creates three vertical windows
  .2 .SUBLINK sample - three rows
  .fo off
   .su H30 u
  .fo on
  .su H30 u
:p.
  .3 middle panel
  .fo off
   .su H30 u
  .fo on
  .su H30 u
:p.
  .4 lower panel
  .
  This window has only a height of 40% of the complete width of the INF
  application space, as the other two windows use up to 60% of it.
:exmp.
:p.
This command
:ul compact.
:li.creates a list of links to pages below the current level
.br
(see the section about :link reftype=hd viewport dependent refid=30.header levels:elink.)
:li.and splits up the window into several so-called viewports
:eul.
:p.
You can also ommit either action, thus only creating the list or
only splitting up the window.
:p.
:p.
The :hp2..SUBLINK:ehp2. command supports the following parameters&colon.
:parml  break=none tsize=15.
:pt.:hp2.x:ehp2.
:pd.where x is is the maximum levels below the current one
that are to be processed. Specify
:parml  break=none tsize=5.
:pt.:hp2.1:ehp2. to :hp2.n:ehp2.
:pd.how all pages below the level of the current page not deeper than 1 to n
:pt.:hp2.0:ehp2.
:pd.to show all pages below the level of the current page without a level limit
:pt.:hp2.-1:ehp2.
:pd.show all following pages of exactly the same level, but not including subpages
:eparml.
:pt.:hp2.anchor:ehp2.
:pd.starting with a period, where the anchor defines the start page, from which the
sublink list should determined from. Default is the current page, that
contains the .SUBLINK command.
.br
This parameter may not be combined with the parameter for splitting windows.
:pt.:hp2.list type:ehp2.
:pd.specifying one of the following values (abbreviation allowed)
:ul compact.
:li.unordered
:li.ordered
:li.simple
:li.breaks (uses line breaks instead of list items)
:li.nolist (splits windows, but creates no list)
:eul.
:pt.:hp2.clear:ehp2.
:pd.where this parameter sets the clear attribute for the link window.
This will close all other windows before when this window is opened.
:pt.:hp2.Vxx:ehp2. or :hp2.Hxx:ehp2.
:pd.where xx is a portion of 100 percent points
of width or height, where the screen should be split
between this and the sublink pages vertically or horizontally.
xx must be between 20 and 80 and specfies the height or width
of the source window. The remaining percent points of screen
width and height are used for the linked target windows.
.br
This parameter may not be specified together with an anchor name
to determine the start page.
:eparml.
:p.
The following restrioctions apply to sublink lists&colon.
:ul compact.
:li.you can use the .SUBLINK command only once per page!
:li.the parameters for anchor name and for splitting windows are
mutually exclusive
:eul.
:p.
For examples for the :hp2..SUBLINK:ehp2. command see also&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=67..SUBLINK samples:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=68..SUBLINK sample - three rows:elink.
:li.:link reftype=hd viewport dependent refid=71..SUBLINK sample - three cols:elink.
:li.:link reftype=hd viewport dependent refid=74..SUBLINK sample - mixed right down right:elink.
:li.:link reftype=hd viewport dependent refid=79..SUBLINK sample - mixed down right down:elink.
:li.:link reftype=hd viewport dependent refid=84..SUBLINK sample - only splitting windows:elink.
:eul.
:eul.
:p.
:h2 id=54 x=30% y=0% width=70% height=100%..TITLE
:i1..TITLE

.br
:hp2..TITLE:ehp2. - set document title
:p.
Example&colon.
:xmp.
 .ti This is the document title
:exmp.
:p.
This command sets the document title. Speciy that
command as the very first command in your :hp2.MultiDesk:ehp2. compatible
source file.
:p.
:h2 id=55 x=30% y=0% width=70% height=100%..ULIST
:i1..ULIST

.br
:hp2..ULIST:ehp2. - create unordered list
:p.
Example&colon.
:xmp.
 .ul compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
:exmp.
:p.
This command creates an unordered list.
The following rules apply to unordered lists&colon.
:ul compact.
:li.the following parms can be specified
:parml  compact tsize=2.
:pt.:hp1.compact:ehp1.
:pd.do not place empty lines between items
:pt.:hp1.bold  italic  underlined  hilite:ehp1.
:pd.one or more :link reftype=hd viewport dependent refid=32.text attributes:elink. to be used for the parameter term
:eparml.
:li.a list must be terminated by an empty line
:li.a list level can explicitely be ended with the :link reftype=hd viewport dependent refid=34..ELIST:elink. command
:li.an item starts with a minus sign as the item marker
being the first non-space character on the line
:li.the identation of the items are determined by
the position of the item markers
:eul.
:p.
The resulting list from the example above looks like this&colon.
:ul compact.
:li.this is item 1
:li.this is item 2
:ul compact.
:li.this is item 2.1
:ul compact.
:li.this is item 2.1.1
:eul.
:eul.
:li.this is item 3
:eul.
:p.
:h1 id=56.Limitations

.br
The current version of :hp2.MultiDesk:ehp2. has the following limitations&colon.
:ul .
:li.names of source (and include) files may not contain blanks
:li.artwork links are not (yet) supported
:eul.
:p.
:h1 id=57 x=0% y=0% width=30% height=100%.Revision history
:link reftype=hd auto viewport dependent refid=58.

.br
Select one of the following topics&colon.
:ul compact.
:li.:link reftype=hd viewport dependent refid=58.file_id.diz:elink.
:li.:link reftype=hd viewport dependent refid=59.Version 1.02:elink.
:li.:link reftype=hd viewport dependent refid=60.Version 1.01:elink.
:li.:link reftype=hd viewport dependent refid=61.Version 1.00:elink.
:eul.
:p.
:h2 id=58 x=30% y=0% width=70% height=100%.file_id.diz
:i1.file_id.diz

.br
:xmp.
(v1.02) HyperText/2 - FREEWARE
This package allows you to easily create
powerful OS/2 INF files with only a handfull
of commands instead of the complex set of IPF
commands. Unlike other packages, HyperText/2
cannot produce Win help files or HTML files,
but it is freeware (also unlike other tools)
&colon.-)
Author&colon. C.Langanke@TeamOS2.de
:exmp.
:p.
:h2 id=59 x=30% y=0% width=70% height=100%.Version 1.02
:i1.Version 1.02

.br
:hp5.:ehp5.:hp7.Fixed/Updated&colon.:ehp7.:hp5.:ehp5.
:ul .
:li.added command
:sl compact.
:li.:link reftype=hd viewport dependent refid=34..ELIST:elink.
:esl.
.br
.br
to allow to end a list level in nested lists or multilevel lists
in order to allow adding text after a list (level).
:li.added support for nested lists created by the commands
:sl compact.
:li.:link reftype=hd viewport dependent refid=52..SLIST:elink., :link reftype=hd viewport dependent refid=47..OLIST:elink., :link reftype=hd viewport dependent refid=55..ULIST:elink. and :link reftype=hd viewport dependent refid=48..PLIST:elink.
:esl.
:li.changed access to sourcefile to readonly (important when using TVFS)
:li.added detection for empty :link reftype=hd viewport dependent refid=30.header:elink. text
:li.changed INF title from :hp2.Compiler Reference:ehp2. to :hp2.IPF Preprocessor Reference:ehp2.
:eul.
:p.
:hp5.:ehp5.:hp7.New&colon.:ehp7.:hp5.:ehp5.
:ul .
:li.added source samples with comparison to IPF code
:li.added support of attribute characters also for :link reftype=hd viewport dependent refid=21.http links:elink.
:eul.
:p.
:h2 id=60 x=30% y=0% width=70% height=100%.Version 1.01
:i1.Version 1.01

.br
:hp5.:ehp5.:hp7.Fixed/Updated&colon.:ehp7.:hp5.:ehp5.
:ul .
:li.lines with a period as first non-whitespace character within a list got lost
:li.commandline parameter :hp2./?:ehp2. did not display help
:li.external or internet links with text got link text still appended to URL
:li.documentation update for
:ul .
:li.:link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands&colon.
.br
conditional compile may not be nested
:li.:link reftype=hd viewport dependent refid=51..SET:elink. command&colon.
.br
variables set with the .SET command are resolved at the end of the document only
:eul.
:eul.
:p.
:hp5.:ehp5.:hp7.New&colon.:ehp7.:hp5.:ehp5.
:ul .
:li.text replacement implemented for parmeters to commands
:li.:link reftype=hd viewport dependent refid=42..IF / .IFDEF / .IFNDEF:elink. commands now can handle multiple conditions
:eul.
:p.
:h2 id=61 x=30% y=0% width=70% height=100%.Version 1.00
:i1.Version 1.00

.br
First public release
:p.
:h1 id=62.Trademarks

.br
The following trademarks are used in this online help file&colon.
:ul compact.
:li.OS/2 is a trademark of IBM Corporation.
:eul.
:p.
:p.
:h1 id=63 x=0% y=0% width=30% height=100%.MultiDesk configuration samples
:link reftype=hd auto viewport dependent refid=64.

.br
:ul compact.
:li.:link reftype=hd viewport dependent refid=64.Sample configuration file:elink.
:li.:link reftype=hd viewport dependent refid=65.list sample:elink.
:li.:link reftype=hd viewport dependent refid=66.parameter list sample:elink.
:eul.
:p.
:h2 id=64 x=30% y=0% width=70% height=100%.Sample configuration file
:i1.Sample configuration file

.br
:xmp.
                              Sample Configuration File
:p.
# -- MuDesk configuration file --
#
# !!!! Don't put spaces around the "=" sign !!!!
#
#-----------------------------------------------------------------------------
# The system will automatically login this user after default_user_timeout
# seconds, if this variable is set. You can comment it out, or leave it blank
# to disable automatic login.
# Note that setting the timeout to 0 will also disable auto-login.
#
default_user=cris
default_user_timeout=20
#
#-----------------------------------------------------------------------------
# The root user is the user that has access to all the log files, the
# config files, etc. Here you tell how the root user is named. Default is
# 'root'.
#         !! IT IS NOT POSSIBLE TO SET DEFAULT_USER = ROOT_USER !!
#
root_user=root
#
#-----------------------------------------------------------------------------
# If this is set to YES, then MuDesk will NOT ask to enter a password. Also,
# this enables starting the default_user by simply pressing "ENTER" when the
# login prompt shows. Default is NO.
# Note however that log files, config files, etc are still locked to everyone
# but the root_user (which will always require a password).
#
relaxed_security=NO
#
#-----------------------------------------------------------------------------
# After ssaver_timeout seconds without user interaction, the screen will be
# blanked. Note that screen blanking is never disabled. If you do not specify
# it, it will be set to the default of 120 seconds.
#
ssaver_timeout=60
#
#-----------------------------------------------------------------------------
# If this is set to YES, all logins will be logged to the log_users_file file.
# Note that this file will be readable only by the root user.
#
log_users=YES
log_users_file=E&colon.\SysBoot.Log
#
#-----------------------------------------------------------------------------
# This is where the users tree is created by default. This is only used by
# administration program.
# You can override this setting  on a one-by-one basis, by using the
# administration program.
#
users_tree=E&colon.\Users
#
# -- end of cfg file --
:exmp.
:p.
:p.
:h2 id=65 x=30% y=0% width=70% height=100%.list sample
:i1.list sample

.br
:hp5.:ehp5.:hp7.List created by IPF code&colon.:ehp7.:hp5.:ehp5.
:xmp.
 &colon.ul compact.
 &colon.li.this is the first level 1 item
 &colon.li.this is the second level 1 item
 &colon.ul compact.
 &colon.li.this is the first level 2 item
 &colon.li.this is the second level 2 item
 &colon.li.this is the third level 2 item
 &colon.eul.
 &colon.eul.
:exmp.
:p.
:hp5.:ehp5.:hp7.List created by MultiDesk code&colon.:ehp7.:hp5.:ehp5.
:xmp.
 .ul compact
 - this is the first level 1 item
 - this is the second level 1 item
   - this is the first level 2 item
   - this is the second level 2 item
   - this is the third level 2 item
:p.
:exmp.
:hp5.:ehp5.:hp7.resulting list&colon.:ehp7.:hp5.:ehp5.
:ul compact.
:li.this is the first level 1 item
:li.this is the second level 1 item
:ul compact.
:li.this is the first level 2 item
:li.this is the second level 2 item
:li.this is the third level 2 item
:eul.
:eul.
:p.
:h2 id=66 x=30% y=0% width=70% height=100%.parameter list sample
:i1.parameter list sample

.br
:hp5.:ehp5.:hp7.Parameter list created by IPF code&colon.:ehp7.:hp5.:ehp5.
:xmp.
 &colon.parml compact.
 &colon.pt.&colon.hp2.item1&colon.ehp2.
 &colon.pd.this is description for item 1
 &colon.pt.&colon.hp2.item2&colon.ehp2.
 &colon.pd.this is description for item 2
 &colon.pt.&colon.hp2.item3&colon.ehp2.
 &colon.pd.this is description for item 3
 &colon.eul.
:exmp.
:p.
:hp5.:ehp5.:hp7.Parameter list created by MultiDesk code&colon.:ehp7.:hp5.:ehp5.
:xmp.
 .pl compact bold
 - item1
 = this is description for item 1
 - item2
 = this is description for item 2
 - item3
 = this is description for item 3
:p.
:exmp.
:hp5.:ehp5.:hp7.resulting parameter list&colon.:ehp7.:hp5.:ehp5.
:parml  compact.
:pt.:hp2.item1:ehp2.
:pd.this is description for item 1
:pt.:hp2.item2:ehp2.
:pd.this is description for item 2
:pt.:hp2.item3:ehp2.
:pd.this is description for item 3
:eparml.
:p.
:p.
:h1 id=67..SUBLINK samples

.br
Here are some samples demonstrating the power of the :hp2..SUBLINK:ehp2. command.
This section already at the bottom demoes the sublink command without
splitting the window, but just listing up links to all panels directly
below this one. The command for the unordered list for one sub level only
is&colon.
:p.
:xmp.
 .sublink unordered 1
:exmp.
.br
 or as abbreviation&colon.
:xmp.
 .su u 1
:exmp.
.br
So here is the list of pages exactly one level below, giving you demos
of the :hp2..SUBKLINK:ehp2. command. The command used in these samples is being
displayed in each split window.
.br
These command always splits the remaining part
of the page space either vertically with the parameter :hp2.Vxx:ehp2. or horizontally
with the parameter :hp2.Hxx:ehp2., where xx is a fraction of 100 percent
compared to the height and width of the INF application space
(not compared to the remaining space !).
.br
As an example V30 splits the space into two windows of 30 and 70 percent
of the size of the INF application space.
:ul compact.
:li.:link reftype=hd viewport dependent refid=68..SUBLINK sample - three rows:elink.
:li.:link reftype=hd viewport dependent refid=71..SUBLINK sample - three cols:elink.
:li.:link reftype=hd viewport dependent refid=74..SUBLINK sample - mixed right down right:elink.
:li.:link reftype=hd viewport dependent refid=79..SUBLINK sample - mixed down right down:elink.
:li.:link reftype=hd viewport dependent refid=84..SUBLINK sample - only splitting windows:elink.
:eul.
:p.
:h2 id=68 x=0% y=70% width=100% height=30%..SUBLINK sample - three rows
:i1..SUBLINK sample - three rows
:link reftype=hd auto viewport dependent refid=69.

.br
:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=69.middle panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=70.lower panel:elink.
:eul.

:eul.
:p.
:h3 id=69 x=0% y=40% width=100% height=30%.middle panel
:i1.middle panel
:link reftype=hd auto viewport dependent refid=70.

:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=70.lower panel:elink.
:eul.
:p.
:h4 id=70 x=0% y=0% width=100% height=40%.lower panel
:i1.lower panel

.br
This window has only a height of 40% of the complete width of the INF
application space, as the other two windows use up to 60% of it.
:p.
:h2 id=71 x=0% y=0% width=30% height=100%..SUBLINK sample - three cols
:i1..SUBLINK sample - three cols
:link reftype=hd auto viewport dependent refid=72.

:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=72.middle panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=73.right panel:elink.
:eul.

:eul.
:p.
:h3 id=72 x=30% y=0% width=30% height=100%.middle panel
:i1.middle panel
:link reftype=hd auto viewport dependent refid=73.

:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=73.right panel:elink.
:eul.
:p.
:h4 id=73 x=60% y=0% width=40% height=100%.right panel
:i1.right panel

.br
This window has only a width of 40% of the complete width of the INF
application space, as the other two windows use up to 60% of it.
:p.
:h2 id=74 x=0% y=0% width=30% height=100%..SUBLINK sample - mixed right down right
:i1..SUBLINK sample - mixed right down right
:link reftype=hd auto viewport dependent refid=75.

.br
:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=75.2nd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=76.3rd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=77.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=78.5th panel:elink.
:eul.

:eul.

:eul.

:eul.
:p.
:h3 id=75 x=30% y=70% width=70% height=30%.2nd panel
:i1.2nd panel
:link reftype=hd auto viewport dependent refid=76.

.br
:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=76.3rd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=77.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=78.5th panel:elink.
:eul.

:eul.

:eul.
:p.
:h4 id=76 x=30% y=0% width=30% height=70%.3rd panel
:i1.3rd panel
:link reftype=hd auto viewport dependent refid=77.

.br
:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=77.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=78.5th panel:elink.
:eul.

:eul.
:p.
:h5 id=77 x=60% y=40% width=40% height=30%.4th panel
:link reftype=hd auto viewport dependent refid=78.

.br
:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=78.5th panel:elink.
:eul.
:p.
:h6 id=78 x=60% y=0% width=40% height=40%.5th panel

:p.
:h2 id=79 x=0% y=70% width=100% height=30%..SUBLINK sample - mixed down right down
:i1..SUBLINK sample - mixed down right down
:link reftype=hd auto viewport dependent refid=80.

.br
:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=80.2nd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=81.3rd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=82.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=83.5th panel:elink.
:eul.

:eul.

:eul.

:eul.
:p.
:h3 id=80 x=0% y=0% width=30% height=70%.2nd panel
:i1.2nd panel
:link reftype=hd auto viewport dependent refid=81.

.br
:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=81.3rd panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=82.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=83.5th panel:elink.
:eul.

:eul.

:eul.
:p.
:h4 id=81 x=30% y=40% width=70% height=30%.3rd panel
:i1.3rd panel
:link reftype=hd auto viewport dependent refid=82.

.br
:xmp.
 .su H30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=82.4th panel:elink.
:ul compact.
:li.:link reftype=hd viewport dependent refid=83.5th panel:elink.
:eul.

:eul.
:p.
:h5 id=82 x=30% y=0% width=30% height=40%.4th panel
:link reftype=hd auto viewport dependent refid=83.

.br
:xmp.
 .su V30 u
:exmp.
:ul compact.
:li.:link reftype=hd viewport dependent refid=83.5th panel:elink.
:eul.
:p.
:h6 id=83 x=60% y=0% width=40% height=40%.5th panel

:p.
:h2 id=84 x=0% y=0% width=30% height=100%..SUBLINK sample - only splitting windows
:i1..SUBLINK sample - only splitting windows
:link reftype=hd auto viewport dependent refid=85.

:xmp.
 .su V30 no
:exmp.

:p.
:h3 id=85 x=30% y=0% width=70% height=100%.right panel
:i1.right panel

.br
:hp2.Note&colon.:ehp2.
:ul compact.
:li.The left window does not contain the list. The parameter :hp2.NOLIST:ehp2.
(here&colon. the abbreviation :hp2.no:ehp2.) prevents :hp2.MultiDesk:ehp2. from creating the list.
:eul.
:p.
:p.
:euserdoc.
