/*********************************************************************\
   MkObj
   (C) 1996 by Marcel Mller, Darmstadt
   based on MkObj by Thomas Christinck, Braunschweig
\*********************************************************************/

PARSE ARG name

/* check for usage */
IF name = '' THEN DO
  SAY 'Usage: MkObj <executablename>'
  EXIT 2
  END

/* load funcs */
CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
CALL SysLoadFuncs

/* replace slash by backslash (for unix freaks) */
pos = 0
DO FOREVER
  pos = POS('/', name, pos +1)
  IF pos = 0 THEN LEAVE
  name = OVERLAY('\', name, pos)
  END
DROP pos

/* check extension */
split = MAX(LASTPOS("\", name), LASTPOS("/", name), LASTPOS(":", name))
IF LASTPOS('.', name) > split THEN DO
  /* explicit extension */

  /* search */
  rc = SysFileTree(name, files, 'FO')
  IF rc > 0 THEN DO
    SAY 'Out of momory'
    EXIT 3
    END
  IF \(files.0 = 0) THEN DO
    IF files.0 > 1 THEN DO
      SAY 'Create 'files.0' objects ?'
      PARSE UPPER PULL reply
      IF \(reply = 'Y') THEN
        EXIT 1
      END
    DO I=1 TO files.0
      CALL createobj files.I
      END
    EXIT 0
    END
  DROP files

  IF (POS('*',name)+POS('?',name)) = 0 THEN DO
    /* try path */
    fullname = SysSearchPath('PATH', name)
    IF \(fullname = '') THEN DO
      CALL createobj fullname
      EXIT 0
      END
    END
  END

ELSE DO
  /* automatic extension */

  /* search .CMD */
  rc = SysFileTree(name'.CMD', files1, 'FO')
  IF rc > 0 THEN DO
    SAY 'Out of momory'
    EXIT 3
    END
  /* search .BAT */
  rc = SysFileTree(name'.BAT', files2, 'FO')
  IF rc > 0 THEN DO
    SAY 'Out of momory'
    EXIT 3
    END
  /* search .EXE */
  rc = SysFileTree(name'.EXE', files3, 'FO')
  IF rc > 0 THEN DO
    SAY 'Out of momory'
    EXIT 3
    END
  /* search .COM */
  rc = SysFileTree(name'.COM', files4, 'FO')
  IF rc > 0 THEN DO
    SAY 'Out of momory'
    EXIT 3
    END
  nfiles = files1.0 + files2.0 + files3.0 + files4.0
  IF \(nfiles = 0) THEN DO
    IF nfiles > 1 THEN DO
      SAY 'Create 'nfiles' objects ?'
      PARSE UPPER PULL reply
      IF \(reply = 'Y') THEN
        EXIT 1
      END
    DO I=1 TO files1.0
      CALL createobj files1.I
      END
    DO I=1 TO files2.0
      CALL createobj files2.I
      END
    DO I=1 TO files3.0
      CALL createobj files3.I
      END
    DO I=1 TO files4.0
      CALL createobj files4.I
      END
    EXIT 0
    END
  DROP files1
  DROP files2
  DROP files3
  DROP files4

  IF (POS('*',name)+POS('?',name)) = 0 THEN DO
    /* try path .CMD */
    fullname = SysSearchPath('PATH', name'.CMD')
    IF \(fullname = '') THEN DO
      CALL createobj fullname
      EXIT 0
      END
    /* try path .BAT */
    fullname = SysSearchPath('PATH', name'.BAT')
    IF \(fullname = '') THEN DO
      CALL createobj fullname
      EXIT 0
      END
    /* try path .EXE */
    fullname = SysSearchPath('PATH', name'.EXE')
    IF \(fullname = '') THEN DO
      CALL createobj fullname
      EXIT 0
      END
    /* try path .COM */
    fullname = SysSearchPath('PATH', name'.COM')
    IF \(fullname = '') THEN DO
      CALL createobj fullname
      EXIT 0
      END
    END
  END

SAY "No executable file matching '"name"' found"
EXIT 1

createobj: PROCEDURE
  PARSE ARG fullname
  SAY 'creating 'fullname' ...'
  /* create name & dir */
  slash = LASTPOS("\", fullname)
  point = LASTPOS(".", fullname)
  IF point > slash THEN
    name = SUBSTR(fullname, slash+1, point - slash -1)
  ELSE
    name = SUBSTR(fullname, slash+1)
  dir = SUBSTR(fullname, 1, slash-1)
  /* create object */
  rc = SysCreateObject("WPProgram", name, "<WP_DESKTOP>", "EXENAME="fullname)
  IF rc = 0 THEN
    SAY "The programobject "name" could not be created"
  RETURN
