/* Rexx program to install INFLib  */
'echo off'

call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

parse arg parms

if parms = ""
    Then
        Do
            'CLS'
            Say ''
            Say ''
            Say 'ERROR!'
            Say 'Incorrect or missing parameters'
            Say 'Correct syntax is:  '
            Say '     ILInst INFLib_directory'
            Return
        End

parse var parms infDir

if right(infDir,1) <> '\'
    Then infDir = infDir||'\'

/* Let's do the disclaimer stuff */
'CLS'
Say ''
Say ''
Say 'By using this program, you are agreeing to accept'
Say 'all risk for use of this program.'
Say ''
Say 'This means that YOU and YOU ALONE are responsible for'
Say 'any and all problems that may arise from use of this software.'
Say ''
Say 'Do you agree to these terms? (Y/N):'
pull agree

if agree <> 'Y'
    Then Exit


Say 'Do you really want to install INFLib into 'infDir' (Y/N) ?'
pull response

if response = 'Y'
    Then
        Do
            'echo y|xcopy *.* '||infDir||'>NUL'

           call SysCreateObject 'WPProgram', 'ShowWho', '<WP_DESKTOP>',';EXENAME='||infDir||'\INFLib.Exe;STARTUPDIR='||infDir||';PROGTYPE=PM;OBJECTID=<INFLib>',REPLACE
        End

Say 'Installation completed successfully.'

Say 'Do you wish to read the INFLib.Doc file now?'
pull response

if response = 'Y'
    Then
        'type INFLib.Doc|more'

Say 'Do you wish to print the INFLib.Doc file now?'
pull response

if response = 'Y'
    Then
        'print INFLib.doc'
