/*                                                           */
/* This program modifies WIN-OS2 settings on */
/* network applications listed in a companion data file. */
/* The data file must be colocated with this .CMD file, and */
/* be named FIXNETAP.DAT (see Housekeeping subrtn.) */
/*                                                           */
/* CHANGE LOG:                                           */
/*   9/6/96  PAD  .DAT file processing                 */
/*   12/96 PAD  longer timeout and                      */
/*    same DAT file for DTObv, non-DTObv: mutiple FOLDER ID entries */
/*   1/97  PAD  shorter timeout for objects within the folder  */
/*                                                           */
/*************************************************************/
 
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

start:
if \ Housekeeping() then
   exit
if \ Get_Dat_File() then
   exit
if \ Get_Folder(Max_Delay) then
   do
      say "Can't find folder: "||Folder_ID
      /*pull x*/
      exit
   end /* do */

/*  Finally, start modifying settings for net apps listed in parm file  */
do i=1 to IDs.0
   Obj_ID=substr(IDs.i,length(ID_Label)+1)
   /*say Obj_ID*/
   if \ Fix_Settings() then
      say "Can't change settings for "||Obj_ID
end 
/*   processing stops here!   */
return

Housekeeping:
Dat_File='FIXNETAP.DAT'  /* name of .DAT file holding folder and app obj ids */
ID_Label='OBJECT ID = '   /* a literal in the .DAT file */
Folder_Label='FOLDER ID = '  /* a literal in the .DAT file */
parse source me  /* get the directory where this .CMD is located */
dir_start=lastpos(':',me)-1
dir_len=(lastpos('\',me)-dir_start)+1
dis_path=substr(me,dir_start,dir_len)
/*if lastpos('\',dis_path)<length(dis_path) then
   dis_path=dis_path||'\'*/
/*say 'path to '||Dat_File||' is '||dis_path*/
/* append this path to the name of the parameter file */
Dat_File = dis_path||Dat_File
/* the settings in the following string will overwrite current settings */
/* for the program objects listed in the .DAT file.  */
setup='PROGTYPE=PROG_31_ENHSEAMLESSCOMMON;'||,
      'SET WIN_DDE=1;'||,
      'SET WIN_CLIPBOARD=1;'||,
      'SET WIN_ATM=0;'||,
      'SET DOS_BACKGROUND_EXECUTION=0;'||,
      'SET DOS_HIGH=1;'||,
      'SET DOS_UMB=1;'||,
      'SET DOS_LASTDRIVE=R;'||,
      'SET DOS_DEVICE=C:\OS2\MDOS\LPTDD.SYS,'||,
                     'C:\OS2\MDOS\ANSI.SYS,'||,
                     'C:\TCPIP\BIN\VDOSTCP.SYS;'||,
      'SET DOS_FILES=50;'||,
      'SET DOS_FCBS=20;'||,
      'SET HW_TIMER=1;'||,
      'SET DPMI_DOS_API=ENABLED;'||,
      'SET DPMI_MEMORY_LIMIT=64;'||,
      'SET HW_ROM_TO_RAM=1;'||,
      'SET IDLE_SECONDS=20;'||,
      'SET IDLE_SENSITIVITY=75;'||,
      'SET INT_DURING_IO=0;'||,
      'SET SESSION_PRIORITY=1;'||,
      'SET VIDEO_FASTPASTE=1;'||,
      'SET VIDEO_RETRACE_EMULATION=0;'||,
      'SET VIDEO_WINDOW_REFRESH=5;'||,
      'SET VIDEO_8514A_XGA_IOTRAP=0;'||,
      'SET XMS_MEMORY_LIMIT=10240;'||,
      'SET VIDEO_SWITCH_NOTIFICATION=1;'
RCOPEN=0
RC1=0
max_delay=120
min_delay=3
return 1

Get_Dat_File: 
/* does the parameter file exist? */
x=sysfiletree(Dat_File,'files.','fst')<>0
if x then
do
   say 'SysFileTree failure, error '||x'  (press ENTER)'
   /*pull x*/
   return 0
end /* do */
if files.0=0 then
do
   say Dat_File||' Not found!'
   /*pull x*/
   return 0
end /* do */
call SysFileSearch ID_Label , dat_file , 'IDs.'
if IDs.0 < 1 then
do
   say 'Parameter file must contain at least one "'||ID_Label||'"  entry!'
   /*pull x*/
   return 0
end
call SysFileSearch Folder_Label , dat_file , 'Fldrs.'
if Fldrs.0 < 1 then
do
   say 'Parameter file must contain at least one "'||Folder_Label||'"  entry!'
   /*pull x*/
   return 0
end
do i = 1 to fldrs.0
   Fldrs.i=substr(Fldrs.i,length(Folder_Label)+1)
end
return 1

Get_Folder: procedure expose fldrs.
parse arg w
 DO I=1 TO w
  do j=1 to fldrs.0
   RCOPEN = SysOpenObject(fldrs.j, 'ICON', '0')   /* open the folder identified in the .DAT file */
   IF RCOPEN=1 then
       DO
          /*   change the settings for this folder to flowed, mini icons, etc  */
          rc = SysSetObjectData(fldrs.j, 'ICONVIEW=FLOWED,MINI;ALWAYSSORT=YES') ;
          return 1
       END
  end  /* j=1 to fldrs.0  */
 RC=SYSSLEEP(1)
 END
return 0

Fix_Settings: procedure expose Obj_ID setup min_delay
DO i=1 TO min_delay
  RC1=SysSetObjectData(OBJ_ID,setup)  /*  overwrite settings with desired ones  */ 
  IF RC1=1 then return 1
  RC=SYSSLEEP(1)
END
return 0
