#----------------------------------------------------------------------------
# TOOLS.MAK for os2 hosted intel lx targeting tools
#
# SCCSID: tools/os2.386/lx.386/bin/tools.mak, *ibmc386, wp.os2.386, 940617.2 1.7 94/06/17
#
# FUNCTIONS:
#
# CALLED FROM: Header.mak
#
# ORIGINS:
#
# (C) COPYRIGHT International Business Machines Corp. 1994
# All Rights Reserved
# Licensed Materials - Property of IBM
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#----------------------------------------------------------------------------
#
# Change History:
# ---------------
# Defect # Date     By  Description
# -----------------------------------------------------------------------------
# 160027   07/13/96 TV  Added v304 level of VAC++ and ILINK macro
# 183684   08/21/97 TV  Added JAVA_VER macro variable
# 184829   09/05/97 TV  Removed default setting of JAVA_VER variable.
#
# Initials:
#   TV - Thorne Ventura
#----------------------------------------------------------------------------
!ifndef CSET_VER
CSET_VER  = 9
!endif

!ifndef SOM_VER
SOM_VER   = 21
!endif

!ifndef MASM_VER
MASM_VER  = 51
!endif

!ifndef TCP_VER
TCP_VER  = V30
!endif

!if "$(CSET_VER)" != "6"  && "$(CSET_VER)" != "9" && "$(CSET_VER)" != "11"
!error  CSET_VER must be either 6, 9, or 11 !
!endif

!if "$(JAVA_VER)" != "V102"  && "$(JAVA_VER)" != "V11X" && "$(JAVA_VER)" !=""
!error  JAVA_VER must be either V102, V11X or null.
!endif

# VACPP_VER is a macro variable to determine which VAC++ compiler to use,
# if at all.  Since each component of VAC++ has its own CSD's, the version
# indicated indicates which build version to use: 0 = current; 1 = latest.
# If VACPP_VER is not specified, C Set paths are set up.  IF VACPP_VER is
# specified, VAC++ paths are set up.
#
!if "$(VACPP_VER)" != "v3" && "$(VACPP_VER)" != "v304" && "$(VACPP_VER)" != ""
!error  VACPP_VER must be either v3, v304 or null.
!endif

!if "$(SOM_VER)" != "20" && "$(SOM_VER)" != "21"
!error  SOM_VER  must be either 20 or 21 !
!endif

!if "$(MASM_VER)" != "51" && "$(MASM_VER)" != "60"
!error MASM_VER  must be either 51 or 60 !
!endif

CSET_DIR = csd$(CSET_VER)
SOM_DIR  = som$(SOM_VER)
MASM_DIR  =masm$(MASM_VER)

#
# List here any macro variables whose values are different depending on which
# tool set is requested, C Set or VAC++.  Note that VAC++ comes with
# its own SOM which is scattered across different directories.
#
# COMPILER_HDR2 was added for the WP Shell group so they can use the
# COMPILER_HDR and COMPILER_XXX macro variables separately.
#
!if "$(VACPP_VER)" == ""
! ifndef USER_CSET
USER_CSET    = $(TOOLS2)\ibmcpp\$(CSET_DIR)
! endif
TOOLSX       = $(USER_CSET)\bin;$(TOOLS2)\$(SOM_DIR)\bin;
TOOLSDPATHX  = $(USER_CSET)\help;$(TOOLS2)\$(SOM_DIR)\msg;$(TOOLS1)
COMPILER_HDR1= $(USER_CSET)\include
COMPILER_HDR2= $(USER_CSET)\ibmclass
COMPILER_HDR = $(COMPILER_HDR1);$(COMPILER_HDR2)
COMPILER_LIB_PATH = $(USER_CSET)\lib;
COMPILER_LIB = $(COMPILER_LIB_PATH:;=)
LINK         = link386
LINK16       = link
LIBUTIL      = lib
!else
! ifndef USER_VACPP
USER_VACPP   = $(TOOLS2)\vacpp\$(VACPP_VER)
! endif
TOOLSX       = $(USER_VACPP)\bin;$(TOOLS2)\$(SOM_DIR)\bin;
TOOLSDPATHX  = $(USER_VACPP)\help;$(TOOLS2)\$(SOM_DIR)\msg;$(TOOLS1)
COMPILER_HDR1= $(USER_VACPP)\include
COMPILER_HDR2= $(USER_VACPP)\ibmclass
COMPILER_HDR = $(COMPILER_HDR1);$(COMPILER_HDR2)
COMPILER_LIB_PATH = $(USER_VACPP)\lib;
COMPILER_LIB = $(COMPILER_LIB_PATH:;=)
LINK         = ilink /nofree
ILINK        = ilink
LIBUTIL      = ilib
!endif

!if "$(JAVA_VER)" != ""
! ifndef USER_JAVAC
USER_JAVAC   = $(TOOLS2)\javaos2\$(JAVA_VER)
! endif
TOOLSX       = $(USER_JAVAC)\bin;
COMPILER_HDR1= $(USER_JAVAC)\include
COMPILER_HDR = $(COMPILER_HDR1);
COMPILER_LIB_PATH = $(USER_JAVAC)\lib;
COMPILER_LIB = $(COMPILER_LIB_PATH:;=)
!endif

!ifndef USER_MASM
USER_MASM    = $(TOOLS2)\$(MASM_DIR)
!endif
!ifndef USER_MSC
USER_MSC     = $(TOOLS2)\Mcl
!endif
!ifndef USER_MSC32
USER_MSC32   = $(TOOLS2)\mcl386
!endif
TOOLSY       = $(TOOLSX);$(USER_MASM)\binp;$(USER_MASM)\binb
TOOLSC       = $(TOOLSY);$(USER_MSC)\bin;$(TOOLS2)\mcl386\bin;
TOOLSDPATH   = $(TOOLSDPATHX);$(USER_MASM)\help
MSC16        = $(USER_MSC)
MSC16INC     = $(MSC16)\include
MSC16LIB     = $(MSC16)\lib
MSC32        = $(USER_MSC32)
MSC32INC     = $(MSC32)\include
MSC32LIB     = $(MSC32)\lib

#
# Set SOM-related paths for C Set and VAC++.  The SOM_DIR variables point to
# the SOM levels provided by Austin.  The build .mak files do nothing with
# SOM_COMP_HDR and SOM_COMP_LIB.  They are provided for developer usage.
#
SOM_COMP_HDR = $(TOOLS2)\$(SOM_DIR)\include
SOM_COMP_LIB = $(TOOLS2)\$(SOM_DIR)\lib

!if "$(VACPP_VER)" != ""
!  if [set LOCPATH=$(USER_VACPP)\LOCALE] ||\
      [set VBPATH=$(USER_VACPP)\DDE4VB] ||\
      [set LPATH=$(USER_VACPP)\MACROS] ||\
      [set CODELPATH=$(USER_VACPP)\MACROS]
!  endif
!endif

TCP_DIR = $(TOOLS2)\tcp\$(TCP_VER)\bin

#----------------------------------------------------------------------------
# Compiler and Tools Macros
#----------------------------------------------------------------------------

CC        = icc
CC16      = cl
CC32      = cl386
AS        = masm
RC        = rc
WRC       = wrc
SC        = sc
MAPSYM    = mapsym
EAUTIL    = eautil
IMPLIB    = implib
INCLUDES  = includes
IPF       = ipfc
MAKEPATH  = makepath
MAPSYM    = mapsym
OS2STUB   = os2stub
SED       = sed
TOUCH     = touch
TABIFY    = tabify
THUNK     = thk2asm
H2INC     = h2inc
NSYNC     = nsync
COPY      = copy
AWK       = gawk
BLDVER    = bldver
RPCGEN    = rpcgen
JAVAC     = javac

#
#   Possibly define some common set of compiler/linker etc flags
#
