/* ALWATASK.C ... ALWALTFXu^XNXCb`uvTv */
#define INCL_DOS
#define INCL_GPI
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include "alwatask.h"
#include "alwatsks.h"
#include "alwatskd.h"

#if MAKE_DLL
/* DLL[` */
/* FbCuNꍇ́A폜̓RgAEgKv܂ */
ULONG EXPENTRY _DLL_InitTerm( HMODULE hmodule ,ULONG flg ){ return TRUE; }
#endif

static const char TASKSW_CLASSNAME[] ={ "ALWALTFX_TASKSW" };
FNWP TASKSW_WndProc;

static BOOL TASKSW_AllocMem( ULONG ssiz ,ULONG vsiz );
static void TASKSW_FreeMem(void);
static int  TASKSW_CursorFromChar( UCHAR chr );
static int  TASKSW_CursorFromPoint( PPOINTS ptr );
static void TASKSW_SetNewCursor( HWND hwnd ,int ncsr );
static void TASKSW_DrawCursor( HPS hps ,BOOL flg );
static void TASKSW_Draw3DFrame( HPS hps ,PRECTL rect ,int width ,LONG col1 ,LONG col2 );

static HWND HwTaskFrame;  /* ^XNXCb`̃t[EEBhEEnh */
static HWND HwTaskClient; /* ^XNXCb`̃NCAgEEBhEEnh */
static HWND HwTaskText;   /* IĂ^XN\pÓIEBhEEnh */

/* eR}hhc */
#define TASKCMD_SELECT 1 /* I */
#define TASKCMD_CANCEL 2 /*  */
#define TASKCMD_UP     3 /* փJ[\ړ */
#define TASKCMD_DOWN   4 /*      V        */
#define TASKCMD_LEFT   5 /*      V        */
#define TASKCMD_RIGHT  6 /*      V        */

/* ANZ[^Ee[u */
#define ACCEL_CNT 9
static struct{
	ACCELTABLE table;
	ACCEL acc[ACCEL_CNT-1];
} AccelTable ={
  { ACCEL_CNT ,0
 ,{  { AF_ALT|AF_VIRTUALKEY          ,VK_ENTER   ,TASKCMD_SELECT } } }
 ,{  { AF_ALT|AF_VIRTUALKEY          ,VK_NEWLINE ,TASKCMD_SELECT }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_SPACE   ,TASKCMD_CANCEL }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_UP      ,TASKCMD_UP     }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_DOWN    ,TASKCMD_DOWN   }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_LEFT    ,TASKCMD_LEFT   }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_RIGHT   ,TASKCMD_RIGHT  }
    ,{ AF_ALT|AF_VIRTUALKEY          ,VK_TAB     ,TASKCMD_RIGHT  }
    ,{ AF_ALT|AF_SHIFT|AF_VIRTUALKEY ,VK_BACKTAB ,TASKCMD_LEFT   } }
};

/* EAt@xbgL[oe[u */
static const UCHAR ScanCode_Numeric[10][2] ={
  { 0x0B ,0x52 } /* '0' ... P߂tL[AQ߂eL[ */
 ,{ 0x02 ,0x4F } /* '1' */
 ,{ 0x03 ,0x50 } /* '2' */
 ,{ 0x04 ,0x51 } /* '3' */
 ,{ 0x05 ,0x4B } /* '4' */
 ,{ 0x06 ,0x4C } /* '5' */
 ,{ 0x07 ,0x4D } /* '6' */
 ,{ 0x08 ,0x47 } /* '7' */
 ,{ 0x09 ,0x48 } /* '8' */
 ,{ 0x0A ,0x49 } /* '9' */
};

static const UCHAR ScanCode_Alphabet[26] ={
  0x1E /* 'A' */
 ,0x30 /* 'B' */
 ,0x2E /* 'C' */
 ,0x20 /* 'D' */
 ,0x12 /* 'E' */
 ,0x21 /* 'F' */
 ,0x22 /* 'G' */
 ,0x23 /* 'H' */
 ,0x17 /* 'I' */
 ,0x24 /* 'J' */
 ,0x25 /* 'K' */
 ,0x26 /* 'L' */
 ,0x32 /* 'M' */
 ,0x31 /* 'N' */
 ,0x18 /* 'O' */
 ,0x19 /* 'P' */
 ,0x10 /* 'Q' */
 ,0x13 /* 'R' */
 ,0x1F /* 'S' */
 ,0x14 /* 'T' */
 ,0x16 /* 'U' */
 ,0x2F /* 'V' */
 ,0x11 /* 'W' */
 ,0x2D /* 'X' */
 ,0x15 /* 'Y' */
 ,0x2C /* 'Z' */
};

static HACCEL Haccel;     /* ^XNXCb`pANZ[^Ee[uEnh */

static SWBLOCK* SwBlock = 0; /* ^XNꗗ\̂̃obt@ */
static int* BufValid = 0;    /* ̕\ItZbgԍ̗񋓃obt@ */
static int CntValid;         /* ̍v */
static int Cursor;           /* ^XNIJ[\ʒu */
static int NumCancel;        /* ^XNXCb`̖߂ԍ */

static LONG SvScrX,SvScrY; /* XN[̏cVXel */
static LONG SvPtrX,SvPtrY; /* ACȐcVXel */
static LONG TitleY;        /* ^XN\ÓIEBhȄc */
static LONG DlgBkCol;      /* ^XNEBhE̔wiF */
static HPOINTER HptrPgm;   /* ACRȂ^XNp̉ACR */

#define	TASKW_ENUM_X 10 /* ^XNEBhEɒu鉡ѐ */

#define FRAME_X 4 /* izjt[̉ */
#define FRAME_Y 4 /* izjt[̏c */

/* ^XNACR\擪wW([) */
#define ICO_TOP_X (SvPtrX/2)
/* ^XNACR\擪xW([)ic=^XNj */
#define ICO_TOP_Y(c) ((SvPtrY/2)+(SvPtrY*3/2)*((c)/TASKW_ENUM_X)+TitleY)
/* ^XNACR\wWZoin=^XNԍj */
#define ICO_LOC_X(n) (ICO_TOP_X+(SvPtrX*3/2)*((n)%TASKW_ENUM_X))
/* ^XNACR\xWZoic=^XNAn=^XNԍj */
#define ICO_LOC_Y(c,n) (ICO_TOP_Y(c)-(SvPtrY*3/2)*((n)/TASKW_ENUM_X))

/* ^XNACROɕ`悳J[\g̍Wic=^XNAn=^XNԍj */
#define CSR_LEFT(n) (ICO_LOC_X(n)-SvPtrX/4)
#define CSR_BOTTOM(c,n) (ICO_LOC_Y(c,n)-SvPtrY/4)
#define CSR_RIGHT(n) (ICO_LOC_X(n)+SvPtrX*5/4-1)
#define CSR_TOP(c,n) (ICO_LOC_Y(c,n)+SvPtrY*5/4-1)

/* ^XNEBhÊ̂̃TCYyѕ\Wic=^XNj */
#define TASKW_SIZ_X (FRAME_X*2+ICO_LOC_X(TASKW_ENUM_X-1)+ICO_LOC_X(1))
#define TASKW_SIZ_Y(c) (FRAME_Y*2+ICO_TOP_Y((c)+TASKW_ENUM_X))
#define TASKW_OFS_X ((SvScrX-TASKW_SIZ_X)/2)
#define TASKW_OFS_Y(c) ((SvScrY-TASKW_SIZ_Y(c))/2)


/* ֐FTASKSW_CREATE */
/* @\@F^XNXCb`EEBhE쐬i\͍sȂj */
/* @Fprm = Ăяo瑗p[^ */
/* ߂lFIŌĂяo瑗p[^̍\ TASKSW_PARAM */
/* @@@F̃TCYA ُI 0 Ԃ */
/* l@FDLL[hɈxĂяo */
/* @@@F̊֐́AK`Ȃ΂ȂȂ */
ULONG EXPENTRY TASKSW_CREATE( const TASKSW_PARAM* prm )
{
	ULONG rc = 0;

	/* ԏ߂ɁAALWALTFX瑗p[^̃TCYA炪] */
	/* TCY𖞂Ă邪AmFȂ΂ȂȂ */
	if( prm->cbSize>=sizeof(TASKSW_PARAM) ){
		TASKSETTING_Init( prm->hab );
		if( WinRegisterClass( prm->hab ,(PSZ)TASKSW_CLASSNAME ,TASKSW_WndProc ,0 ,0 ) ){
			ULONG fcf = 0;
			HwTaskFrame = WinCreateStdWindow( HWND_DESKTOP ,0 ,&fcf
			 ,(PSZ)TASKSW_CLASSNAME ,(PSZ)TASKSW_CLASSNAME ,WS_VISIBLE ,prm->hmodule ,0 ,&HwTaskClient );
			if( HwTaskFrame!=0 ){
				SvScrX = WinQuerySysValue( HWND_DESKTOP ,SV_CXSCREEN );
				SvScrY = WinQuerySysValue( HWND_DESKTOP ,SV_CYSCREEN );
				SvPtrX = WinQuerySysValue( HWND_DESKTOP ,SV_CXICON );
				SvPtrY = WinQuerySysValue( HWND_DESKTOP ,SV_CYICON );
				TitleY = WinQuerySysValue( HWND_DESKTOP ,SV_CYTITLEBAR );
				DlgBkCol = WinQuerySysColor( HWND_DESKTOP ,SYSCLR_DIALOGBACKGROUND ,0 );
				HptrPgm = WinQuerySysPointer( HWND_DESKTOP ,SPTR_PROGRAM ,FALSE );
				HwTaskText = WinCreateWindow( HwTaskFrame ,WC_STATIC ,""
				 ,WS_VISIBLE|SS_TEXT|DT_CENTER ,0 ,0 ,0 ,0 ,HwTaskFrame ,HWND_BOTTOM ,1 ,0 ,0 );
				WinSetPresParam( HwTaskText ,PP_BACKGROUNDCOLOR ,sizeof(LONG) ,&DlgBkCol );

				Haccel = WinCreateAccelTable( prm->hab ,&AccelTable.table );
				WinSetAccelTable( prm->hab ,Haccel ,HwTaskFrame );

				/* ̈ɁA(DLL)z肷 TASKSW_PARAM */
				/* ̃TCYԂBALWALTFX ́A̒l炱DLLz肷 */
				/* ALWALTFX ̃o[Woip̎dg݁j */
				rc = sizeof(TASKSW_PARAM);
			}
		}
	}

	return rc;
}


/* ֐FTASKSW_SHOW */
/* @\@F^XNXCb`EEBhE\ */
/* @Fprm = Ăяo瑗p[^ */
/* @@@Fsw = ^XNꗗ\̂ւ̃|C^ */
/* @@@Fcursor = ŏɑI^XÑItZbgԍ */
/* @@@Fcancel = 쎞ɃANeBuɂȂ^XÑItZbgԍ */
/* @@@Ficursor,cancel̒l-1̏ꍇAY^XNwj */
/* ߂lFI TRUEAُI FALSE */
/* l@FAlt+TABoȂǂɁAALWALTFX Ăяo */
/* @@@Fi\ɌĂяo鎖͖Bq TASKSW_ISSHOWING QƁj */
/* @@@F̊֐́AK`Ȃ΂ȂȂ */
BOOL EXPENTRY TASKSW_SHOW( const TASKSW_PARAM* prm ,PSWBLOCK sw ,LONG cursor ,LONG cancel )
{
	BOOL rc = FALSE;
	int li;

	ULONG ssiz = sizeof(SWBLOCK)+sizeof(SWENTRY)*(sw->cswentry-1);
	ULONG vsiz = sizeof(int)*sw->cswentry;

	if( TASKSW_AllocMem(ssiz,vsiz) ){
		/* ^XNێ郁obt@蓖Đ */
		memcpy( SwBlock ,sw ,ssiz );
		CntValid = 0;
		Cursor = 0;
		NumCancel = -1;
		/* ^XN̓eʂmFA\^XNI肷 */
		for( li = 0 ;li < SwBlock->cswentry ;li++ ){
			int lj;
			PSWCNTRL sc = &(SwBlock->aswentry[li].swctl);
			/* s͑Is^XN  XLbv */
			if( sc->uchVisibility!=SWL_VISIBLE ) continue;
			if( sc->fbJump!=SWL_JUMPABLE ) continue;
			/* \^XN^CgݒɍvĂȂmF */
			for( lj = 0 ;lj < IgnTask.cnt ;lj++ ){
				if( !strcmp( IgnTask.buf[lj].str ,sc->szSwtitle ) ) break;
			}
			if( lj < IgnTask.cnt ){
				/* \^XN^Cgݒɍv  XLbv */
				continue;
			}

			if( li==cursor ) Cursor = CntValid; /* J[\ʒu */
			else
			if( li==cancel ) NumCancel = li;  /* 쎞̖߂ */

			BufValid[CntValid++] = li; /* \^XNԍɒǉ */
		}
		if( CntValid ){
			WinSetWindowPos( HwTaskFrame ,HWND_TOP
			 ,TASKW_OFS_X ,TASKW_OFS_Y(CntValid)
			 ,TASKW_SIZ_X ,TASKW_SIZ_Y(CntValid)
			 ,SWP_MOVE|SWP_SIZE|SWP_ZORDER|SWP_SHOW|SWP_ACTIVATE );
			WinSetFocus( HWND_DESKTOP ,HwTaskClient );
			rc = TRUE;
		}
	}

	if(!rc) TASKSW_FreeMem();

	return rc;
}


/* ֐FTASKSW_HIDE */
/* @\@F^XNXCb`EEBhE\ɂ */
/* @Fprm = Ăяo瑗p[^ */
/* ߂lF */
/* l@F^XNXCb`\ɂׂɁAALWALTFX Ăяo */
/* @@@Fi\ł͂ȂꍇłAĂяo\j */
/* @@@F̊֐́AK`Ȃ΂ȂȂ */
VOID EXPENTRY TASKSW_HIDE( const TASKSW_PARAM* prm )
{
	WinShowWindow( HwTaskFrame ,FALSE );
	WinSetWindowPos( HwTaskFrame ,0 ,0,0,0,0 ,SWP_DEACTIVATE );
	TASKSW_FreeMem();
}


/* ֐FTASKSW_ISSHOWING */
/* @\@F^XNXCb`EEBhE\Ă邩ۂԂ */
/* @Fprm = Ăяo瑗p[^ */
/* ߂lF\ TRUEA\ FALSE */
/* l@F^XNXCb`\OȂǂɁAALWALTFX Ăяo */
/* @@@FȂA^XNXCb`\́A^XNXCb`EEBhEg */
/* @@@Fi͎qEBhEjtH[JXĂȂ΂ȂȂ */
/* @@@F܂A^XNXCb`EEBhE̕\\̃gOƁA */
/* @@@FANeBuANeBũgOƂ́AĂȂ΂Ȃ */
/* @@@FAƂłiALWALTFX̓́AOƂĂj */
/* @@@F̊֐́AK`Ȃ΂ȂȂ */
BOOL EXPENTRY TASKSW_ISSHOWING( const TASKSW_PARAM* prm )
{
	return WinIsWindowVisible( HwTaskFrame );
}


/* ֐FTASKSW_DESTROY */
/* @\@F^XNXCb`EEBhEj */
/* @Fprm = Ăяo瑗p[^ */
/* ߂lF */
/* l@FDLLA[hOɈxĂяo */
/* @@@FiTASKSW_CREATE̐ۂɊւ炸AKĂяoj */
/* @@@F̊֐́AK`Ȃ΂ȂȂ */
VOID EXPENTRY TASKSW_DESTROY( const TASKSW_PARAM* prm )
{
	TASKSETTING_Term( prm->hab );
	WinSetAccelTable( prm->hab ,0 ,HwTaskFrame );
	WinDestroyAccelTable( Haccel );
	WinDestroyWindow( HwTaskText );
	WinDestroyWindow( HwTaskFrame );
}


/* ֐FTASKSW_SETTING */
/* @\@F^XNXCb`EEBhEݒp_CAOEEBhE\ */
/* @Fprm = Ăяo瑗p[^ */
/* ߂lFI TRUEAُI FALSE */
/* l@F̊֐́AK`Kv͖ */
BOOL EXPENTRY TASKSW_SETTING( const TASKSW_PARAM* prm )
{
	return WinDlgBox( HWND_DESKTOP ,prm->hwalwaltfx ,TASKSETTING_DlgProc
	 ,prm->hmodule ,ALWATASK_SETTING_MAIN ,0 )!=DID_ERROR;
}


/* ֐FTASKSW_WndProc */
/* @\@F^XNXCb`ENCAgEEBhEEvV[W */
/* @F */
/* ߂lF */
/* l@FEBhEEvV[Wŗv鏈́Aȉ̂R_ł */
/* @@@F@EEBhE̕` */
/* @@@F@E҂̑ɑ΂鉞 */
/* @@@F@E^XN؂ւyєANeBuɃEBhE\ */
MRESULT EXPENTRY TASKSW_WndProc( HWND hwnd ,ULONG msg ,MPARAM mp1 ,MPARAM mp2 )
{
	static SIZEL size;

	switch(msg){
	 case WM_PAINT:
		if(!SwBlock||!BufValid) break; /* mF */
		else{
			int li;
			RECTL rect;
			HPS hps = WinBeginPaint( hwnd ,0 ,0 );
			GpiCreateLogColorTable( hps ,0 ,LCOLF_RGB ,0 ,0 ,0 );
			WinQueryWindowRect( hwnd ,&rect );
			WinFillRect( hps ,&rect ,DlgBkCol );
			rect.xLeft = 0;
			rect.yBottom = 0;
			rect.xRight = size.cx - 1;
			rect.yTop = size.cy - 1;
			TASKSW_Draw3DFrame( hps ,&rect ,1 ,CLR_WHITE ,CLR_DARKGRAY );
			rect.xLeft = FRAME_X;
			rect.yBottom = FRAME_Y;
			rect.xRight = size.cx - 1 - FRAME_X;
			rect.yTop = size.cy - 1 - FRAME_Y;
			TASKSW_Draw3DFrame( hps ,&rect ,1 ,CLR_DARKGRAY ,CLR_WHITE );
			for( li = 0 ;li < CntValid ;li++ ){
				HPOINTER hptr = (HPOINTER)WinSendMsg( SwBlock->aswentry[BufValid[li]].swctl.hwnd ,WM_QUERYICON ,0 ,0 );
				WinDrawPointer( hps ,ICO_LOC_X(li) ,ICO_LOC_Y(CntValid,li) ,hptr?hptr:HptrPgm ,DP_NORMAL );
			}
			TASKSW_DrawCursor(hps,TRUE);
			WinEndPaint(hps);
		}
		return 0;
	 case WM_SIZE:
		size.cx = SHORT1FROMMP(mp2);
		size.cy = SHORT2FROMMP(mp2);
		WinSetWindowPos( HwTaskText ,0 ,FRAME_X+1 ,FRAME_Y+1 ,size.cx-(FRAME_X+1)*2 ,TitleY ,SWP_MOVE|SWP_SIZE );
		break;
	 case WM_CHAR:
		if( (CHARMSG(&msg)->fs&(KC_VIRTUALKEY|KC_KEYUP))==(KC_VIRTUALKEY|KC_KEYUP)
		 && CHARMSG(&msg)->vkey==VK_ALT ){
			/* AltL[  uIvƓ */
			WinSendMsg( hwnd ,WM_COMMAND
			 ,MPFROMSHORT(TASKCMD_SELECT) ,MPFROM2SHORT(CMDSRC_OTHER,FALSE) );
			return (MRESULT)TRUE;
		}
		if(!SwBlock||!BufValid) break; /* mF */
		if( (CHARMSG(&msg)->fs&(KC_SCANCODE|KC_KEYUP))==(KC_SCANCODE) ){
			/* 擪LN^v^XNփJ[\ړ */
			int ncsr = -1;
			int li;
			/* '0'-'9'`FbN */
			for( li = 0 ;li<10 ;li++ ){
				if( CHARMSG(&msg)->scancode==ScanCode_Numeric[li][0]
				 || CHARMSG(&msg)->scancode==ScanCode_Numeric[li][1] ){
					break;
				}
			}
			if(li<10){
				ncsr = TASKSW_CursorFromChar( '0'+li );
			}
			else{
				/* 'A'-'Z'`FbN */
				for( li = 0 ;li<26 ;li++ ){
					if( CHARMSG(&msg)->scancode==ScanCode_Alphabet[li] ){
						break;
					}
				}
				if(li<26){
					ncsr = TASKSW_CursorFromChar( 'A'+li );
				}
			}
			if( ncsr>=0 ){
				TASKSW_SetNewCursor( hwnd ,ncsr );
				return (MRESULT)TRUE;
			}
		}
		break;
	 case WM_BUTTON1CLICK: case WM_BUTTON2CLICK: case WM_BUTTON3CLICK:
	 case WM_BUTTON1DBLCLK: case WM_BUTTON2DBLCLK: case WM_BUTTON3DBLCLK:
		if(SwBlock&&BufValid){ /* mF */
			int ncsr = TASKSW_CursorFromPoint( (PPOINTS)(&mp1) );
			if( ncsr>=0 ){
				BOOL same = (ncsr==Cursor);
				/* }EX{^ꂽʒuփJ[\ړ */
				TASKSW_SetNewCursor( hwnd ,ncsr );
				/* _uNbN͍XɁAuIvs */
				if(same) switch(msg){
				 case WM_BUTTON1DBLCLK: case WM_BUTTON2DBLCLK: case WM_BUTTON3DBLCLK:
					WinSendMsg( hwnd ,WM_COMMAND
					 ,MPFROMSHORT(TASKCMD_SELECT) ,MPFROM2SHORT(CMDSRC_OTHER,FALSE) );
				}
				return (MRESULT)TRUE;
			}
		}
		break;
	 case WM_COMMAND:
		if(SwBlock&&BufValid){ /* mF */
			int ncsr = Cursor;
			switch( COMMANDMSG(&msg)->cmd ){
			 case TASKCMD_SELECT:
				{
					const SWENTRY* swe = &SwBlock->aswentry[BufValid[Cursor]];
					HSWITCH hs = swe->hswitch;
					HWND hw = swe->swctl.hwnd;
					WinSwitchToProgram( hs );
					/* ł́AuBvꂽEBhE\Ȃ̂ŁA */
					WinShowWindow( hw ,TRUE );
				}
				TASKSW_HIDE((TASKSW_PARAM*)NULL);
				break;
			 case TASKCMD_CANCEL:
				if( NumCancel>=0 ){
					ULONG style = WinQueryWindowULong( SwBlock->aswentry[NumCancel].swctl.hwnd ,QWL_STYLE );
					if( (style&WS_VISIBLE) && !(style&WS_MINIMIZED) ){
						/* uv悪\Ăꍇ̂݁A^XN؂ւ */
						WinSwitchToProgram( SwBlock->aswentry[NumCancel].hswitch );
					}
				}
				TASKSW_HIDE((TASKSW_PARAM*)NULL);
				break;
			 case TASKCMD_UP:
				if( (ncsr-=TASKW_ENUM_X)<0 ){
					if( (ncsr+=TASKW_ENUM_X*((CntValid-1)/TASKW_ENUM_X+1))>=CntValid ){
						ncsr = CntValid-1;
					}
				}
				break;
			 case TASKCMD_DOWN:
				if( (ncsr+=TASKW_ENUM_X)>=CntValid ){
					if( (ncsr-=TASKW_ENUM_X*((CntValid-1)/TASKW_ENUM_X+1))<0 ){
						ncsr = CntValid-1;
					}
				}
				break;
			 case TASKCMD_LEFT:
				if( (--ncsr)<0 ) ncsr = CntValid-1;
				break;
			 case TASKCMD_RIGHT:
				if( (++ncsr)>=CntValid ) ncsr = 0;
				break;
			}
			if( Cursor!=ncsr ){
				TASKSW_SetNewCursor( hwnd ,ncsr );
			}
		}
		break;
	 case WM_ACTIVATE:
		if( !SHORT1FROMMP(mp1) ){
			/* ANeBuŁAEBhE\ɂȂ΂ȂȂ */
			/* iR͑OL֐ TASKSW_ISSHOWING ̃RgQƁj */
			TASKSW_HIDE((TASKSW_PARAM*)NULL);
#if !MAKE_DLL
			/* fobOpR[hBANeBu玩I */
			WinPostMsg( hwnd ,WM_QUIT ,0 ,0 );
#endif
		}
		break;
	}
	return WinDefWindowProc( hwnd ,msg ,mp1 ,mp2 );
}


/* ֐FTASKSW_AllocMem */
/* @\@F^XNXCb`pƗp̊蓖 */
/* @FQނ̃obt@ɊUׂTCY */
/* ߂lFI TRUEAُI FALSE */
/* l@F */
static BOOL TASKSW_AllocMem( ULONG ssiz ,ULONG vsiz )
{
	BOOL rc;

	TASKSW_FreeMem(); /* Ô߁AU */
	rc = !DosAllocMem( (PPVOID)&SwBlock ,ssiz ,PAG_COMMIT|PAG_READ|PAG_WRITE )
	  && !DosAllocMem( (PPVOID)&BufValid ,vsiz ,PAG_COMMIT|PAG_READ|PAG_WRITE );
	if(!rc) TASKSW_FreeMem();

	return rc;
}


/* ֐FTASKSW_FreeMem */
/* @\@F^XNXCb`pƗp̉ */
/* @F */
/* ߂lF */
/* l@F */
static void TASKSW_FreeMem(void)
{
	DosFreeMem( SwBlock ); SwBlock = 0;
	DosFreeMem( BufValid ); BufValid = 0;
}


/* ֐FTASKSW_CursorFromChar */
/* @\@F^XN̐擪LN^v^XÑJ[\ʒuԂ */
/* @Fchr = 擪L(ASCII) */
/* ߂lFJ[\ʒu -1iȃLj */
/* l@F݂̃J[\ʒu̎̃^XN珇Ɍ */
static int TASKSW_CursorFromChar( UCHAR chr )
{
	int rc = -1;
	int ncsr = Cursor;
	int li;
	for( li = 0 ;li < CntValid ;li++ ){
		if(li!=0){
			UCHAR topc = SwBlock->aswentry[BufValid[ncsr]].swctl.szSwtitle[0];
			if( topc==chr || topc==(chr|0x20) ) break;
		}
		if( (++ncsr)>=CntValid ) ncsr = 0;
	}
	if( li < CntValid ){
		rc = ncsr;
	}
	return rc;
}


/* ֐FTASKSW_CursorFromPoint */
/* @\@Fw肳ꂽWɂJ[\ʒuԂ */
/* @Fptr = |C^[ʒuf[^̃|C^ */
/* ߂lFJ[\ʒu -1iȍWj */
/* l@F */
static int TASKSW_CursorFromPoint( PPOINTS ptr )
{
	int rc = -1;
	int lx;

	for( lx = 0 ;lx < TASKW_ENUM_X ;lx++ ){
		if( CSR_LEFT(lx) <= ptr->x && ptr->x <= CSR_RIGHT(lx) ){
			int ly;
			for( ly = 0 ;ly < CntValid ;ly+=TASKW_ENUM_X ){
				if( CSR_BOTTOM(CntValid,ly) <= ptr->y && ptr->y <= CSR_TOP(CntValid,ly) ){
					int nc = ly + lx;
					if( nc < CntValid ){ rc = nc; }
					break;
				}
			}
			break;
		}
	}

	return rc;
}


/* ֐FTASKSW_SetNewCursor */
/* @\@FJ[\ʒu̍XV */
/* @Fhwnd = EBhEEnh */
/* ߂lF */
/* l@F */
static void TASKSW_SetNewCursor( HWND hwnd ,int ncsr )
{
	HPS hps = WinGetPS(hwnd);
	GpiCreateLogColorTable( hps ,0 ,LCOLF_RGB ,0 ,0 ,0 );
	if( Cursor != ncsr ){
		TASKSW_DrawCursor( hps ,FALSE );
		Cursor = ncsr;
	}
	TASKSW_DrawCursor( hps ,TRUE );
	WinReleasePS(hps);
}


/* ֐FTASKSW_DrawCursor */
/* @\@F^XNXCb`̃J[\` */
/* @Fhps = \ԃnh */
/* @@@Fflg = `tOiTRUE=\AFALSE=\j */
/* ߂lF */
/* l@F */
static void TASKSW_DrawCursor( HPS hps ,BOOL flg )
{
	RECTL rect;


	rect.xLeft = CSR_LEFT(Cursor);
	rect.yBottom = CSR_BOTTOM(CntValid,Cursor);
	rect.xRight = CSR_RIGHT(Cursor);
	rect.yTop = CSR_TOP(CntValid,Cursor);

	if(!flg){
		TASKSW_Draw3DFrame( hps ,&rect ,2 ,DlgBkCol ,DlgBkCol );
	}
	else{
		TASKSW_Draw3DFrame( hps ,&rect ,2 ,CLR_DARKGRAY ,CLR_WHITE );
		WinSetWindowText( HwTaskText ,SwBlock->aswentry[BufValid[Cursor]].swctl.szSwtitle );
	}
}


/* ֐FTASKSW_Draw3DFrame */
/* @\@FR`̕` */
/* @Fhps = \ԃnh */
/* @@@Frect = `W */
/* @@@Fwidth =   */
/* @@@Fcol1 = я̐̐F */
/* @@@Fcol2 = Eщ̐̐F */
/* ߂lF */
/* l@F */
static void TASKSW_Draw3DFrame( HPS hps ,PRECTL rect ,int width ,LONG col1 ,LONG col2 )
{
	int li;
	POINTL p[4];

	p[0].x = rect->xLeft;	p[0].y = rect->yTop;	/*  */
	p[1].x = rect->xRight;	p[1].y = rect->yTop;	/* E */
	p[2].x = rect->xRight;	p[2].y = rect->yBottom;	/* E */
	p[3].x = rect->xLeft;	p[3].y = rect->yBottom;	/*  */

	for( li = 0 ;li < width ;li++ ){
		GpiMove( hps ,&p[3] );
		GpiSetColor( hps ,col1 );
		GpiPolyLine( hps ,2 ,&p[0] );
		GpiSetColor( hps ,col2 );
		GpiPolyLine( hps ,2 ,&p[2] );

		p[0].x++; p[0].y--;	/*  */
		p[1].x--; p[1].y--;	/* E */
		p[2].x--; p[2].y++;	/* E */
		p[3].x++; p[3].y++;	/*  */
	}
}

