/******************************************************************************
/*
/* NAME: DIFINST.GML
/*
/* FUNCTION: Panel Definitions for XGA DIF Installation Program.
/*
/* CHANGE HISTORY:
/*
/*   20Nov91 KJE - Created
/*
/******************************************************************************

/******************************************************************************
/*
/* String Resource Definitions
/*
/******************************************************************************
<DEFINE, ID=YES>Yes
<DEFINE, ID=NO>No

/******************************************************************************
/*
/* Panel Definitions
/*
/******************************************************************************

/******************************************************************************
/* INSTALL_MAIN
/******************************************************************************
<PANEL,ID=INSTALL_MAIN, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program
<TEXT, ROW=5, COL=CENTER>Main Menu

<TEXT, ROW=7, COL=3>Please, choose one of the following options:
<TEXT, ROW=8, COL=3>

<SELLIST, PROMPT=BEFORE, VARID=0, AUTOSEL=ON>
   <SELITEM, ROW=11, COL=12, SPACE=1, SELVALUE=0, HELP=INSTALL_HELP>
      Install all XGA DMQS Display Information Files.
   <SELITEM, ROW=13, COL=12, SPACE=1, SELVALUE=1, HELP=SPECIFIC_INSTALL_HELP>
      Install specific XGA DMQS Display Information File(s).
   <SELITEM, ROW=15, COL=12, SPACE=1, SELVALUE=2, HELP=CHANGE_XGA_PROFILE_HELP>
      Change XGA Display Configuration Profile.
<\SELLIST>

<TEXT, ROW=18, COL=CENTER>Use the UP and DOWN cursor keys to select item.

<FKEYS>
   <ENTER>Enter=Continue
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_INSTALL_PANEL
/******************************************************************************
<PANEL,ID=DIF_INSTALL_PANEL, TRACE=OFF>
<HELP, ID=DIF_INSTALL_PANEL_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
INSTALL ALL DISPLAY INFORMATION FILES:
<TEXT, ROW=8, COL=3>

<TEXT, ROW=10, COL=3>
Please ensure that the XGA Display Information Files are available on the
<TEXT, ROW=11, COL=3>
source drive specified below. Press the Enter key to continue:

<PROMPT,
   ROW=13,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=0,
   VARLEN=1,
   DEFAULT=A,
   DATATYPE=ALPHA
>
Source disk drive to copy from.....

<PROMPT,
   ROW=14,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=1,
   VARLEN=40,
   DEFAULT=\
>
Source directory to copy from......

<PROMPT,
   ROW=16,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=2,
   VARLEN=1,
   DEFAULT=C,
   DATATYPE=ALPHA
>
Destination disk drive to copy to..

<PROMPT,
   ROW=17,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=3,
   VARLEN=40,
   DEFAULT=\XGA$DMQS
>
Destination directory to copy to...

<FKEYS>
   <ENTER>Enter=Continue
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_REINSTALL_PANEL
/******************************************************************************
<PANEL,ID=DIF_REINSTALL_PANEL, TRACE=OFF>
<HELP, ID=DIF_REINSTALL_PANEL_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
RE-INSTALL ALL DISPLAY INFORMATION FILES:
<TEXT, ROW=8, COL=3>

<TEXT, ROW=10, COL=3>
The Display Information Files have already been installed on your system.
<TEXT, ROW=11, COL=3>
However, you may continue with this installation if you wish to re-install
<TEXT, ROW=12, COL=3>
ALL of the Display Information files. Please ensure that the XGA Display
<TEXT, ROW=13, COL=3>
Information Files are available on the source drive specified below.

<PROMPT,
   ROW=15,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=0,
   VARLEN=1,
   DEFAULT=A,
   DATATYPE=ALPHA
>
Source disk drive to copy from.....

<PROMPT,
   ROW=16,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=1,
   VARLEN=40,
   DEFAULT=\
>
Source directory to copy from......

<PROMPT,
   ROW=18,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=2,
   VARLEN=1,
   DEFAULT=C,
   DATATYPE=ALPHA
>
Destination disk drive to copy to..

<PROMPT,
   ROW=19,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=3,
   VARLEN=40,
>
Destination directory to copy to...

<FKEYS>
   <ENTER>Enter=Continue
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_SPECIFIC_INSTALL_PANEL
/******************************************************************************
<PANEL,ID=DIF_SPECIFIC_INSTALL_PANEL, TRACE=OFF>
<HELP, ID=DIF_SPECIFIC_INSTALL_PANEL_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
INSTALL SPECIFIC DISPLAY INFORMATION FILES:
<TEXT, ROW=8, COL=3>

<TEXT, ROW=10, COL=3>
Please ensure that the Specific XGA Display Information Files are available
<TEXT, ROW=11, COL=3>
on the source drive specified below. Press the Enter key to continue:

<PROMPT,
   ROW=13,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=0,
   VARLEN=1,
   DEFAULT=A,
   DATATYPE=ALPHA
>
Source disk drive to copy from.....

<PROMPT,
   ROW=14,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=1,
   VARLEN=40,
   DEFAULT=\
>
Source directory to copy from......

<PROMPT,
   ROW=16,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=1,
   VARID=2,
   VARLEN=1,
   DEFAULT=C,
   DATATYPE=ALPHA
>
Destination disk drive to copy to..

<PROMPT,
   ROW=17,
   COL=10,
   PROMPT=AFTER,
   SPACE=0,
   PROMPTLEN=25,
   VARID=3,
   VARLEN=40,
   DEFAULT=\XGA$DMQS
>
Destination directory to copy to...

<FKEYS>
   <ENTER>Enter=Continue
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CREATE_DMQS_PROFILE
/******************************************************************************
<PANEL,ID=CHANGE_XGA_PROFILE, TRACE=OFF>
<HELP, ID=CHANGE_XGA_PROFILE_SPECIFIC_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=6, COL=1>
CHANGE XGA DMQS DISPLAY CONFIGURATION PROFILE:
<TEXT, ROW=7, COL=1>


<TEXT, ROW=8, COL=1>
Start  XGA
<TEXT, ROW=9, COL=1>
Up     Slot  Display Type
<TEXT, ROW=10, COL=1>
    

/******************************************************************************
/* Selection list to select available XGAs from. Each item will be enabled
/* only if there is a corresponding XGA adapter card available to be selected.
/* The selection items will be enabled top down, from lowest XGA slot number
/* to highest XGA slot number.
/******************************************************************************
<SELLIST, PROMPT=BEFORE, VARID=0, CURSORID=1, DISABLEID=2, AUTOSEL=ON>
   <SELITEM, ROW=11, COL=2, SELVALUE=0, DISABLEINDEX=0>
   <SELITEM, ROW=12, COL=2, SELVALUE=1, DISABLEINDEX=1>
   <SELITEM, ROW=13, COL=2, SELVALUE=2, DISABLEINDEX=2>
   <SELITEM, ROW=14, COL=2, SELVALUE=3, DISABLEINDEX=3>
   <SELITEM, ROW=15, COL=2, SELVALUE=4, DISABLEINDEX=4>
   <SELITEM, ROW=16, COL=2, SELVALUE=5, DISABLEINDEX=5>
   <SELITEM, ROW=17, COL=2, SELVALUE=6, DISABLEINDEX=6>
   <SELITEM, ROW=18, COL=2, SELVALUE=7, DISABLEINDEX=7>
   <SELITEM, ROW=19, COL=2, SELVALUE=8, DISABLEINDEX=8>
   <SELITEM, ROW=20, COL=2, SELVALUE=9, DISABLEINDEX=9>
<\SELLIST>

/******************************************************************************
/* Static list box for Slot Number List.
/******************************************************************************
<LIST,
   TYPE=STATIC,
   ROW=10,
   COL=8,
   DEPTH=10,
   LENGTH=2,
   VARID=3,
   SELID=4,
   BORDER=OFF
>

/******************************************************************************
/* Static list box for Display Description Text List chosen for corrsponding
/* XGA adapter card(s).
/******************************************************************************
<LIST,
   TYPE=STATIC,
   ROW=10,
   COL=13,
   DEPTH=10,
   LENGTH=65,
   VARID=5,
   SELID=6,
   BORDER=OFF
>

<TEXT, ROW=23, COL=2>
Use UP and DOWN cursor keys to select XGA.

<FKEYS>
   <ENTER>Enter=Accept Setup
   <F1>F1=Help
   <F2>F2=Change Display Type
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CREATE_DMQS_PROFILE
/******************************************************************************
<PANEL,ID=CHANGE_DISPLAY_TYPE, TRACE=OFF>
<HELP, ID=CHANGE_DISPLAY_TYPE_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=6, COL=1>
CHANGE DISPLAY TYPE FOR XGA IN SLOT
<TEXT, ROW=7, COL=1>


/******************************************************************************
/* Static text field for slot number.
/******************************************************************************
<LIST,
   TYPE=STATIC,
   ROW=5,
   COL=36,
   DEPTH=1,
   LENGTH=2,
   VARID=0,
   SELID=0,
   BORDER=OFF
>

<TEXT, ROW=9, COL=1>
Current display type is:

/******************************************************************************
/* Static text field for Current Display Type description text.
/******************************************************************************
<LIST,
   TYPE=STATIC,
   ROW=9,
   COL=0,
   DEPTH=1,
   LENGTH=79,
   VARID=1,
   SELID=1,
   BORDER=OFF
>

/******************************************************************************
/* List box for available Display Types to select from.
/******************************************************************************
<LIST,
   TYPE=SINGSEL,
   ROW=11,
   COL=1,
   DEPTH=8,
   LENGTH=78,
   VARID=2,
   SELID=3,
   BORDER=ON
>

<TEXT, ROW=21, COL=2>
Use UP/DOWN cursor keys to choose different display type.

<TEXT, ROW=22, COL=2>
Press alpha/numeric key to move to item beginning with key typed.

<TEXT, ROW=23, COL=2>
Press Enter key to select display type highlighted.

<FKEYS>
   <ENTER>Enter=Select Display Type
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CREATE_DIRECTORY_PROMPT
/******************************************************************************
<PANEL,ID=CREATE_DIRECTORY_PROMPT, TRACE=OFF>

<PROMPT,
   ROW=22,
   COL=1,
   PROMPT=BEFORE,
   SPACE=0,
   PROMPTLEN=1,
   VARID=0,
   VARLEN=1,
   DEFAULT=Y
>

<TEXT, ROW=22, COL=5, VARSUB=1>
Create directory? (%s)

<FKEYS>
   <ENTER>Enter=Continue
   <F3>F3=Cancel
<\FKEYS>
<\PANEL>

/******************************************************************************
/* OVERWRITE_FILE_PROMPT
/******************************************************************************
<PANEL,ID=OVERWRITE_FILE_PROMPT, TRACE=OFF>

<PROMPT,
   ROW=22,
   COL=1,
   PROMPT=BEFORE,
   SPACE=0,
   PROMPTLEN=1,
   VARID=0,
   VARLEN=1,
   DEFAULT=Y
>

<TEXT, ROW=22, COL=5, VARSUB=1>
Over-write? (%s)

<FKEYS>
   <ENTER>Enter=Continue
   <F3>F3=Cancel
<\FKEYS>

<\PANEL>

/******************************************************************************
/*
/* Help Panel Definitions
/*
/******************************************************************************

/******************************************************************************
/* INSTALL_KEYS_HELP
/******************************************************************************
<PANEL, ID=INSTALL_KEYS_HELP, TRACE=OFF>
<TEXT, ROW=2, COL=3>
KEY DEFINITIONS HELP:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=6>
General Keys:
<TEXT, ROW=7, COL=9>
Esc - Exit the panel (always available).
<TEXT, ROW=8, COL=9>
UP-ARROW or SHIFT/TAB - Move to the previous field.
<TEXT, ROW=9, COL=9>
DOWN-ARROW or TAB - Move to the next field.

<TEXT, ROW=11, COL=6>
Data Entry Prompts:
<TEXT, ROW=13, COL=9>
RIGHT-ARROW - Move to the next character.
<TEXT, ROW=14, COL=9>
LEFT-ARROW - Move to the previous character.
<TEXT, ROW=15, COL=9>
DEL - Delete character over cursor.
<TEXT, ROW=16, COL=9>
BACKSPACE - Delete character to left of cursor.
<TEXT, ROW=17, COL=9>
HOME - Move the cursor to the beginning of the prompt.
<TEXT, ROW=18, COL=9>
END - Move the cursor to the end of the prompt.

<FKEYS>
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* INSTALL_MAIN_HELP
/******************************************************************************
<PANEL, ID=INSTALL_MAIN_HELP, TRACE=OFF>
<HELP, ID=INSTALL_KEYS_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
XGA DMQS Display Information File Installation General Help:
<TEXT, ROW=8, COL=3>


<TEXT, ROW=10, COL=4>
This utility will install the DMQS (Display Mode Query/Set) Display
<TEXT, ROW=11, COL=4>
Information Files onto your system so that any programs that use the DMQS
<TEXT, ROW=12, COL=4>
Services on your system will be able to obtain the needed information about
<TEXT, ROW=13, COL=4>
any display that you may have attached to an XGA adapter card.

<TEXT, ROW=15, COL=4>
This utility will allow you to install all Display Information Files or a
<TEXT, ROW=16, COL=4>
partial set of Display Information Files on your system. Additionally,
<TEXT, ROW=17, COL=4>
should you need to upgrade to a newer version of Display Information Files,
<TEXT, ROW=18, COL=4>
you can choose to re-install the full set of Display Information Files.

<FKEYS>
   <F1>F1=Key definitions help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* INSTALL_HELP
/******************************************************************************
<PANEL,ID=INSTALL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Install all XGA Display Information Files:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option will install all the Display Information Files available for
<TEXT, ROW=6, COL=3>
the XGA display adapter.

<TEXT, ROW=8, COL=3>
NOTE: You can install the XGA Display Information Files on a system which
<TEXT, ROW=9, COL=3>
does not support DMQS. However, if you do not have hardware that supports
<TEXT, ROW=10, COL=3>
DMQS, then you will not be able to use any DMQS supporting services (i.e.
<TEXT, ROW=11, COL=3>
Device Drivers that utilize DMQS to initialize XGA hardware).

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* INSTALL_EXIT_HELP
/******************************************************************************
<PANEL,ID=INSTALL_EXIT_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
The Display Information Files have been successfully installed onto your
<TEXT, ROW=8, COL=3>
system. Additionally, your AUTOEXEC.BAT file has been updated to
<TEXT, ROW=9, COL=3>
reflect the proper path to locate these Display Information Files.

<TEXT, ROW=11, COL=3>
If the AUTOEXEC.BAT file did not exist before, then it has been created
<TEXT, ROW=12, COL=3>
and placed in the root of your C: drive.

<TEXT, ROW=14, COL=3>
Once you have exited this installation program, please restart your
<TEXT, ROW=15, COL=3>
computer system in order for the environment settings on your system to
<TEXT, ROW=16, COL=3>
correctly reflect the location of the Display Information Files that
<TEXT, ROW=17, COL=3>
have just been installed.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* REINSTALL_HELP
/******************************************************************************
<PANEL,ID=REINSTALL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Re-Install all XGA Display Information Files:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option will re-install all the display files available for the XGA
<TEXT, ROW=6, COL=3>
onto your system under the path specified by the DMQSPATH environment
<TEXT, ROW=7, COL=3>
variable.
<TEXT, ROW=8, COL=3>
Any files from your old DMQS Installation with the same name as the new
<TEXT, ROW=9, COL=3>
display files will be over-written. Also, there may be some additional
<TEXT, ROW=10, COL=3>
XGA Display Information Files added to your system.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* REINSTALL_EXIT_HELP
/******************************************************************************
<PANEL,ID=REINSTALL_EXIT_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
The Display Information Files have been successfully re-installed onto
<TEXT, ROW=8, COL=3>
your system. Additionally, your AUTOEXEC.BAT file has been updated to
<TEXT, ROW=9, COL=3>
reflect the proper path to locate these Display Information Files.

<TEXT, ROW=11, COL=3>
If the AUTOEXEC.BAT file did not exist before, then it has been created
<TEXT, ROW=12, COL=3>
and placed in the root of your C: drive.

<TEXT, ROW=14, COL=3>
Once you have exited this installation program, please restart your
<TEXT, ROW=15, COL=3>
computer system in order for the environment settings on your system to
<TEXT, ROW=16, COL=3>
correctly reflect the location of the Display Information Files that
<TEXT, ROW=17, COL=3>
have just been installed.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* SPECIFIC_INSTALL_HELP
/******************************************************************************
<PANEL,ID=SPECIFIC_INSTALL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Install specific XGA Display Information File(s):
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option will install specific, non-packed, Display Information Files
<TEXT, ROW=6, COL=3>
that you provide on a supplied diskette.

<TEXT, ROW=8, COL=3>
If you have installed any Display Information Files before, the new files
<TEXT, ROW=9, COL=3>
will be copied into the same directory as before, unless you wish to override
<TEXT, ROW=10, COL=3>
the current DMQSPATH setting. Otherwise, if no Display Information Files have
<TEXT, ROW=11, COL=3>
been installed before, you will be asked to create a new directory that will
<TEXT, ROW=12, COL=3>
contain these specific Display Information Files.

<TEXT, ROW=14, COL=3>
Also, if any of the specific files that you are installing match those from
<TEXT, ROW=15, COL=3>
a previous installation, then the old files shall be over-written.

<TEXT, ROW=17, COL=3>
NOTE: You can install the XGA Display Information Files on a system which
<TEXT, ROW=18, COL=3>
does not support DMQS. However, if you do not have hardware that supports
<TEXT, ROW=19, COL=3>
DMQS, then you will not be able to use any DMQS supporting services (i.e.
<TEXT, ROW=20, COL=3>
Device Drivers that utilize DMQS to initialize XGA hardware).

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* SPECIFIC_INSTALL_EXIT_HELP
/******************************************************************************
<PANEL,ID=SPECIFIC_INSTALL_EXIT_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>
<TEXT, ROW=1, COL=CENTER>XGA
<TEXT, ROW=2, COL=CENTER>DMQS (Display Mode Query/Set)
<TEXT, ROW=3, COL=CENTER>Display Information File
<TEXT, ROW=4, COL=CENTER>Installation Program

<TEXT, ROW=7, COL=3>
The Specific Display Information Files have been successfully installed
<TEXT, ROW=8, COL=3>
onto your system. Additionally, your AUTOEXEC.BAT file has been updated
<TEXT, ROW=9, COL=3>
to reflect the proper path to locate these Display Information Files.

<TEXT, ROW=11, COL=3>
If the AUTOEXEC.BAT file mentioned above did not exist before, then it has
<TEXT, ROW=12, COL=3>
been created and placed in the root of your C: drive.

<TEXT, ROW=14, COL=3>
Once you have exited this installation program, please restart your
<TEXT, ROW=15, COL=3>
computer system in order for the environment settings on your system to
<TEXT, ROW=16, COL=3>
correctly reflect the location of the Display Information Files that
<TEXT, ROW=17, COL=3>
have just been installed.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_INSTALL_PANEL_HELP
/******************************************************************************
<PANEL, ID=DIF_INSTALL_PANEL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Install all Display Information Files:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
The "Install all Display Information Files" option allows you to place
<TEXT, ROW=6, COL=3>
information about all displays that can be attached to your XGA display
<TEXT, ROW=7, COL=3>
adapter card onto your computer system. This information is in the form
<TEXT, ROW=8, COL=3>
of Display Information Files. These Display Information Files will provide
<TEXT, ROW=9, COL=3>
programs the ability to identify and best utilize any compatible display
<TEXT, ROW=10, COL=3>
that may be attached to your XGA display adapter.

<TEXT, ROW=12, COL=3>
SOURCE DISK DRIVE TO COPY FROM:
<TEXT, ROW=13, COL=6>
The disk drive containing the Display Information Packed File.

<TEXT, ROW=15, COL=3>
SOURCE DIRECTORY TO COPY FROM:
<TEXT, ROW=16, COL=6>
The path where the Display Information Files are copied from.

<TEXT, ROW=18, COL=3>
DESTINATION DISK DRIVE TO COPY TO:
<TEXT, ROW=19, COL=6>
The drive that you wish to install Display Information Files on.

<TEXT, ROW=21, COL=3>
DESTINATION DIRECTORY TO COPY TO:
<TEXT, ROW=22, COL=6>
The path where the Display Information Files are copied to.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_REINSTALL_PANEL_HELP
/******************************************************************************
<PANEL, ID=DIF_REINSTALL_PANEL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Re-Install all Display Information Files:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
The "Re-Install all Display Information Files" option allows you to update
<TEXT, ROW=6, COL=3>
the Display Information Files currently installed on your computer. This
<TEXT, ROW=7, COL=3>
re-installation process will place the Display Information Files in the
<TEXT, ROW=8, COL=3>
directory specified by the DMQSPATH environment variable. However, you can
<TEXT, ROW=9, COL=3>
override the destination by entering a different destination drive and path.
<TEXT, ROW=10, COL=3>
Any Display Information Files installed on your current system will be
<TEXT, ROW=11, COL=3>
over-written if you decide to re-install under the same directory.

<TEXT, ROW=13, COL=3>
SOURCE DISK DRIVE TO COPY FROM:
<TEXT, ROW=14, COL=6>
The disk drive containing the Display Information Packed File.

<TEXT, ROW=16, COL=3>
SOURCE DIRECTORY TO COPY FROM:
<TEXT, ROW=17, COL=6>
The path where the Display Information Files are copied from.

<TEXT, ROW=19, COL=3>
DESTINATION DISK DRIVE TO COPY TO:
<TEXT, ROW=20, COL=6>
The drive that you wish to install Display Information Files on.

<TEXT, ROW=22, COL=3>
DESTINATION DIRECTORY TO COPY TO:
<TEXT, ROW=23, COL=6>
The path where the Display Information Files are copied to.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* DIF_SPECIFIC_INSTALL_PANEL_HELP
/******************************************************************************
<PANEL, ID=DIF_SPECIFIC_INSTALL_PANEL_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Install Specific Display Information Files:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option will install specific, non-packed, Display Information Files
<TEXT, ROW=6, COL=3>
that you provide on a supplied diskette.

<TEXT, ROW=8, COL=3>
SOURCE DISK DRIVE TO COPY FROM:
<TEXT, ROW=9, COL=6>
The disk drive containing the non-packed Display Information File(s).

<TEXT, ROW=11, COL=3>
SOURCE DIRECTORY TO COPY FROM:
<TEXT, ROW=12, COL=6>
The path where the Display Information Files are copied from.

<TEXT, ROW=14, COL=3>
DESTINATION DISK DRIVE TO COPY TO:
<TEXT, ROW=15, COL=6>
The drive that you wish to install Display Information Files on.

<TEXT, ROW=17, COL=3>
DESTINATION DIRECTORY TO COPY TO:
<TEXT, ROW=18, COL=6>
The path where the Display Information Files are copied to.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CHANGE_XGA_PROFILE_HELP
/******************************************************************************
<PANEL, ID=CHANGE_XGA_PROFILE_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Change XGA Display Configuration Profile:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option allows you to override your XGA Display configuration. If you
<TEXT, ROW=6, COL=3>
do not create a configuration profile for the DMQS services, then the
<TEXT, ROW=7, COL=3>
default display type and display startup will be used based upon the POST
<TEXT, ROW=8, COL=3>
(Power On Self Test) initialization of your system. However, you can
<TEXT, ROW=9, COL=3>
override the system startup values via this "Change XGA Display
<TEXT, ROW=10, COL=3>
Configuration Profile" option.

<TEXT, ROW=12, COL=3>
NOTE: You can install the XGA Display Information Files on a system which
<TEXT, ROW=13, COL=3>
does not support DMQS. However, if you do not have hardware that supports
<TEXT, ROW=14, COL=3>
DMQS, then you will not be able to use any DMQS supporting services (i.e.
<TEXT, ROW=15, COL=3>
Device Drivers that utilize DMQS to initialize XGA hardware).

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CHANGE_XGA_PROFILE_SPECIFIC_HELP
/******************************************************************************
<PANEL, ID=CHANGE_XGA_PROFILE_SPECIFIC_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Change XGA Display Configuration Profile:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This option provides a way to set the configuration of the XGA/Display
<TEXT, ROW=6, COL=3>
environment found on your system. With this option you can specify the
<TEXT, ROW=7, COL=3>
following:

<TEXT, ROW=9, COL=3>
o STARTUP SLOT - This specifies which adapter to use when a graphics
<TEXT, ROW=10, COL=5>
application using DMQS services is running on an XGA equipped system.
<TEXT, ROW=12, COL=5>
NOTE: This option is intended to be used in a multiple XGA environment.
<TEXT, ROW=13, COL=11>
Otherwise, with a single XGA equipped system the single XGA will
<TEXT, ROW=14, COL=11>
always be selected as the startup slot.

<TEXT, ROW=16, COL=3>
o DISPLAY TYPE - This specifies what type of display is attached to the XGA
<TEXT, ROW=17, COL=5>
  adapter card in the slot specified.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/* CHANGE_DISPLAY_TYPE_HELP
/******************************************************************************
<PANEL, ID=CHANGE_DISPLAY_TYPE_HELP, TRACE=OFF>
<HELP, ID=INSTALL_MAIN_HELP>

<TEXT, ROW=2, COL=3>
Change Display Type for XGA:
<TEXT, ROW=3, COL=3>


<TEXT, ROW=5, COL=3>
This panel allows you to select the display type that you want to assign to
<TEXT, ROW=6, COL=3>
the XGA adapter in the slot number specified. This display type that you
<TEXT, ROW=7, COL=3>
choose will be used by the graphics application which uses DMQS services
<TEXT, ROW=8, COL=3>
in order to initialize the XGA adapter and provided you with the correct
<TEXT, ROW=9, COL=3>
mode settings (Resolution, Interlaced/Non-Interlaced, Frequency, etc...)
<TEXT, ROW=10, COL=3>
for the display which is attached to the XGA adapter card.

<FKEYS>
   <F1>F1=Help
   <F3>F3=Exit
<\FKEYS>
<\PANEL>

/******************************************************************************
/*
/* Message Definitions
/*
/******************************************************************************

/******************************************************************************
/* SOURCE_DISK_NOT_VALID
/******************************************************************************
<PANEL, ID=SOURCE_DISK_NOT_VALID, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Source disk drive is not valid.
<\PANEL>

/******************************************************************************
/* DEST_DISK_NOT_AVAIL
/******************************************************************************
<PANEL, ID=DEST_DISK_NOT_AVAIL, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Destination disk drive is not valid.
<\PANEL>

/******************************************************************************
/* SOURCE_DEST_CONFLICT
/******************************************************************************
<PANEL, ID=SOURCE_DEST_CONFLICT, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Source/Destination drive and path can not be the same.
<\PANEL>

/******************************************************************************
/* SOURCE_PATH_INVALID
/******************************************************************************
<PANEL, ID=SOURCE_PATH_INVALID, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Source directory is not valid.
<\PANEL>

/******************************************************************************
/* DEST_PATH_INVALID
/******************************************************************************
<PANEL, ID=DEST_PATH_INVALID, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Destination directory is not valid.
<\PANEL>

/******************************************************************************
/* PATH_NOT_FOUND
/******************************************************************************
<PANEL, ID=PATH_NOT_FOUND, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
WARNING: Destination directory does not exist.
<\PANEL>

/******************************************************************************
/* COULD_NOT_CREATE_DIR
/******************************************************************************
<PANEL, ID=COULD_NOT_CREATE_DIR, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
SEVERE ERROR: Could not create directory %s
<\PANEL>

/******************************************************************************
/* COULD_NOT_FIND_DIF
/******************************************************************************
<PANEL, ID=COULD_NOT_FIND_DIF, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
SEVERE ERROR: Could not find Display Information File %s
<\PANEL>

/******************************************************************************
/* FILE_ALREADY_EXISTS
/******************************************************************************
<PANEL, ID=FILE_ALREADY_EXISTS, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
WARNING: %s already exists.
<\PANEL>

/******************************************************************************
/* LOOKING_FOR_DIF_FILES
/******************************************************************************
<PANEL, ID=LOOKING_FOR_DIF_FILES, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
Looking for Display Information Files on source disk %s.
<\PANEL>

/******************************************************************************
/* COULD_NOT_FIND_ANY_DIFS
/******************************************************************************
<PANEL, ID=COULD_NOT_FIND_ANY_DIFS, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Could not find any Display Information Files to copy.
<\PANEL>

/******************************************************************************
/* COPY_DIF_FAILURE
/******************************************************************************
<PANEL, ID=COPY_DIF_FAILURE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
SEVERE ERROR: Failed during Display Information File copy process.
<\PANEL>

/******************************************************************************
/* COPY_DIF_NOTIFICATION
/******************************************************************************
<PANEL, ID=COPY_DIF_NOTIFICATION, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
Copying Display Information File(s)....
<\PANEL>

/******************************************************************************
/* ERROR_OPENING_FILE
/******************************************************************************
<PANEL, ID=ERROR_OPENING_FILE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
SEVERE ERROR: Could not open file %s
<\PANEL>

/******************************************************************************
/* ERROR_CREATING_FILE
/******************************************************************************
<PANEL, ID=ERROR_CREATING_FILE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
SEVERE ERROR: Could not create file %s
<\PANEL>

/******************************************************************************
/* ERROR_READING_FILE
/******************************************************************************
<PANEL, ID=ERROR_READING_FILE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1, VARSUB=0>
SEVERE ERROR: Failed in reading file %s
<\PANEL>

/******************************************************************************
/* MEMORY_ALLOCATION_ERROR
/******************************************************************************
<PANEL, ID=MEMORY_ALLOCATION_ERROR, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
CRITICAL ERROR: Memory allocation error occurred during installation process.
<\PANEL>

/******************************************************************************
/* UNPACKING_DISPLAY_FILES
/******************************************************************************
<PANEL, ID=UNPACKING_DISPLAY_FILES, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
Unpacking Display Information files...
<\PANEL>

/******************************************************************************
/* UPDATING_SYSTEM_FILES
/******************************************************************************
<PANEL, ID=UPDATING_SYSTEM_FILES, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
Updating system startup files...
<\PANEL>

/******************************************************************************
/* FAILED_TO_UPDATE_SYSTEM_FILES
/******************************************************************************
<PANEL, ID=FAILED_TO_UPDATE_SYSTEM_FILES, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
FATAL ERROR: Failed in updating system startup files.
<\PANEL>

/******************************************************************************
/* NO_DIF_UPDATES_MADE
/******************************************************************************
<PANEL, ID=NO_DIF_UPDATES_MADE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
WARNING: No Display Information Files have been updated.
<\PANEL>

/******************************************************************************
/* READING_DMQS_SYSTEM_CONFIGURATION
/******************************************************************************
<PANEL, ID=READING_DMQS_SYSTEM_CONFIGURATION, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
Reading DMQS system configuration, please wait...
<\PANEL>

/******************************************************************************
/* READ_DMQS_CONFIGURATION_FAILED
/******************************************************************************
<PANEL, ID=READ_DMQS_CONFIGURATION_FAILED, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Failed to read DMQS information, please check your DMQS configuration.
<\PANEL>

/******************************************************************************
/* DMQS_NOT_SUPPORTED_WARNING
/******************************************************************************
<PANEL, ID=DMQS_NOT_SUPPORTED_WARNING, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
WARNING: DMQS not supported on system, however you may continue installation.
<\PANEL>

/******************************************************************************
/* DMQS_NOT_SUPPORTED_ERROR
/******************************************************************************
<PANEL, ID=DMQS_NOT_SUPPORTED_ERROR, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: DMQS not supported on system, can not configure XGA hardware.
<\PANEL>

/******************************************************************************
/* DIF_FILES_NOT_FOUND
/******************************************************************************
<PANEL, ID=DIF_FILES_NOT_FOUND, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: No DMQS path is set specifying where DIF files are.
<\PANEL>

/******************************************************************************
/* PROFILE_CREATION_ERROR
/******************************************************************************
<PANEL, ID=PROFILE_CREATION_ERROR, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
SEVERE ERROR: Could not create XGA configuration profile.
<\PANEL>

/******************************************************************************
/* DRIVE_WRITE_PROTECTED_WITH_PAUSE
/******************************************************************************
<PANEL, ID=DRIVE_WRITE_PROTECTED_WITH_PAUSE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Drive specified is write protected, press any key to continue...
<\PANEL>

/******************************************************************************
/* DRIVE_NOT_READY_WITH_PAUSE
/******************************************************************************
<PANEL, ID=DRIVE_NOT_READY_WITH_PAUSE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Drive specified is not ready, press any key to continue...
<\PANEL>

/******************************************************************************
/* DISK_WRITE_ERROR_WITH_PAUSE
/******************************************************************************
<PANEL, ID=DISK_WRITE_ERROR_WITH_PAUSE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: Could not write to drive specified, press any key to continue...
<\PANEL>

/******************************************************************************
/* GENERAL_DOS_FAILURE_WITH_PAUSE
/******************************************************************************
<PANEL, ID=GENERAL_DOS_FAILURE_WITH_PAUSE, TRACE=OFF>
<TEXT, ROW=MSGAREA, COL=1>
ERROR: General system failure, press any key to continue...
<\PANEL>
