/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef __UTIL_H__
#define __UTIL_H__

#include "basics.h"

class TextureCache;

#ifdef USE_GLIDE3
typedef struct
{
	float sow;                   /* s texture ordinate (s over w) */
	float tow;                   /* t texture ordinate (t over w) */
} GrTmuVertex;

typedef struct
{
	float x, y;                   /* X, and Y of scrn space */
	float z;                      /* Z in range [0, 65535] used for clipping */
	float oow;                    /* 1/W (used for W-buffering, texturing) */
	float r, g, b;                /* R, G, B, ([0..255.0]) */
	float a;                      /* Alpha [0..255.0] */
	GrTmuVertex tmuvtx[2];
} GrVertex;

#define GR_VERTEX_X_OFFSET  0
#define GR_VERTEX_Y_OFFSET  1
#define GR_VERTEX_Z_OFFSET  2
#define GR_VERTEX_OOW_OFFSET 3
#define GR_VERTEX_R_OFFSET 4
#define GR_VERTEX_G_OFFSET 5
#define GR_VERTEX_B_OFFSET 6
#define GR_VERTEX_A_OFFSET 7
#define GR_VERTEX_S0_OFFSET 8
#define GR_VERTEX_T0_OFFSET 9
#define GR_VERTEX_S1_OFFSET 10
#define GR_VERTEX_T1_OFFSET 11

#else // USE_GLIDE3

#define GR_VERTEX_S0_OFFSET 9
#define GR_VERTEX_T0_OFFSET 10
#define GR_VERTEX_S1_OFFSET 12
#define GR_VERTEX_T1_OFFSET 13

#endif // USE_GLIDE3

BOOL GlideInitialize();
void GlideCleanup();
void StoreGlideState();
void RestoreGlideState();
int GetNumTMUs();
int GetNumColorBuffers();
TextureCache *GetTexCache(GrChipID_t tmu);
void DrawCursor(int x, int y);
void DrawBackground(float width, float height);
void FadeBackground(float width, float height, float fade);

#include "wintypes.h"


typedef MRESULT APIENTRY PWHFN( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );

extern int g_quit;

void os2_InitializeXWindow( float resolutionX, float resolutionY );
void os2_ShutdownXWindow( void );
void os2_ResizeXWindow( float resolutionX, float resolutionY );

void os2_EventLoop( void );
void os2_ProcessEvent( QMSG qmsg );

void ProcessMouse(int button, int action, int x, int y);
void ProcessKey(int key, int action);

void os2_GetCursorPos( POINTL *mouseCoordinates );
void os2_SetCursorPos(int x, int y);

void os2_SetXWindow( PWHFN *pwhfnThis );

LONG os2_timeGetTime( void );

#endif // __UTIL_H__

