/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	lunix_utils.c
	A file containing fuctions than approximate Win32 'like' functions

	** NOTE **
  		These functions are approximate and do not emulate 
		the entire (or any) functionality of the Win32 functions

	Win32 functions are prefixed with 'linux_<Win32 function name>'
*/

#include <sys/time.h>
#include "wintypes.h"
#include "util.h"
#include "Printerr.h"

HWND hWndMain;
HWND hWndFrame;
HMQ hmq;
HAB hab;
QMSG qmsg;

unsigned int displayWidth, displayHeight;

unsigned int g_winWidth, g_winHeight;
float        g_mouseMovementScalarX, g_mouseMovementScalarY;
float        g_oneOverMouseMovementScalarX, g_oneOverMouseMovementScalarY;
long         g_startTime = 0;

static PWHFN *pwhfnCurrent;

void os2_SetXWindow( PWHFN *pwhfnThis )
{
   pwhfnCurrent = pwhfnThis;
}

MRESULT APIENTRY MainWindow( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
   HPS hps;
   RECTL rect;

   switch ( msg )
      {
      case WM_ACTIVATE:
         if (!mp1)
            grSstControl(GR_CONTROL_DEACTIVATE);
         else
            grSstControl(GR_CONTROL_ACTIVATE);
         break;

      case WM_PAINT:
         hps = WinBeginPaint( hwnd, 0, &rect );
         WinFillRect( hps, &rect, SYSCLR_WINDOW );
         WinEndPaint( hps );
         break;

      case WM_CLOSE:
         WinPostMsg( hwnd, WM_QUIT, 0, 0 );
         break;

      default:
         if ( pwhfnCurrent )
            return pwhfnCurrent(hwnd,msg,mp1,mp2);
         else
            return WinDefWindowProc(hwnd,msg,mp1,mp2);
         break;
      }

   return 0;
}

void os2_InitializeXWindow( float resolutionX, float resolutionY )
{
  PPIB ppib;
  PTIB ptib;
  ULONG flCreate;
  CHAR szGlideClass[] = "GlideClass";

	struct timeval timeData;
	struct timezone timeZoneData;
       
	gettimeofday( &timeData, &timeZoneData );

	g_startTime = timeData.tv_sec;

	/* get desktop resolution size */
	displayWidth  = WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN);
	displayHeight = WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);

	/* cacluate scale ratio for the mouse movements */
	if(displayWidth < resolutionX) {
	  g_mouseMovementScalarX = resolutionX / (float)displayWidth;
	  g_oneOverMouseMovementScalarX = 1.0f / g_mouseMovementScalarX;
	} 
	else {
	  g_mouseMovementScalarX = (float)displayWidth / resolutionX;
	  g_oneOverMouseMovementScalarX = g_mouseMovementScalarX;
	}
	g_winWidth = displayWidth;

	/* cacluate scale ratio for the mouse movements */
	if(displayHeight < resolutionY) {
	  g_mouseMovementScalarY = resolutionY / (float)displayHeight;
	  g_oneOverMouseMovementScalarY = 1.0f / g_mouseMovementScalarY;
	} 
	else {
	  g_mouseMovementScalarY = (float)displayHeight / resolutionY;
	  g_oneOverMouseMovementScalarY = g_mouseMovementScalarY;
	}
	g_winHeight = displayHeight;

  DosGetInfoBlocks(&ptib, &ppib);
  ppib->pib_ultype = 3;

  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab, 0);

  WinRegisterClass( hab, szGlideClass, MainWindow, CS_MOVENOTIFY | CS_SIZEREDRAW, 0 );

  flCreate = FCF_TASKLIST ;

  hWndFrame = WinCreateStdWindow( HWND_DESKTOP, WS_VISIBLE, &flCreate, szGlideClass, "Glide Test", WS_VISIBLE, 0, 1, &hWndMain );

  WinSetWindowPos( hWndFrame,
                   HWND_TOP,
                   0, 0, g_winWidth, g_winHeight,
                   SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW
                 );

  WinSetFocus( HWND_DESKTOP, hWndMain );
}

void os2_ShutdownXWindow( void )
{
  WinDestroyWindow(hWndMain);
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
}

void os2_ResizeXWindow( float resolutionX, float resolutionY)
{
	/* cacluate scale ratio for the mouse movements */
	if(displayWidth < resolutionX) {
	  g_mouseMovementScalarX = resolutionX / (float)displayWidth;
	  g_oneOverMouseMovementScalarX = 1.0f / g_mouseMovementScalarX;
	} 
	else {
	  g_mouseMovementScalarX = (float)displayWidth / resolutionX;
	  g_oneOverMouseMovementScalarX = g_mouseMovementScalarX;
	}

	/* cacluate scale ratio for the mouse movements */
	if(displayHeight < resolutionY) {
	  g_mouseMovementScalarY = resolutionY / (float)displayHeight;
	  g_oneOverMouseMovementScalarY = 1.0f / g_mouseMovementScalarY;
	} 
	else {
	  g_mouseMovementScalarY = (float)displayHeight / resolutionY;
	  g_oneOverMouseMovementScalarY = g_mouseMovementScalarY;
	}
}

void os2_EventLoop( void )
{
   while ( WinPeekMsg( hab, &qmsg, 0, 0, 0, PM_REMOVE ) )
      WinDispatchMsg( hab, &qmsg );
}

void os2_GetCursorPos(POINTL *mouseCoordinates)
{
    POINTL ptl;

    WinQueryPointerPos(HWND_DESKTOP,&ptl);
    mouseCoordinates->x = (long)(ptl.x*g_mouseMovementScalarX);
    mouseCoordinates->y = (long)(ptl.y*g_mouseMovementScalarY);
}

void os2_SetCursorPos(int x, int y)
{
    WinSetPointerPos( HWND_DESKTOP,
		      (long)(x*g_oneOverMouseMovementScalarX), 
		      (long)(y*g_oneOverMouseMovementScalarY) );
}

/*
	os2_timeGetTime() is similar to the Win32 multimedia timer function timeGetTime()
	This function returns number of milliseconds since the UNIX Epoch (January 1, 1970)
*/

LONG os2_timeGetTime( void )
{
	struct timeval timeData;
	struct timezone timeZoneData;

	/* timeZoneData is not used and is only passed because gettimeofday requires it */
	gettimeofday( &timeData, &timeZoneData );

	timeData.tv_sec -= g_startTime;
	/* return the timestamp in milliseconds  */
	return ( (timeData.tv_sec * 1000) + timeData.tv_usec/1000 );
}

