/* Create SciTech Display Doctor Desktop objects */
/*******************************************************/
/* Before running, SET LANG= to the correct language.  */
/* It may already be correctly set in your CONFIG.SYS. */
/* For examples:                                       */
/* SET LANG=ar_AA for Arabic                           */
/* SET LANG=pt_BR for Brazil                           */
/* SET LANG=zh_CN for Simplified Chinese               */
/* SET LANG=de_DE for Germany                          */
/* SET LANG=da_DK for Denmark                          */
/* SET LANG=es_ES for Spain                            */
/* SET LANG=el_GR for Greece                           */
/* SET LANG=fi_FI for Finland                          */
/* SET LANG=fr_FR for France                           */
/* SET LANG=iw_IL for Israel                           */
/* SET LANG=it_IT for Italy                            */
/* SET LANG=ja_JP for Japan                            */
/* SET LANG=ko_KR for Korea                            */
/* SET LANG=nl_NL for Netherlands                      */
/* SET LANG=no_NO for Norway                           */
/* SET LANG=sv_SE for Sweden                           */
/* SET LANG=zh_TW for Taiwan                           */
/* SET LANG=en_US for English (default)                */
/*******************************************************/

/******************************************
* Define MRI strings here
*******************************************/

  MRI_PARAMETERS_GAMON             = 'Parameters for GAMON (-h for usage)'
  MRI_TITLE_CONFIGURATION_PROGRAM  = 'Configuration^Program'
  MRI_TITLE_HARDWARE_REPORT        = 'Hardware^Report'
  MRI_TITLE_MONITOR_UTILITY        = 'Monitor Utility'
  MRI_TITLE_SCITECH_DISPLAY_DOCTOR = 'SciTech Display^Doctor/se 7.0'
  MRI_TITLE_SCITECH_MARKETPLACE    = 'SciTech Marketplace^Consumer Products'
  MRI_TITLE_UNINSTALL              = 'Uninstall'

/******************************************
* Define message ids from *mid*.h
*******************************************/

  MSG_CANNOT_MAKE            =   82
  MSG_INSTALL_UNSUCCESSFUL   = 1975



/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* get current directory - Where SDD utilities are installed */
os2bootPath = SysSearchPath('PATH', 'os2boot')
if os2bootpath \= ''
then bootDrive = filespec('drive', os2bootPath)
else exit
sdddir=bootDrive || '\sdd'

CreateObjects:

/* Create the Scitech folder on Desktop */
Class='WPFolder'
Location='<WP_DESKTOP>'
ObjectID='<SCITECH_DESKTOP>'
Title=MRI_TITLE_SCITECH_DISPLAY_DOCTOR
SETUP='ICONVIEWPOS=16 44 56 23;ALWAYSSORT=YES;OPEN=NO;DISABLETOOLBAR=1;'

Call MakeObject

/* All other objects created in Scitech folder */
Location='<SCITECH_DESKTOP>'

/* Create Shadows */
Class='WPShadow'

Title='System'
ObjectID='<SCITECH_SYSTEM>'
SETUP='SHADOWID=<WP_SYSTEM>;'
Call MakeObject

Title='readme.txt'
ObjectID='<SCITECH_README>'
SETUP='SHADOWID='sdddir'\readme.txt'
Call MakeObject

Title='changes.txt'
ObjectID='<SCITECH_CHANGES>'
SETUP='SHADOWID='sdddir'\changes.txt;'
Call MakeObject

/* Make URLs */
Class='WPUrl'

Title=MRI_TITLE_SCITECH_MARKETPLACE
ObjectID='<SCITECH_MARKET>'
SETUP='URL=http://www.scitechsoft.com/sdd_os2_order.html'
Call MakeObject

/* Make Programs */
Class='WPProgram'

Title=MRI_TITLE_MONITOR_UTILITY
ObjectID='<SCITECH_GAMON>'
SETUP='EXENAME=CMD.EXE;'||,
          'STARTUPDIR='sdddir';'||,
          'PARAMETERS=/c (GAMON.EXE [' || MRI_PARAMETERS_GAMON || '] ' ||,
                  '> gamon.out & e.exe gamon.out );'||,
      'PROGTYPE=WINDOWABLEVIO;'
Call MakeObject

Title=MRI_TITLE_CONFIGURATION_PROGRAM
ObjectID='<SCITECH_GACTRL>'
SETUP='EXENAME='sdddir'\GACTRL.EXE;'||,
          'STARTUPDIR='sdddir';'||,
      'PROGTYPE=FULLSCREEN;'
Call MakeObject

Title=MRI_TITLE_HARDWARE_REPORT
ObjectID='<SCITECH_REPORT>'
SETUP='EXENAME=cmd.exe;'||,
          'STARTUPDIR='sdddir';'||,
      'PARAMETERS=/c (GAREPORT.EXE > gareport.out & start /f e.exe gareport.out);'||,
      'PROGTYPE=FULLSCREEN;'
Call MakeObject

Title=MRI_TITLE_UNINSTALL
ObjectID='<SCITECH_UNINSTAL>'
SETUP='EXENAME='sdddir'\UNINSTAL.EXE;'||,
                  'STARTUPDIR='sdddir';'||,
          'PROGTYPE=PM;'||,
          'NOAUTOCLOSE=YES;'
Call MakeObject

exit

/******************************************************
* Make a Work Place Shell object
*******************************************************/

MakeObject:
  if SysCreateObject(Class,Title,Location,'OBJECTID='ObjectID';'||,
                     'TITLE='title';'SETUP,'U')<>1,
  then Say Title || ' ' || MyGetMsg(SysGetMessage(MSG_CANNOT_MAKE))
  return

/******************************************************
* Remove SYSXXXX: from messages
*******************************************************/

MyGetMsg: Procedure

  parse arg message
  if pos('SYS', word(message, 1)) == 1
    then parse arg . message
  return message
