/*******************************************************************/
/*     Broadcast Script UM-Client 2.0 (Lan Server)                 */
/*******************************************************************/
/*                                                                 */
/* This REXX script may use the following parameters :             */
/*                                                                 */
/* 1  Message name (same as defined in message file (UMC_MESG)     */
/* 2  Message to send to users : YES or NO                         */
/* 3  Message text                                                 */
/*                                                                 */
/* Example of customization :                                      */
/*                                                                 */
/* if msgName ="Agent_Communication_Failed" then                   */
/*   do                                                            */
/*    specific action ...                                          */
/*   end                                                           */
/* else                                                            */
/*   do                                                            */
/*    specific action ...                                          */
/*   end                                                           */
/*                                                                 */
/*******************************************************************/

/* Parse arguments 1, 2 & 3 */
PARSE ARG '"'msgName'" "'msgYesNo'" "'msgText'"' 

/* Disable local echo of system commands */
'@echo off'

/* Get Host name */
'hostname > umc_name.tmp'
CALL STREAM 'umc_name.tmp','c','open read'
UMC_NAME=LINEIN('umc_name.tmp')
CALL STREAM 'umc_name.tmp','c','close'
'del umc_name.tmp'

/* Build message into a temporary file */
CALL STREAM 'umc_msg.tmp','c','open write'

blankline = " "
sepline = "-----------------------------------------------" 
header = "         UM-Client : "UMC_NAME
call lineout 'umc_msg.tmp',sepline
call lineout 'umc_msg.tmp',blankline
call lineout 'umc_msg.tmp',header
call lineout 'umc_msg.tmp',blankline
call lineout 'umc_msg.tmp',sepline
call lineout 'umc_msg.tmp',msgText
call lineout 'umc_msg.tmp',sepline

CALL STREAM 'umc_msg.tmp','c','close'

/* Sends broadcast message to all administrators defined in umc_fadm file */
fic_adm = 'umc_fadm'
admin=LINEIN(fic_adm)
DO WHILE admin > 0
  'NET SEND 'admin' < umc_msg.tmp'
  admin=LINEIN(fic_adm)
END

/* Sends broadcast message to all users */
IF msgYesNo="YES"
  THEN 'NET SEND /users < umc_msg.tmp' 

'del umc_msg.tmp'

EXIT


