/* rexx */
/* Trace SYSTEM.T?F file split utility */
/* R.J.Moore 4th May 1996 */
/* version 1.3 */
say 'SYSSPLIT: TRACE SYSTEM.T?F split file list utility version 1.3'
say 'Author: Richard Moore - 19 September 1996'
say 'Copyright (C) 1995, IBM UK Ltd.'
say ''

trace 'o'

!.=''
arg !.0sysfile d .

if d='DEBUG' then !.0dbg=(0=0)
else !.0dbg=(0=1)

if !.0sysfile='' then do
   say 'SYSSPLIT SYSTEM.T?F'
   exit 4
end  /* Do */

!.0tffopen=0=1
signal on halt name haltexit

!.0rxcc=rxfuncadd('SysFileTree','REXXUTIL','SysFileTree')
call SysFileTree !.0sysfile,'x','F'
if x.0=0 then do
   say 'File' !.0sysfile 'not found'
   if !.0rxcc=0 then call rxfuncdrop 'SysFileTree'
   exit 4
end  /* Do */
if !.0rxcc=0 then call rxfuncdrop 'SysFileTree'

extents.=''     /* list of duplicate suffixes per TFF */
namelst.=0=1    /* boolean test for name existence */
uniqnames.=''   /* list of unique names */
j=0             /* number of unique names */

hdrsize=c2d(getword(0))
files=c2d(getword(2))

/* either create temporary TFFs  */
/* or final TDFs                  */
!.0tfftype=0=1
offset=4
do i=1 to files
   name=getbyte(offset,15)
   name=strip(name,'T','0'x)
   parse var name name '.' ext
   if ext='TFF' then do
      extents.name=extents.name 'F'i
      if namelst.name then do
         namelst.name=0=0 /*true*/
         j=j+1
         uniqnames.j=name
      end  /* Do */
      name=name'.F'i
      !.0tfftype=0=0
   end /* do */
   else name=name'.'ext
   offset=offset+15
   file_size=c2d(getdword(offset))
   offset=offset+4
   file_offset=c2d(getdword(offset))
   offset=offset+4
   if !.0dbg then do
      say 'size: x'd2x(file_size)
      say 'offset: x'd2x(file_offset)
   end /* do */
   data=getbyte(file_offset,file_size)
   if ext='TFF' then,
      say 'Generating temporary TFF:' name
   else,
      say 'Generating:' name
   '@erase' name '2>NUL'
   x=charout(name,data)
   x=charout(name)
end /* do */
uniqnames.0=j

/* now look for duplicate names, if found used */
/* TRCUST to combine them                      */
/* if not found then rename tor *.TFF          */

trace 'o'
if !.0tfftype then do i=1 to uniqnames.0
   name=uniqnames.i
   if words(extents.name)>1 then do
      say 'Combining TFFs for' name 'from:'
      '@erase @@COMB@@.TSF 2>NUL'
      do j=1 to words(extents.name)
         ext=word(extents.name,j)
         say '  ' name'.'ext
         x=lineout('@@COMB@@.TSF',name'.'ext)
      end /* do */
      x=lineout('@@COMB@@.TSF')
      say 'Generating:' name'.TFF'
      'TRCUST @@COMB@@.TSF /C='name'.TFF'
      do j=1 to words(extents.name)
         ext=word(extents.name,j)
         '@ERASE' name'.'ext '2>NUL'
      end /* do */
   end  /* Do */
   else do
      say 'Generating:' name'.TFF'
      ext=word(extents.name,1)
      '@erase' name'.TFF' '2>NUL'
      '@rename' name'.'ext name'.TFF' '2>NUL'
   end  /* Do */
end /* do */
'@erase @@COMB@@.TSF 2>NUL'


haltexit: if !.0tffopen then x=lineout(!.0sysfile) /* close tfffile */

exit 0



x=getbyte(!.0tff.i.0offset)
do while x<>'0'x
   !.0tff.i.0fmt=!.0tff.i.0fmt || x
   !.0tff.i.0offset=!.0tff.i.0offset+1
   x=getbyte(!.0tff.i.0offset)
end /* do */

return 0     


getbyte: procedure expose !.
/* read one or more bytes from the .tff file from given offset */

parse arg offset,length
if length='' then length=1
return charin(!.0sysfile,offset+1,length)

getword: procedure expose !.
/* read a word from the .tff file from given offset */

parse arg offset
x=charin(!.0sysfile,offset+1,2)
return translate('12',x,'21')

getdword: procedure expose !.
/* read a double word from the .tff file from given offset */

parse arg offset
x=charin(!.0sysfile,offset+1,4)
return translate('1234',x,'4321')
