/*
 * showcp.h
 */
#define IDR_MAIN       1      /* resource identifier */
#include <unidef.h>
#include <uconv.h>

/*
 *  Standard Dialog box ids
 */
#define FILEOPEN        2000
#define FILESAVE        2001

#define MSGBOXID        1001
#define OBJECTID        1002

/*
 *  Menu item ids
 */
#define IDM_FILE                            1000
#define IDM_FILENEW                         1100
#define IDM_FILEOPEN                        1200
#define IDM_FILESAVE                        1300
#define IDM_FILESAVEAS                      1400
#define IDM_PRINTM                          1500
#define IDM_PRINT                           1501
#define IDM_PRINTNU                         1502
#define IDM_PRINTI                          1503

#define IDM_EXIT                            1900
#define IDM_ESCAPE                          1901
#define IDM_PAGEDOWN                        1902
#define IDM_PAGEUP                          1903
#define IDM_EXTRA                           1904
#define IDM_EBCDIC                          1905
#define IDM_WINCP                           1906

#define IDM_FONT                            2500
#define IDM_TIMES                           2504
#define IDM_HELV                            2508
#define IDM_COURIER                         2512
#define IDM_SYSP                            2516
#define IDM_SYSVIO                          2520
#define IDM_MT30                            2524
#define IDM_ARIAL                           2528
#define IDM_SYMBOL                          2532
#define IDM_WINGDING                        2536
#define IDM_DINGBAT                         2540
#define IDM_TMSRMN                          2544
#define IDM_HEL                             2548
#define IDM_COURNEW                         2552
#define IDM_BITCYB                          2556
#define IDM_LUCIDA                          2560
#define IDM_MINCHO                          2564
#define IDM_TNRWT                           2568
#define IDM_MTSANS                          2572

#define IDM_ATTR                            2600
#define IDM_NORMAL                          2601
#define IDM_BOLD                            2602
#define IDM_ITALIC                          2603
#define IDM_BOLDITALIC                      2604

#define IDM_HELP                            9000
#define IDM_HELPUSINGHELP                   9100
#define IDM_HELPGENERAL                     9200
#define IDM_HELPKEYS                        9300
#define IDM_HELPINDEX                       9400
#define IDM_HELPTUTORIAL                    9500
#define IDM_HELPPRODUCTINFO                 9600

#define IDM_CODEPAGE                       10000
#define IDM_WARD                           15000
#define IDM_SIZE                           16000

/*
 *  Dialog item ids
 */
#define ID_OK               1
#define ID_CANCEL           2

/*
 *  Stringtable ids
 */
#define IDS_FILEOPENEXT             1
#define IDS_APPNAME                 2
#define IDS_HELPLIBRARYNAME         3
#define IDS_OPEN                    4
#define IDS_HELPWINDOWTITLE         5
#define IDS_SAVE                    6
#define IDS_UNTITLED                7
#define IDS_TITLEBARSEPARATOR       8
#define IDS_OBJECTCLASS             9
#define IDS_CODEPAGE                10

/*
 *  Messagetable ids
 */
#define IDMSG_INITFAILED                1
#define IDMSG_MAINWINCREATEFAILED       2
#define IDMSG_NOCP                      3
#define IDMSG_CANNOTLOADSTRING          4
#define IDMSG_CANNOTLOADEXITLIST        5
#define IDMSG_CANNOTOPENPRINTER         6
#define IDMSG_PRINTINITFAILED           7
#define IDMSG_PRINTERROR                8
#define IDMSG_CANNOTALLOCATEMEMORY      9
#define IDMSG_CANNOTCREATEUCONV        10
#define IDMSG_HELPLOADERROR            11
#define IDMSG_HELPDISPLAYERROR         12
#define IDMSG_YOURTUTORIAL             13
#define IDMSG_NOPRINTER                14

/*
 *  Ids of messages used between threads
 */
#define TM_THREADINITFAILED         WM_USER+300

/*
 *  Other constants
 */
#define MESSAGELEN          50    /* maximum length for messages */
#define TITLESEPARATORLEN   4

/* return values for initialization routines */
#define RETURN_SUCCESS      0   /* successful return in DosExit */
#define RETURN_ERROR        1   /* error return in DosExit */
#define BEEP_WARN_FREQ      60  /* frequency of warning beep */
#define BEEP_WARN_DUR      100  /* duration of warning beep */

/*
 *  Help table and subtables
 */
#define TEMPLATE_HELP_TABLE                 1000
#define SUBTABLE_MAIN                       2000
#define SUBTABLE_PRODUCTINFODLG             3000


/*
 *  Main window help panels
 */
#define PANEL_MAIN                          2100
#define PANEL_PRODUCTINFODLG                3100


#define PANEL_FILE                          2210
#define PANEL_FILENEW                       2220
#define PANEL_FILEOPEN                      2230
#define PANEL_FILESAVE                      2240
#define PANEL_FILESAVEAS                    2250
#define PANEL_FILEEXIT                      2290
#define PANEL_EDIT                          2310
#define PANEL_EDITUNDO                      2320
#define PANEL_EDITCUT                       2330
#define PANEL_EDITCOPY                      2340
#define PANEL_EDITPASTE                     2350
#define PANEL_EDITCLEAR                     2360
#define PANEL_HELP                          2910
#define PANEL_HELPINDEX                     2920
#define PANEL_HELPGENERAL                   2930
#define PANEL_HELPUSINGHELP                 2940
#define PANEL_HELPKEYS                      2950
#define PANEL_HELPTUTORIAL                  2960
#define PANEL_HELPPRODUCTINFO               2970

/*
 *  Enter text dialog help subtable
 */
#define PANEL_PRODUCTINFO_OK                3110

#define HID_FS_OPEN_DLG_HELP_PANEL          4163
#define HID_FS_SAVE_DLG_HELP_PANEL          4210

#define IDD_PRODUCTINFO     1001                                                /*<-@UNI->*/

#define IDC_OK              1
#define IDC_CANCEL          2
#define IDC_HELP            3
#define IDC_ICON            4
#define IDC_BITMAP          5                                                   /*<-@UNI  */
#define IDR_BITMAP          6                                                   /*  @UNI->*/


typedef struct {
    char  * name;
    USHORT  uni;
    USHORT  len;
} NAMETAB;
#define NOTHEXVAL 999999
NAMETAB * Unicode;           /* Unicode name table  */
char    * Unitext;           /* Unicode name data   */
NAMETAB * Utab[256];
char    * Value;
char      GlyphAdobe[64];
char      GlyphIBM[12];
char      Fn[260];           /* Expanded file name */
char      InLine[256];       /* Input line from names file */

char hexstr[18] = "0123456789ABCDEF";

/*
 *  Global variables
 */
extern HWND hwndMainFrame;
extern HWND hwndMain;
extern HAB  hab;
extern HMQ  hmq;
extern HDC  hdcMain;
extern CHAR szAppName[];
extern CHAR szUntitled[];
extern BOOL fPrintEnabled;
extern BOOL fHelpEnabled;

extern char * BidiTypes[];
extern char * UniTypes[];

/*
 *  Entry point declarations
 */
MRESULT EXPENTRY MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
ULONG MessageBox(HWND hwndOwner, ULONG idMsg, ULONG fsStyle, BOOL fBeep);
VOID MainCommand(MPARAM mp1, MPARAM mp2, HWND hwnd);
BOOL Init(VOID);
MRESULT InitMainWindow(HWND hwnd, MPARAM mp1, MPARAM mp2);
VOID ExitProc(USHORT usTermCode);
int  getposition(int x, int y);
void setupfont(HWND hwnd);
VOID SetSysMenu(HWND hDlg);
VOID UpdateTitleText(HWND hwnd);
VOID EditUndo(MPARAM mp2);
VOID EditCut(MPARAM mp2);
VOID EditCopy(MPARAM mp2);
VOID EditPaste(MPARAM mp2);
VOID EditClear(MPARAM mp2);
VOID UserCommand(MPARAM mp1, MPARAM mp2);
VOID InitMenu(MPARAM mp1, MPARAM mp2);
VOID EnableMenuItem(HWND hwndMenu, USHORT idItem, BOOL fEnable);
VOID MainPaint(HWND hwnd);
VOID InitHelp(VOID);
VOID HelpIndex(VOID);
VOID HelpGeneral(VOID);
VOID HelpUsingHelp(VOID);
VOID HelpKeys(VOID);
VOID HelpTutorial(VOID);
VOID HelpProductInfo(VOID);
VOID DisplayHelpPanel(ULONG idPanel);
VOID DestroyHelpInstance(VOID);


/*
 * Glyph name support
 */
int    getglyph(UniChar uni);
char * getline(char * buf, FILE * f);
int    getnames(NAMETAB * * tab, char * name, char * * text, NAMETAB * * utab);
long   gethexval(char * cp);
long   parse (char * line, char * * value);
char * nexttoken(char * value);
void   nullword(char * cptr);
FILE * findopen (char * fname, char * mode, char * path, int msg);
void   searchenv (const char *fname, const char *env_var, char *path);
char * getpath (char *src, char *dst);
int    readunitab(void);
char * getuniinfo(UniChar uc);
void   tokenuni(char * str, char * temp, char * token[16]);
char * getdesc(char * name, char * table[]);
