/*******************************************************************************
* FILE NAME: WinMenu.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     WinMenu                                                                  *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _HPOSITION_
#include "HPosition.hpp"
#endif

#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _IGROUPBX_
#include <igroupbx.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ISTATTXT_
#include <istattxt.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _ISETCV_
#include <isetcv.hpp>
#endif

#ifndef _IPUSHBUT_
#include <ipushbut.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _WINMENU_
#include "WinMenu.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for WinMenuConn2
//*****************************************************************************
class WinMenuConn2 : public IObserver {
public:
   virtual  ~WinMenuConn2(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos1Lat(valueAsDouble) to Position1(latitude))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->VBSETTEXTFROMVALUE(target->target().latitude());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos1Lat(valueAsDouble) to Position1(latitude))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->target().setLatitude(source->VBDOUBLEVALUEFROMTEXT());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == HPosition::latitudeId) && (&target->target() == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   IVBVariablePart<HPosition> * target;
   Boolean aligning;


};   //WinMenuConn2


//*****************************************************************************
// Class definition for WinMenuConn3
//*****************************************************************************
class WinMenuConn3 : public IObserver {
public:
   virtual  ~WinMenuConn3(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos1Lon(valueAsDouble) to Position1(longitude))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->VBSETTEXTFROMVALUE(target->target().longitude());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos1Lon(valueAsDouble) to Position1(longitude))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->target().setLongitude(source->VBDOUBLEVALUEFROMTEXT());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == HPosition::longitudeId) && (&target->target() == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   IVBVariablePart<HPosition> * target;
   Boolean aligning;


};   //WinMenuConn3


//*****************************************************************************
// Class definition for WinMenuConn4
//*****************************************************************************
class WinMenuConn4 : public IObserver {
public:
   virtual  ~WinMenuConn4(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos2Lat(valueAsDouble) to Position2(latitude))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->VBSETTEXTFROMVALUE(target->target().latitude());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos2Lat(valueAsDouble) to Position2(latitude))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->target().setLatitude(source->VBDOUBLEVALUEFROMTEXT());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == HPosition::latitudeId) && (&target->target() == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   IVBVariablePart<HPosition> * target;
   Boolean aligning;


};   //WinMenuConn4


//*****************************************************************************
// Class definition for WinMenuConn5
//*****************************************************************************
class WinMenuConn5 : public IObserver {
public:
   virtual  ~WinMenuConn5(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IEntryField * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos2Lon(valueAsDouble) to Position2(longitude))");
         ITRACE_DEVELOP(" setting source from target ");
         aligning = true;
         try {source->VBSETTEXTFROMVALUE(target->target().longitude());}
         catch (IException& exc) {};
         aligning = false;
         }
      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Pos2Lon(valueAsDouble) to Position2(longitude))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->target().setLongitude(source->VBDOUBLEVALUEFROMTEXT());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IEntryField::textId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == HPosition::longitudeId) && (&target->target() == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IEntryField * source;
   IVBVariablePart<HPosition> * target;
   Boolean aligning;


};   //WinMenuConn5


//*****************************************************************************
// Class definition for WinMenuConn17
//*****************************************************************************
class WinMenuConn17 : public IObserver, public IStandardNotifier {
public:
   virtual  ~WinMenuConn17(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IFrameWindow * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PBQuit(buttonClickEvent) to TestWindow(close))");
         try {target->close();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IFrameWindow * target;


};   //WinMenuConn17


//*****************************************************************************
// Class definition for WinMenuConn6
//*****************************************************************************
class WinMenuConn6 : public IObserver, public IStandardNotifier {
public:
   virtual  ~WinMenuConn6(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   WinMenuConn6 & setPos(IVBVariablePart<HPosition> * aSelf) {iPos = aSelf; return *this;};
   double actionResult() const { return iActionResult; };
   WinMenuConn6 & setActionResult(double aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PBCalculate(buttonClickEvent) to Position1(headingTo))");
         try {setActionResult(target->target().headingTo(iPos->target()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IVBVariablePart<HPosition> * target;
   IVBVariablePart<HPosition> * iPos;
   double iActionResult;


};   //WinMenuConn6

const INotificationId WinMenuConn6::actionResultId = "WinMenuConn6::actionResult";

//*****************************************************************************
// Class definition for WinMenuConn9
//*****************************************************************************
class WinMenuConn9 : public IObserver, public IStandardNotifier {
public:
   virtual  ~WinMenuConn9(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(WinMenuConn6 * aSource, IEntryField * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn6(actionResult) to HeadResult(valueAsDouble))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->VBSETTEXTFROMVALUE(source->actionResult());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == WinMenuConn6::actionResultId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IEntryField::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   WinMenuConn6 * source;
   IEntryField * target;
   Boolean aligning;


};   //WinMenuConn9


//*****************************************************************************
// Class definition for WinMenuConn18
//*****************************************************************************
class WinMenuConn18 : public IObserver, public IStandardNotifier {
public:
   virtual  ~WinMenuConn18(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IPushButton * aSource, IVBVariablePart<HPosition> * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   WinMenuConn18 & setPos(IVBVariablePart<HPosition> * aSelf) {iPos = aSelf; return *this;};
   double actionResult() const { return iActionResult; };
   WinMenuConn18 & setActionResult(double aSelf) {
      iActionResult = aSelf;
      notifyObservers(INotificationEvent(actionResultId, *this));
      return *this;
      };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId actionResultId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IPushButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : PBCalculate(buttonClickEvent) to Position1(distanceTo))");
         try {setActionResult(target->target().distanceTo(iPos->target()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * source;
   IVBVariablePart<HPosition> * target;
   IVBVariablePart<HPosition> * iPos;
   double iActionResult;


};   //WinMenuConn18

const INotificationId WinMenuConn18::actionResultId = "WinMenuConn18::actionResult";

//*****************************************************************************
// Class definition for WinMenuConn10
//*****************************************************************************
class WinMenuConn10 : public IObserver, public IStandardNotifier {
public:
   virtual  ~WinMenuConn10(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(WinMenuConn18 * aSource, IEntryField * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn18(actionResult) to DistResult(valueAsDouble))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->VBSETTEXTFROMVALUE(source->actionResult());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == WinMenuConn18::actionResultId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IEntryField::textId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   WinMenuConn18 * source;
   IEntryField * target;
   Boolean aligning;


};   //WinMenuConn10


#pragma export (WinMenu::readyId)
const INotificationId WinMenu::readyId = "WinMenu::readyId";
//------------------------------------------------------------------------------
// WinMenu :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (WinMenu::defaultFramingSpec())
const IRectangle WinMenu::defaultFramingSpec()
{
   return(IRectangle(IPoint(158, IWindow::desktopWindow()->size().height()-61-470),ISize(285, 470)));
}


//------------------------------------------------------------------------------
// WinMenu :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (WinMenu::defaultTitle())
IString WinMenu::defaultTitle()
{
   return("Positions Utility");
}


//------------------------------------------------------------------------------
// WinMenu :: WinMenu
//------------------------------------------------------------------------------
#pragma export (WinMenu::WinMenu(unsigned long, IWindow *, IWindow *, const IRectangle &, const IFrameWindow::Style &, const char *))
WinMenu::WinMenu(
      unsigned long id, 
      IWindow * parent, 
      IWindow * owner, 
      const IRectangle & rect, 
      const IFrameWindow::Style & style, 
      const char * title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iPosition1 = new IVBVariablePart<HPosition>();
   iPosition2 = new IVBVariablePart<HPosition>();
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iGroupBox1 = new IGroupBox(
      id+WNDOFFSET_WinMenu_GroupBox1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText1 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText1, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IStaticText::defaultStyle() | IControl::group);
   iStaticText2 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPos1Lat = new IEntryField(
      id+WNDOFFSET_WinMenu_Pos1Lat, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() & ~IControl::group | IEntryField::autoTab | IControl::tabStop);
   iPos1Lon = new IEntryField(
      id+WNDOFFSET_WinMenu_Pos1Lon, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() & ~IControl::group & ~IControl::tabStop | IEntryField::autoTab);
   iGroupBox2 = new IGroupBox(
      id+WNDOFFSET_WinMenu_GroupBox2, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText3 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IStaticText::defaultStyle() | IControl::group);
   iStaticText4 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText4, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPos2Lat = new IEntryField(
      id+WNDOFFSET_WinMenu_Pos2Lat, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() & ~IControl::group | IEntryField::autoTab | IControl::tabStop);
   iPos2Lon = new IEntryField(
      id+WNDOFFSET_WinMenu_Pos2Lon, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() & ~IControl::tabStop | IEntryField::autoTab);
   iGroupBox3 = new IGroupBox(
      id+WNDOFFSET_WinMenu_GroupBox3, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iStaticText5 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText5, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IStaticText::defaultStyle() | IControl::group);
   iStaticText6 = new IStaticText(
      id+WNDOFFSET_WinMenu_StaticText6, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iDistResult = new IEntryField(
      id+WNDOFFSET_WinMenu_DistResult, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IEntryField::readOnly);
   iHeadResult = new IEntryField(
      id+WNDOFFSET_WinMenu_HeadResult, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle(), 
      IEntryField::defaultStyle() | IEntryField::readOnly);
   iCVSButtons = new ISetCanvas(
      id+WNDOFFSET_WinMenu_CVSButtons, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle());
   iPBCalculate = new IPushButton(
      id+WNDOFFSET_WinMenu_PBCalculate, 
      iCVSButtons, 
      iCVSButtons, 
      IRectangle(), 
      IPushButton::defaultStyle() | IPushButton::defaultButton | IControl::group | IControl::tabStop);
   iPBQuit = new IPushButton(
      id+WNDOFFSET_WinMenu_PBQuit, 
      iCVSButtons, 
      iCVSButtons, 
      IRectangle(), 
      IPushButton::defaultStyle() & ~IControl::tabStop);

   conn2 = new WinMenuConn2();
   conn3 = new WinMenuConn3();
   conn4 = new WinMenuConn4();
   conn5 = new WinMenuConn5();
   conn17 = new WinMenuConn17();
   conn6 = new WinMenuConn6();
   conn9 = new WinMenuConn9();
   conn18 = new WinMenuConn18();
   conn10 = new WinMenuConn10();

   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iMultiCellCanvas1->addToCell(iGroupBox1, 2, 2, 5, 6);
   iMultiCellCanvas1->addToCell(iStaticText1, 3, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText2, 3, 6, 1, 1);
   iMultiCellCanvas1->addToCell(iPos1Lon, 5, 6, 1, 1);
   iMultiCellCanvas1->addToCell(iPos1Lat, 5, 4, 1, 1);
   iMultiCellCanvas1->addToCell(iGroupBox2, 2, 9, 5, 6);
   iMultiCellCanvas1->addToCell(iStaticText3, 3, 11, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText4, 3, 13, 1, 1);
   iMultiCellCanvas1->addToCell(iPos2Lat, 5, 11, 1, 1);
   iMultiCellCanvas1->addToCell(iPos2Lon, 5, 13, 1, 1);
   iMultiCellCanvas1->addToCell(iGroupBox3, 2, 16, 5, 6);
   iMultiCellCanvas1->addToCell(iStaticText5, 3, 18, 1, 1);
   iMultiCellCanvas1->addToCell(iStaticText6, 3, 20, 1, 1);
   iMultiCellCanvas1->addToCell(iDistResult, 5, 18, 1, 1);
   iMultiCellCanvas1->addToCell(iHeadResult, 5, 20, 1, 1);
   iMultiCellCanvas1->addToCell(iCVSButtons, 2, 23, 5, 1);
   iMultiCellCanvas1->setColumnWidth(5, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setColumnWidth(7, IMultiCellCanvas::defaultCell().width(), false);
   iMultiCellCanvas1->setRowHeight(22, IMultiCellCanvas::defaultCell().height(), true);
   iMultiCellCanvas1->setRowHeight(24, IMultiCellCanvas::defaultCell().height(), false);
   iGroupBox1->setText("Position 1");
   iGroupBox1->setMinimumSize(ISize(123, 98));
   iStaticText1->setAlignment(IStaticText::centerLeft);
   iStaticText1->setText("Latitude");
   iStaticText1->setMinimumSize(ISize(123, 23));
   iStaticText2->setAlignment(IStaticText::centerLeft);
   iStaticText2->setText("Longitude");
   iStaticText2->setMinimumSize(ISize(123, 22));
   iPos1Lat->setLimit(8);
   iPos1Lat->setAlignment(IEntryField::center);
   iPos1Lat->setMinimumSize(ISize(101, 28));
   iPos1Lon->setLimit(8);
   iPos1Lon->setAlignment(IEntryField::center);
   iPos1Lon->setMinimumSize(ISize(101, 28));
   iGroupBox2->setText("Position 2");
   iGroupBox2->setMinimumSize(ISize(123, 98));
   iStaticText3->setAlignment(IStaticText::centerLeft);
   iStaticText3->setText("Latitude");
   iStaticText3->setMinimumSize(ISize(123, 22));
   iStaticText4->setAlignment(IStaticText::centerLeft);
   iStaticText4->setText("Longitude");
   iStaticText4->setMinimumSize(ISize(123, 22));
   iPos2Lat->setLimit(8);
   iPos2Lat->setAlignment(IEntryField::center);
   iPos2Lat->setMinimumSize(ISize(101, 28));
   iPos2Lon->setLimit(8);
   iPos2Lon->setAlignment(IEntryField::center);
   iPos2Lon->setMinimumSize(ISize(101, 28));
   iGroupBox3->setText("Results");
   iGroupBox3->setMinimumSize(ISize(123, 98));
   iStaticText5->setAlignment(IStaticText::centerLeft);
   iStaticText5->setText("Distance");
   iStaticText5->setMinimumSize(ISize(123, 23));
   iStaticText6->setAlignment(IStaticText::centerLeft);
   iStaticText6->setText("Heading");
   iStaticText6->setMinimumSize(ISize(123, 20));
   iDistResult->setLimit(16);
   iDistResult->setAlignment(IEntryField::center);
   iDistResult->setMinimumSize(ISize(101, 28));
   iHeadResult->setLimit(16);
   iHeadResult->setAlignment(IEntryField::center);
   iHeadResult->setMinimumSize(ISize(101, 28));
   iCVSButtons->setAlignment(ISetCanvas::centerCenter);
   iCVSButtons->setMinimumSize(ISize(123, 51));
   iCVSButtons->setPackType(ISetCanvas::expanded);
   iPBCalculate->setText("~Calculate");
   iPBCalculate->setMinimumSize(ISize(102, 34));
   iPBQuit->setText("~Quit");
   iPBQuit->setMinimumSize(ISize(102, 34));
}     //end constructor


//------------------------------------------------------------------------------
// WinMenu :: ~WinMenu
//------------------------------------------------------------------------------
#pragma export (WinMenu::~WinMenu())
WinMenu::~WinMenu()
{
   conn2->stopHandlingNotificationsFor(*iPos1Lat);
   conn2->stopHandlingNotificationsFor(*iPosition1);
   conn3->stopHandlingNotificationsFor(*iPos1Lon);
   conn3->stopHandlingNotificationsFor(*iPosition1);
   conn4->stopHandlingNotificationsFor(*iPos2Lat);
   conn4->stopHandlingNotificationsFor(*iPosition2);
   conn5->stopHandlingNotificationsFor(*iPos2Lon);
   conn5->stopHandlingNotificationsFor(*iPosition2);
   conn17->stopHandlingNotificationsFor(*iPBQuit);
   conn6->stopHandlingNotificationsFor(*iPBCalculate);
   conn9->stopHandlingNotificationsFor(*conn6);
   conn9->stopHandlingNotificationsFor(*iHeadResult);
   conn18->stopHandlingNotificationsFor(*iPBCalculate);
   conn10->stopHandlingNotificationsFor(*conn18);
   conn10->stopHandlingNotificationsFor(*iDistResult);

   delete conn2;
   delete conn3;
   delete conn4;
   delete conn5;
   delete conn17;
   delete conn6;
   delete conn9;
   delete conn18;
   delete conn10;


   delete iPosition1;
   delete iPosition2;
   delete iMultiCellCanvas1;
   delete iGroupBox1;
   delete iStaticText1;
   delete iStaticText2;
   delete iPos1Lat;
   delete iPos1Lon;
   delete iGroupBox2;
   delete iStaticText3;
   delete iStaticText4;
   delete iPos2Lat;
   delete iPos2Lon;
   delete iGroupBox3;
   delete iStaticText5;
   delete iStaticText6;
   delete iDistResult;
   delete iHeadResult;
   delete iCVSButtons;
   delete iPBCalculate;
   delete iPBQuit;
}

//------------------------------------------------------------------------------
// WinMenu :: initializePart
//------------------------------------------------------------------------------
#pragma export (WinMenu::initializePart())
WinMenu & WinMenu::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// WinMenu :: makeConnections
//------------------------------------------------------------------------------
#pragma export (WinMenu::makeConnections())
Boolean WinMenu::makeConnections()
{
   iPosition1->enableNotification();
   iPosition2->enableNotification();
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iGroupBox1->enableNotification();
   iStaticText1->enableNotification();
   iStaticText2->enableNotification();
   iPos1Lat->enableNotification();
   iPos1Lon->enableNotification();
   iGroupBox2->enableNotification();
   iStaticText3->enableNotification();
   iStaticText4->enableNotification();
   iPos2Lat->enableNotification();
   iPos2Lon->enableNotification();
   iGroupBox3->enableNotification();
   iStaticText5->enableNotification();
   iStaticText6->enableNotification();
   iDistResult->enableNotification();
   iHeadResult->enableNotification();
   iCVSButtons->enableNotification();
   iPBCalculate->enableNotification();
   iPBQuit->enableNotification();

   conn2->initialize(iPos1Lat, iPosition1);
   conn2->handleNotificationsFor(*iPos1Lat);
   conn2->handleNotificationsFor(*iPosition1);
   conn3->initialize(iPos1Lon, iPosition1);
   conn3->handleNotificationsFor(*iPos1Lon);
   conn3->handleNotificationsFor(*iPosition1);
   conn4->initialize(iPos2Lat, iPosition2);
   conn4->handleNotificationsFor(*iPos2Lat);
   conn4->handleNotificationsFor(*iPosition2);
   conn5->initialize(iPos2Lon, iPosition2);
   conn5->handleNotificationsFor(*iPos2Lon);
   conn5->handleNotificationsFor(*iPosition2);
   conn17->initialize(iPBQuit, this);
   conn17->handleNotificationsFor(*iPBQuit);
   conn6->initialize(iPBCalculate, iPosition1);
   conn6->handleNotificationsFor(*iPBCalculate);
   conn6->setPos(iPosition2);
   conn9->initialize(conn6, iHeadResult);
   conn9->handleNotificationsFor(*conn6);
   conn9->handleNotificationsFor(*iHeadResult);
   conn18->initialize(iPBCalculate, iPosition1);
   conn18->handleNotificationsFor(*iPBCalculate);
   conn18->setPos(iPosition2);
   conn10->initialize(conn18, iDistResult);
   conn10->handleNotificationsFor(*conn18);
   conn10->handleNotificationsFor(*iDistResult);

   conn2->setTarget();
   conn3->setTarget();
   conn4->setTarget();
   conn5->setTarget();
   return true;
}



