/****************************************************************
 * Dateiname   : ps.h
 *               Geschrieben 2/93 von Ralf Seidel nach einer
 *               Vorlage von Rick Fishman
 * Beschreibung: Diese Headerdatei stellt ein undokumentierte
 *               Funktion von OS/2 zur Verfgung und definiert
 *               die dazugehrigen Typen.
 * Bemerkungen : Um diese Funktion zu nutzen mu in der .def
 *               Datei zum jeweiligen Programm die Anweisung
 *                  IMPORTS DosQProcStatus.154
 *               auftauchen.
 *               Bei der Verwendung von EMX-gcc mu eine Datei
 *               mit den Eintrgen
 *                  +psimp.s
 *                  DosQProcStatus doscalls 154 F
 *               benutzt werden und mit dem Befehl
 *                  emximp -o ps.a ps.imp
 *               in eine "linkbare" Form ungewandelt werden.
 *               ps.a ist dann wie eine zustzliche Library zu
 *               verwenden
 ****************************************************************/

#pragma linkage( DosQProcStatus, far16 pascal )

/* Prototyp von DosQProcStatus */
#ifdef __EMX__
USHORT _THUNK_FUNCTION(DosQProcStatus)(PVOID pvBuf, USHORT cbBuf);
#else
USHORT DosQProcStatus( PVOID pvBuf, USHORT cbBuf );
#endif

#define PROCINFO_ENDFLAG 3       /* Endflag der Proceinfoliste */
#define PROCINFO_CONTFLAG 1
#define PROCINFO_BUF_SIZE 0x8000 /* Buffergre fr Statusdaten */


#pragma pack(1)

typedef struct _SUMMARY
{
   ULONG   ulThreadCt;          /* Grte Thread ID des Systems */
   ULONG   ulProcCt;            /* ?                            */
   ULONG   ulOpenFileCt;        /* Anzahl geffneter Dateien    */
} SUMMARY, *PSUMMARY;


typedef struct _THREADINFO
{
   USHORT  usUnknown1;          /* immer 0100 ?                 */
   USHORT  usUnknown2;          /* immer 0 ?                    */
   USHORT  usProcTid;           /* TID im Prozess (2 bytes!)    */
   USHORT  usSysTid;            /* TID des Systems (2 bytes!)   */
   ULONG   ulBlockId;           /* Block ID (?)                 */
   USHORT  usPriority;          /* Prioritt                    */
   USHORT  usUnknown3;          /* immer 0 ?                    */
   ULONG   ulExecCt1;           /* Zhler der Ausfhrungszeit ? */
   ULONG   ulExecCt2;           /* Zhler der Ausfhrungszeit ? */
   USHORT  usThreadStat;        /* 1=ready, 2=blocked,          */
                                /* 5=running, 9=frozen          */
   USHORT  usUnknown4;          /* immer 0 ?                    */
} THREADINFO, *PTHREADINFO;


typedef struct _PROCESSINFO
{
   ULONG       ulEndFlag;       /* 3 = letzter Eintrag          */
                                /* 1 = weitere folgen           */
   PTHREADINFO ptiFirst;        /* Addresse des ersten          */
                                /* Thread Ctrl Block            */
   USHORT      pid;             /* Proze ID (2 bytes!)         */
   USHORT      pidParent;       /* Parent`s process ID          */
   USHORT      usSessionType;   /* Session Typ                  */
   USHORT      usUnknown1;      /* immer 0 ?                    */
   USHORT      usUnknown2;      /* nicht immer 0                */
   USHORT      usUnknown3;      /* immer 0 ?                    */
   USHORT      sid;             /* Session ID                   */
   USHORT      usUnknown4;      /* immer 0 ?                    */
   USHORT      hModRef;         /* handle des .EXE Moduls       */
   USHORT      usThreadCt;      /* Anzahl Threads im Proze     */
   USHORT      usUnknown5;
   USHORT      usUnknown6;      /* immer 0 ?                    */
   USHORT      usUnknown7;      /* immer 0 ?                    */
   USHORT      usUnknown8;      /* immer 0 ?                    */
   USHORT      usThreadIdCt;    /* USHORTs in Thread ID Tabelle */
   USHORT      usModCt;         /* USHORTs in ModHandle Tabelle */
   USHORT      usUshortCt;      /* USHORTs in USHORT Tabelle    */
   USHORT      usUnknown9;
   PUSHORT     pusThreadIdTable;/* Addresse TID Tabelle         */
   PUSHORT     pusHModTable;    /* Addresse ModHandle Tabelle   */
   PUSHORT     pusUSHORTTable;  /* Addresse USHORT Tabelle      */
} PROCESSINFO, *PPROCESSINFO;


typedef struct _SEMINFO
{
   struct _SEMINFO *pNext;      /* Zeiger zum nchsten Block    */
                                /* (NULL beim Allerletzten)     */
   USHORT   usOwner;            /* Besitzender Thread           */
   UCHAR    uchFlag;            /* Flag ?                       */
   UCHAR    uchRefCt;           /* Anzahl der Verweise          */
   UCHAR    uchRequestCt;       /* Anzahl der Anforderungen     */
                                /* (requests)                   */
   UCHAR    uchUnknown1;        /* immer 0 ?                    */
   USHORT   usUnknown2;         /* immer 0 ?                    */
   USHORT   usIndex;            /* Index (0 beim Letzten)       */
   USHORT   usUnknown3;         /* Immer 'EM'                   */
                                /* (berrest von "SEM" ?)       */
   CHAR     szSemName[1];       /* ASCIIZ Semaphorenname        */
} SEMINFO, *PSEMINFO;

typedef struct _SHRMEMINFO
{
    struct _SHRMEMINFO *pNext;  /* Nchster Block               */
                                /* (NULL beim Letzten)          */
    USHORT      usMemHandle;    /* Shared memory handle         */
    SEL         selMem;         /* Selector                     */
    USHORT      usRefCt;        /* Anzahl der Referenzen        */
    CHAR        szMemName[1];   /* ASCIIZ shared memory Name    */
} SHRMEMINFO, *PSHRMEMINFO;


typedef struct _MODINFO
{
   struct _MODINFO *pNext;      /* Nchsten Block               */
                                /* (NULL beim letzten)          */
   USHORT   hMod;               /* Modul handle                 */
   USHORT   usMemModel;         /* Modultyp (0=16bit,1=32bit)   */
   ULONG    ulRefCt;            /* Anzahl importierter Module   */
   ULONG    ulSegCt;            /* Anzahl Segmente im Module    */
   ULONG    ulUnknown1;         /* immer 0 ?                    */
   PSZ      szModName;          /* Adresse des Modulnamens      */
   USHORT   usModRef[1];        /* Handles importierer Module   */
} MODINFO, *PMODINFO;


typedef struct _BUFFHEADER
{
   PSUMMARY        psumm;       /* Allgemeine Daten             */
   PPROCESSINFO    ppi;         /* Zeiger auf den ersten        */
                                /* PROCESSINFO Block.           */
   /* Die Adressen der nchsten Blcke errechnen sich durch     */
   /* Addition von ppi mit der Gre der THREADINFO Struktur    */
   /* mal der Anzahl der Threads des Prozesses.                 */
   /* (pNext = (PPROCESSINFO)(ppi->ptiFirst+ppi->usThreadCt))   */
   PSEMINFO        psi;         /* SEM Info Zeiger (+16 Bytes)  */
                                /* Ebenso Zeiger auf das Ende   */
                                /* der Prozeinfoliste          */
   PVOID           pUnknown1;   /* immer NULL ?                 */
   PSHRMEMINFO     psmi;        /* SHARED MEMORY Info Zeiger    */
   PMODINFO        pmi;         /* MODULE Info Zeiger           */
   PVOID           pUnknown2;   /* immer NULL ?                 */
   PVOID           pUnknown3;   /* immer NULL ?                 */
} BUFFHEADER, *PBUFFHEADER;
#pragma pack()
