/****************************************************************
 *
 *  Dieses Programm ersetzt das von IBM mitgelieferte pstat.
 *  Es ist aber mglich mehr Angaben auszugegeben bzw die Ausgaben
 *  auf wesentlich Merkmale zu reduzieren.
 *  Author: Ralf Seidel
 *  email: rauh@wrcd1.uni-wuppertal.de
 *  subject: fuer Ralf
 *
 *  This Program replaces pstat deliverd with the OS/2 package. 
 *  It has some more options and alows the output to be more brief.
 *  All comments are written in german, because I don't expect 
 *  much interrest.
 *  I developed it using EMX GCC but it may be possible to use other
 *  compilers though I could not test this by myself.
 *  Author: Ralf Seidel
 *  email: rauh@wrcd1.uni-wuppertal.de
 *  subject: for Ralf
 ****************************************************************/
#include <stdio.h>
#include <strings.h>
#include <malloc.h>
#include <ctype.h>
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#include <os2.h>
#include "ps.h"

#define RC_OK 0                 /* return codes */
#define RC_ERR 1

/*
#define SHOW_UNKNOWN_HEADER 
#define SHOW_UNKNOWN_PROCESS
#define SHOW_UNKNOWN_THREAD  
#define SHOW_UNKNOWN_SEM     
#define SHOW_UNKNOWN_MODULS
*/

/* Funktionen */

#ifndef __EMX__
/* Diese Funktion dubliziert den ihr bergebenen ASCIIZ String */
/* Sie allociert dafr mittels malloc() den bentigten Platz und */
/* kopiert dann bei Erfolg von malloc() den bergebenen String mit */
/* den Befehl memcpy */
char *strdup( char *string )
{
   char *p;
   size_t n;
   n = strlen( string ) + 1;
   if ( p = (char*) malloc( n )) != NULL )
      (char *)memcpy( p, string, n );
   return p;
}
#endif


/* Ausgabe einer kurzen Mitteilung bei falschen Parametern */
void ShowUsage()
{
   fprintf( stderr, "Fehler bei den Komandooptionen\n" );
   fprintf( stderr, "Gltige Optionen sind: ?ABCHMOT\n" );
   exit( RC_ERR );
}

/* Ausgabe der Hilfestellung */
void ShowHelp()
{
   printf( "Optionen sind:\n" );
   printf( "\tH : Anzeigen von allgemeinen Informationen\n" );
   printf( "\tC : Anzeigen von Prozeinformationen\n" );
   printf( "\tT : Anzeigen von Proze- und Threadinformationen\n" );
   printf( "\tO : Anzeigen von Modulen im System\n" );
   printf( "\tM : Anzeigen von Informationen ber 'shared Memory'\n" );
   printf( "\tS : Anzeigen von Systemsemaphoren\n" );
   printf( "\tA : Anzeigen aller Angaben (default)\n" );
   printf( "\tB : Kurzanzeige\n" );
   printf( "Bei der Verwendung der Option B werden die Angaben " \
           "verkrzt ausgeben:\n" );
   exit( RC_OK );
}

/* Ausgabe der allgemeinen Angaben */
void ShowSum( PBUFFHEADER pBufHead )
{
   PSUMMARY pProcSum;

   printf( "\nAllgemeine Angaben:\n" );
   pProcSum = pBufHead->psumm;
   printf( "Anzahl der Prozesse(?)\t: %.8x\n", pProcSum->ulProcCt );
   printf( "Anzahl der Threads\t: %.8x\n",
           pProcSum->ulThreadCt );
   printf( "Geffnete Dateien\t: %.8x\n", pProcSum->ulOpenFileCt );
#ifdef SHOW_UNKNOWN_HEADER
   printf( "Unknown1: %.8x\n", pBufHead->pUnknown1 );
   printf( "Unknown2: %.8x\n", pBufHead->pUnknown2 );
   printf( "Unknown3: %.8x\n", pBufHead->pUnknown3 );
#endif /* SHOW_UNKNOWN_HEADER */
} 

/* Ausgabe der Processinformationen */
void ShowProc( PBUFFHEADER pBufHead, \
               BOOL fShowThread, BOOL fShowBrief )
{
   typedef struct _MODLIST
   {
      struct _MODLIST *pNext;
      USHORT   hMod;            /* Interne Kennung */
      PSZ      pModName;        /* Name des Moduls */
   } MODLIST, *PMODLIST;

   PPROCESSINFO pProcInfo;
   PTHREADINFO pThreadInfo;
   PMODINFO pModInfo;
   PMODLIST pModList;
   PMODLIST pmli;
/*   PUSHORT pusi; */

   printf( "\n\t\tProzeinformationen\n\n" );

   /* Erstellung der Liste mit den Modulnamen */

   if (( pModList = (PMODLIST) malloc( sizeof (MODLIST) )) == NULL )
   {
      fprintf(stderr, "malloc: memory exhausted in %s at %d\n", \
              __FILE__, __LINE__ );
      exit( RC_ERR );
   }
   pmli = pModList;
   for ( pModInfo = pBufHead->pmi; pModInfo != NULL;
         pModInfo = pModInfo->pNext )
   {
   if (( pmli->pModName = (CHAR *)strdup(pModInfo->szModName )) == NULL )
   {
      fprintf(stderr, "strdup: memory exhausted in %s at %d\n",
              __FILE__, __LINE__ );
      exit( RC_ERR );
   } /* endif */
      pmli->hMod = pModInfo->hMod;
      if ( (pmli->pNext = (PMODLIST) malloc( sizeof (MODLIST) )) == NULL )
      {
         fprintf(stderr, "malloc: memory exhausted in %s at %d\n",
                 __FILE__, __LINE__ );
         exit( RC_ERR );
      }
      pmli = pmli->pNext;
      pmli->pNext = NULL;
   }

   /* Ausgabe der Prozeinformationen */

   printf( "PID  (dez)\tModulname\n" );
   if ( fShowBrief == FALSE )
      printf( "\tPPID\tSID\tKennung\tSession Typ\n");
   if ( fShowThread == TRUE )
   {
      printf( "Threadinfos:\n" );
      printf( "\tProcID\tSysID\tBlockID\t\tPrio.\tZhler 1 & 2\t" );
      printf( "Status\n" );
   } /* endif fShowThread */
   pProcInfo = pBufHead->ppi;
   while ( pProcInfo->ulEndFlag != PROCINFO_ENDFLAG )
   {
      if ( pProcInfo->ulEndFlag != PROCINFO_CONTFLAG )
      {
         fprintf( stderr,
                  "Unerwarteter Wert in der Prozessinfolist: %d\n",
                  pProcInfo->ulEndFlag );
         exit( RC_ERR );
      } /* endif */

      /* Finden des zum Proze dazugehrigen Moduls */

      pmli = pModList;
      while ( (pmli != NULL) && (pmli->hMod != pProcInfo->hModRef) )
         pmli = pmli->pNext;
      printf( "%.4x (%d)\t", pProcInfo->pid, pProcInfo->pid );
      if ( pmli == NULL )
         printf( "Name nicht gefunden!\n" );
      else
         printf( "%s\n", pmli->pModName );
      if ( fShowBrief == FALSE )
      {
         printf( "\t%.2x\t", pProcInfo->pidParent );
         printf( "%.2x\t", pProcInfo->sid );
         printf( "%.4x\t", pProcInfo->hModRef );
         printf( "%d : ",pProcInfo->usSessionType );
         switch( pProcInfo->usSessionType )
         {
         case SSF_TYPE_DEFAULT:
            printf("System\n");
            break;
         case SSF_TYPE_FULLSCREEN:
            if ( pProcInfo->hModRef == 0 )
               printf( "DOS\n" );
            else
               printf( "OS/2 FS\n" );
            break;
         case SSF_TYPE_WINDOWABLEVIO:
            printf( "OS/2 Window\n" );
            break;
         case SSF_TYPE_PM:
            printf( "PM\n" );
            break;
         case SSF_TYPE_VDM:
            printf( "Detached\n" );
            break;
/* Folgende Typen werden noch in os.h deklariert aber nie benutzt */
/*       case SSF_TYPE_GROUP:   
            printf( "Gruppe\n" );
            break;
         case SSF_TYPE_DLL:
            printf( "DLL\n" );
            break;
         case SSF_TYPE_WINDOWEDVDM:
            printf( "Virtual DOS (Window)\n" );
            break;
         case SSF_TYPE_PDD:
            printf( "PDD\n" );
            break;
         case SSF_TYPE_VDD:
            printf( "VDD\n" );
            break; */
         default:
            printf( "Unbekannt (Fehler ?)\n" );
         } /* endswitch */
#ifdef SHOW_UNKNOWN_PROCESS
         printf( "Unknown1: %4x\n", pProcInfo->usUnknown1 );
         printf( "Unknown2: %4x\n", pProcInfo->usUnknown2 );
         printf( "Unknown3: %4x\n", pProcInfo->usUnknown3 );
         printf( "Unknown4: %4x\n", pProcInfo->usUnknown4 );
         printf( "Unknown5: %4x\n", pProcInfo->usUnknown5 );
         printf( "Unknown6: %4x\n", pProcInfo->usUnknown6 );
         printf( "Unknown7: %4x\n", pProcInfo->usUnknown7 );
         printf( "Unknown8: %4x\n", pProcInfo->usUnknown8 );
         printf( "Unknown9: %4x\n", pProcInfo->usUnknown9 );
#endif
      } /* endif fShowBrief */
      /* Ausgabe der zugehrigen Thread Informationen */
      if ( fShowThread == TRUE )
      {
         pThreadInfo = pProcInfo->ptiFirst;
         for ( pThreadInfo = pProcInfo->ptiFirst;
               pThreadInfo < pProcInfo->ptiFirst
                             + pProcInfo->usThreadCt;
               pThreadInfo++ )
         {
            printf( "\t%.2x\t", pThreadInfo->usProcTid );
            printf( "%.2x\t", pThreadInfo->usSysTid );
            printf( "%.8x\t", pThreadInfo->ulBlockId );
            printf( "%.4x\t", pThreadInfo->usPriority );
            printf( "%.4x\t", pThreadInfo->ulExecCt1 );
            printf( "%.4x\t", pThreadInfo->ulExecCt2 );
            printf( "%d : ", pThreadInfo->usThreadStat );
            switch ( pThreadInfo->usThreadStat )
            {
            case 1:
               printf( "ready\n" );
               break;
            case 2:
               printf( "blocked\n" );
               break;
            case 5:
               printf( "running\n" );
               break;
            case 9:
               printf( "frozen\n" );
               break;
            default:
               printf( "unbekannt\n" );
            } /* endswitch */
#ifdef SHOW_UNKNOWN_THREAD
            printf( "Unknown1: %.4x\n", pThreadInfo->usUnknown1 );
            printf( "Unknown2: %.4x\n", pThreadInfo->usUnknown2 );
            printf( "Unknown3: %.4x\n", pThreadInfo->usUnknown3 );
            printf( "Unknown4: %.4x\n", pThreadInfo->usUnknown4 );
#endif
         } /* endif fShowThread */
      } /* endfor */
      pProcInfo = (PPROCESSINFO)
                  ( pProcInfo->ptiFirst + pProcInfo->usThreadCt );
   } /* endwhile */
   printf( "\n" );
} /* end ShowProc */

/* Ausgabe der Informationen ber Semaphoren */
void ShowSem( PBUFFHEADER pBufHead, BOOL fShowBrief )
{
   PSEMINFO pSemInfo;

   printf( "\n\t\tSystemsemaphoren\n\n" );
   printf( "Semaphorenname\n" );
   if ( fShowBrief == FALSE )
   {
      printf( "\tEigner\t\tAnzahl\t\tAnzahl\n" );
      printf( "\tThread" );
      printf( "\tIndex" );
      printf( "\tVerweise" );
      printf( "\tAnforderungen" );
      printf( "\tFlags\n" );
   } /* endif fShowBrief */
   for (pSemInfo = (PSEMINFO)((char*)pBufHead->psi + 0x10);
        pSemInfo != NULL && pSemInfo->usIndex != 0;
        pSemInfo = pSemInfo->pNext )
   {
      printf( "%s\n", pSemInfo->szSemName );
      if ( fShowBrief == FALSE )
      {
         if ( pSemInfo->usOwner != 0 )
            printf( "\t%.4x", pSemInfo->usOwner );
         else
            printf( "\t" );
         printf( "\t%.4x", pSemInfo->usIndex );
         printf( "\t%.2x\t", pSemInfo->uchRefCt );
         printf( "\t%.2x\t", pSemInfo->uchRequestCt );
         printf( "\t%.2x\n", pSemInfo->uchFlag );
#ifdef SHOW_UNKNOWN_SEM
         printf( "Unknown1: %.2x\t", pSemInfo->uchUnknown1 );
         printf( "Unknown2: %.4x\t", pSemInfo->usUnknown2 );
         printf( "Unknown3: %.4x\n", pSemInfo->usUnknown3 );
#endif
      } /* endif fShowBrief */
   } /* endfor fShowBrief */
   printf( "\n" );
} /* end ShowSem */

/* Ausgabe der Informationen ber shared memory */
void ShowMem ( PBUFFHEADER pBufHead, BOOL fShowBrief )
{
   PSHRMEMINFO pShrMemInfo;
 
   printf( "\n\t\tGemeinsam benutzter Speicher\n\n" );
   printf( "Name des Speichers\n" );
   if ( fShowBrief == FALSE )
   {
      printf( "\tInterne Kennung\t\tAnzahl der Verweise\tSelektor\n" );
   } /* endif fShowBrief */
   for ( pShrMemInfo = pBufHead->psmi;
         pShrMemInfo != NULL && pShrMemInfo->selMem != 0;
         pShrMemInfo = pShrMemInfo->pNext )
   {
      printf( "%s\n", pShrMemInfo->szMemName );
      if ( fShowBrief == FALSE )
      {
         printf( "\t%.4x\t\t", pShrMemInfo->usMemHandle);
         printf( "\t%.4x\t\t", pShrMemInfo->usRefCt );
         printf( "\t%.4x\n", pShrMemInfo->selMem );
      } /* endif fShowBrief */
   } /* endfor pShrMemInfo */
   printf( "\n" );
} /* end ShowMem */

/* Ausgabe der Informationen ber geladene Module */
void ShowMod( PBUFFHEADER pBufHead, BOOL fShowBrief )
{
   PMODINFO pModInfo;
   USHORT *pModRef;
   INT i;

   printf( "Geladene Module im System:\n\n" );
   printf( "Modulname\n" );
   if ( fShowBrief == FALSE )
   {
      printf( "\t\t\tInterne\t\tAnzahl\t\tAnzahl\n" );
      printf( "\tModultyp\t" );
      printf( "Kennung\t\t" );
      printf( "Verweise\t" );
      printf( "Segmente\n" );
      printf( "Kennungen von referenzierten Modulen\n" );
   } /* endif fShowBrief */
   for ( pModInfo = pBufHead->pmi; pModInfo != NULL;
         pModInfo = pModInfo->pNext )
   {
      printf( "%s\n", pModInfo->szModName );
      if ( fShowBrief == FALSE )
      {
         printf( "\t%d = %s\t", pModInfo->usMemModel,
                 (pModInfo->usMemModel == 0)?"16 Bit":"32 Bit");
         printf( "%.4x\t\t", pModInfo->hMod );
         printf( "%.4x\t\t", pModInfo->ulRefCt );
         printf( "%.4x\n", pModInfo->ulSegCt );
         pModRef = pModInfo-> usModRef;
         for ( i = 0; i < pModInfo->ulRefCt; i++ )
            printf( "%.4x\t", *pModRef++ );
         printf( "\n" );
#ifdef SHOW_UNKNOWN_MODULS
            printf( "Unnkown1: %.8x\n", pModInfo->ulUnknown1 );
#endif
      } /* endif fShowBrief */
   } /* endfor */
} /* end ShowMod */


/* HAUPTPROGRAMM */

int main(int argc, char *argv[], char *envp[])
{
   /* Variablen fr die Systeminformationen */
   PBUFFHEADER pBufHead;
   USHORT usRetCode;
   USHORT usBufSize = PROCINFO_BUF_SIZE;

   /* Variablen fr die Ausgabeoptionen */
   BOOL fShowSum = TRUE;
   BOOL fShowProc = TRUE;
   BOOL fShowThread = TRUE;
   BOOL fShowSem = TRUE;
   BOOL fShowMem = TRUE;
   BOOL fShowMod = TRUE;
   BOOL fShowBrief = FALSE;

   /* Variablen fr die Parameterauswertung */
   PSZ szParam;

   /* Sonstige Variablen */
   INT i;

   /* Auswertung der Kommandozeile */

   /* Ausgabe des Programmnamens */
   printf( "%s : (c) Ralf Seidel 2/93\n", argv[0] );
   for (i = 1; i < argc; i++)
   {
      for ( szParam = argv[i]; *szParam != '\0'; szParam++ )
      {
         switch ( toupper( *szParam ))
         {
         case '-':
         case '/':
            break;
         case '?':
            ShowHelp();
            break;
         case 'B':
            fShowBrief = TRUE;
            break;
         case 'C':
            if ( fShowProc == TRUE )
            {
               fShowSum = FALSE;
               fShowThread = FALSE;
               fShowSem = FALSE;
               fShowMem = FALSE;
               fShowMod = FALSE;
            }
            else
               fShowProc = TRUE;
            /* endif */
            break;
         case 'T':
            if ( fShowThread == TRUE )
            {
               fShowSum = FALSE;
               fShowSem = FALSE;
               fShowMem = FALSE;
               fShowMod = FALSE;
            }
            else
            {
               fShowProc = TRUE;
               fShowThread = TRUE;
            } /* endif */
            break;
         case 'H':
            if ( fShowSum == TRUE )
            {
               fShowProc = FALSE;
               fShowThread = FALSE;
               fShowSem = FALSE;
               fShowMem = FALSE;
               fShowMod = FALSE;
            }
            else
               fShowSum = TRUE;
            /* endif fShowSum */
            break;
         case 'S':
            if ( fShowSem == TRUE )
            {
               fShowSum = FALSE;
               fShowProc = FALSE;
               fShowThread = FALSE;
               fShowMem = FALSE;
               fShowMod = FALSE;
            }
            else
               fShowSem = TRUE;
            /* endif fShowSem */
            break;
         case 'M':
            if ( fShowMem == TRUE )
            {
               fShowSum = FALSE;
               fShowProc = FALSE;
               fShowThread = FALSE;
               fShowSem = FALSE;
               fShowMod = FALSE;
            }
            else
               fShowMem = TRUE;
            /* endif fShowMem */
            break;
         case 'L':
         case 'O':
            if ( fShowMod == TRUE )
            {
               fShowSum = FALSE;
               fShowProc = FALSE;
               fShowThread = FALSE;
               fShowSem = FALSE;
               fShowMem = FALSE;
            }
            else
               fShowMod = TRUE;
            /* endif */
            break;
         case 'A':
            fShowSum = TRUE;
            fShowProc = TRUE;
            fShowThread = TRUE;
            fShowSem = TRUE;
            fShowMem = TRUE;
            fShowMod = TRUE;
            break;
/*       case 'P':
            break;*/
         default: 
            ShowUsage();
         } /* endswitch */
      } /* endfor szParam */
   } /* endfor i */
   if (( pBufHead = (PBUFFHEADER) malloc( (size_t)usBufSize)) == NULL )
   {
      fprintf(stderr, "malloc: memory exhausted in %s at %d\n", \
                       __FILE__, __LINE__ );
      exit(RC_ERR);
   }
#ifdef __EMX__
   _THUNK_PROLOG(4 + 2);
   _THUNK_FLAT(pBufHead);
   _THUNK_SHORT(usBufSize);
   usRetCode = (USHORT) _THUNK_CALL( DosQProcStatus );
#else
   usRetCode = DosQProcStatus( pBufHead, usBufSize );
#endif
   switch ( usRetCode )
   {
   case NO_ERROR:
      break;
   case ERROR_BUFFER_OVERFLOW:
      fprintf( stderr, "DosQProcStatus: Datenbuffer zu klein\n" );
      fprintf( stderr, "Buffergre ndern und neu compilieren\n" );
      exit( RC_ERR );
   default:
      fprintf( stderr, "DosQProcStatus: Errorcode %d", usRetCode );
      exit( RC_ERR );
   } /* endswitch */

   /* Ausgabe des Bufferheaders" */
   if ( fShowSum == TRUE ) 
      ShowSum( pBufHead );
   /* Ausgabe der Prozeinformationen */
   if ( fShowProc == TRUE )
      ShowProc( pBufHead, fShowThread, fShowBrief );
   /* Ausgabe der Informationen ber Semaphoren */
   if ( fShowSem == TRUE )
      ShowSem( pBufHead, fShowBrief );
   /* Ausgabe der Informationen ber "shared memory" */
   if ( fShowMem == TRUE )
      ShowMem( pBufHead, fShowBrief );
   /* Ausgabe der Informationen ber geladene Module */
   if ( fShowMod == TRUE )
      ShowMod( pBufHead, fShowBrief );
   return RC_OK;
}

