/************************************************************************/
/* Priority is a quick-and-dirty priority-launcher for OS/2 2.x.        */
/* This code was written by M. Kimes and is hereby released to the      */
/* public domain by the author -- no rights reserved.                   */
/*                                                                      */
/* C/Set2 1.0:      icc /Rn /O+ /Gs+ /Gm- /W3 /Kb /Sa priority.c        */
/* C++ Tools 2.1:   icc /Rn /O+ /Ol+ /Gu+ /Gs+ /W3 /Kb /Sd+ /Gi+        */
/*                      /Sa /Gm- priority.c                             */
/*                                                                      */
/* To get command line help, type "PRIORITY /?" at a command line.      */
/*                                                                      */
/* Undocumented "switches" are activated by adding a text character to  */
/* the end of the first argument:  D = Debug mode, S = shutup           */
/* Example:  "priority 1D 0 somefile.exe"                               */
/*                                                                      */
/************************************************************************/

#define INCL_DOS
#define INCL_VIO

#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

BOOL shutup = FALSE;  /* don't speak */


void _System pprintf (const char *string,...) {

  /* use VioWrtTTY so we don't interfere with any redirection */

  static char     buffer[1024];
  static va_list  ap;
  static int      len;

  if(!shutup) {
    va_start(ap,string);
    len = vsprintf(buffer,string,ap);
    va_end(ap);
    VioWrtTTY(buffer,len,0);
  }
}

int main (int argc,char *argv[]) {

  static   TIB          *tib;
  static   PIB          *pib;
  static   SHORT         class,delta;
  static   unsigned long apptype;
  static   char         *leader = NULL,runme[1100],object[25],*p;
  register char         *pp,*ppp;
  register int           x;
  static   RESULTCODES   rt;

  if(argc >= 3 && argv[1][strlen(argv[1]) - 1] == 'S')
    shutup = TRUE;

  if(!shutup && !DosGetInfoBlocks(&tib,&pib)) {  /* get current priority */
    class = (tib->tib_ptib2->tib2_ulpri & (~255)) >> 8;
    /* note:  doesn't seem to return negative deltas (shows as 0) */
    delta = tib->tib_ptib2->tib2_ulpri & 255;
    pprintf("\r\nCurrent priority is %d:%d (%ld)",class,delta,
            tib->tib_ptib2->tib2_ulpri);
  }
  if(argc >= 3) {  /* get priority arguments first */
    class = atoi(argv[1]);
    delta = atoi(argv[2]);
    if(class < PRTYC_IDLETIME || class > PRTYC_FOREGROUNDSERVER) {
      shutup = FALSE;
      pprintf("\r\n**Error in priority class %d",class);
    }
    if(delta < PRTYD_MINIMUM || delta > PRTYD_MAXIMUM) {
      shutup = FALSE;
      pprintf("\r\n**Error in priority delta %d",delta);
    }
    DosSetPriority(PRTYS_PROCESS,class,delta,0L);
    if(!shutup && !DosGetInfoBlocks(&tib,&pib)) {
      class = (tib->tib_ptib2->tib2_ulpri & (~255)) >> 8;
      delta = tib->tib_ptib2->tib2_ulpri & 255;
      pprintf("\r\nPriority set to %d:%d (%ld)",class,delta,
             tib->tib_ptib2->tib2_ulpri);
    }
    /* see if we need to run through command interpreter */
    if(!argv[3] || !strchr(argv[3],'.') || DosQueryAppType(argv[3],&apptype) ||
       (!(apptype & FAPPTYP_NOTWINDOWCOMPAT) &&
       !(apptype & FAPPTYP_WINDOWCOMPAT) && !(apptype & FAPPTYP_BOUND) &&
       apptype != FAPPTYP_32BIT)) {
      if(DosScanEnv("COMSPEC",(char **)&leader) || !leader || !*leader)
        leader = "CMD.EXE"; /* guess */
    }
    *runme = 0;
    p = runme;
    if(leader) {  /* prepend command interpreter we found or guessed at */
      strcpy(p,leader);
      p += strlen(p) + 1;
      if(argv[3]) {
        strcpy(p,"/C ");
        p += strlen(p);
      }
      x = 3;
    }
    else {        /* else just the program itself */
      strcpy(p,argv[3]);
      p += strlen(p) + 1;
      x = 4;
    }
    for(;x < argc;x++) {
      /* see if we need to add any double-quotes to protect arguments
         containing spaces.  also strip leading/trailing spaces.  this
         code is intentionally sloppy; since it doesn't need to remember
         the allocated variables to free them later, it doesn't bother. */
      ppp = malloc(strlen(argv[x]) + 3);
      if(ppp) {
        ppp++;
        strcpy(ppp,argv[x]);
        while(*ppp && (*ppp == ' ' || *ppp == '\t')) /* strip leading spaces */
          ppp++;
        if(*ppp) {
          pp = ppp + (strlen(ppp) - 1);   /* strip trailing spaces */
          while(pp > ppp && (*pp == ' ' || *pp == '\t')) {
            *pp = 0;
            pp--;
          }
        }
        if(strchr(ppp,' ')) {  /* need double quotes */
          ppp--;
          *ppp = '\"';
          strcat(ppp,"\"");
        }
        argv[x] = ppp;
      }
      if(*argv[x]) {
        strcpy(p,argv[x]);
        p += strlen(p);
        if(x < argc - 1) {  /* add space between arguments */
          *p = ' ';
          p++;
        }
      }
    }
    p = 0;
    /* check for "debug" mode */
    if(argv[1][strlen(argv[1]) - 1] == 'D') {
      p = runme;
      pprintf("\r\nCL: \"%s\"",p);
      p += strlen(p) + 1;
      if(*p)
        pprintf(" \"%s\"",p);
      *object = 0;
      pprintf("\r\nDosExecPgm returned: %ld%s%s%s",
             DosExecPgm(object,24L,EXEC_ASYNC,runme,NULL,&rt,runme),
             (*object) ? " (" : "",(*object) ? object : "",
             (*object) ? ")" : "");
    }
    else
      DosExecPgm(object,24L,EXEC_ASYNC,runme,NULL,&rt,runme);
  }
  else {  /* usage */
    shutup = FALSE;
    pprintf("\r\n\r\n Priority is a public domain launch-with-priority program by M. Kimes\r\n"
            " Compiled: %s  %s\r\n"
            "\r\nUsage:  Priority [<class> <delta> [<command> [args...]]]\r\n"
            "  <class> is from 1 to 4 (3 is a higher priority then 4; otherwise, the\r\n"
            "          higher the number, the higher the priority).\r\n"
            "  <delta> is from -31 to 31; the higher the number, the higher the\r\n"
            "          priority within the <class>.\r\n\r\n"
            "Example:  priority 1 15 someprog.exe some args \"arg with spaces\"\r\n\r\n"
            " Note that 2:0 is the normal priority.  Be careful with priority class 3;\r\n"
            " not even the OS/2 kernal can preempt a program running at 3:31.  Class 1\r\n"
            " is useful for running programs during \"idle\" CPU cycles.  Class 4 can be\r\n"
            " used sparingly to boost timing-critical programs.\r\n",__TIME__,__DATE__);
  }
  pprintf("\r\n");
  return 0;
}
