/*PID SERVER  v1.00*/
/*Server side of program*/

RxExtraAPI = RxFuncQuery('RxExtra')  /* Checks for Rxextras */
IF RxExtraAPI \= 0 THEN
       DO
               Call RxFuncAdd 'RxExtra', 'RxExtras' , 'RxExtra'
               Call RxExtra 'Load'
       END

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Test = RxFuncQuery('GrxLoadFuncs')
IF Test >< 0 THEN
       Do
       Call RxFuncAdd 'GrxLoadFuncs', 'GRXUTILS', 'GRXLOADFUNCS'
       Call GrxLoadFuncs
       END
/************ Finished loading DLLs ******************/

Call SysCls
Say 'PID Server v1.00'
Say
Say 'For best results run this program in a FULLSCREEN OS/2 session'

SIGNAL ON HALT
pipename = '\PIPE\SFOGG\PIDSERVER'
bufsize = 256
queuename = '\QUEUES\SFOGG\PIDSERVER'

Say
Say 'Starting Pipe'

Call GrxSrvrCreateNPipeThrd pipename, bufsize, queuename  /*Creating thread*/

   IF result >< 0 Then
       Do
           SAY 'Could not create server thread'
           Say 'Try closing this OS/2 command line and starting a new one.'
           EXIT
       END

Say 'Server thread started successfully'
Say 'Connecting to the thread.'

hpipe = GrxSrvrConnectNPipe()  /* Connecting to pipe */

Do while hpipe >< 0

       readrc = GrxReadNPipe(hpipe, 'readmsg')
       IF readrc >< 0 THEN
               DO
                 Say 'Bad return code from function'
                 Say 'Client probably disconnected....closing connection.'
                 disconnectrc = GrxSrvrDisconnectNPipe(hpipe)
                 Say 'Restarting Connection'
                 hpipe = GrxSrvrConnectNPipe()
               End

       Call received(readmsg)


End

Exit

RECEIVED:
ARG input

IF input = 'L' THEN                    /*Client asked for a process list*/
       DO
         Call RxQuerySwitchList 'temp.'
             DO COUNT = 2 to temp.0
                msg = temp.count temp.count.PID '*****'
                writerc = GrxWriteNPipe(hpipe, msg)
             END

       END

Else IF datatype(input, N) THEN      /*Received number...process to kill*/
       DO
          rc = RxKillProcess(input)
          msg = 'Process status is:' rc
          writerc = GrxWriteNPipe(hpipe, msg)

       END
ELSE                         /*Bad data from pipe*/
       DO
          msg = 'Error...no action taken'
          writerc = GrxWriteNPipe(hpipe, msg)
       END


msg = "Enter 'L' to see list of running programs or PID# to kill another."
writerc = GrxWriteNPipe(hpipe, msg)
msg = '0000'                        /*Keeps client from trying to read empty pipe*/
writerc = GrxWriteNPipe(hpipe, msg)

RETURN

HALT:
       SAY 'BREAK PRESSED, EXITING..........'
       BEEP(250,250)
       EXIT

