@echo off
if NOT "%@EVAL[2+2]"=="4" goto not4dos
if "%OSLITE"=="" goto novar

echo Unlite V1.1 by Enrico Demarin *FREEWARE*

set TMP1=%@UNIQUE[%OSLITE]
set NODEL=0
set NOEAS=0

unset /Q ORG2
unset /Q ORG1

if "%#"=="0" goto sum
gosub scanopt

SET INFILE=%@PATH[%ORG1]%@NAME[%ORG1].cmd
if NOT EXIST %INFILE goto err1

if "%ORG2"=="" goto nohd3
SET OUTFILE=%@PATH[%ORG2]%@NAME[%ORG2].exe
goto hdone3

:nohd3
unset /Q TEST
SET TEST=%@LINE[%INFILE,2]
iff NOT "%@SUBSTR[%TEST,0,13]"=="SET ORIGNAME=" then goto err2
endiff
%TEST
SET OUTFILE=%@PATH[%ORG1]%@NAME[%ORG1].exe

:hdone3
unset /Q TEST
SET TEST=%@LINE[%INFILE,3]
iff NOT "%@SUBSTR[%TEST,0,12]"=="SET LITSIZE=" then goto err2
endiff
%TEST
skip %LITSIZE <%INFILE >%TMP1
SET SIZE=%@FILESIZE[%TMP1,b]
if "%SIZE"=="0" goto err2
echo Decompressing %INFILE...
gzip -dcn <%TMP1 >%OUTFILE
if NOT ERRORLEVEL==0 goto err3


if "%NOEAS"=="1" goto report
echo Restoring EAs...
if NOT EXIST %TMP1 goto eacopy
del %TMP1 >nul
:eacopy
eautil %INFILE %TMP1 /P /S
if NOT EXIST %TMP1 goto report
eautil %OUTFILE %TMP1 /O /J
:report
echo Done. (CMD/EXE bytes=%@FILESIZE[%INFILE,b],%@FILESIZE[%OUTFILE,b]) 
if NOT EXIST %INFILE goto isdone
if "%NODEL"=="1" goto isdone
del %INFILE >nul
:isdone
goto doquit

echo File Unlited successfully. (%OUTFILE)
goto doquit

:err1
echo Error: source file name invalid or missing.
goto sum

:err2
echo Error: file isn't an OSlited executable.
goto doquit

:err3
echo Error: GZip returned a bad status.
if NOT EXIST %OUTFILE goto sum
del %OUTFILE >nul
goto doquit


:sum
echo Syntax    : unlite source [destination] [-NODEL -NOEAS]
echo Purpose   : decompress an Oslited  file.
echo Parameters:
echo            source      : cmd file to compress
echo            destination : name of decompressed file,
echo                          (if no name is specified, Unlite will use
echo                          the name stored in the decompression header)
echo            -NODEL      : don't delete the compressed file
echo            -NOEAS      : don't copy .CMD extended attributes to the 
echo							  destination file.		
echo Requirements:
echo      Unlite can work ONLY on a HPFS drive. 4OS2 2.0 or higher must 
echo      be installed. And GZIP.EXE,SKIP.EXE,LTHDR.CMD must be in
echo      the path.

:doquit
if NOT EXIST %TMP1 goto clean1
del %TMP1 >nul
:clean1
quit

:not4dos
echo This procedure requires 4OS2 2.00 or higher.
quit

:novar
echo OSLITE environment not defined.
quit

:scanopt
SET COUNT=%#
DO WHILE "%COUNT" != "0"

iff "%@UPPER[%1]"=="-NODEL" then 
SET NODEL=1
elseiff "%@UPPER[%1]"=="-NOEAS" then 
SET NOEAS=1
elseiff "%@SUBSTR[%1,0,1]"=="-" then
echo Invalid option : %1
elseiff "%ORG1"=="" then
SET ORG1=%1
elseiff "%ORG2"==""	then
SET ORG2=%1
else
echo Extra argument %1 ignored.
endiff

shift 1
SET COUNT=%@EVAL[%COUNT-1]
ENDDO
return

