 /******************************************************
*  SHUTDOWN.CPP - SHUTDOWN CLASS                        *
 ******************************************************/

#include "defines.hpp"                                // type defines
#include "shutdown.hpp"                               // shutdown class
#include "command.hpp"                                // command class
#include "process.hpp"                                // process class

#define   DB2WAIT 30000L                              // DB2 manager
#define   OS2WAIT 30000L                              // file system

extern "C" {
#include "sql.h"                                      // sql prototypes
#include "sqlenv.h"                                   //   "        "
#include "sqlcodes.h"                                 //   "        "
#include "sqlutil.h"                                  //   "        "
#include "sqlca.h"                                    //   "        "

NOLINE VOID stopDB2Manager(VOID *shutDown);           // client server
NOLINE VOID stopDB2Clients(VOID *shutDown);           // manager only
NOLINE VOID stopFileSystem(VOID *shutDown);           // update deamon
}
static sqlca SQLCA;                                   // sql structure
static HEV DB2Handle = 0L, DB2Finish = 0L;            // DB2 semaphores
static HEV OS2Handle = 0L, OS2Finish = 0L;            // OS2 semaphores

/******************************************************
*  main - mainline                                      *
 ******************************************************/

VOID main(ULONG argCount, PCHAR argVector[])

{
     LONG returnCode = 0L;                            // return code

     COMMAND *comMand = new COMMAND();                // command class
     PROCESS *proCess = new PROCESS();                // process class

     if (comMand->commandLine(argCount, argVector) == TRUE) {
          SHUTDOWN *shutDown = new SHUTDOWN();        // shutdown class
          /*
           * create a few semaphores
           */
          returnCode = DosCreateEventSem("\\SEM32\\STOPDB2.SEM", &DB2Handle, 0L, FALSE);
          returnCode = DosCreateEventSem("\\SEM32\\WAITDB2.SEM", &DB2Finish, 0L, FALSE);
          returnCode = DosCreateEventSem("\\SEM32\\STOPOS2.SEM", &OS2Handle, 0L, FALSE);
          returnCode = DosCreateEventSem("\\SEM32\\WAITOS2.SEM", &OS2Finish, 0L, FALSE);
          /*
           * next just list the running process (no DosKillProcess)
           */
          if ((comMand->doEverything == TRUE) ||      // do everything
              (comMand->listingFlag  == TRUE)) {      // listing flag
               proCess->listRunning();                // list process
               /*
                * if we're doing anything else then we skip a line
                */
               if ((comMand->doEverything != FALSE) ||// do everything
                   (comMand->clientServer != FALSE) ||// client server
                   (comMand->managerOnly  != FALSE) ||// manager only
                   (comMand->updateDeamon != FALSE) ||// update deamon
                   (comMand->killProcess  != NOPID)) {// kill process
                    printf("\n");                     // skip a line
               }                                      // do everything
          }
          /*
           * if there's a process to kill then call DosKillProcess
           */
          // ((comMand->doEverything == TRUE) ||      // do everything
          if ((comMand->killProcess  != NOPID)) {     // kill process
               PID processID = (PID) comMand->killProcess;
               printf("Killing process (pid=%lu)...", (ULONG) processID);
               returnCode = DosKillProcess(1L, processID);
               printf("complete! (rc=%lu)\n", returnCode);
          }
          /*
           * if we're really doing anything tell the user about it
           */
          if ((comMand->doEverything != FALSE) ||     // do everything
              (comMand->clientServer != FALSE) ||     // client server
              (comMand->managerOnly  != FALSE) ||     // manager only
              (comMand->updateDeamon != FALSE)) {     // update deamon
               printf("Starting shutdown...\n");      // start shutdown
               shutDown->startThreads(comMand);       // start threads
               shutDown->cycleThreads(comMand);       // cycle threads
          }                                           // do everything
          /*
           * clean up the semaphores
           */
          returnCode = DosCloseEventSem(DB2Handle);   // DB2 manager
          returnCode = DosCloseEventSem(DB2Finish);   // DB2 manager
          returnCode = DosCloseEventSem(OS2Handle);   // file system
          returnCode = DosCloseEventSem(OS2Finish);   // file system

          delete shutDown;                            // shutdown class
     }
     delete proCess;                                  // process class
     delete comMand;                                  // command class

     DosExit(EXIT_PROCESS, returnCode);               // exit program
}

 /******************************************************
*  SHUTDOWN::startThreads - start threads               *
 ******************************************************/

NOLINE VOID SHUTDOWN::startThreads(COMMAND *comMand)

{
     LONG returnCode;                                 // return code
     /*
      * kill DB/2 connections and/or stop the database manager
      */
     // ((comMand->doEverything == TRUE) ||           // do everything
     if ((comMand->managerOnly  == TRUE)) {           // manager only
          _beginthread(::stopDB2Manager, NULL, 0x4000U, (VOID *) this);
     } else
     /*
      * kill DB/2 connections and/or stop the database manager
      */
     if ((comMand->doEverything == TRUE) ||           // do everything
         (comMand->clientServer == TRUE)) {           // client server
          _beginthread(::stopDB2Clients, NULL, 0x4000U, (VOID *) this);
     }
     /*
      * finally we should be able to stop the OS/2 file system
      */
     if ((comMand->doEverything == TRUE) ||           // do everything
         (comMand->updateDeamon == TRUE)) {           // update deamon
          _beginthread(::stopFileSystem, NULL, 0x4000U, (VOID *) this);
     }
}

 /******************************************************
*  SHUTDOWN::cycleThreads - cycle threads               *
 ******************************************************/

NOLINE VOID SHUTDOWN::cycleThreads(COMMAND *comMand)

{
     LONG returnCode;                                 // return code
     /*
      * kill DB/2 connections and/or stop the database manager
      */
     // ((comMand->doEverything == TRUE) ||           // do everything
     if ((comMand->managerOnly  == TRUE)) {           // manager only
          returnCode = DosPostEventSem(DB2Handle);    // wakeup thread
          returnCode = DosWaitEventSem(DB2Finish, DB2WAIT);
     } else
     /*
      * kill DB/2 connections and/or stop the database manager
      */
     if ((comMand->doEverything == TRUE) ||           // do everything
         (comMand->clientServer == TRUE)) {           // client server
          returnCode = DosPostEventSem(DB2Handle);    // wakeup thread
          returnCode = DosWaitEventSem(DB2Finish, DB2WAIT);
     }
     /*
      * finally we should be able to stop the OS/2 file system
      */
     if ((comMand->doEverything == TRUE) ||           // do everything
         (comMand->updateDeamon == TRUE)) {           // update deamon
          returnCode = DosPostEventSem(OS2Handle);    // wakeup thread
          returnCode = DosWaitEventSem(OS2Finish, OS2WAIT);
     }
}

 /******************************************************
*  SHUTDOWN::stopDB2Manager - stop DB2 manager          *
 ******************************************************/

NOLINE LONG SHUTDOWN::stopDB2Manager(VOID)

{
     LONG returnCode;                                 // return code

     printf("Stopping database manager...\n");        // show message

     sqlestop(&SQLCA);                                // DB2 manager

     returnCode = SQLCA.sqlcode;                      // get sqlcode

     if (returnCode == 0L) printf("Database shutdown!\n");

     else                  printf("DB/2 Error! (%ld)\n");

     return returnCode;                               // return code
}

 /******************************************************
*  SHUTDOWN::stopDB2Clients - stop DB2 clients          *
 ******************************************************/

NOLINE LONG SHUTDOWN::stopDB2Clients(VOID)

{
     LONG returnCode;                                 // return code

     printf("Killing DB/2 connections and\n");         // show message

     printf("Stopping database manager...\n");        // show message

     sqlekill(&SQLCA);                                // DB2 clients

     returnCode = SQLCA.sqlcode;                      // get sqlcode

     if (returnCode == 0L) printf("Database complete!\n");

     else                  printf("DB/2 Error! (%ld)\n");

     return returnCode;                               // return code
}

 /******************************************************
*  SHUTDOWN::stopFileSystem - stop file system          *
 ******************************************************/

NOLINE LONG SHUTDOWN::stopFileSystem(VOID)

{
     LONG returnCode;                                 // return code

     printf("Stopping OS/2 file system...\n");        // show message

     returnCode = DosShutdown(0L);                    // file system

     if (returnCode == 0L) printf("Shutdown complete!\n");

     else                  printf("OS/2 Error! (%ld)\n");

     return returnCode;                               // return code
}

 /******************************************************
*  stopDB2Manager - stop DB2 manager                    *
 ******************************************************/

NOLINE VOID stopDB2Manager(VOID *shutDown)

{
     LONG returnCode = 0L;                            // return code

     returnCode = DosWaitEventSem(DB2Handle, -1L);    // wait forever

     returnCode = ((SHUTDOWN *) shutDown)->stopDB2Manager();

     returnCode = DosPostEventSem(DB2Finish);         // wake thread
}

 /******************************************************
*  stopDB2Clients - stop DB2 clients                    *
 ******************************************************/

NOLINE VOID stopDB2Clients(VOID *shutDown)

{
     LONG returnCode = 0L;                            // return code

     returnCode = DosWaitEventSem(DB2Handle, -1L);    // wait forever

     returnCode = ((SHUTDOWN *) shutDown)->stopDB2Clients();

     returnCode = DosPostEventSem(DB2Finish);         // wake thread
}

 /******************************************************
*  stopFileSystem - stop file system                    *
 ******************************************************/

NOLINE VOID stopFileSystem(VOID *shutDown)

{
     LONG returnCode = 0L;                            // return code

     returnCode = DosWaitEventSem(OS2Handle, -1L);    // wait forever

     returnCode = ((SHUTDOWN *) shutDown)->stopFileSystem();

     returnCode = DosPostEventSem(OS2Finish);         // wake thread
}

