 /******************************************************
*  COMMAND.HPP - COMMAND CLASS                          *
 ******************************************************/

#ifndef   COMMAND_CLASS
#define   COMMAND_CLASS                               // command class

#include "doscall.hpp"                                // doscall class

CLASS     COMMAND {                                   // command class
PUBLIC:
UNIQUE    /**/      COMMAND(VOID);                    // a constructor
UNIQUE    /**/     ~COMMAND(VOID);                    // a ~destructor
PUBLIC:
STATIC    BOOL      clientServer;                     // client server
STATIC    BOOL      managerOnly;                      // manager only
STATIC    BOOL      doEverything;                     // do everything
STATIC    BOOL      listingFlag;                      // listing flag
STATIC    BOOL      updateDeamon;                     // update deamon
STATIC    LONG      killProcess;                      // kill process
PUBLIC:
UNIQUE    BOOL      commandLine(ULONG argCount, PCHAR argVector[]);
UNIQUE    VOID      commandUsage(BOOL helpFormat);    // command usage
};

 /******************************************************
*  COMMAND::COMMAND - a constructor                     *
 ******************************************************/

INLINE COMMAND::COMMAND(VOID)

{
}

 /******************************************************
*  COMMAND::~COMMAND - a destructor                     *
 ******************************************************/

INLINE COMMAND::~COMMAND(VOID)

{
}

#endif                                                // command class

