 /******************************************************
*  COMMAND.CPP - COMMAND CLASS                          *
 ******************************************************/

#include "defines.hpp"                                // type defines
#include "command.hpp"                                // command class

#define   VERSION "2.0"                               // version number

BOOL  COMMAND::clientServer = FALSE;                  // client server
BOOL  COMMAND::managerOnly  = FALSE;                  // manager only
BOOL  COMMAND::doEverything = FALSE;                  // do everything
BOOL  COMMAND::listingFlag  = FALSE;                  // listing flag
BOOL  COMMAND::updateDeamon = FALSE;                  // update deamon
LONG  COMMAND::killProcess  = NOPID;                  // kill process

 /******************************************************
*  COMMAND::commandLine - command line                  *
 ******************************************************/

NOLINE BOOL COMMAND::commandLine(ULONG argCount, PCHAR argVector[])

{
     register LONG  i;                                // arg counter
     register CHAR *c, *p;                            // arg pointer

     printf("\nOS/2 Shutdown for DB/2 Version %s\n", VERSION);
     printf("Copyright (c) 1994 SoftFocus Inc. All rights reserved.\n\n");

     for (i = 1; i < argCount; i++) {                 // check args
          p = argVector[i]; c = p++;                  // current arg

          if ((*c == '-') || (*c == '/')) {           // arg switch
               do {                                   // nested args
                    switch(toupper(*p++)) {           // upper case
                         case 'A':
                              doEverything = TRUE;    // do everything
                              break;                  // continue ok
                         case 'D':
                              managerOnly  = TRUE;    // manager only
                              break;                  // continue ok
                         case 'F':
                              updateDeamon = TRUE;    // update deamon
                              break;                  // continue ok
                         case 'K':
                              clientServer = TRUE;    // client server
                              break;                  // continue ok
                         case 'L':
                              listingFlag  = TRUE;    // listing flag
                              break;                  // continue ok
                         case 'P':
                              killProcess  = atol(p + 1); *p = '\0';
                              break;                  // continue ok
                         default :
                              commandUsage(TRUE);     // print usage
                              return FALSE;           // return error
                    }                                 // end switch
               } while (*p != '\0');                  // nested args
          } else {
               commandUsage(TRUE);                    // print usage
               return FALSE;                          // return error
          }
     }
     if ((clientServer != FALSE) ||                   // client server
         (managerOnly  != FALSE) ||                   // manager only
         (doEverything != FALSE) ||                   // do everything
         (listingFlag  != FALSE) ||                   // listing flag
         (updateDeamon != FALSE) ||                   // update deamon
         (killProcess  != NOPID)) {                   // kill process
          return TRUE;                                // continue ok
     }
     commandUsage(FALSE);                             // print usage
     return FALSE;                                    // return error
}

 /******************************************************
*  COMMAND::commandUsage - command usage                *
 ******************************************************/

NOLINE VOID COMMAND::commandUsage(BOOL helpFormat)

{
     printf("Usage: shutdown [/A] [/D] [/F] [/K] [/L] [/P:pid] [/?]\n");

     if (helpFormat == TRUE) {                        // help format
          printf("\n");                               // skip a line
          printf("  [/A]     = same as entering /KFL\n");
          printf("  [/D]     = stop database manager\n");
          printf("  [/F]     = stop OS/2 file system\n");
          printf("  [/K]     = kill DB/2 connections\n");
          printf("  [/L]     = list active processes\n");
          printf("  [/P:pid] = kill process id (dec)\n");
          printf("  [/?]     = display this helptext\n\n");

          printf("The /K option attempts to 'kill' all DB/2 client/server\n");
          printf("connections before stopping the database manager.  Use\n");
          printf("this option if you are running shutdown on a database\n");
          printf("server.  The /D option stops the database manager only.\n");
          printf("Use this option if you are running shutdown on a data-\n");
          printf("base client or on a system with a stand alone database.\n");
          printf("The /F option stops the OS/2 file system.  At least one\n");
          printf("option must be specified.  Options may be combined and\n");
          printf("case is insignificant.\n");
     }
}

