#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_WININPUT

#include <os2.h>
#include <stdio.h>
#include <string.h>

HFILE hf;
SHIFTSTATE ss;
BYTE KeyState[257];
BOOL bFlag;
APIRET rc;


int main ( int argc, char * argv[]) {	
  void setnumlock(BOOL bSet);
  
  if (argc == 1) {
     printf("You must either specify NUMLOCK ON or NUMLOCK OFF\n");
     return 1;
  }
  else if (!strcmpi(argv[1],"ON") )   setnumlock(TRUE);
  else if (!strcmpi(argv[1],"OFF"))   setnumlock(FALSE);
  else
     printf(" You must either specify NUMLOCK ON or NUMLOCK OFF");
     
 return 0;
}


void setnumlock(BOOL bSet)
{
  ULONG ulAction, ulLength;

  rc = DosOpen("KBD$",
               &hf,
               &ulAction,
               0L,
               0,
               FILE_OPEN,
               OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE,
               0);

  ulAction = 0;
  ulLength = sizeof(ss);
  rc = DosDevIOCtl(hf,
                   IOCTL_KEYBOARD,
                   KBD_GETSHIFTSTATE,
                   0,
                   0,
                   &ulAction,
                   &ss,
                   sizeof(ss),
                   &ulLength);

  WinSetKeyboardStateTable(HWND_DESKTOP, KeyState, FALSE);

  /* if bSet is true, enable NUMLOCK */
  if(bSet)
    {
    KeyState[VK_NUMLOCK] |= 0x01;
    ss.fsState |= NUMLOCK_ON;
    }
  else
    {
    KeyState[VK_NUMLOCK] &= ~0x01;
    ss.fsState &= ~NUMLOCK_ON;
    }

  WinSetKeyboardStateTable(HWND_DESKTOP, KeyState, TRUE);

  ulAction = sizeof(ss);
  ulLength = 0;
  rc = DosDevIOCtl(hf,
                   IOCTL_KEYBOARD,
                   KBD_SETSHIFTSTATE,
                   &ss,
                   sizeof(ss),
                   &ulAction,
                   0,
                   0,
                   &ulLength);

  rc = DosClose(hf);
}

