/* this script automatically  updates some object whose icon has not been
 updated by newlook.cmd */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* check working directory                                                   */
wkdir = SysSearchPath('PATH', 'UPDATE.CMD')
if wkdir = '' then do
   say
   say
   call beep 700, 500
   say '  Error!!!'
   say '  UPDATE.CMD must be run in its own directory. Just double click on its icon.'
   say
   say
   '@pause'
   call SysDropFuncs
   exit
end

nldir = DIRECTORY()
say
say
if (updQuestion('Information folder'))
   then do
   if ( \ SysSetObjectData('<WP_INFO>', 'ICONRESOURCE=60,PMWP') |,
        \ SysSetObjectData('<WP_INFO>', 'ICONNFILE=1,' || nldir ||,
        '\MORICONS\INFO2.ICO'))
      then call warnmsg 'Information folder'
   end
if (updQuestion('OS/2 System folder'))
   then do
   if ( \ SysSetObjectData('<WP_OS2SYS>', 'ICONRESOURCE=61,PMWP') |,
        \ SysSetObjectData('<WP_OS2SYS>', 'ICONNRESOURCE=1,35,PMWP'))
      then call warnmsg 'OS/2 System folder'
   end
if (updQuestion('System Setup folder'))
   then do
   if ( \ SysSetObjectData('<WP_CONFIG>', 'ICONRESOURCE=59,PMWP') |,
        \ SysSetObjectData('<WP_CONFIG>', 'ICONNRESOURCE=1,15,PMWP'))
       then call warnmsg 'System Setup folder'
   end
if (updQuestion('Command Prompts folder'))
   then do
   if ( \ SysSetObjectData('<WP_PROMPTS>', 'ICONRESOURCE=38,PMWP') |,
        \ SysSetObjectData('<WP_PROMPTS>', 'ICONNRESOURCE=1,37,PMWP'))
      then call warnmsg 'Command Prompts folder'
   end
if (updQuestion('Minimized Window Viewer folder'))
   then do
   if ( \ SysSetObjectData('<WP_VIEWER>', 'ICONRESOURCE=58,PMWP') |,
        \ SysSetObjectData('<WP_VIEWER>', 'ICONNFILE=1,' || nldir ||,
        '\MORICONS\MINVIEW2.ICO'))
      then call warnmsg 'Minimized Window Viewer folder'
   end
if (updQuestion('Shredder'))
   then do
   if ( \ SysSetObjectData('<WP_SHRED>', 'ICONRESOURCE=28,PMWP'))
      then call warnmsg 'Shredder'
   end
if (updQuestion('Network folder'))
   then do
   if ( \ SysSetObjectData('<WP_NETWORK>', 'ICONRESOURCE=33,PMWP') |,
        \ SysSetObjectData('<WP_NETWORK>', 'ICONNRESOURCE=1,9,PMWP'))
      then call warnmsg 'Network folder'
   end
if (updQuestion('Drives folder'))
   then do
   if ( \ SysSetObjectData('<WP_DRIVES>', 'ICONRESOURCE=27,PMWP') |,
        \ SysSetObjectData('<WP_DRIVES>', 'ICONNFILE=1,' || nldir ||,
        '\MORICONS\DRIVES2.ICO'))
      then call warnmsg 'Drives folder'
   end
if (updQuestion('Startup folder'))
   then do
   if ( \ SysSetObjectData('<WP_START>', 'ICONRESOURCE=29,PMWP') |,
        \ SysSetObjectData('<WP_START>', 'ICONNRESOURCE=1,8,PMWP'))
      then call warnmsg 'Startup folder'
   end
call SysDropFuncs
exit


/* question routine */
updQuestion:
arg folder
   say '  Do you want to update the' folder 'object icon? (y/n)'
   say
   pull reply
   if reply = 'Y' then
      return 1
   else
      return 0
/* end updQuestion */


/* warning routine */
warnmsg:
arg msg
   call beep 500 300
   say
   say '  Warning!!! Cannot set' msg 'folder new icon.'
   say
   pause
return
