/* DEUTSCH.CMD: Installation von MEMSIZE in Deutsch. */

'@Echo Off'
'CHCP 850'

/* REXXUTIL laden */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisieren */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation von MEMSIZE...'
Say ''


/* Nachprfen, ob bestimmte Bestandteile vorhanden sind. */

Language = 'DEUTSCH'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: MEMSIZE.EXE nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: 'Language'.DLL nicht gefunden!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEHLER: 'Language'.HLP nicht gefunden!'
  Signal DONE
  End

/* Zielverzeichnis erfragen. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Bitte geben Sie den vollen Verzeichnisnamen ein, wohin'
Say '  MEMSIZE installiert werden soll (Standard: 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Zielverzeichnis, falls ntig, anlegen. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEHLER: Kann das Zielverzeichnis nicht anlegen.'
    Signal DONE
    End
  End
Say '';


/* Im Systemstart-Ordner installieren? */

Say 'Mchten Sie das Programmobjekt im Ordner Systemstart haben? (J/N)'
Pull YesNo
If YesNo = "J" Then
  Do
  Folder = '<WP_START>'
  Say 'Objekt wird im Systemstart-Ordner plaziert.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Objekt wird auf der Arbeitsoberflche plaziert.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Installation durchfhren. */

Say 'Kopiere MEMSIZE nach ' Directory '...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'Erzeuge Programmobjekt...'
Type = 'WPProgram'
Title = 'Systemresourcen'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objekt erzeugt!  Fertig.'
Else
  Say 'FEHLER: Nicht erzeugt!'

Signal DONE

FAILURE:
Say 'Fehler in der REXX-Ausfhrung.'
Signal DONE

HALT:
Say 'REXX-Halt.'
Signal DONE

SYNTAX:
Say 'REXX-Syntaxfehler.'
Signal DONE

DONE:
Exit
