/* BPORTUGU.CMD: Instalao do MEMSIZE em Portugues do Brasil */

'@Echo Off'
'CHCP 850'

/* Carrega REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Inicializa */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Instalao do MEMSIZE...'
Say ''


/* Verifica a existncia de vrios arquivos necessrios. */

Language = 'BPORTUGU'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRO: MEMSIZE.EXE NO foi encontrado!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRO: 'Language'.DLL! NO foi encontrado!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERRO: 'Language'.HLP! NO foi encontrado!'
  Signal DONE
  End

/* Pede o nome do diretrio de destino. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Por favor, escreva o nome completo do diretrio no qual'
Say '  deseja instalar o programa MEMSIZE (default  'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Cria o diretrio de destino, se necessrio. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERRO: No foi possvel criar o diretrio de destino.'
    Signal DONE
    End
  End
Say ''

/* Guarda o diretrio de destino. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE.INI", "MEMSIZE", "INIPATH", Directory )

/* Pergunta sobre a Pasta de Inicializao. */

Say "Deseja colocar na Pasta de Inicializao? (S/N)"
Pull YesNo
If YesNo = "S" Then
  Do
  Folder = '<WP_START>'
  Say "O objeto ser copiado na Pasta de Inicializao."
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say "O objeto ser copiado no Ambiente de Trabalho."
  End
Say ''


/* Destroi o objeto antigo, se existir. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Executa a instalao. */

Say 'Copiando MEMSIZE para o diretrio 'Directory' ...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say "Criando o objeto do programa..."
Type = 'WPProgram'
Title = 'Recursos do Sistema'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say "O objeto foi criado.  Fim."
Else
  Say "ERRO: NO foi possvel criar o objeto!"

Signal DONE

FAILURE:
Say 'Erro de REXX.'
Signal DONE

HALT:
Say 'O REXX foi encerrado.'
Signal DONE

SYNTAX:
Say 'Erro de sintaxe de REXX.'
Signal DONE

DONE:
Exit
