/* ENGLISH.CMD: Install MEMSIZE in English. */

'@Echo Off'
'CHCP 850'

/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing MEMSIZE...'
Say ''


/* Verify the existence of the various component files. */

Language = 'ENGLISH'

Result = SysFileTree( 'MEMSIZE2.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: MEMSIZE2.EXE not found!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.DLL not found!'
  Signal DONE
  End

Result = SysFileTree( "OBJECTS.OS2\"Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: 'Language'.HLP not found!'
  Signal DONE
  End

/* Ask for the target directory name. */

BootDrive = Filespec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))
Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = BootDrive'\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Please enter the full name of the directory to which'
Say '  you want MEMSIZE installed (default 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End
Say ''


/* Save the target directory. */

SysIni( "USER", "MEMSIZE", "INIPATH", Directory )
SysIni( Directory"\MEMSIZE2.INI", "MEMSIZE", "INIPATH", Directory )


/* Ask for the target folder. */

Say 'Do you wish to install to the startup folder? (Y/N)'
Pull YesNo
If YesNo = "Y" Then
  Do
  Folder = '<WP_START>'
  Say 'Object will be placed in the startup folder.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Object will be placed on the desktop.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say 'Copying MEMSIZE to 'Directory' ...'
Copy MEMSIZE2.EXE Directory '1>NUL'
Copy "OBJECTS.OS2\"Language".DLL" Directory"\MEMSIZE2.DLL" '1>NUL'
Copy "OBJECTS.OS2\"Language".HLP" Directory"\MEMSIZE2.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE2.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE2.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE2.INF"
      End
   "HLP2INF" Directory"\MEMSIZE2.HLP"
   End

Result = SysFileTree( "SNPSHOT2.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNPSHOT2.EXE" Directory"\SNPSHOT2.EXE"  '1>NUL'
   End

Say 'Creating program object...'
Type = 'WPProgram'
Title = 'System Resources'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE2.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Object created!  Done.'
Else
  Say 'ERROR: Object not created.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
