/*
 *      MAKELOG2
 *
 *      by Marcus Grber April/May '95
 *
 *      Converts VRAMx.DAT output files from BMP2LOGO to Warp boot logo.
 *
 *      Compile: gcc -Wl,-S -Zomf -Zsys -o makelog2.exe makelog2.c
 *
 *        -Wl,-S        strips debugging info, reducing EXE file size by 8K
 *        -Zomf -Zsys   creates a standalone OS/2 EXE not requiring emx.dll.
 */

#include <stdio.h>
#include <stdlib.h>

int main(void)
{
        struct {
          long ofs;
          long size;
        } logo_header[4];
        FILE *fout,*fin;
        char fname[]="VRAMx.DAT";
        int plane,i,j,b,by,cnt,bufc,line[16],buf[64];
        long adr;

        puts("\nMAKELOG2 -=- by Marcus Grber May '95\n"
               "Converts VRAMx.DAT output files from BMP2LOGO to Warp boot logo.\n");
        fout = fopen("VRAM.DAT","wb");  /* open target file */
        if(!fout) {
          puts("Error opening output file VRAM.DAT.");
          return 1;
        }
        fwrite(logo_header,sizeof(logo_header),1,fout);
                                        /* skip over header */
        for(plane=0; plane<4; plane++) {/* process four bitplanes */
          logo_header[plane].ofs=ftell(fout);
                                        /* starting offset of bitplane */
          fname[4]=plane+'0';
          printf("%s...\n",fname);
          fin=fopen(fname,"rb");
          if(!fin) {
            puts("Error opening input file.");
            fclose(fout);
            return 2;
          }
          by=-1;
          cnt=0;
          bufc=0;
          for(i=0;i<640*480/2/4;i++)
          {
            if((i%16)==0)
              fscanf(fin,"%%%%%08lx %02x%02x %02x%02x %02x%02x %02x%02x "
                         "%02x%02x %02x%02x %02x%02x %02x%02x\n",
              &adr,&line[1],&line[0],&line[3], &line[2], &line[5], &line[4], &line[7], &line[6],
                   &line[9],&line[8],&line[11],&line[10],&line[13],&line[12],&line[15],&line[14]);

            if(i<640*400/2/4)
              b=line[i%16];             /* current byte */
            else
              b=0;                      /* zero out lines beyond 400 */

            /*
             * The following code compresses the "stream" of bytes in b
             * using an RLE based compression method. Coding is basically
             * as follows:
             *
             *   - A 00h byte indicates a run of repeated bytes; it is
             *     followed by two bytes giving the number of repetions and
             *     the byte to be repeated.
             *   - Any other value announces a group of bytes to be copied
             *     "as is". If the two low-order bits of this value are 0,
             *     the six high order bits give the number of bytes to be
             *     copied. I don't know what the meaning of other
             *     combinations of bit 0/1 could be...
             *   - The end of the data is marked by a sequence of two 00h
             *     bytes.
             */
            if(b==by && cnt<255)
              cnt++;                    /* count up to 255 identical bytes */
            else {
              if(cnt>3 || bufc+cnt>63)  /* end sequence of unrepeated bytes? */
              {                         
                if(cnt<=3)              /* will not generate repeat... */
                  for(j=0;cnt && bufc<63;j++,cnt--)
                                        /* stuff as many as possible... */
                    buf[bufc++]=by;     /* ...to end of current sequence */
                if(bufc)                /* flush unrepeated data */
                {
                  fputc(bufc*4,fout);
                  for(j=0; j<bufc; j++)
                    fputc(buf[j],fout);
                  bufc=0;               /* buffer has been flushed */
                }
              }
              if(cnt>3)
              {
                fputc(0x00,fout);       /* code "true" repetition */
                fputc(cnt,fout);
                fputc(by,fout);
              }
              else
              {
                for(j=0; cnt; j++,cnt--)/* only few repeated bytes:... */
                  buf[bufc++]=by;       /* ...add to current sequence */
              }
              by=b;                     /* another byte */
              cnt=1;                    /* first occurance */
            }

          }

          if(cnt<3 && bufc+cnt<=63)
          {
            for(j=0; j<cnt; j++)        /* only few repeated bytes:... */
              buf[bufc++]=by;           /* ...add to current sequence */
            cnt=0;
          }
          if(bufc)                      /* flush unrepeated data */
          {
            fputc(bufc,fout);
            for(j=0; j<bufc; j++)
              fputc(buf[j],fout);
          }
          if(cnt) {                     /* still repeated bytes left? */
            fputc(0x00,fout);           /* flush one-char buffer */
            fputc(cnt,fout);
            fputc(by,fout);
          }
          fputc(0x00,fout);             /* end of file */
          fputc(0x00,fout);
          fclose(fin);
          logo_header[plane].size=ftell(fout)-logo_header[plane].ofs;
                                        /* size of bitplane */
        }

        fseek(fout,0,SEEK_SET);         /* seek to beginning of file */
        fwrite(logo_header,sizeof(logo_header),1,fout);
                                        /* finalize header */
        fclose(fout);
        puts("Created VRAM.DAT - replace \\OS2LOGO to change boot logo.");
        return 0;                       /* no errors were detected */
}
