/*****************************************************************************/
/*   JobStart.CMD    GWB 7/17/95					     */	
/*                                                                           */
/* Starts job1 every day at 9pm                                              */
/*                                                                           */
/*  1.1 - Accepts the time to start on the command line                      */
/*  1.2 - Starts Job1 Weekdays at 9pm, Job2 Saturday at 9pm                  */
/*  1.21- Did the help test a little simpler                                 */
/*****************************************************************************/

call RxFuncAdd 'SysLoadFuncs' , 'RexxUtil',  'SysLoadFuncs'
call SysLoadFuncs

secsday=60*60*24
Ver="1.21 7/21/95 GWB"
parse arg waittime debug .
parse value waittime with hh ':' mm .
interval=120
job1='"Job1" /c d:\misc\hello.cmd'
job2='"Job2" /c d:\misc\goodbye.cmd'
job2day='Saturday'
DayOff='Sunday'
if pos('?',arg(1))>0 then
  do
    say "JobStart: Ver=" Ver " Usage is JobStart Start_Time"
    say " Start_Time = Time of Day in HH:MM format to start, default is 9:00pm."
    say " Job1 runs at Start_Time during weekdays, Job2 on Saturday, Never on Sunday"
    say "  Good starting call is     JobStart 21:00             "
    exit
  end  
if (debug="" | debug='?') then debug=0
if (debug<>0) then
  trace r
if waittime="" then
  secstart=secsday-60*60*3	/* Start monitoring at 9pm */
else
  do 
    parse value waittime with hh ':' mm .
    if hh > 24 then
      hh=23
    if mm > 60 then
      mm=00 
    secstart=60*( (60*hh) + mm) 	/* Time of day in seconds to start */ 
  end
/*               Calculate when to start    */
do forever
  IF (Time("Seconds")> secstart) then
    secstart = secstart + secsday         /* Already past the start time for today, start tomorrow */
  secsdelay=secstart-Time("Seconds")    /* Number of seconds to wait */
  say "Delay Seconds before starting=" secsdelay
  if (debug<>0) then
    do
      say "Start the waiting"  
      secsdelay=30
    end
  Call SysSleep(secsdelay)		/* Wait here until time to start job */
  today=Date('W')
  say today
  if (today<>Dayoff & today <> Job2Day) then
     '@Start'  job1 
  else
    if (today<>DayOff) then 
      '@Start' job2
  Call SysSleep(5)			/* Cut some slack */
end /* do forever*/

return

