/* INInst - Install / UnInstall for INIedit */

PARSE ARG action

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL RxFuncAdd  'FastIniStart','FastIni','FastIniStart'
CALL RxFuncAdd  'FastIniEnd','FastIni','FastIniEnd'

CALL SysCls

SELECT
        WHEN TRANSLATE(STRIP(action)) = 'I' THEN CALL InstallMe
        WHEN TRANSLATE(STRIP(action)) = 'U' THEN CALL UnInstallMe
        OTHERWISE CALL WhatAction
END
Exit /* End of INInst */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Ŀ'
SAY 'No installation parameter specified. Correct parameter is:                   '
SAY '     I = Install,     U = UnInstall,      any other key = Exit.              '
SAY ''
SAY ' Please try again with correct parameter '
PARSE PULL action
SELECT
        WHEN TRANSLATE(STRIP(action)) = 'I' THEN CALL InstallMe
        WHEN TRANSLATE(STRIP(action)) = 'U' THEN CALL UnInstallMe
        OTHERWISE CALL NoAction
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
SAY 'Ŀ'
SAY 'Error! No installation parameter specified. Leaving INInst.  Press any key...'
SAY ''
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - procedura za instalaciju programa INIedit */

InstallMe:  PROCEDURE

CALL ChkCfg
CALL SysCls

SAY 'Ŀ'
SAY 'Welcome to INIedit Installation procedure!                                   '
SAY 'Your files are in directory: '||LEFT(DIRECTORY(),48)||                      ''
SAY 'This program will do following:                                              '
SAY '     Create Folder and Program Objects for INIedit files on your Desktop,    '
SAY '     Associate INIedit with *.INI files,                                     '
SAY '     Create custom Configuration file (INIEDIT.INI),                         '
SAY '     Add some entries to your OS2.INI file, in Application ToolsByGoran.     '
SAY 'Note: if INIedit is already installed, this procedure will erase old         '
SAY '     entries, and create new (allways use this procedure after moving        '
SAY '     INIedit to another drive or directory).                                 '
SAY 'After Installation is complete, start INIedit, and configure it as you wish. '
SAY ''
SAY ' Press "Y" (and Enter) to start Installation, any other key to exit '
PARSE PULL answer
IF TRANSLATE(STRIP(answer)) <> "Y" THEN DO
        CALL NoAction
END

SAY ' Writing entries in OS2.INI'
CALL SysIni 'USER','ToolsByGoran','INIeditWorkDir',DIRECTORY()
CALL SysIni 'USER','ToolsByGoran','INIeditINIfile',DIRECTORY()||'\INIEDIT.INI'
CALL SysIni 'USER','ToolsByGoran','INIeditVersion','0.90'
myinifileRC = FastIniStart('INIEDIT.INI','mylangfileHandle')
SAY ' Writing INIEDIT.INI'
/* Application: Language */
CALL SysIni 'INIEDIT.INI','Language','CROATIAN','1'
CALL SysIni 'INIEDIT.INI','Language','ENGLISH','1'
CALL SysIni 'INIEDIT.INI','Language','FRENCH','1'
CALL SysIni 'INIEDIT.INI','Language','GERMAN','1'
CALL SysIni 'INIEDIT.INI','Language','ITALIAN','1'
CALL SysIni 'INIEDIT.INI','Language','SPANISH','1'
/* Application: ProportionalFont */
CALL SysIni 'INIEDIT.INI','ProportionalFont','9.WarpSans','1'
CALL SysIni 'INIEDIT.INI','ProportionalFont','10.Helvetica','1'
CALL SysIni 'INIEDIT.INI','ProportionalFont','10.System Proportional','1'
/* Application: MonospacedFont */
CALL SysIni 'INIEDIT.INI','MonospacedFont','10.System VIO','1'
CALL SysIni 'INIEDIT.INI','MonospacedFont','10.Courier','1'
CALL SysIni 'INIEDIT.INI','MonospacedFont','10.System Monospaced','1'
/* Application: General */
CALL SysIni 'INIEDIT.INI','General','Workdir',DIRECTORY()
CALL SysIni 'INIEDIT.INI','General','CurrLang','ENGLISH'
CALL SysIni 'INIEDIT.INI','General','SafeMode','YES'
CALL SysIni 'INIEDIT.INI','General','ShowAll','NO'
CALL SysIni 'INIEDIT.INI','General','FastHex','NO'
CALL SysIni 'INIEDIT.INI','General','FileList','YES'
CALL SysIni 'INIEDIT.INI','General','Position','100 60 500 456'
CALL SysIni 'INIEDIT.INI','General','PosComp','150 50 483 488'
CALL SysIni 'INIEDIT.INI','General','PosFind','150 130 501 345'
CALL SysIni 'INIEDIT.INI','General','Misc','2'||DATE('B')||'110'
CALL SysIni 'INIEDIT.INI','General','ProportionalFont','9.WarpSans'
CALL SysIni 'INIEDIT.INI','General','MonospacedFont','10.System VIO'
CALL FastIniEnd myinifileHandle
SAY 'INIEDIT.INI created!'
SAY ' '
CALL SysDestroyObject '<INITOOLS090FOLDER>'
FolderTitle = 'INI Tools'||'0D0A'x||'Version 0.90'
ProgTitle = 'INI editor'
CompTitle = 'INI compare'
FindTitle = 'INI find'
InsTitle = 'Install/ReInstall/UnInstall'
EXE1 = 'INIedit.exe'
EXE2 = 'INIcomp.exe'
EXE3 = 'INIfind.exe'
CMD1 = 'INInst.cmd'
InstallDir = DIRECTORY()
WorkDir = DIRECTORY()
Assoc = '*.INI'
Setup1 = 'EXENAME='InstallDir'\'EXE1';ASSOCFILTER='Assoc';STARTUPDIR='WorkDir''
Setup2 = 'EXENAME='InstallDir'\'EXE2';STARTUPDIR='WorkDir''
Setup3 = 'EXENAME='InstallDir'\'EXE3';STARTUPDIR='WorkDir''
Setup5 = 'EXENAME='InstallDir'\'CMD1';STARTUPDIR='WorkDir''
Action = Replace
SAY 'Creating Folder - INIedit'
CALL  SysCreateObject 'WPFolder',FolderTitle,'<WP_DESKTOP>','OBJECTID=<INITOOLS090FOLDER>'
SAY 'Creating Program object - INIedit'
CALL SysCreateObject 'WPProgram',ProgTitle,'<INITOOLS090FOLDER>',Setup1,Action
SAY 'Creating Program object - INIcomp'
CALL SysCreateObject 'WPProgram',CompTitle,'<INITOOLS090FOLDER>',Setup2,Action
SAY 'Creating Program object - INIfind'
CALL SysCreateObject 'WPProgram',FindTitle,'<INITOOLS090FOLDER>',Setup3,Action
SAY 'Creating Program object - Install'
CALL SysCreateObject 'WPProgram',InsTitle,'<INITOOLS090FOLDER>',Setup5,Action
SAY 'Creating WPS object - documentation'
CALL SysCreateShadow Workdir||'\INIedit.htm','<INITOOLS090FOLDER>'
SAY ' WPS object (Folder and Program objects) created! Press any key to exit...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall INIedit */

UnInstallMe: PROCEDURE

CALL SysCls
SAY 'Ŀ'
SAY 'This is INIedit UnInstallation procedure!                                    '
SAY 'Your files are in directory: '||LEFT(DIRECTORY(),48)||                      ''
SAY 'This program will do following:                                              '
SAY '     Destroy Folder and Program Objects for INIedit files on your Desktop,   '
SAY '     Remove entries in your OS2.INI file, in Application ToolsByGoran.       '
SAY 'Note: if you want to ReInstall INIedit, start (INInst I) again.              '
SAY ''
SAY ' Press "Y" (and Enter) to start UnInstall, any other key to exit '
PULL answer
IF answer <> "Y" THEN DO
        CALL NoAction
END
SAY ' Destroying INIedit Folder'
CALL SysDestroyObject '<INITOOLS090FOLDER>'
SAY ' Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','INIeditWorkDir','DELETE:'
CALL SysIni 'USER','ToolsByGoran','INIeditINIfile','DELETE:'
CALL SysIni 'USER','ToolsByGoran','INIeditVersion','DELETE:'
SAY ' '
SAY ' UnInstallation complete.'
SAY ' You can delete files in directory: '||DIRECTORY()
SAY ' If you want to ReInstall INIedit, start INInst I.Press any key to exit...'
PULL answer
RETURN /* End of UnInstallMe */

/* ChkCfg - check configuration */

ChkCfg:     PROCEDURE

CALL SysCls
SAY 'Please wait. Checking configuration...'
SAY ' '
myver = SysOS2Ver()
IF myver = "2.30" THEN DO
    myver = "OS/2 Warp - Version 3"
    SAY 'OS Version is: '||myver||'     '||'OK'
    SAY ' '
    SAY 'Checking default font ...'
    defFont = SysIni('USER','PM_SystemFonts','DefaultFont')
    IF defFont = "9.WarpSans"||"00"x THEN DO
        SAY 'Default font is: '||defFont||'             '||'OK'
        SAY ' '
        SAY 'Your configuration is OK.'
        SAY ' '
    END
    IF defFont <> "9.WarpSans"||"00"x THEN DO
        SAY ' '
        SAY 'Default font is: '||defFont
        SAY ' '
        SAY '    Alert! Warp 3 user.'
        SAY '    We have problem here. >> Default font for INIedit is be 9.WarpSans.'
        SAY '    Set your default font to 9.WarpSans or Helvetica if you do not have'
        SAY '    WarpSans installed on your machine.'
        SAY '    Read Warp3 section ini INIedit.htm file for more information.'
        SAY ' '
        BEEP(500,250)
    END
END
IF myver = "2.40" THEN DO
    myver = 'OS/2 Warp - Version 4'
    SAY 'Operating System Version is: '||myver||'     '||'OK'
    SAY ' '
    SAY 'Your configuration is OK.'
    SAY ' '
END
SAY 'Press any key to continue...'
PULL answer
CALL SysCls

RETURN /* End of ChkCfg */

